/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerInterceptor
extends AbstractInterceptor {
    protected static final Log log;
    protected Log categoryLogger;
    protected String logCategory;
    protected String logLevel;
    static /* synthetic */ Class class$com$opensymphony$xwork2$interceptor$TimerInterceptor;

    public String getLogCategory() {
        return this.logCategory;
    }

    public void setLogCategory(String logCatgory) {
        this.logCategory = logCatgory;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (!this.shouldLog()) {
            return invocation.invoke();
        }
        return this.invokeUnderTiming(invocation);
    }

    protected String invokeUnderTiming(ActionInvocation invocation) throws Exception {
        long startTime = System.currentTimeMillis();
        String result = invocation.invoke();
        long executionTime = System.currentTimeMillis() - startTime;
        StringBuffer message = new StringBuffer(100);
        message.append("Executed action [");
        String namespace = invocation.getProxy().getNamespace();
        if (namespace != null && namespace.trim().length() > 0) {
            message.append(namespace).append("/");
        }
        message.append(invocation.getProxy().getActionName());
        message.append("!");
        message.append(invocation.getProxy().getMethod());
        message.append("] took ").append(executionTime).append(" ms.");
        this.doLog(this.getLoggerToUse(), message.toString());
        return result;
    }

    protected boolean shouldLog() {
        if (this.logLevel == null && this.logCategory == null) {
            return log.isInfoEnabled();
        }
        return TimerInterceptor.isLoggerEnabled(this.getLoggerToUse(), this.logLevel);
    }

    protected Log getLoggerToUse() {
        if (this.logCategory != null) {
            if (this.categoryLogger == null) {
                this.categoryLogger = LogFactory.getLog((String)this.logCategory);
                if (this.logLevel == null) {
                    this.logLevel = "info";
                }
            }
            return this.categoryLogger;
        }
        return log;
    }

    protected void doLog(Log logger, String message) {
        if (this.logLevel == null) {
            logger.info((Object)message);
            return;
        }
        if ("debug".equalsIgnoreCase(this.logLevel)) {
            logger.debug((Object)message);
        } else if ("info".equalsIgnoreCase(this.logLevel)) {
            logger.info((Object)message);
        } else if ("warn".equalsIgnoreCase(this.logLevel)) {
            logger.warn((Object)message);
        } else if ("error".equalsIgnoreCase(this.logLevel)) {
            logger.error((Object)message);
        } else if ("fatal".equalsIgnoreCase(this.logLevel)) {
            logger.fatal((Object)message);
        } else if ("trace".equalsIgnoreCase(this.logLevel)) {
            logger.trace((Object)message);
        } else {
            throw new IllegalArgumentException("LogLevel [" + this.logLevel + "] is not supported");
        }
    }

    private static boolean isLoggerEnabled(Log logger, String level) {
        if ("debug".equalsIgnoreCase(level)) {
            return logger.isDebugEnabled();
        }
        if ("info".equalsIgnoreCase(level)) {
            return logger.isInfoEnabled();
        }
        if ("warn".equalsIgnoreCase(level)) {
            return logger.isWarnEnabled();
        }
        if ("error".equalsIgnoreCase(level)) {
            return logger.isErrorEnabled();
        }
        if ("fatal".equalsIgnoreCase(level)) {
            return logger.isFatalEnabled();
        }
        if ("trace".equalsIgnoreCase(level)) {
            return logger.isTraceEnabled();
        }
        throw new IllegalArgumentException("LogLevel [" + level + "] is not supported");
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$interceptor$TimerInterceptor;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$interceptor$TimerInterceptor = new TimerInterceptor[0].getClass().getComponentType();
        }
        log = LogFactory.getLog((Class)clazz);
    }
}

