/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.sf.retrotranslator.runtime.java.lang._Class;
import net.sf.retrotranslator.runtime.java.lang.annotation.Annotation_;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverUtil<T> {
    private static final Log log;
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private ClassLoader classloader;
    static /* synthetic */ Class class$com$opensymphony$xwork2$util$ResolverUtil;

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public void findImplementations(Class parent, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        IsA test = new IsA(parent);
        for (String pkg : packageNames) {
            this.findInPackage(test, pkg);
        }
    }

    public void findSuffix(String suffix, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        NameEndsWith test = new NameEndsWith(suffix);
        for (String pkg : packageNames) {
            this.findInPackage(test, pkg);
        }
    }

    public void findAnnotated(Class<? extends Annotation_> annotation, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        AnnotatedWith test = new AnnotatedWith(annotation);
        for (String pkg : packageNames) {
            this.findInPackage(test, pkg);
        }
    }

    public void find(Test test, String ... packageNames) {
        if (packageNames == null) {
            return;
        }
        for (String pkg : packageNames) {
            this.findInPackage(test, pkg);
        }
    }

    public void findInPackage(Test test, String packageName) {
        Enumeration<URL> urls;
        packageName = packageName.replace('.', '/');
        ClassLoader loader = this.getClassLoader();
        try {
            urls = loader.getResources(packageName);
        }
        catch (IOException ioe) {
            log.warn((Object)new StringBuffer().append("Could not read package: ").append(packageName).toString(), (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            try {
                String urlPath = urls.nextElement().getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                log.info((Object)new StringBuffer().append("Scanning for classes in [").append(urlPath).append("] matching criteria: ").append(test).toString());
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.loadImplementationsInDirectory(test, packageName, file);
                    continue;
                }
                this.loadImplementationsInJar(test, packageName, file);
            }
            catch (IOException ioe) {
                log.warn((Object)"could not read entries", (Throwable)ioe);
            }
        }
    }

    private void loadImplementationsInDirectory(Test test, String parent, File location) {
        File[] files = location.listFiles();
        StringBuffer builder = null;
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuffer(100);
            builder.append(parent).append("/").append(file.getName());
            String string = packageOrClass = parent == null ? file.getName() : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            this.addIfMatching(test, packageOrClass);
        }
    }

    private void loadImplementationsInJar(Test test, String parent, File jarfile) {
        try {
            JarEntry entry;
            JarInputStream jarStream = new JarInputStream(new FileInputStream(jarfile));
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith(parent) || !name.endsWith(".class")) continue;
                this.addIfMatching(test, name);
            }
        }
        catch (IOException ioe) {
            log.error((Object)new StringBuffer().append("Could not search jar file '").append(jarfile).append("' for classes matching criteria: ").append(test).append(" due to an IOException").toString(), (Throwable)ioe);
        }
    }

    protected void addIfMatching(Test test, String fqn) {
        try {
            Class<?> type;
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            if (log.isDebugEnabled()) {
                log.debug((Object)new StringBuffer().append("Checking to see if class ").append(externalName).append(" matches criteria [").append(test).append("]").toString());
            }
            if (test.matches(type = loader.loadClass(externalName))) {
                this.matches.add(type);
            }
        }
        catch (Throwable t) {
            log.warn((Object)new StringBuffer().append("Could not examine class '").append(fqn).append("' due to a ").append(t.getClass().getName()).append(" with message: ").append(t.getMessage()).toString());
        }
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$util$ResolverUtil;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$util$ResolverUtil = new ResolverUtil[0].getClass().getComponentType();
        }
        log = LogFactory.getLog((Class)clazz);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation_> annotation;

        public AnnotatedWith(Class<? extends Annotation_> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean matches(Class type) {
            return type != null && _Class.isAnnotationPresent((Class)type, this.annotation);
        }

        public String toString() {
            return new StringBuffer().append("annotated with @").append(_Class.getSimpleName(this.annotation)).toString();
        }
    }

    public static class NameEndsWith
    implements Test {
        private String suffix;

        public NameEndsWith(String suffix) {
            this.suffix = suffix;
        }

        public boolean matches(Class type) {
            return type != null && type.getName().endsWith(this.suffix);
        }

        public String toString() {
            return "ends with the suffix " + this.suffix;
        }
    }

    public static class IsA
    implements Test {
        private Class parent;

        public IsA(Class parentType) {
            this.parent = parentType;
        }

        public boolean matches(Class type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + _Class.getSimpleName((Class)this.parent);
        }
    }

    public static interface Test {
        public boolean matches(Class var1);
    }
}

