/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.location;

import com.opensymphony.xwork2.util.PropertiesReader;
import com.opensymphony.xwork2.util.location.Locatable;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.location.LocationImpl;
import com.opensymphony.xwork2.util.location.LocationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatableProperties
extends Properties
implements Locatable {
    Location location;
    Map<String, Location> propLocations;

    public LocatableProperties() {
        this((Location)null);
    }

    public LocatableProperties(Location loc) {
        this.location = loc;
        this.propLocations = new HashMap<String, Location>();
    }

    @Override
    public void load(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        PropertiesReader pr = new PropertiesReader(reader);
        while (pr.nextProperty()) {
            String name = pr.getPropertyName();
            String val = pr.getPropertyValue();
            int line = pr.getLineNumber();
            String desc = this.convertCommentsToString(pr.getCommentLines());
            LocationImpl loc = new LocationImpl(desc, this.location.getURI(), line, 0);
            this.setProperty(name, val, loc);
        }
    }

    String convertCommentsToString(List<String> lines) {
        StringBuffer sb = new StringBuffer();
        if (lines != null && lines.size() > 0) {
            for (String line : lines) {
                sb.append(line).append('\n');
            }
        }
        return sb.toString();
    }

    public Object setProperty(String key, String value, Object locationObj) {
        Object obj = super.setProperty(key, value);
        if (this.location != null) {
            Location loc = LocationUtils.getLocation(locationObj);
            this.propLocations.put(key, loc);
        }
        return obj;
    }

    public Location getPropertyLocation(String key) {
        return this.propLocations.get(key);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }
}

