/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.profiling;

import com.opensymphony.xwork2.util.profiling.ProfilingTimerBean;
import net.sf.retrotranslator.runtime.java.lang._System;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilTimerStack {
    protected static ThreadLocal<ProfilingTimerBean> current = new ThreadLocal();
    public static final String ACTIVATE_PROPERTY = "xwork.profile.activate";
    public static final String MIN_TIME = "xwork.profile.mintime";
    private static final Log log;
    static /* synthetic */ Class class$com$opensymphony$xwork2$util$profiling$UtilTimerStack;

    public static void push(String name) {
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean newTimer = new ProfilingTimerBean(name);
        newTimer.setStartTime();
        ProfilingTimerBean currentTimer = current.get();
        if (currentTimer != null) {
            currentTimer.addChild(newTimer);
        }
        current.set(newTimer);
    }

    public static void pop(String name) {
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean currentTimer = current.get();
        if (currentTimer != null && name != null && name.equals(currentTimer.getResource())) {
            currentTimer.setEndTime();
            ProfilingTimerBean parent = currentTimer.getParent();
            if (parent == null) {
                UtilTimerStack.printTimes(currentTimer);
                current.set(null);
            } else {
                current.set(parent);
            }
        } else if (currentTimer != null) {
            UtilTimerStack.printTimes(currentTimer);
            current.set(null);
            log.warn((Object)new StringBuffer().append("Unmatched Timer.  Was expecting ").append(currentTimer.getResource()).append(", instead got ").append(name).toString());
        }
    }

    private static void printTimes(ProfilingTimerBean currentTimer) {
        log.info((Object)currentTimer.getPrintable(UtilTimerStack.getMinTime()));
    }

    private static long getMinTime() {
        try {
            return Long.parseLong(System.getProperty(MIN_TIME, "0"));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static boolean isActive() {
        return System.getProperty(ACTIVATE_PROPERTY) != null;
    }

    public static void setActive(boolean active) {
        if (active) {
            System.setProperty(ACTIVATE_PROPERTY, "true");
        } else {
            _System.clearProperty((String)ACTIVATE_PROPERTY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T profile(String name, ProfilingBlock<T> block) throws Exception {
        UtilTimerStack.push(name);
        try {
            T t = block.doProfiling();
            return t;
        }
        finally {
            UtilTimerStack.pop(name);
        }
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$util$profiling$UtilTimerStack;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$util$profiling$UtilTimerStack = new UtilTimerStack[0].getClass().getComponentType();
        }
        log = LogFactory.getLog((Class)clazz);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProfilingBlock<T> {
        public T doProfiling() throws Exception;
    }
}

