/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.validator.ShortCircuitableValidator;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorConfig;
import com.opensymphony.xwork2.validator.ValidatorFileParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidatorFactory {
    private static Map validators = new HashMap();
    private static Log LOG;
    static /* synthetic */ Class class$com$opensymphony$xwork2$validator$ValidatorFactory;

    private ValidatorFactory() {
    }

    public static Validator getValidator(ValidatorConfig cfg) {
        return ValidatorFactory.getValidator(cfg, ObjectFactory.getObjectFactory());
    }

    public static Validator getValidator(ValidatorConfig cfg, ObjectFactory objectFactory) {
        Validator validator;
        String className = ValidatorFactory.lookupRegisteredValidatorType(cfg.getType());
        try {
            validator = objectFactory.buildValidator(className, cfg.getParams(), null);
        }
        catch (Exception e) {
            String msg = "There was a problem creating a Validator of type " + className + " : caused by " + e.getMessage();
            throw new XWorkException(msg, e, cfg);
        }
        validator.setMessageKey(cfg.getMessageKey());
        validator.setDefaultMessage(cfg.getDefaultMessage());
        if (validator instanceof ShortCircuitableValidator) {
            ((ShortCircuitableValidator)((Object)validator)).setShortCircuit(cfg.isShortCircuit());
        }
        return validator;
    }

    public static void registerValidator(String name, String className) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering validator of class " + className + " with name " + name));
        }
        validators.put(name, className);
    }

    public static String lookupRegisteredValidatorType(String name) {
        String className = (String)validators.get(name);
        if (className == null) {
            throw new IllegalArgumentException("There is no validator class mapped to the name " + name);
        }
        return className;
    }

    private static void parseValidators() {
        InputStream is;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Loading validator definitions.");
        }
        String resourceName = "validators.xml";
        Class<?> clazz = class$com$opensymphony$xwork2$validator$ValidatorFactory;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$validator$ValidatorFactory = new ValidatorFactory[0].getClass().getComponentType();
        }
        if ((is = ClassLoaderUtil.getResourceAsStream(resourceName, clazz)) == null) {
            resourceName = "com/opensymphony/xwork2/validator/validators/default.xml";
            Class<?> clazz2 = class$com$opensymphony$xwork2$validator$ValidatorFactory;
            if (clazz2 == null) {
                clazz2 = class$com$opensymphony$xwork2$validator$ValidatorFactory = new ValidatorFactory[0].getClass().getComponentType();
            }
            is = ClassLoaderUtil.getResourceAsStream(resourceName, clazz2);
        }
        if (is != null) {
            ValidatorFileParser.parseValidatorDefinitions(is, resourceName);
        }
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$validator$ValidatorFactory;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$validator$ValidatorFactory = new ValidatorFactory[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
        ValidatorFactory.parseValidators();
    }
}

