/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.util.Date;
import java.util.Vector;
import oracle.AQ.AQAgent;
import oracle.AQ.AQException;
import oracle.AQ.AQSignature;
import oracle.AQ.AQUtil;

public class AQMessageProperty {
    public static final int DELAY_NONE = 0;
    public static final int EXPIRATION_NEVER = -1;
    public static final int STATE_READY = 0;
    public static final int STATE_WAITING = 1;
    public static final int STATE_PROCESSED = 2;
    public static final int STATE_EXPIRED = 3;
    static final int DEFAULT_PRIORITY = 1;
    static final int DEFAULT_DELAY = 0;
    static final int DEFAULT_EXPIRATION = -1;
    private int m_priority = 1;
    private int m_delay = 0;
    private String corrid = null;
    private int m_attempts = 0;
    private Vector recp_list = new Vector(30);
    private AQAgent m_sender = null;
    private byte[] orig_m_id = null;
    private String exc_queue = null;
    private int m_state = -1;
    private Date enq_time = null;
    private AQSignature m_signature = null;
    private long m_expiration = -1L;

    public int getPriority() throws AQException {
        return this.m_priority;
    }

    public void setPriority(int n) throws AQException {
        this.m_priority = n;
    }

    public int getDelay() throws AQException {
        return this.m_delay;
    }

    public void setDelay(int n) throws AQException {
        this.m_delay = n;
    }

    public long getExpiration() throws AQException {
        return this.m_expiration;
    }

    public void setExpiration(long l) throws AQException {
        this.m_expiration = l;
    }

    public String getCorrelation() throws AQException {
        return this.corrid;
    }

    public void setCorrelation(String string) throws AQException {
        this.corrid = string;
    }

    public int getAttempts() throws AQException {
        return this.m_attempts;
    }

    void setAttempts(int n) throws AQException {
        this.m_attempts = n;
    }

    public Vector getRecipientList() throws AQException {
        return this.recp_list;
    }

    public void setRecipientList(Vector vector) throws AQException {
        this.recp_list = vector;
    }

    public byte[] getOrigMessageId() throws AQException {
        return this.orig_m_id;
    }

    void setOrigMessageId(byte[] byArray) throws AQException {
        this.orig_m_id = byArray;
    }

    public AQAgent getSender() throws AQException {
        return this.m_sender;
    }

    public void setSender(AQAgent aQAgent) throws AQException {
        this.m_sender = aQAgent;
    }

    public AQSignature getSignature() throws AQException {
        return this.m_signature;
    }

    public void setSignature(AQSignature aQSignature) throws AQException {
        this.m_signature = aQSignature;
    }

    public String getExceptionQueue() throws AQException {
        return this.exc_queue;
    }

    public void setExceptionQueue(String string) throws AQException {
        this.exc_queue = string;
    }

    public Date getEnqueueTime() throws AQException {
        return this.enq_time;
    }

    void setEnqueueTime(Date date) throws AQException {
        this.enq_time = date;
    }

    public int getState() throws AQException {
        return this.m_state;
    }

    void setState(int n) throws AQException {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new AQException(0, "Invalid state");
        }
        this.m_state = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append("[AQMessageProperty]");
        stringBuffer.append("\n  message_priority : " + this.m_priority);
        stringBuffer.append("\n  delay            : " + this.m_delay);
        stringBuffer.append("\n  expiration       : " + this.m_expiration);
        stringBuffer.append("\n  correlation      : " + this.corrid);
        stringBuffer.append("\n  attempts         : " + this.m_attempts);
        if (this.recp_list != null) {
            stringBuffer.append("Recipients [" + this.recp_list.size() + "]");
            n = 0;
            while (n < this.recp_list.size()) {
                if ((AQAgent)this.recp_list.elementAt(n) != null) {
                    stringBuffer.append(((AQAgent)this.recp_list.elementAt(n)).toString());
                }
                ++n;
            }
        }
        if (this.m_sender != null) {
            stringBuffer.append("\n  sender           : \n");
            stringBuffer.append(this.m_sender.toString());
        } else {
            stringBuffer.append("\n  sender           : null");
        }
        stringBuffer.append("\n  original msg id  : " + AQUtil.ByteArraytoString(this.orig_m_id));
        stringBuffer.append("\n  exception queue  : " + this.exc_queue);
        stringBuffer.append("\n  message state    : ");
        if (this.m_state == 0) {
            stringBuffer.append("READY");
        } else if (this.m_state == 1) {
            stringBuffer.append("WAITING");
        } else if (this.m_state == 2) {
            stringBuffer.append("PROCESSED");
        } else if (this.m_state == 3) {
            stringBuffer.append("EXPIRED");
        } else {
            stringBuffer.append("Unknown state");
        }
        return stringBuffer.toString();
    }
}

