/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.jms.JMSException;
import oracle.AQ.AQAgent;
import oracle.AQ.AQDequeueOption;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQEnqueueOption;
import oracle.AQ.AQException;
import oracle.AQ.AQMessage;
import oracle.AQ.AQMessageProperty;
import oracle.AQ.AQOracleAgent;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleMessage;
import oracle.AQ.AQOracleObjectPayload;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQOracleRawPayload;
import oracle.AQ.AQOracleSQLException;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQQueue;
import oracle.AQ.AQQueueProperty;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQSession;
import oracle.AQ.AQSignature;
import oracle.AQ.AQUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jms.AQjmsSession;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;

public class AQOracleQueue
implements AQQueue {
    private String owner;
    private String name;
    private String table;
    private int pload_type;
    private String p_data_type;
    AQQueueProperty property;
    Integer queue_type;
    private AQOracleSession aq_sess;
    private CallableStatement alterq_stmt;
    private CallableStatement rems_stmt;
    private CallableStatement adds_stmt;
    private CallableStatement alts_stmt;
    private CallableStatement allq_stmt;
    private CallableStatement allqo_stmt;
    private CallableStatement alprop_stmt;
    private CallableStatement unscprop_stmt;
    private CallableStatement enprop_stmt;
    private CallableStatement disprop_stmt;
    private OracleCallableStatement enqr_norcp_stmt;
    private OracleCallableStatement enqr_rcp_stmt;
    private OracleCallableStatement enqo_norcp_stmt;
    private OracleCallableStatement enqo_rcp_stmt;
    private OracleCallableStatement deq_raw_stmt;
    private OracleCallableStatement deq_obj_stmt;
    private Hashtable trans_list;
    private boolean secure;

    AQOracleQueue(AQOracleSession aQOracleSession, String string, String string2, String string3, AQQueueProperty aQQueueProperty, int n, String string4, boolean bl) throws AQException {
        this.owner = string;
        this.table = string3;
        this.aq_sess = aQOracleSession;
        if (string2 == null || string2.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, string2);
        } else {
            this.name = string2;
        }
        if (aQQueueProperty == null) {
            AQUtil.throwAQEx(185);
        } else {
            this.property = aQQueueProperty;
        }
        if (n == 2) {
            this.p_data_type = null;
        } else if (n == 1) {
            if (string4 == null || string4.equals("")) {
                AQUtil.throwAQEx(122, "payload object type must be specified");
            }
            this.p_data_type = string4;
        } else {
            AQUtil.throwAQEx(129);
        }
        this.pload_type = n;
        this.queue_type = null;
        this.alterq_stmt = null;
        this.adds_stmt = null;
        this.alts_stmt = null;
        this.rems_stmt = null;
        this.allq_stmt = null;
        this.allqo_stmt = null;
        this.alprop_stmt = null;
        this.unscprop_stmt = null;
        this.enprop_stmt = null;
        this.disprop_stmt = null;
        this.enqr_norcp_stmt = null;
        this.enqr_rcp_stmt = null;
        this.enqo_norcp_stmt = null;
        this.enqo_rcp_stmt = null;
        this.deq_obj_stmt = null;
        this.deq_raw_stmt = null;
        this.trans_list = new Hashtable();
        this.secure = bl;
    }

    public AQOracleQueue(AQjmsSession aQjmsSession, String string, String string2, String string3, AQQueueProperty aQQueueProperty, int n, String string4, boolean bl) throws JMSException, AQException {
        Connection connection = null;
        this.owner = string;
        this.table = string3;
        if (string2 == null || string2.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, string2);
        } else {
            this.name = string2;
        }
        connection = aQjmsSession.getDBConnection();
        if (aQQueueProperty == null) {
            AQUtil.throwAQEx(185);
        } else {
            this.property = aQQueueProperty;
        }
        this.aq_sess = new AQOracleSession(connection);
        if (n == 2) {
            AQUtil.throwAQEx(193);
        }
        if (string4 == null || string4.equals("")) {
            AQUtil.throwAQEx(122, "payload object type must be specified");
        }
        this.pload_type = n;
        this.alterq_stmt = null;
        this.adds_stmt = null;
        this.alts_stmt = null;
        this.rems_stmt = null;
        this.allq_stmt = null;
        this.allqo_stmt = null;
        this.alprop_stmt = null;
        this.unscprop_stmt = null;
        this.enprop_stmt = null;
        this.disprop_stmt = null;
        this.enqr_norcp_stmt = null;
        this.enqr_rcp_stmt = null;
        this.enqo_norcp_stmt = null;
        this.enqo_rcp_stmt = null;
        this.deq_obj_stmt = null;
        this.deq_raw_stmt = null;
        this.trans_list = new Hashtable();
        this.secure = bl;
    }

    public String getOwner() {
        return this.owner;
    }

    void setOwner(String string) throws AQException {
        this.owner = string;
    }

    public String getName() {
        return this.name;
    }

    void setName(String string) throws AQException {
        this.name = string;
    }

    public String getCompleteName() {
        String string = null;
        string = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return string;
    }

    public AQSession getAQSession() {
        return this.aq_sess;
    }

    public void setAQSession(AQOracleSession aQOracleSession) throws AQException {
        if (aQOracleSession != null) {
            AQOracleDebug.trace(3, "AQOracleQueue.setAQSession", "entry");
            this.aq_sess = aQOracleSession;
            this.alterq_stmt = null;
            this.adds_stmt = null;
            this.alts_stmt = null;
            this.rems_stmt = null;
            this.allq_stmt = null;
            this.allqo_stmt = null;
            this.alprop_stmt = null;
            this.unscprop_stmt = null;
            this.enprop_stmt = null;
            this.disprop_stmt = null;
            this.enqr_norcp_stmt = null;
            this.enqr_rcp_stmt = null;
            this.enqo_norcp_stmt = null;
            this.enqo_rcp_stmt = null;
            this.deq_obj_stmt = null;
            this.deq_raw_stmt = null;
        } else {
            AQUtil.throwAQEx(122, "Session cannot be null");
        }
    }

    public int getPayloadType() throws AQException {
        return this.pload_type;
    }

    void setPayloadType(int n) throws AQException {
        this.pload_type = n;
    }

    public String getObjectPayloadType() throws AQException {
        return this.p_data_type;
    }

    public String getQueueTableName() throws AQException {
        return this.table;
    }

    void setQueueTableName(String string) throws AQException {
        this.table = string;
    }

    public synchronized AQQueueProperty getProperty() throws AQException {
        Connection connection = null;
        ResultSet resultSet = null;
        String string = "";
        AQOracleDebug.trace(4, "AQOracleQueue.getProperty", "entry-no params");
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                if (this.owner == null || this.owner.equals("")) {
                    if (this.allq_stmt == null) {
                        AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "before prepare-1");
                        this.allq_stmt = connection.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type from all_queues t1, all_queue_tables t2 where t1.name=? and t1.queue_table=t2.queue_table and t1.owner=t2.owner");
                    } else {
                        this.allq_stmt.clearParameters();
                    }
                    this.allq_stmt.setString(1, this.name.toUpperCase());
                    resultSet = this.allq_stmt.executeQuery();
                } else {
                    if (this.allqo_stmt == null) {
                        AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "before prepare-2");
                        this.allqo_stmt = connection.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type from all_queues t1, all_queue_tables t2 where t1.owner=? and t1.name=? and t2.owner=? and t1.queue_table=t2.queue_table");
                    } else {
                        this.allqo_stmt.clearParameters();
                    }
                    this.allqo_stmt.setString(1, this.owner.toUpperCase());
                    this.allqo_stmt.setString(2, this.name.toUpperCase());
                    this.allqo_stmt.setString(3, this.owner.toUpperCase());
                    AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "before execute");
                    resultSet = this.allqo_stmt.executeQuery();
                }
            }
            catch (SQLException sQLException) {
                AQOracleDebug.traceEx(3, "AQOracleQueue.getProperty-1", sQLException);
                if (this.owner == null || this.owner.equals("")) {
                    try {
                        this.allq_stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.allq_stmt = null;
                } else {
                    try {
                        this.allqo_stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.allqo_stmt = null;
                }
                throw sQLException;
            }
            if (resultSet.next()) {
                if (resultSet.getString(4).equals("EXCEPTION_QUEUE")) {
                    this.property.setQueueType(1);
                }
                this.property.setMaxRetries(resultSet.getInt(5));
                this.property.setRetryInterval(resultSet.getInt(6));
                string = resultSet.getString(7).trim();
                if (string.equals("FOREVER")) {
                    this.property.setRetentionTime(-1.0);
                } else {
                    this.property.setRetentionTime(resultSet.getDouble(7));
                }
                this.property.setComment(resultSet.getString(8));
            } else if (this.owner == null || this.owner.equals("")) {
                AQUtil.throwAQEx(190, this.name);
            } else {
                AQUtil.throwAQEx(190, this.owner + "." + this.name);
            }
            if (resultSet.next()) {
                AQUtil.throwAQEx(182);
            }
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getProperty-2", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
        AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "exit");
        return this.property;
    }

    public AQQueueProperty getProperty(boolean bl) throws AQException {
        if (bl) {
            AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "return cached prop");
            return this.property;
        }
        AQOracleDebug.trace(5, "AQOracleQueue.getProperty", "get prop from db");
        return this.getProperty();
    }

    void setProperty(AQQueueProperty aQQueueProperty) throws AQException {
        this.property = aQQueueProperty;
    }

    public void start(boolean bl, boolean bl2) throws AQException {
        Statement statement = null;
        Connection connection = null;
        String string = "";
        String string2 = "true";
        String string3 = "true";
        if (this.name == null || this.name.equals("")) {
            AQUtil.throwAQEx(122, "name invalid");
        }
        string = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (!bl) {
                string2 = "false";
            }
            if (!bl2) {
                string3 = "false";
            }
            statement = connection.prepareCall("begin dbms_aqadm.start_queue(queue_name => ?, enqueue => " + string2 + ", dequeue => " + string3 + "); end;");
            statement.setString(1, string);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.start", sQLException);
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void start() throws AQException {
        this.start(true, true);
    }

    public void startEnqueue() throws AQException {
        this.start(true, false);
    }

    public void startDequeue() throws AQException {
        this.start(false, true);
    }

    public void stop(boolean bl, boolean bl2, boolean bl3) throws AQException {
        Statement statement = null;
        Connection connection = null;
        String string = "";
        String string2 = "true";
        String string3 = "true";
        String string4 = "false";
        if (this.name == null || this.name.equals("")) {
            AQUtil.throwAQEx(122, "invalid name");
        }
        string = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (!bl) {
                string2 = "false";
            }
            if (!bl2) {
                string3 = "false";
            }
            if (bl3) {
                string4 = "true";
            }
            statement = connection.prepareCall("begin dbms_aqadm.stop_queue(queue_name => ?, enqueue => " + string2 + ", dequeue => " + string3 + ", wait => " + string4 + "); end;");
            statement.setString(1, string);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.stop", sQLException);
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void stop(boolean bl) throws AQException {
        this.stop(true, true, bl);
    }

    public void stopEnqueue(boolean bl) throws AQException {
        this.stop(true, false, bl);
    }

    public void stopDequeue(boolean bl) throws AQException {
        this.stop(false, true, bl);
    }

    public void alterQueue(AQQueueProperty aQQueueProperty) throws AQException {
        CallableStatement callableStatement = null;
        Connection connection = null;
        Object var4_4 = null;
        String string = "";
        String string2 = "true";
        string = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (!aQQueueProperty.isAutoCommitEnabled()) {
                string2 = "false";
                callableStatement = connection.prepareCall("begin dbms_aqadm.alter_queue(queue_name => ?, max_retries => ?, retry_delay => ?, retention_time => ?, auto_commit => false, comment => ?); end;");
            } else {
                if (this.alterq_stmt != null) {
                    this.alterq_stmt.clearParameters();
                } else {
                    this.alterq_stmt = connection.prepareCall("begin dbms_aqadm.alter_queue(queue_name => ?, max_retries => ?, retry_delay => ?, retention_time => ?, auto_commit => true, comment => ?); end;");
                }
                callableStatement = this.alterq_stmt;
            }
            callableStatement.setString(1, string);
            if (aQQueueProperty.max_retries != null) {
                ((OracleCallableStatement)callableStatement).setObject(2, (Object)aQQueueProperty.max_retries, 4);
            } else {
                ((OracleCallableStatement)callableStatement).setNull(2, 4);
            }
            if (aQQueueProperty.retry_interval != null) {
                ((OracleCallableStatement)callableStatement).setObject(3, (Object)aQQueueProperty.retry_interval, 8);
            } else {
                ((OracleCallableStatement)callableStatement).setNull(3, 8);
            }
            if (aQQueueProperty.retention_time != null) {
                ((OracleCallableStatement)callableStatement).setObject(4, (Object)aQQueueProperty.retention_time, 8);
            } else {
                ((OracleCallableStatement)callableStatement).setNull(4, 8);
            }
            callableStatement.setString(5, aQQueueProperty.getComment());
            callableStatement.execute();
            if (!aQQueueProperty.equals(this.property)) {
                this.property.setMaxRetries(aQQueueProperty.getMaxRetries());
                this.property.setRetryInterval(aQQueueProperty.getRetryInterval());
                this.property.setRetentionTime(aQQueueProperty.getRetentionTime());
                this.property.setComment(aQQueueProperty.getComment());
            }
        }
        catch (SQLException sQLException) {
            if (string2.equals("true")) {
                try {
                    this.alterq_stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.alterq_stmt = null;
            }
            AQOracleDebug.traceEx(3, "AQOracleQueue.alterQueue", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
    }

    public AQMessage createMessage() throws AQException {
        AQOracleMessage aQOracleMessage = null;
        AQOracleRawPayload aQOracleRawPayload = null;
        AQOracleObjectPayload aQOracleObjectPayload = null;
        AQMessageProperty aQMessageProperty = null;
        aQMessageProperty = new AQMessageProperty();
        if (this.pload_type == 2) {
            aQOracleRawPayload = new AQOracleRawPayload();
            aQOracleMessage = new AQOracleMessage(this.pload_type, aQOracleRawPayload, aQMessageProperty);
        } else if (this.pload_type == 1) {
            aQOracleObjectPayload = new AQOracleObjectPayload();
            aQOracleMessage = new AQOracleMessage(this.pload_type, aQOracleObjectPayload, aQMessageProperty);
        } else {
            AQUtil.throwAQEx(129);
        }
        return aQOracleMessage;
    }

    public void drop() throws AQException {
        Statement statement = null;
        Connection connection = null;
        String string = "";
        boolean bl = true;
        String string2 = "true";
        string = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (!bl) {
                string2 = "false";
            }
            statement = connection.prepareCall("begin dbms_aqadm.drop_queue(queue_name => ?, auto_commit =>" + string2 + "); end;");
            statement.setString(1, string);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dropQueue", sQLException);
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
        this.aq_sess = null;
    }

    public byte[] enqueue(AQEnqueueOption aQEnqueueOption, AQMessage aQMessage) throws AQException {
        Connection connection = null;
        String string = "";
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        AQMessageProperty aQMessageProperty = null;
        AQAgent aQAgent = null;
        AQOracleRawPayload aQOracleRawPayload = null;
        AQOracleObjectPayload aQOracleObjectPayload = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string2 = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Object var17_17 = null;
        Integer n4 = null;
        Hashtable hashtable = null;
        Vector vector = null;
        int n5 = 0;
        ARRAY aRRAY = null;
        AQSignature aQSignature = null;
        int n6 = 0;
        if (aQMessage == null) {
            AQUtil.throwAQEx(133);
        }
        if (aQEnqueueOption == null) {
            AQUtil.throwAQEx(176);
        }
        string = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        aQMessageProperty = aQMessage.getMessageProperty();
        aQAgent = aQMessageProperty.getSender();
        aQSignature = aQMessageProperty.getSignature();
        try {
            connection = this.aq_sess.getDBConnection();
            hashtable = (Hashtable)((OracleConnection)connection).getTypeMap();
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(184);
        }
        try {
            hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(146, exception);
        }
        aQOracleRawPayload = (AQOracleRawPayload)aQMessage.getRawPayload();
        if (aQOracleRawPayload != null && this.pload_type != 2) {
            AQUtil.throwAQEx(171, "RAW");
        }
        if ((aQOracleObjectPayload = (AQOracleObjectPayload)aQMessage.getObjectPayload()) != null && this.pload_type != 1) {
            AQUtil.throwAQEx(171, "OBJECT");
        }
        if ((vector = aQMessageProperty.getRecipientList()) != null && !vector.isEmpty()) {
            n5 = vector.size();
        }
        try {
            if (aQOracleRawPayload != null) {
                oracleCallableStatement = this.getEnqRawStmt(n5, connection);
                byArray = aQOracleRawPayload.getBytes();
                oracleCallableStatement.setBytes(15, byArray);
                n4 = new Integer(2);
            } else if (aQOracleObjectPayload != null) {
                oracleCallableStatement = this.getEnqObjStmt(n5, connection);
                if (aQOracleObjectPayload.getCustomDatum() != null) {
                    oracleCallableStatement.setCustomDatum(15, aQOracleObjectPayload.getCustomDatum());
                } else if (aQOracleObjectPayload.getORAData() != null) {
                    oracleCallableStatement.setORAData(15, aQOracleObjectPayload.getORAData());
                } else if (aQOracleObjectPayload.getSqlData() != null) {
                    Class<?> clazz = aQOracleObjectPayload.getClass();
                    hashtable.put(this.p_data_type, clazz.getName());
                    oracleCallableStatement.setObject(15, (Object)aQOracleObjectPayload.getSqlData(), 2002);
                } else if (aQOracleObjectPayload.getStruct() != null) {
                    oracleCallableStatement.setObject(15, (Object)aQOracleObjectPayload.getStruct(), 2002);
                } else {
                    AQOracleDebug.trace(3, "AQOracleQueue.enqueue-3", "Null object payload");
                    AQUtil.throwAQEx(104);
                }
                n4 = new Integer(1);
            } else {
                AQOracleDebug.trace(3, "AQOracleQueue.enqueue-2", "Null payload");
                AQUtil.throwAQEx(104);
            }
            oracleCallableStatement.setString(1, string);
            if (aQAgent != null) {
                oracleCallableStatement.setString(2, aQAgent.getName());
                oracleCallableStatement.setString(3, aQAgent.getAddress());
                oracleCallableStatement.setInt(4, aQAgent.getProtocol());
            } else {
                oracleCallableStatement.setString(2, null);
                oracleCallableStatement.setString(3, null);
                oracleCallableStatement.setInt(4, 0);
            }
            if (aQMessageProperty.getOrigMessageId() != null) {
                oracleCallableStatement.setObject(5, (Object)aQMessageProperty.getOrigMessageId(), -2);
            } else {
                oracleCallableStatement.setNull(5, -2);
            }
            oracleCallableStatement.setString(6, aQMessageProperty.getCorrelation());
            n = new Integer(aQEnqueueOption.getVisibility());
            oracleCallableStatement.setObject(7, (Object)n, 4);
            n2 = new Integer(aQMessageProperty.getPriority());
            oracleCallableStatement.setObject(8, (Object)n2, 4);
            n3 = new Integer(aQMessageProperty.getDelay());
            oracleCallableStatement.setObject(9, (Object)n3, 4);
            oracleCallableStatement.setLong(10, aQMessageProperty.getExpiration());
            if (aQEnqueueOption.getRelMessageId() == null) {
                oracleCallableStatement.setNull(11, -2);
            } else {
                oracleCallableStatement.setBytes(11, aQEnqueueOption.getRelMessageId());
            }
            if (aQEnqueueOption.seq_deviation == null) {
                oracleCallableStatement.setNull(12, 2);
            } else {
                oracleCallableStatement.setObject(12, (Object)aQEnqueueOption.seq_deviation, 4);
            }
            oracleCallableStatement.setString(13, aQMessageProperty.getExceptionQueue());
            oracleCallableStatement.setObject(14, (Object)n4, 4);
            oracleCallableStatement.registerOutParameter(16, -2);
            if (n5 > 0) {
                aRRAY = this.createRecpArrayfromVector(vector);
                oracleCallableStatement.setObject(17, (Object)aRRAY, 2003);
            }
            if (this.aq_sess.is82compatible()) {
                AQOracleDebug.trace(3, "AQOracleQueue.enqueue", "82 compatible");
                n6 = n5 > 0 ? 18 : 17;
                if (aQSignature != null) {
                    oracleCallableStatement.setORAData(n6, (ORAData)aQSignature);
                } else {
                    oracleCallableStatement.setNull(n6, 2002, "SYS.AQ$_SIG_PROP");
                }
                oracleCallableStatement.setString(++n6, aQEnqueueOption.getTransformation());
            }
            resultSet = oracleCallableStatement.executeQuery();
            byArray2 = oracleCallableStatement.getBytes(16);
            ((AQOracleMessage)aQMessage).setMessageId(byArray2);
            if (AQOracleDebug.DEBUG) {
                string2 = oracleCallableStatement.getString(16);
                AQOracleDebug.trace(3, "AQOracleQueue.enqueue", string2);
            }
            if (!AQDriverManager.isStmtCachingEnabled()) {
                this.destroyStmt(oracleCallableStatement);
            }
            resultSet.close();
        }
        catch (AQException aQException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.enqueue-4", aQException);
            this.destroyStmt(oracleCallableStatement);
            throw aQException;
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.enqueue-5", sQLException);
            this.destroyStmt(oracleCallableStatement);
            throw new AQOracleSQLException(sQLException);
        }
        return byArray2;
    }

    public AQMessage dequeue(AQDequeueOption aQDequeueOption) throws AQException {
        if (this.pload_type == 1) {
            AQUtil.throwAQEx(174);
        }
        return this.dequeue(aQDequeueOption, null, null, false);
    }

    public AQMessage dequeue(AQDequeueOption aQDequeueOption, CustomDatumFactory customDatumFactory) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (customDatumFactory == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(aQDequeueOption, customDatumFactory, null, false);
    }

    public AQMessage dequeue(AQDequeueOption aQDequeueOption, ORADataFactory oRADataFactory) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (oRADataFactory == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(aQDequeueOption, oRADataFactory, null, false);
    }

    public AQMessage dequeue(AQDequeueOption aQDequeueOption, Class clazz) throws AQException {
        Class<?> clazz2 = null;
        String string = null;
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (clazz == null) {
            AQUtil.throwAQEx(169);
        }
        if ((string = clazz.getName()).equals("java.sql.SQLData")) {
            AQUtil.throwAQEx(191);
        }
        if (!string.equals("oracle.sql.STRUCT")) {
            try {
                clazz2 = Class.forName("java.sql.SQLData");
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(109);
            }
            if (!clazz2.isAssignableFrom(clazz)) {
                AQUtil.throwAQEx(191);
            }
        }
        return this.dequeue(aQDequeueOption, null, clazz, false);
    }

    AQMessage dequeue(AQDequeueOption aQDequeueOption, Object object, Class clazz, boolean bl) throws AQException {
        Connection connection = null;
        String string = "";
        OracleCallableStatement oracleCallableStatement = null;
        Object var8_8 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        Object var11_11 = null;
        ResultSet resultSet = null;
        AQMessageProperty aQMessageProperty = null;
        AQOracleMessage aQOracleMessage = null;
        AQAgent aQAgent = null;
        AQOracleRawPayload aQOracleRawPayload = null;
        AQOracleObjectPayload aQOracleObjectPayload = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        String string2 = null;
        Timestamp timestamp = null;
        Hashtable hashtable = null;
        long l = 0L;
        long l2 = 0L;
        CustomDatum customDatum = null;
        ORAData oRAData = null;
        SQLData sQLData = null;
        STRUCT sTRUCT = null;
        ARRAY aRRAY = null;
        AQAgent[] aQAgentArray = null;
        Vector<AQAgent> vector = null;
        int n6 = 0;
        int n7 = 0;
        String string3 = null;
        int n8 = 0;
        if (aQDequeueOption == null) {
            AQUtil.throwAQEx(175);
        }
        string = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        if (this.pload_type == 1 && object == null && clazz == null) {
            AQUtil.throwAQEx(167);
        }
        if (object != null && clazz != null) {
            AQUtil.throwAQEx(168);
        }
        try {
            try {
                connection = this.aq_sess.getDBConnection();
                hashtable = (Hashtable)((OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(146, exception);
            }
            if (this.pload_type == 2) {
                oracleCallableStatement = this.getDeqRawStmt(connection);
                n5 = new Integer(2);
                oracleCallableStatement.registerOutParameter(24, -2);
            } else if (this.pload_type == 1) {
                oracleCallableStatement = this.getDeqObjStmt(connection);
                n5 = new Integer(1);
                oracleCallableStatement.registerOutParameter(24, -2);
                if (aQDequeueOption.getTransformation() != null) {
                    string3 = this.getTransfxmDest(aQDequeueOption.getTransformation());
                    AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "transfxm:" + aQDequeueOption.getTransformation());
                    AQOracleDebug.trace(5, "AQOracleQueue.dequeue", "user_payload_type: " + string3);
                    if (string3.equalsIgnoreCase("SYS.XMLTYPE")) {
                        oracleCallableStatement.registerOutParameter(25, 2007, string3);
                    } else {
                        oracleCallableStatement.registerOutParameter(25, 2002, string3);
                    }
                } else if (this.p_data_type.equalsIgnoreCase("SYS.XMLTYPE")) {
                    oracleCallableStatement.registerOutParameter(25, 2007, this.p_data_type);
                } else {
                    oracleCallableStatement.registerOutParameter(25, 2002, this.p_data_type);
                }
            } else {
                AQUtil.throwAQEx(129);
            }
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "q_name=" + string);
            oracleCallableStatement.setString(1, string);
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "cons_name=" + aQDequeueOption.getConsumerName());
            oracleCallableStatement.setString(2, aQDequeueOption.getConsumerName());
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "message_id=" + aQDequeueOption.getMessageId());
            if (aQDequeueOption.getMessageId() == null) {
                oracleCallableStatement.setNull(3, -2);
            } else {
                oracleCallableStatement.setBytes(3, aQDequeueOption.getMessageId());
            }
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "corr_id=" + aQDequeueOption.getCorrelation());
            oracleCallableStatement.setString(4, aQDequeueOption.getCorrelation());
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "deq_mode=" + aQDequeueOption.getDequeueMode());
            n3 = new Integer(aQDequeueOption.getDequeueMode());
            oracleCallableStatement.setObject(5, (Object)n3, 4);
            n = new Integer(aQDequeueOption.getNavigationMode());
            oracleCallableStatement.setObject(6, (Object)n, 4);
            n2 = new Integer(aQDequeueOption.getVisibility());
            oracleCallableStatement.setObject(7, (Object)n2, 4);
            n4 = new Integer(aQDequeueOption.getWaitTime());
            oracleCallableStatement.setObject(8, (Object)n4, 4);
            oracleCallableStatement.registerOutParameter(9, 91);
            oracleCallableStatement.registerOutParameter(10, 4);
            oracleCallableStatement.registerOutParameter(11, -2);
            oracleCallableStatement.registerOutParameter(12, 12);
            oracleCallableStatement.registerOutParameter(13, 4);
            oracleCallableStatement.registerOutParameter(14, 4);
            oracleCallableStatement.registerOutParameter(15, 4);
            oracleCallableStatement.registerOutParameter(16, 4);
            oracleCallableStatement.registerOutParameter(17, 12);
            oracleCallableStatement.registerOutParameter(18, 2003, "SYS.AQ$_RECIPIENTS");
            oracleCallableStatement.registerOutParameter(19, 12);
            oracleCallableStatement.registerOutParameter(20, 12);
            oracleCallableStatement.registerOutParameter(21, 4);
            oracleCallableStatement.registerOutParameter(22, -2);
            oracleCallableStatement.setObject(23, (Object)n5, 4);
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "bound all pre82 params");
            if (this.aq_sess.is82compatible()) {
                AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "binding v82 params");
                if (this.pload_type == 2) {
                    n6 = 25;
                } else if (this.pload_type == 1) {
                    n6 = 26;
                }
                AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "idx: " + n6 + " condition: " + aQDequeueOption.getCondition());
                oracleCallableStatement.setString(n6++, aQDequeueOption.getCondition());
                if (aQDequeueOption.getSignature() != null) {
                    oracleCallableStatement.setORAData(n6++, (ORAData)aQDequeueOption.getSignature());
                } else {
                    oracleCallableStatement.setNull(n6++, 2002, "SYS.AQ$_SIG_PROP");
                }
                oracleCallableStatement.registerOutParameter(n6, 2002, "SYS.AQ$_SIG_PROP");
                n8 = n6++;
                oracleCallableStatement.setString(n6, aQDequeueOption.getTransformation());
            }
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "before execute");
            resultSet = oracleCallableStatement.executeQuery();
            AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "after execute");
            aQMessageProperty = new AQMessageProperty();
            timestamp = oracleCallableStatement.getTimestamp(9);
            l = ((Date)timestamp).getTime();
            l2 = l + (long)(timestamp.getNanos() / 1000000);
            Date date = new Date(l2);
            aQMessageProperty.setEnqueueTime(date);
            aQMessageProperty.setState(oracleCallableStatement.getInt(10));
            byArray2 = oracleCallableStatement.getBytes(11);
            aQMessageProperty.setCorrelation(oracleCallableStatement.getString(12));
            aQMessageProperty.setPriority(oracleCallableStatement.getInt(13));
            aQMessageProperty.setDelay(oracleCallableStatement.getInt(14));
            aQMessageProperty.setExpiration(oracleCallableStatement.getLong(15));
            aQMessageProperty.setAttempts(oracleCallableStatement.getInt(16));
            aQMessageProperty.setExceptionQueue(oracleCallableStatement.getString(17));
            if (bl && (aRRAY = oracleCallableStatement.getARRAY(18)) != null && aRRAY.length() > 0) {
                aQAgentArray = this.createAgentListfromSubsArray(aRRAY);
                vector = new Vector<AQAgent>(aQAgentArray.length);
                n7 = 0;
                while (n7 < aQAgentArray.length) {
                    vector.addElement(aQAgentArray[n7]);
                    ++n7;
                }
                aQMessageProperty.setRecipientList(vector);
            }
            if ((string2 = oracleCallableStatement.getString(19)) != null && !string2.equals("")) {
                aQAgent = new AQAgent(string2, oracleCallableStatement.getString(20), oracleCallableStatement.getInt(21));
                aQMessageProperty.setSender(aQAgent);
            }
            aQMessageProperty.setOrigMessageId(oracleCallableStatement.getBytes(22));
            if (this.pload_type == 2) {
                byArray = oracleCallableStatement.getBytes(24);
                aQOracleRawPayload = new AQOracleRawPayload(byArray, byArray.length);
                aQOracleMessage = new AQOracleMessage(this.pload_type, aQOracleRawPayload, aQMessageProperty);
            } else {
                if (object != null) {
                    AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "payload_fact != null");
                    if (object instanceof CustomDatumFactory) {
                        AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "payload_fact == CustomDatumFactory");
                        customDatum = (CustomDatum)oracleCallableStatement.getCustomDatum(25, (CustomDatumFactory)object);
                        aQOracleObjectPayload = new AQOracleObjectPayload(customDatum);
                    } else {
                        AQOracleDebug.trace(4, "AQOracleQueue.dequeue", "payload_fact == ORADataFactory");
                        oRAData = (ORAData)oracleCallableStatement.getORAData(25, (ORADataFactory)object);
                        aQOracleObjectPayload = new AQOracleObjectPayload(oRAData);
                    }
                } else if (clazz != null) {
                    String string4 = clazz.getName();
                    AQOracleDebug.trace(5, "AQOracleQueue.dequeue", "sql_data_cl!= null:" + string4);
                    if (string4.equals("oracle.sql.STRUCT")) {
                        sTRUCT = (STRUCT)oracleCallableStatement.getObject(25, (Map<String, Class<?>>)null);
                        aQOracleObjectPayload = new AQOracleObjectPayload(sTRUCT);
                    } else {
                        if (aQDequeueOption.getTransformation() != null) {
                            hashtable.put(string3, clazz);
                        } else {
                            hashtable.put(this.p_data_type, clazz);
                        }
                        sQLData = (SQLData)oracleCallableStatement.getObject(25);
                        aQOracleObjectPayload = new AQOracleObjectPayload(sQLData);
                    }
                }
                AQOracleDebug.trace(5, "AQOracleQueue.dequeue", "before constructing message");
                aQOracleMessage = new AQOracleMessage(this.pload_type, aQOracleObjectPayload, aQMessageProperty);
                AQOracleDebug.trace(5, "AQOracleQueue.dequeue", "after constructing message");
            }
            aQOracleMessage.setMessageId(byArray2);
            if (this.aq_sess.is82compatible()) {
                aQMessageProperty.setSignature((AQSignature)oracleCallableStatement.getORAData(n8, AQSignature.getFactory()));
            }
            if (!AQDriverManager.isStmtCachingEnabled()) {
                this.destroyStmt(oracleCallableStatement);
            }
        }
        catch (AQException aQException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dequeue-2", aQException);
            this.destroyStmt(oracleCallableStatement);
            throw aQException;
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dequeue-3", sQLException);
            this.destroyStmt(oracleCallableStatement);
            throw new AQOracleSQLException(sQLException);
        }
        return aQOracleMessage;
    }

    public void addSubscriber(AQAgent aQAgent, String string) throws AQException {
        Connection connection = null;
        String string2 = "";
        Hashtable hashtable = null;
        AQOracleAgent aQOracleAgent = null;
        if (aQAgent == null) {
            AQUtil.throwAQEx(149);
        }
        string2 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
                hashtable = (Hashtable)((OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(146, exception);
            }
            aQOracleAgent = new AQOracleAgent(aQAgent.getName(), aQAgent.getAddress(), aQAgent.getProtocol());
            if (this.adds_stmt != null) {
                this.adds_stmt.clearParameters();
            } else {
                this.adds_stmt = connection.prepareCall("begin dbms_aqadm.add_subscriber(queue_name => ?, subscriber => ?, rule => ?); end;");
            }
            this.adds_stmt.setString(1, string2);
            this.adds_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            this.adds_stmt.setString(3, string);
            this.adds_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.adds_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.adds_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.addSubscriber", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void removeSubscriber(AQAgent aQAgent) throws AQException {
        Connection connection = null;
        String string = "";
        Hashtable hashtable = null;
        AQOracleAgent aQOracleAgent = null;
        if (aQAgent == null) {
            AQUtil.throwAQEx(149);
        }
        string = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
                hashtable = (Hashtable)((OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(146, exception);
            }
            aQOracleAgent = new AQOracleAgent(aQAgent.getName(), aQAgent.getAddress(), aQAgent.getProtocol());
            if (this.rems_stmt != null) {
                this.rems_stmt.clearParameters();
            } else {
                this.rems_stmt = connection.prepareCall("begin dbms_aqadm.remove_subscriber(queue_name => ?, subscriber => ?); end;");
            }
            this.rems_stmt.setString(1, string);
            this.rems_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            this.rems_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.rems_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rems_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.removeSubscriber", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void alterSubscriber(AQAgent aQAgent, String string) throws AQException {
        Connection connection = null;
        String string2 = "";
        Hashtable hashtable = null;
        AQOracleAgent aQOracleAgent = null;
        if (aQAgent == null) {
            AQUtil.throwAQEx(149);
        }
        string2 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
                hashtable = (Hashtable)((OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(146, exception);
            }
            aQOracleAgent = new AQOracleAgent(aQAgent.getName(), aQAgent.getAddress(), aQAgent.getProtocol());
            if (this.alts_stmt != null) {
                this.alts_stmt.clearParameters();
            } else {
                this.alts_stmt = connection.prepareCall("begin dbms_aqadm.alter_subscriber(queue_name => ?, subscriber => ?, rule => ?); end;");
            }
            this.alts_stmt.setString(1, string2);
            this.alts_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            this.alts_stmt.setString(3, string);
            this.alts_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.alts_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alts_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.alterSubscriber", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
    }

    public AQAgent[] getSubscribers() throws AQException {
        Connection connection = null;
        Statement statement = null;
        Hashtable hashtable = null;
        String string = "";
        ARRAY aRRAY = null;
        AQAgent[] aQAgentArray = null;
        string = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
                hashtable = (Hashtable)((OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(146, exception);
            }
            statement = (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_queue_subscribers(?, ?); end;");
            statement.setString(1, string);
            statement.registerOutParameter(2, 2003, "SYS.AQ$_SUBSCRIBERS");
            statement.execute();
            aRRAY = statement.getARRAY(2);
            if (aRRAY != null && aRRAY.length() > 0) {
                AQOracleDebug.println("Array is of length: " + aRRAY.length());
                AQOracleDebug.println("Array is of type " + aRRAY.getSQLTypeName());
                AQOracleDebug.println("Array element is of type code " + aRRAY.getBaseType());
                AQOracleDebug.println("Array element is of type name " + aRRAY.getBaseTypeName());
                aQAgentArray = this.createAgentListfromSubsArray(aRRAY);
            }
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getSubscribers", sQLException);
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
        return aQAgentArray;
    }

    public void schedulePropagation(String string, Date date, Double d, String string2, Double d2) throws AQException {
        Connection connection = null;
        Statement statement = null;
        Timestamp timestamp = null;
        String string3 = "";
        Double d3 = null;
        string3 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (date != null) {
                timestamp = new Timestamp(date.getTime());
                statement = connection.prepareCall("begin dbms_aqadm.schedule_propagation(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?, start_time => ?); end;");
                statement.setTimestamp(6, timestamp);
            } else {
                statement = connection.prepareCall("begin dbms_aqadm.schedule_propagation(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?); end;");
            }
            statement.setString(1, string3);
            statement.setString(2, string);
            if (d != null) {
                statement.setObject(3, d, 8);
            } else {
                statement.setNull(3, 8);
            }
            statement.setString(4, string2);
            if (d2 != null) {
                statement.setObject(5, d2, 8);
            } else {
                d3 = new Double(60.0);
                statement.setObject(5, d3, 8);
            }
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.schedulePropagation", sQLException);
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void unschedulePropagation(String string) throws AQException {
        Connection connection = null;
        String string2 = "";
        string2 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (this.unscprop_stmt != null) {
                this.unscprop_stmt.clearParameters();
            } else {
                this.unscprop_stmt = connection.prepareCall("begin dbms_aqadm.unschedule_propagation(queue_name => ?, destination => ?); end;");
            }
            this.unscprop_stmt.setString(1, string2);
            this.unscprop_stmt.setString(2, string);
            this.unscprop_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.unscprop_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.unscprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.unschedulePropagation", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void alterPropagationSchedule(String string, Double d, String string2, Double d2) throws AQException {
        Connection connection = null;
        Object var6_6 = null;
        String string3 = "";
        Double d3 = null;
        string3 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (this.alprop_stmt != null) {
                this.alprop_stmt.clearParameters();
            } else {
                this.alprop_stmt = connection.prepareCall("begin dbms_aqadm.alter_propagation_schedule(queue_name => ?, destination => ?, duration => ?, next_time => ?, latency => ?); end;");
            }
            this.alprop_stmt.setString(1, string3);
            this.alprop_stmt.setString(2, string);
            if (d != null) {
                this.alprop_stmt.setObject(3, (Object)d, 8);
            } else {
                this.alprop_stmt.setNull(3, 8);
            }
            this.alprop_stmt.setString(4, string2);
            if (d2 != null) {
                this.alprop_stmt.setObject(5, (Object)d2, 8);
            } else {
                d3 = new Double(60.0);
                this.alprop_stmt.setObject(5, (Object)d3, 8);
            }
            this.alprop_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.alprop_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.alterPropagationSchedule", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void enablePropagationSchedule(String string) throws AQException {
        Connection connection = null;
        String string2 = "";
        string2 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (this.enprop_stmt != null) {
                this.enprop_stmt.clearParameters();
            } else {
                this.enprop_stmt = connection.prepareCall("begin dbms_aqadm.enable_propagation_schedule(queue_name => ?, destination => ?); end;");
            }
            this.enprop_stmt.setString(1, string2);
            this.enprop_stmt.setString(2, string);
            this.enprop_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.enprop_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.enprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.enablePropagationSchedule", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void disablePropagationSchedule(String string) throws AQException {
        Connection connection = null;
        String string2 = "";
        string2 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (this.disprop_stmt != null) {
                this.disprop_stmt.clearParameters();
            } else {
                this.disprop_stmt = connection.prepareCall("begin dbms_aqadm.disable_propagation_schedule(queue_name => ?, destination => ?); end;");
            }
            this.disprop_stmt.setString(1, string2);
            this.disprop_stmt.setString(2, string);
            this.disprop_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.disprop_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.disprop_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueue.disablePropagationSchedule", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void grantQueuePrivilege(String string, String string2, boolean bl) throws AQException {
        Connection connection = null;
        Statement statement = null;
        String string3 = "";
        String string4 = "false";
        string3 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            if (bl) {
                string4 = "true";
            }
            statement = connection.prepareCall("begin dbms_aqadm.grant_queue_privilege(privilege => ?, queue_name => ?, grantee => ?, grant_option => " + string4 + "); end;");
            statement.setString(1, string);
            statement.setString(2, string3);
            statement.setString(3, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.grantQueuePrivilege", sQLException);
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
    }

    public void grantQueuePrivilege(String string, String string2) throws AQException {
        this.grantQueuePrivilege(string, string2, false);
    }

    public void revokeQueuePrivilege(String string, String string2) throws AQException {
        Connection connection = null;
        CallableStatement callableStatement = null;
        String string3 = "";
        string3 = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                connection = this.aq_sess.getDBConnection();
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(184);
            }
            callableStatement = connection.prepareCall("begin dbms_aqadm.revoke_queue_privilege(privilege => ?, queue_name => ?, grantee => ?); end;");
            callableStatement.setString(1, string);
            callableStatement.setString(2, string3);
            callableStatement.setString(3, string2);
            callableStatement.execute();
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.revokeQueuePrivilege", sQLException);
            try {
                callableStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
    }

    public byte[] propEnqueue(AQEnqueueOption aQEnqueueOption, AQMessage aQMessage) throws AQException {
        return this.enqueue(aQEnqueueOption, aQMessage);
    }

    public AQMessage propDequeue(AQDequeueOption aQDequeueOption) throws AQException {
        if (this.pload_type == 1) {
            AQUtil.throwAQEx(174);
        }
        return this.dequeue(aQDequeueOption, null, null, true);
    }

    public AQMessage propDequeue(AQDequeueOption aQDequeueOption, Class clazz) throws AQException {
        Class<?> clazz2 = null;
        String string = null;
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (clazz == null) {
            AQUtil.throwAQEx(169);
        }
        if ((string = clazz.getName()).equals("java.sql.SQLData")) {
            AQUtil.throwAQEx(191);
        }
        try {
            clazz2 = Class.forName("java.sql.SQLData");
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(109);
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            AQUtil.throwAQEx(191);
        }
        return this.dequeue(aQDequeueOption, null, clazz, true);
    }

    public AQMessage propDequeue(AQDequeueOption aQDequeueOption, CustomDatumFactory customDatumFactory) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (customDatumFactory == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(aQDequeueOption, customDatumFactory, null, true);
    }

    public AQMessage propDequeue(AQDequeueOption aQDequeueOption, ORADataFactory oRADataFactory) throws AQException {
        if (this.pload_type == 2) {
            AQUtil.throwAQEx(177);
        }
        if (oRADataFactory == null) {
            AQUtil.throwAQEx(137);
        }
        return this.dequeue(aQDequeueOption, oRADataFactory, null, true);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AQQueue]");
        stringBuffer.append("\n  owner            : " + this.owner);
        stringBuffer.append("\n  name             : " + this.name);
        stringBuffer.append("\n  queue table      : " + this.table);
        if (this.property != null) {
            stringBuffer.append("\n" + this.property.toString());
        }
        if (this.pload_type == 2) {
            stringBuffer.append("\n  Payload type     : RAW");
        } else if (this.pload_type == 1) {
            stringBuffer.append("\n  Payload type     : OBJECT");
        } else {
            stringBuffer.append("\n  Payload type     : UNKNOWN");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean isMultiConsumer() throws AQException {
        int n;
        if (this.queue_type == null) {
            AQOracleDebug.trace(4, "AQOracleQueue.isMultiConsumer", "queue_type==null");
            AQQueueTable aQQueueTable = this.aq_sess.getQueueTable(this.getOwner(), this.getQueueTableName());
            this.queue_type = ((AQOracleQueueTable)aQQueueTable).isMulticonsumerEnabled() ? new Integer(2) : new Integer(1);
        }
        return (n = this.queue_type.intValue()) == 2;
    }

    private ARRAY createRecpArrayfromVector(Vector vector) throws AQException {
        Connection connection = null;
        ArrayDescriptor arrayDescriptor = null;
        Object[] objectArray = null;
        ARRAY aRRAY = null;
        int n = 0;
        AQOracleAgent aQOracleAgent = null;
        AQAgent aQAgent = null;
        int n2 = 0;
        if (vector == null || vector.isEmpty()) {
            AQUtil.throwAQEx(145);
        }
        n = vector.size();
        objectArray = new Object[n];
        n2 = 0;
        while (n2 < n) {
            aQAgent = (AQAgent)vector.elementAt(n2);
            aQOracleAgent = new AQOracleAgent(aQAgent.getName(), aQAgent.getAddress(), aQAgent.getProtocol());
            objectArray[n2] = aQOracleAgent;
            ++n2;
        }
        try {
            connection = this.aq_sess.getDBConnection();
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(184);
        }
        try {
            arrayDescriptor = ArrayDescriptor.createDescriptor((String)"SYS.AQ$_RECIPIENTS", (Connection)connection);
            aRRAY = new ARRAY(arrayDescriptor, connection, (Object)objectArray);
        }
        catch (SQLException sQLException) {
            throw new AQOracleSQLException(sQLException);
        }
        return aRRAY;
    }

    private AQAgent[] createAgentListfromSubsArray(ARRAY aRRAY) throws AQException {
        Connection connection = null;
        Object var3_3 = null;
        Object[] objectArray = null;
        int n = 0;
        AQOracleAgent aQOracleAgent = null;
        Object var7_7 = null;
        AQAgent[] aQAgentArray = null;
        Hashtable hashtable = null;
        int n2 = 0;
        try {
            connection = this.aq_sess.getDBConnection();
            hashtable = (Hashtable)((OracleConnection)connection).getTypeMap();
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(184);
        }
        try {
            if (aRRAY == null || aRRAY.length() == 0) {
                AQUtil.throwAQEx(145);
            }
            n = aRRAY.length();
            aQAgentArray = new AQAgent[n];
            objectArray = (Object[])aRRAY.getArray((Map)hashtable);
        }
        catch (SQLException sQLException) {
            throw new AQOracleSQLException(sQLException);
        }
        n2 = 0;
        while (n2 < n) {
            aQOracleAgent = (AQOracleAgent)objectArray[n2];
            AQOracleDebug.println("Agent: " + aQOracleAgent.name + "  " + aQOracleAgent.address + "  " + aQOracleAgent.protocol);
            aQAgentArray[n2] = new AQAgent(aQOracleAgent.name, aQOracleAgent.address, aQOracleAgent.protocol);
            ++n2;
        }
        return aQAgentArray;
    }

    OracleCallableStatement getEnqRawStmt(int n, Connection connection) throws AQException, SQLException {
        OracleCallableStatement oracleCallableStatement;
        AQOracleDebug.trace(4, "AQOracleQueue.getEnqRawStmt", "num_recps=" + n);
        if (n > 0) {
            if (this.enqr_rcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqRawStmt", "recp list - stmt=null");
                this.enqr_rcp_stmt = this.aq_sess.is82compatible() ? (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_enqueue_raw( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ?, object_user_data => null, recipients => ?, signature => ?, transformation => ?); end; ") : (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_enqueue_raw( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ?, object_user_data => null, recipients => ?); end; ");
            } else {
                this.enqr_rcp_stmt.clearParameters();
            }
            oracleCallableStatement = this.enqr_rcp_stmt;
        } else {
            if (this.enqr_norcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqRawStmt", "no recp list - stmt=null");
                this.enqr_norcp_stmt = this.aq_sess.is82compatible() ? (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_enqueue_raw_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ?, signature => ?, transformation => ?); end; ") : (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_enqueue_raw_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => ?, msgid => ?); end; ");
            } else {
                this.enqr_norcp_stmt.clearParameters();
            }
            oracleCallableStatement = this.enqr_norcp_stmt;
        }
        return oracleCallableStatement;
    }

    OracleCallableStatement getEnqObjStmt(int n, Connection connection) throws AQException, SQLException {
        OracleCallableStatement oracleCallableStatement;
        AQOracleDebug.trace(4, "AQOracleQueue.getEnqObjStmt", "num_recps=" + n);
        if (n > 0) {
            if (this.enqo_rcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqObjStmt", "recp list - stmt=null");
                if (this.aq_sess.is82compatible()) {
                    AQOracleDebug.trace(3, "AQOracleQueue.getEnqObjStmt", "82 compatible");
                    this.enqo_rcp_stmt = (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_enqueue_obj( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ?, signature => ?, transformation => ?); end;");
                } else {
                    AQOracleDebug.trace(3, "AQOracleQueue.getEnqObjStmt", "not 82 compatible");
                    this.enqo_rcp_stmt = (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_enqueue_obj( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ?); end;");
                }
            } else {
                this.enqo_rcp_stmt.clearParameters();
            }
            oracleCallableStatement = this.enqo_rcp_stmt;
        } else {
            if (this.enqo_norcp_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleQueue.getEnqObjStmt", "no recp list - stmt=null");
                if (this.aq_sess.is82compatible()) {
                    AQOracleDebug.trace(3, "AQOracleQueue.getEnqObjStmt", "82 compatible");
                    this.enqo_norcp_stmt = (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_enqueue_obj_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, signature => ?, transformation => ?); end; ");
                } else {
                    AQOracleDebug.trace(3, "AQOracleQueue.getEnqObjStmt", "not 82 compatible");
                    this.enqo_norcp_stmt = (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_enqueue_obj_no_recpl( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?); end; ");
                }
            } else {
                this.enqo_norcp_stmt.clearParameters();
            }
            oracleCallableStatement = this.enqo_norcp_stmt;
        }
        return oracleCallableStatement;
    }

    OracleCallableStatement getDeqRawStmt(Connection connection) throws AQException, SQLException {
        AQOracleDebug.trace(4, "AQOracleQueue.getDeqRawStmt", "entry");
        if (this.deq_raw_stmt == null) {
            AQOracleDebug.trace(4, "AQOracleQueue.getDeqRawStmt", "stmt=null");
            this.deq_raw_stmt = this.aq_sess.is82compatible() ? (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_dequeue_raw( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ") : (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_dequeue_raw( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ");
        } else {
            this.deq_raw_stmt.clearParameters();
        }
        return this.deq_raw_stmt;
    }

    OracleCallableStatement getDeqObjStmt(Connection connection) throws AQException, SQLException {
        AQOracleDebug.trace(4, "AQOracleQueue.getDeqObjStmt", "entry");
        if (this.deq_obj_stmt == null) {
            AQOracleDebug.trace(4, "AQOracleQueue.getDeqObjStmt", "stmt=null");
            this.deq_obj_stmt = this.aq_sess.is82compatible() ? (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ") : (OracleCallableStatement)connection.prepareCall("begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ");
        } else {
            this.deq_obj_stmt.clearParameters();
        }
        return this.deq_obj_stmt;
    }

    void destroyStmt(OracleCallableStatement oracleCallableStatement) throws AQException {
        if (oracleCallableStatement == null) {
            return;
        }
        try {
            if (oracleCallableStatement == this.enqo_rcp_stmt) {
                this.enqo_rcp_stmt = null;
            } else if (oracleCallableStatement == this.enqo_norcp_stmt) {
                this.enqo_norcp_stmt = null;
            } else if (oracleCallableStatement == this.enqr_rcp_stmt) {
                this.enqr_rcp_stmt = null;
            } else if (oracleCallableStatement == this.enqr_norcp_stmt) {
                this.enqr_norcp_stmt = null;
            } else if (oracleCallableStatement == this.deq_raw_stmt) {
                this.deq_raw_stmt = null;
            } else if (oracleCallableStatement == this.deq_obj_stmt) {
                this.deq_obj_stmt = null;
            } else {
                AQOracleDebug.trace(1, "AQOracleQueue.destroyStmt", "internal error - stmt not found");
                AQUtil.throwAQEx(122, "stmt not found");
            }
            oracleCallableStatement.close();
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.destroystmterror during stmt close", sQLException);
        }
    }

    public void close() {
        try {
            if (this.alterq_stmt != null) {
                this.alterq_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.rems_stmt != null) {
                this.rems_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.adds_stmt != null) {
                this.adds_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.alts_stmt != null) {
                this.alts_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.allq_stmt != null) {
                this.allq_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.allqo_stmt != null) {
                this.allqo_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.alprop_stmt != null) {
                this.alprop_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.unscprop_stmt != null) {
                this.unscprop_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.enprop_stmt != null) {
                this.enprop_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.disprop_stmt != null) {
                this.disprop_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.enqr_norcp_stmt != null) {
                this.enqr_norcp_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.enqo_rcp_stmt != null) {
                this.enqo_rcp_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.deq_raw_stmt != null) {
                this.deq_raw_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.deq_obj_stmt != null) {
                this.deq_obj_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aq_sess = null;
    }

    String getTransfxmDest(String string) {
        int n = -1;
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Connection connection = null;
        n = string.indexOf(".", 1);
        AQOracleDebug.trace(3, "AQOracleQueue.getTransfxmDest", "enter:" + string);
        try {
            if (n == -1) {
                string4 = ((OracleConnection)connection).getUserName();
                string5 = string;
            } else {
                string4 = string.substring(0, n);
                string5 = string.substring(n + 1);
            }
            AQOracleDebug.trace(3, "AQOracleQueue.getTransfxmDest", "schema" + string4 + " name: " + string5);
            string2 = (String)this.trans_list.get(string4 + "." + string5);
            if (string2 != null) {
                AQOracleDebug.trace(3, "AQOracleQueue.getTransfxmDest", "dest_type cached:" + string2);
                return string2;
            }
            connection = this.aq_sess.getDBConnection();
            statement = (OracleCallableStatement)connection.prepareCall("begin dbms_aqjms.aq$_get_trans_type(?, ?, ?, ?); end;");
            statement.setString(1, string4);
            statement.setString(2, string5);
            statement.registerOutParameter(3, 12);
            statement.registerOutParameter(4, 12);
            resultSet = statement.executeQuery();
            string3 = statement.getString(3);
            string2 = statement.getString(4);
            AQOracleDebug.trace(3, "AQOracleQueue.getTransfxmDest", "dest_type:" + string2);
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getTransfxmDest ex1", sQLException);
        }
        catch (AQException aQException) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.getTransfxmDest ex2", aQException);
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null) {
            this.trans_list.put(string4 + "." + string5, string2);
        }
        return string2;
    }

    void setTransTable(Hashtable hashtable) {
        this.trans_list = hashtable;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public synchronized AQOracleQueue cloneQueue() throws AQException {
        AQOracleQueue aQOracleQueue = new AQOracleQueue((AQOracleSession)null, this.owner, this.name, this.table, this.property, this.pload_type, this.p_data_type, this.secure);
        aQOracleQueue.setTransTable((Hashtable)this.trans_list.clone());
        aQOracleQueue.queue_type = this.queue_type;
        return aQOracleQueue;
    }
}

