/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.AQ.AQUtil;

public class AQOracleQueueTableFactory
implements ObjectFactory {
    private String owner;
    private String qtname;
    AQQueueTableProperty property = null;
    static final String PLTYP_ATTR = "payloadtype";
    static final String MUCSM_ATTR = "multiconsumers";
    static final String MSGRP_ATTR = "messagegrouping";
    static final String COMMT_ATTR = "comment";
    static final String COMPT_ATTR = "compatible";
    static final String PRMIS_ATTR = "primaryinstance";
    static final String SCNIS_ATTR = "secondinstance";
    private String payload_type = null;
    private boolean multi_consumer = false;
    private int mess_grouping = 0;
    private String comment = null;
    private String compatible = null;
    private int primary_inst = 0;
    private int secondary_inst = 0;

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws AQException {
        Reference reference = (Reference)object;
        AQOracleDebug.trace(4, "AQOracleQueueTableFactory.getObjectInstance", "entry");
        if (reference == null) {
            AQOracleDebug.trace(3, "AQOracleQueueTableFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        if (!reference.getClassName().equals("oracle.AQ.AQOracleQueueTable")) {
            AQOracleDebug.trace(3, "AQOracleQueueTableFactory.getObjectInstance", "unable to manufacture object of class: " + reference.getClassName());
            return null;
        }
        try {
            Object object2;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            NamingEnumeration<SearchResult> namingEnumeration = ((DirContext)context).search(name, "(objectclass=*)", searchControls);
            if (namingEnumeration == null) {
                AQOracleDebug.trace(3, "AQOracleQueueTableFactory.getObjectInstance", "failed to search attributes of queue table" + name.get(0));
                return null;
            }
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            this.owner = (String)attributes.get("orclDBAQObjOwner").get();
            this.qtname = (String)attributes.get("orclDBAQObjName").get();
            Attribute attribute = attributes.get("orclDBAQGeneric");
            int n = 0;
            while (n < attribute.size()) {
                String string;
                object2 = (String)attribute.get(n);
                if (((String)object2).toLowerCase().startsWith(PLTYP_ATTR)) {
                    this.payload_type = ((String)object2).substring(PLTYP_ATTR.length() + 1);
                } else if (((String)object2).toLowerCase().startsWith(MUCSM_ATTR)) {
                    string = ((String)object2).substring(MUCSM_ATTR.length() + 1);
                    if (string.toLowerCase().equals("true")) {
                        this.multi_consumer = true;
                    }
                } else if (((String)object2).toLowerCase().startsWith(MSGRP_ATTR)) {
                    string = ((String)object2).substring(MSGRP_ATTR.length() + 1);
                    if (string.toLowerCase().equals("transactional")) {
                        this.mess_grouping = 1;
                    }
                } else if (((String)object2).toLowerCase().startsWith(COMMT_ATTR)) {
                    this.comment = ((String)object2).substring(COMMT_ATTR.length() + 1);
                } else if (((String)object2).toLowerCase().startsWith(COMPT_ATTR)) {
                    this.compatible = ((String)object2).substring(COMPT_ATTR.length() + 1);
                } else if (((String)object2).toLowerCase().startsWith(PRMIS_ATTR)) {
                    this.primary_inst = Integer.valueOf(((String)object2).substring(PRMIS_ATTR.length() + 1));
                } else if (((String)object2).toLowerCase().startsWith(SCNIS_ATTR)) {
                    this.secondary_inst = Integer.valueOf(((String)object2).substring(SCNIS_ATTR.length() + 1));
                }
                ++n;
            }
            this.property = new AQQueueTableProperty(this.payload_type);
            this.property.setMultiConsumer(this.multi_consumer);
            this.property.setMessageGrouping(this.mess_grouping);
            this.property.setComment(this.comment);
            this.property.setCompatible(this.compatible);
            this.property.setPrimaryInstance(this.primary_inst);
            this.property.setSecondaryInstance(this.secondary_inst);
            object2 = new AQOracleQueueTable(null, this.owner, this.qtname, this.property);
            AQOracleDebug.trace(4, "AQOracleQueueTableFactory.getObjectInstance", "exit");
            return object2;
        }
        catch (NamingException namingException) {
            AQOracleDebug.traceEx(3, "AQOracleQueueTableFactory.getObjectInstance", namingException);
            AQUtil.throwAQEx(205, namingException);
            return null;
        }
    }
}

