/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import oracle.AQ.AQException;
import oracle.AQ.AQRawPayload;
import oracle.AQ.AQUtil;

public class AQOracleRawPayload
implements AQRawPayload {
    private byte[] data;
    private int length;

    public AQOracleRawPayload(byte[] byArray, int n) {
        this.data = byArray;
        this.length = n;
    }

    public AQOracleRawPayload() {
        this.data = new byte[100];
        this.length = 100;
    }

    public int getStream(byte[] byArray, int n) throws AQException {
        int n2 = 0;
        int n3 = n;
        if (byArray.length < n) {
            AQUtil.throwAQEx(189);
        }
        if (n3 > this.length) {
            n3 = this.length;
        }
        n2 = 0;
        while (n2 < n3) {
            byArray[n2] = this.data[n2];
            ++n2;
        }
        return n3;
    }

    public byte[] getBytes() throws AQException {
        int n = 0;
        byte[] byArray = null;
        byArray = new byte[this.length];
        n = 0;
        while (n < this.length) {
            byArray[n] = this.data[n];
            ++n;
        }
        return byArray;
    }

    public void setStream(byte[] byArray, int n) throws AQException {
        int n2 = 0;
        if (n > this.data.length) {
            this.data = new byte[n];
        }
        n2 = 0;
        while (n2 < n) {
            this.data[n2] = byArray[n2];
            ++n2;
        }
        this.length = n;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.data == null || this.length == 0) {
            stringBuffer.append("Data  :  <Empty byte array!>");
        } else {
            int n = this.length;
            stringBuffer.append("Length:  " + this.length);
            stringBuffer.append("Data  :  ");
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.data[n2] & 0xFF;
                if (n3 < 16) {
                    stringBuffer.append("0" + Integer.toHexString(n3));
                } else {
                    stringBuffer.append(Integer.toHexString(n3));
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }
}

