/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropDatum;
import oracle.jms.AdtMessage;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.ORAData;

public class AQjmsAdtMessage
extends AQjmsMessage
implements AdtMessage {
    Object adt_payload;

    private AQjmsAdtMessage() throws JMSException {
        super(false);
        this.message_id = null;
        this.enqueue_time = null;
        this.msg_dest = null;
        this.del_mode = 2;
        this.corr_id = "";
        this.redelivered = false;
        this.expiration = 0L;
        this.priority = 1;
        this.msg_properties = null;
        this.access_mode = 2;
        this.prop_read_only = false;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.header_ext = null;
        this.adt_payload = null;
    }

    AQjmsAdtMessage(CustomDatum customDatum) throws JMSException {
        this();
        this.adt_payload = customDatum;
    }

    AQjmsAdtMessage(ORAData oRAData) throws JMSException {
        this();
        this.adt_payload = oRAData;
    }

    AQjmsMessageHeaderExt getMessageHeaderExt() {
        return this.header_ext;
    }

    Hashtable getPropertiesHashtable() {
        return this.msg_properties;
    }

    public String getJMSMessageID() throws JMSException {
        String string = RepConversion.bArray2String((byte[])this.message_id);
        return new String(string);
    }

    public Destination getJMSReplyTo() throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        AQjmsError.throwEx(102);
    }

    public String getJMSType() throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public void setJMSType(String string) throws JMSException {
        AQjmsError.throwEx(102);
    }

    public boolean propertyExists(String string) throws JMSException {
        boolean bl = false;
        if (string.startsWith("JMS", 0)) {
            return string.equals("JMSXRecvTimestamp") || string.equals("JMSXState") || string.equals("JMSXDeliveryCount") || string.equals("JMS_OracleExcpQ") || string.equals("JMS_OracleDelay") || string.equals("JMS_OracleOriginalMessageID");
        }
        return false;
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return false;
        }
        try {
            if (string.startsWith("JMS", 0)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        String string2 = (String)object;
                        return Boolean.valueOf(string2);
                    }
                    return ((Datum)object).booleanValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return false;
        }
    }

    public byte getByteProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return 0;
        }
        try {
            if (string.startsWith("JMS", 0)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        String string2 = (String)object;
                        return Byte.parseByte(string2);
                    }
                    return ((Datum)object).byteValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0;
        }
    }

    public short getShortProperty(String string) throws JMSException {
        Object object = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("oracle.sql.NUMBER");
        }
        catch (Exception exception) {
            AQjmsError.throwEx(109, exception);
            return 0;
        }
        if (string == null) {
            AQjmsError.throwEx(139);
            return 0;
        }
        try {
            if (string.startsWith("JMS", 0)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        return Short.parseShort((String)object);
                    }
                    if (clazz.isInstance(object)) {
                        return ((NUMBER)object).shortValue();
                    }
                    throw new NullPointerException();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0;
        }
    }

    public int getIntProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return 0;
        }
        try {
            if (string.startsWith("JMS", 0)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        return Integer.parseInt((String)object);
                    }
                    return ((Datum)object).intValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0;
        }
    }

    public long getLongProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return 0L;
        }
        try {
            if (string.startsWith("JMS", 0)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        return Long.parseLong((String)object);
                    }
                    return ((Datum)object).longValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0L;
        }
    }

    public float getFloatProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return 0.0f;
        }
        try {
            if (string.startsWith("JMS", 0)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        return Float.valueOf((String)object).floatValue();
                    }
                    return ((Datum)object).floatValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0.0f;
        }
    }

    public double getDoubleProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return 0.0;
        }
        try {
            if (string.startsWith("JMS", 0)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        return Double.valueOf((String)object);
                    }
                    return ((Datum)object).doubleValue();
                }
                throw new NullPointerException();
            }
            throw new NullPointerException();
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return 0.0;
        }
    }

    public String getStringProperty(String string) throws JMSException {
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
            return null;
        }
        try {
            if (string.startsWith("JMS", 0)) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (object instanceof String) {
                        return (String)object;
                    }
                    return ((Datum)object).stringValue();
                }
                return null;
            }
            return null;
        }
        catch (SQLException sQLException) {
            AQjmsError.throwMsgFormatEx(161, null);
            return null;
        }
    }

    public Object getObjectProperty(String string) throws JMSException {
        block12: {
            Object var2_2 = null;
            Object object = null;
            boolean bl = false;
            if (string == null) {
                AQjmsError.throwEx(139);
            } else {
                try {
                    if (string.startsWith("JMS", 0)) {
                        object = this.getSystemProperty(string);
                        if (object != null) {
                            if (string.equals("JMSXRecvTimestamp")) {
                                return new Long(((Datum)object).longValue());
                            }
                            if (string.equals("JMSXState")) {
                                return new Integer(((Datum)object).intValue());
                            }
                            if (string.equals("JMS_OracleExcpQ")) {
                                return object;
                            }
                            if (string.equals("JMS_OracleDelay")) {
                                return new Integer(((Datum)object).intValue());
                            }
                            if (string.equals("JMS_OracleOriginalMessageID")) {
                                return object;
                            }
                            if (string.equals("JMSXDeliveryCount")) {
                                return new Integer(((Datum)object).intValue());
                            }
                            break block12;
                        }
                        return null;
                    }
                    return null;
                }
                catch (SQLException sQLException) {
                    AQjmsError.throwMsgFormatEx(161, null);
                }
            }
        }
        return null;
    }

    public synchronized Enumeration getPropertyNames() throws JMSException {
        Hashtable<String, AQjmsPropDatum> hashtable = null;
        Enumeration enumeration = null;
        AQjmsPropDatum aQjmsPropDatum = null;
        Object var4_4 = null;
        aQjmsPropDatum = new AQjmsPropDatum(27, (String)null);
        hashtable = new Hashtable<String, AQjmsPropDatum>();
        hashtable.put("JMSXRecvTimestamp", aQjmsPropDatum);
        hashtable.put("JMSXState", aQjmsPropDatum);
        hashtable.put("JMSXDeliveryCount", aQjmsPropDatum);
        hashtable.put("JMS_OracleExcpQ", aQjmsPropDatum);
        hashtable.put("JMS_OracleDelay", aQjmsPropDatum);
        hashtable.put("JMS_OracleOriginalMessageID", aQjmsPropDatum);
        enumeration = hashtable.keys();
        return enumeration;
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (string.startsWith("JMS", 0)) {
                NUMBER nUMBER = new NUMBER(bl);
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (string.startsWith("JMS", 0)) {
                NUMBER nUMBER = new NUMBER(by);
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
        }
    }

    public void setShortProperty(String string, short s) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (string.startsWith("JMS", 0)) {
                NUMBER nUMBER = new NUMBER(s);
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setIntProperty(String string, int n) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (string.startsWith("JMS", 0)) {
                NUMBER nUMBER = new NUMBER(n);
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
            throw new AQjmsException("Could not set property value", 0, sQLException);
        }
    }

    public void setLongProperty(String string, long l) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (string.startsWith("JMS", 0)) {
                NUMBER nUMBER = new NUMBER(l);
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
        }
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (!string.startsWith("JMS", 0)) {
                AQjmsError.throwEx(150);
                throw new AQjmsException("User properties not supported on ADT messages", 0);
            }
            NUMBER nUMBER = new NUMBER(f);
            this.setSystemProperty(string, nUMBER);
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
        }
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            if (!string.startsWith("JMS", 0)) {
                AQjmsError.throwEx(150);
                throw new AQjmsException("User properties not supported on ADT messages", 0);
            }
            NUMBER nUMBER = new NUMBER(d);
            this.setSystemProperty(string, nUMBER);
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119);
        }
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyValue(string, string2);
        try {
            if (string.startsWith("JMS", 0)) {
                this.setSystemProperty(string, string2);
            } else {
                AQjmsError.throwEx(150);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        if (object == null) {
            AQjmsError.throwMsgFormatEx(119, null);
        }
        if (object instanceof Boolean) {
            this.setBooleanProperty(string, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByteProperty(string, (Byte)object);
        } else if (object instanceof Short) {
            this.setShortProperty(string, (Short)object);
        } else if (object instanceof Integer) {
            this.setIntProperty(string, (Integer)object);
        } else if (object instanceof Long) {
            this.setLongProperty(string, (Long)object);
        } else if (object instanceof Float) {
            this.setFloatProperty(string, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDoubleProperty(string, (Double)object);
        } else if (object instanceof String) {
            this.setStringProperty(string, (String)object);
        } else {
            AQjmsError.throwMsgFormatEx(119, null);
        }
    }

    public void clearBody() throws JMSException {
        this.adt_payload = null;
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    void setSystemProperty(String string, Object object) throws JMSException, SQLException {
        if (string.startsWith("JMS", 0)) {
            if (string.equals("JMSXUserID")) {
                AQjmsError.throwEx(150);
            } else if (string.equals("JMSXAppID")) {
                AQjmsError.throwEx(150);
            } else if (string.equals("JMSXDeliveryCount")) {
                AQjmsError.throwEx(110, "JMSXDeliveryCount");
            } else if (string.equals("JMSXGroupID")) {
                AQjmsError.throwEx(150);
            } else if (string.equals("JMSXGroupSeq")) {
                AQjmsError.throwEx(150);
            } else if (string.equals("JMSXProducerTXID")) {
                AQjmsError.throwEx(150);
            } else if (string.equals("JMSXConsumerTXID")) {
                AQjmsError.throwEx(150);
            } else if (string.equals("JMSXRecvTimestamp")) {
                AQjmsError.throwEx(110, "JMSXRecvTimestamp");
            } else if (string.equals("JMSXState")) {
                AQjmsError.throwEx(110, "JMSXState");
            } else if (string.equals("JMS_OracleExcpQ")) {
                if (object instanceof String) {
                    this.excp_queue = (String)object;
                } else {
                    AQjmsError.throwEx(153);
                }
            } else if (string.equals("JMS_OracleDelay")) {
                if (object instanceof NUMBER) {
                    this.msg_delay = ((Datum)object).intValue();
                } else {
                    AQjmsError.throwEx(153);
                }
            } else if (string.equals("JMS_OracleOriginalMessageID")) {
                AQjmsError.throwEx(110, "JMS_OracleOriginalMessageID");
            } else {
                AQjmsError.throwEx(140);
            }
        } else {
            AQjmsError.throwEx(140);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    Object getSystemProperty(String string) throws SQLException {
        void var2_10;
        Object var2_2 = null;
        Object var3_11 = null;
        boolean bl = false;
        AQjmsOracleDebug.trace(4, "AQjmsAdtMessage.setSystemProperty", "entry");
        if (!string.startsWith("JMS", 0)) {
            AQjmsOracleDebug.trace(5, "AQjmsAdtMessage.setSystemProperty", "name does not start with JMS, returning null");
            return null;
        }
        if (string.equals("JMSXUserID")) {
            return null;
        }
        if (string.equals("JMSXAppID")) {
            return null;
        }
        if (string.equals("JMSXDeliveryCount")) {
            NUMBER nUMBER = new NUMBER(this.attempts);
        } else {
            if (string.equals("JMSXGroupID")) {
                return null;
            }
            if (string.equals("JMSXGroupSeq")) {
                return null;
            }
            if (string.equals("JMSXProducerTXID")) {
                return null;
            }
            if (string.equals("JMSXConsumerTXID")) {
                return null;
            }
            if (string.equals("JMSXRecvTimestamp")) {
                NUMBER nUMBER = new NUMBER(this.recv_time);
            } else if (string.equals("JMSXState")) {
                NUMBER nUMBER = new NUMBER(this.msg_state);
            } else if (string.equals("JMS_OracleExcpQ")) {
                String string2 = this.excp_queue;
            } else if (string.equals("JMS_OracleDelay")) {
                NUMBER nUMBER = new NUMBER(this.msg_delay);
            } else {
                if (!string.equals("JMS_OracleOriginalMessageID")) {
                    AQjmsOracleDebug.trace(5, "AQjmsAdtMessage.setSystemProperty", "returning null");
                    return null;
                }
                if (this.orig_msg_id == null) {
                    Object var2_8 = null;
                } else {
                    String string3 = "ID:" + RepConversion.bArray2String((byte[])this.orig_msg_id);
                }
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsAdtMessage.setSystemProperty", "exit");
        return var2_10;
    }

    private void setPayload(Object object) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            this.adt_payload = object;
        }
    }

    public void setAdtPayload(CustomDatum customDatum) throws JMSException {
        this.setPayload(customDatum);
    }

    public void setAdtPayload(ORAData oRAData) throws JMSException {
        this.setPayload(oRAData);
    }

    public Object getAdtPayload() throws JMSException {
        return this.adt_payload;
    }
}

