/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.sql.BLOB;
import oracle.sql.ORADataFactory;

public class AQjmsBytesMessage
extends AQjmsMessage
implements BytesMessage {
    byte[] bytes_data;
    AQjmsBytesMessage_C bytes_msg_cont;
    ByteArrayInputStream bytes_instream;
    DataInputStream bytes_datainstream;
    ByteArrayOutputStream bytes_outstream;
    DataOutputStream bytes_dataoutstream;

    public AQjmsBytesMessage() throws JMSException {
        super(true);
        this.bytes_data = null;
        try {
            this.bytes_msg_cont = new AQjmsBytesMessage_C();
            this.bytes_msg_cont.setHeader(this.header_ext);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
            this.access_mode = 1;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public AQjmsBytesMessage(AQjmsSession aQjmsSession) throws JMSException {
        super(aQjmsSession, true);
        this.bytes_data = null;
        try {
            this.bytes_msg_cont = new AQjmsBytesMessage_C();
            this.bytes_msg_cont.setHeader(this.header_ext);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
            this.access_mode = 1;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsBytesMessage(AQjmsSession aQjmsSession, AQjmsBytesMessage_C aQjmsBytesMessage_C) throws JMSException {
        super(aQjmsSession, true);
        this.bytes_data = null;
        try {
            this.bytes_msg_cont = aQjmsBytesMessage_C;
            this.header_ext = this.bytes_msg_cont.getHeader();
            this.readBytesMessageContainer();
            this.bytes_instream = new ByteArrayInputStream(this.bytes_data);
            this.bytes_datainstream = new DataInputStream(this.bytes_instream);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
            this.access_mode = 0;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsBytesMessage(AQjmsSession aQjmsSession, byte[] byArray) throws JMSException {
        super(aQjmsSession, true);
        this.bytes_data = byArray;
        this.bytes_instream = new ByteArrayInputStream(byArray);
        this.bytes_datainstream = new DataInputStream(this.bytes_instream);
        this.bytes_outstream = new ByteArrayOutputStream();
        this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
        this.access_mode = 0;
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        try {
            if (this.bytes_msg_cont != null) {
                this.bytes_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public boolean readBoolean() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return false;
        }
        try {
            return this.bytes_datainstream.readBoolean();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return false;
        }
    }

    public byte readByte() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readByte();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public int readUnsignedByte() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public short readShort() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readShort();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public int readUnsignedShort() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public char readChar() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return '\u0000';
        }
        try {
            return this.bytes_datainstream.readChar();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return '\u0000';
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return '\u0000';
        }
    }

    public int readInt() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.readInt();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public long readLong() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0L;
        }
        try {
            return this.bytes_datainstream.readLong();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0L;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0L;
        }
    }

    public float readFloat() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0.0f;
        }
        try {
            return this.bytes_datainstream.readFloat();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0.0f;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0.0f;
        }
    }

    public double readDouble() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0.0;
        }
        try {
            return this.bytes_datainstream.readDouble();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0.0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0.0;
        }
    }

    public String readUTF() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return null;
        }
        try {
            return this.bytes_datainstream.readUTF();
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return null;
        }
    }

    public int readBytes(byte[] byArray) throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.read(byArray, 0, byArray.length);
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return -1;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public int readBytes(byte[] byArray, int n) throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            return this.bytes_datainstream.read(byArray, 0, n);
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return -1;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeBoolean(bl);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeByte(byte by) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeByte(by);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeShort(short s) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeShort(s);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeChar(char c) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeChar(c);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeInt(int n) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeInt(n);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeLong(long l) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeLong(l);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeFloat(float f) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeFloat(f);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeDouble(double d) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeDouble(d);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeUTF(String string) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.writeUTF(string);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.write(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_dataoutstream.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeObject(Object object) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            if (object == null) {
                throw new NullPointerException(AQjmsError.getMessage(229));
            }
            if (object instanceof Integer) {
                this.writeInt((Integer)object);
            } else if (object instanceof Long) {
                this.writeLong((Long)object);
            } else if (object instanceof Float) {
                this.writeFloat(((Float)object).floatValue());
            } else if (object instanceof Short) {
                this.writeShort((Short)object);
            } else if (object instanceof Byte) {
                this.writeByte((Byte)object);
            } else if (object instanceof Double) {
                this.writeDouble((Double)object);
            } else if (object instanceof String) {
                this.writeUTF(((String)object).toString());
            } else if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
            } else if (object instanceof byte[]) {
                this.writeBytes((byte[])object);
            } else {
                AQjmsError.throwMsgFormatEx(161, null);
            }
        }
    }

    public void reset() throws JMSException {
        byte[] byArray = null;
        byArray = this.getBytesData();
        this.setAccessMode(0);
        this.setPropReadOnly(true);
        this.bytes_instream = new ByteArrayInputStream(byArray);
        this.bytes_datainstream = new DataInputStream(this.bytes_instream);
        this.bytes_outstream.reset();
        this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
    }

    public void clearBody() throws JMSException {
        this.bytes_data = null;
        this.setAccessMode(1);
        this.setPropReadOnly(false);
        this.bytes_outstream.reset();
        this.bytes_dataoutstream = new DataOutputStream(this.bytes_outstream);
    }

    AQjmsBytesMessage_C getBytesMessageCont() {
        return this.bytes_msg_cont;
    }

    public byte[] getBytesData() {
        if (this.bytes_data == null) {
            this.bytes_data = this.bytes_outstream.toByteArray();
        }
        return this.bytes_data;
    }

    void readBytesMessageContainer() throws JMSException {
        BLOB bLOB = null;
        int n = 0;
        byte[] byArray = null;
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.readBytesMessageContainer", "entry");
        try {
            n = this.bytes_msg_cont.getBytesLen();
            AQjmsOracleDebug.trace(5, "AQjmsBytesMessage.readBytesMessageContainer", "- bytes_len: " + n);
            if (n > 2000) {
                bLOB = this.bytes_msg_cont.getBytesLob();
                if (bLOB != null) {
                    byArray = bLOB.getBytes(1L, n);
                }
                this.bytes_data = byArray;
            } else {
                byArray = this.bytes_msg_cont.getBytesRaw();
                this.bytes_data = byArray;
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.readBytesMessageContainer", "exit");
    }

    void populateBytesMessageContainer() throws JMSException {
        Object var1_1 = null;
        int n = 0;
        byte[] byArray = null;
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.populateBytesMessageContainer", "entry");
        try {
            this.bytes_msg_cont.setHeader(this.header_ext);
            byArray = this.getBytesData();
            n = this.bytes_data.length;
            this.reset();
            this.bytes_msg_cont.setBytesLen(new Integer(n));
            AQjmsOracleDebug.trace(5, "AQjmsBytesMessage.populateBytesMessageContainer", "- bytes_len: " + n);
            if (n > 2000) {
                this.bytes_msg_cont.setBytesRaw(null);
            } else {
                this.bytes_msg_cont.setBytesRaw(byArray);
                this.bytes_msg_cont.setBytesLob(null);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.populateBytesMessageContainer", "exit");
    }

    void write_blob(Connection connection, String string, byte[] byArray, boolean bl, boolean bl2) throws JMSException {
        BLOB bLOB = null;
        int n = 0;
        byte[] byArray2 = null;
        int n2 = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.write_blob", "entry");
        try {
            byArray2 = this.getBytesData();
            n = byArray2.length;
            if (string == null) {
                AQjmsOracleDebug.trace(1, "AQjmsBytesMessage.write_blob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsBytesMessage.write_blob", "- bytes_len: " + n + "   qtable: " + string);
            if (n > 2000) {
                ORADataFactory oRADataFactory = bl ? AQjmsGenMessage_C.getFactory() : AQjmsBytesMessage_C.getFactory();
                AQjmsOracleDebug.trace(5, "AQjmsBytesMessage.write_blob", "is_anydata_dest: " + bl2);
                statement = bl2 ? (OracleCallableStatement)connection.prepareCall("SELECT dbms_aqin.aq$_getblob_from_jmsanydata(user_data) FROM " + string + " where msgid = ?") : (OracleCallableStatement)connection.prepareCall("SELECT user_data FROM " + string + " where msgid = ?");
                statement.setBytes(1, byArray);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    if (bl2) {
                        bLOB = ((OracleResultSet)resultSet).getBLOB(1);
                    } else if (bl) {
                        AQjmsGenMessage_C aQjmsGenMessage_C = (AQjmsGenMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        bLOB = aQjmsGenMessage_C.getBytesLob();
                    } else {
                        AQjmsBytesMessage_C aQjmsBytesMessage_C = (AQjmsBytesMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        bLOB = aQjmsBytesMessage_C.getBytesLob();
                    }
                }
                if (bLOB == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsBytesMessage.write_blob", "Internal error - bytes_lob is null");
                    AQjmsError.throwEx(122, "bytes_lob is null");
                }
                n2 = bLOB.putBytes(1L, byArray2);
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.write_blob", "exit");
    }
}

