/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsDeqSelConstants;
import oracle.jms.AQjmsDeqSelTokenManager;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.ASCII_CharStream;
import oracle.jms.ParseException;
import oracle.jms.Token;

class AQjmsDeqSel
implements AQjmsDeqSelConstants {
    public byte[] msg_id = null;
    public String corr_id = null;
    public AQjmsDeqSelTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[2];
    private final int[] jj_la1_0 = new int[]{96, 0x100080};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] stringArray) throws ParseException {
        AQjmsDeqSel aQjmsDeqSel = null;
        String string = null;
        AQjmsOracleDebug.setTraceLevel(5);
        AQjmsOracleDebug.setDebug(true);
        if (stringArray.length < 1) {
            System.out.println("Reading from stdin");
            aQjmsDeqSel = new AQjmsDeqSel(System.in);
        } else {
            try {
                aQjmsDeqSel = new AQjmsDeqSel(new DataInputStream(new FileInputStream(stringArray[0])));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File " + stringArray[0] + " not found. Reading from stdin");
                aQjmsDeqSel = new AQjmsDeqSel(System.in);
            }
        }
        if (stringArray.length > 0) {
            System.out.println("Reading from file: " + stringArray[0]);
        }
        string = aQjmsDeqSel.DequeueSelector();
        System.out.println("Parse Successful");
        if (string.equals("JMSCorrelationID")) {
            System.out.println("Expression: " + string + " " + aQjmsDeqSel.corr_id);
        }
        if (string.equals("JMSMessageID")) {
            System.out.println("Expression: " + string + " " + aQjmsDeqSel.msg_id);
        }
    }

    void setMessageID(Token token) throws ParseException {
        AQjmsOracleDebug.trace(4, "AQjmsDeqSel", "setMessageID - entry");
        String string = token.image;
        string = string.substring(1, string.length() - 1);
        AQjmsOracleDebug.println("AQjmsDeqSel.MessageID:" + string);
        if (!string.startsWith("ID:")) {
            AQjmsOracleDebug.trace(3, "AQjmsDeqSel", "setMessageID - parse exception");
            throw new ParseException("Invalid JMSMessageID in selector");
        }
        string = string.substring(3);
        this.msg_id = RepConversion.nibbles2bArray((byte[])string.getBytes());
        AQjmsOracleDebug.trace(4, "AQjmsDeqSel", "setMessageID - exit");
    }

    void setCorrelationID(Token token) throws ParseException {
        AQjmsOracleDebug.trace(4, "AQjmsDeqSel", "setCorrelationID - entry");
        String string = token.image;
        String string2 = this.checkForEscapeChars(string);
        string2 = string2.substring(1, string2.length() - 1);
        AQjmsOracleDebug.println("AQjmsDeqSel.CorrelationID:" + string2);
        this.corr_id = string2;
        AQjmsOracleDebug.trace(4, "AQjmsDeqSel", "setCorrelationID - exit");
    }

    String checkForEscapeChars(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        AQjmsOracleDebug.trace(5, "AQjmsDeqSel.checkForEscapeChars", "QuotedInput:  " + string);
        if (string == null || string.length() <= 2) {
            return string;
        }
        string2 = string.substring(1, string.length() - 1);
        stringBuffer.append("'");
        if (string2 != null && string2.length() > 0) {
            while (bl2) {
                n2 = string2.indexOf("\\", n);
                if (n2 == -1) {
                    bl2 = false;
                    if (n == 0) {
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(string2.substring(n));
                    continue;
                }
                if (n2 < string2.length() - 1 && string2.charAt(n2 + 1) == '\'') {
                    stringBuffer.append(string2.substring(n, n2));
                    stringBuffer.append("'");
                    stringBuffer.append(string2.charAt(n2 + 1));
                    n = n2 + 2;
                } else {
                    stringBuffer.append(string2.substring(n, n2 + 1));
                    n = n2 + 1;
                }
                bl2 = n < string2.length();
            }
        } else {
            stringBuffer.append(string2);
        }
        stringBuffer.append("'");
        string3 = stringBuffer.toString();
        AQjmsOracleDebug.trace(5, "AQjmsDeqSel.checkForEscapeChars", "New String:  " + string3);
        return string3;
    }

    public final String DequeueSelector() throws ParseException {
        String string = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                string = this.DequeueMessageID();
                break;
            }
            case 6: {
                string = this.DequeueCorrelationID();
                this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AQjmsOracleDebug.println("DequeueSelector: \n" + string);
        return string;
    }

    public final String DequeueMessageID() throws ParseException {
        String string = new String("");
        Token token = null;
        this.jj_consume_token(5);
        this.jj_consume_token(20);
        token = this.jj_consume_token(17);
        this.setMessageID(token);
        return "JMSMessageID";
    }

    public final String DequeueCorrelationID() throws ParseException {
        String string = new String("");
        Token token = null;
        this.jj_consume_token(6);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        token = this.jj_consume_token(17);
        this.setCorrelationID(token);
        return "JMSCorrelationID";
    }

    public AQjmsDeqSel(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new AQjmsDeqSelTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 2) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 2) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public AQjmsDeqSel(AQjmsDeqSelTokenManager aQjmsDeqSelTokenManager) {
        this.token_source = aQjmsDeqSelTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 2) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    public void ReInit(AQjmsDeqSelTokenManager aQjmsDeqSelTokenManager) {
        this.token_source = aQjmsDeqSelTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 2) {
            this.jj_la1[n] = -1;
            ++n;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[21];
        int n2 = 0;
        while (n2 < 21) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 2) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 21) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, AQjmsDeqSelConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

