/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.Service;

public class AQjmsEventListener
implements Runnable {
    private Thread myThread = null;
    Service theService;
    ConnectionManager theConManager;
    PollerManager thePollerManager;
    volatile boolean stopped;
    ServerSocket theListenSock;
    int thePort;
    AQjmsSession theSession;
    Hashtable theConsumerList;
    static /* synthetic */ Class class$oracle$jms$AQjmsEventListener;

    public AQjmsEventListener(String string, int n) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsEventListener-constructor", "Starting event listener");
        this.theConManager = new ConnectionManager(n);
        this.thePollerManager = new PollerManager(n);
        this.theConsumerList = new Hashtable();
        Class[] classArray = new Class[]{class$oracle$jms$AQjmsEventListener == null ? (class$oracle$jms$AQjmsEventListener = AQjmsEventListener.class$("oracle.jms.AQjmsEventListener")) : class$oracle$jms$AQjmsEventListener};
        Object[] objectArray = new Object[]{this};
        Constructor<?> constructor = null;
        try {
            Class<?> clazz = Class.forName(string);
            constructor = clazz.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwEx(122, "service class not found");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            AQjmsError.throwEx(122, "service class constructor not found");
        }
        try {
            this.theService = (Service)constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            AQjmsError.throwEx(122, "couldn't instantiate service classs");
        }
        catch (IllegalAccessException illegalAccessException) {
            AQjmsError.throwEx(122, "illegal access exception on instantiating service");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AQjmsError.throwEx(122, "illegal argument to service constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            AQjmsError.throwEx(122, "exception when instantiating service class");
        }
        this.stopped = true;
        try {
            this.theListenSock = new ServerSocket(0);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(122, "Couldn't create listener's socket");
        }
        try {
            this.theListenSock.setSoTimeout(120000);
        }
        catch (SocketException socketException) {
            AQjmsError.throwEx(122, "Couldn't set timeout on the socket");
        }
        this.thePort = this.theListenSock.getLocalPort();
    }

    public synchronized void addConsumer(AQjmsSession aQjmsSession, AQjmsConsumer aQjmsConsumer) {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.addConsumer", "enter");
        this.theSession = aQjmsSession;
        this.theConsumerList.put(aQjmsConsumer, aQjmsConsumer);
        if (!this.isStopped()) {
            Poller poller = new Poller(aQjmsSession, aQjmsConsumer);
            this.thePollerManager.addPoller(poller);
        }
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.addConsumer", "exit");
    }

    public synchronized void addSession(AQjmsSession aQjmsSession, Hashtable hashtable) {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.addSession", "enter");
        this.theSession = aQjmsSession;
        this.theConsumerList = hashtable;
        if (!this.isStopped()) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
                Poller poller = new Poller(aQjmsSession, aQjmsConsumer);
                this.thePollerManager.addPoller(poller);
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.addSession", "exit");
    }

    public synchronized void removeConsumer(AQjmsConsumer aQjmsConsumer) {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.removeConsumer", "enter");
        this.theConsumerList.remove(aQjmsConsumer);
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.removeConsumer", "exit");
    }

    public synchronized void removeSession(AQjmsSession aQjmsSession) {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.removeSession", "enter");
        this.theSession = null;
        this.theConsumerList = null;
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.removeConsumer", "exit");
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public synchronized void startAQjmsEventListener() throws JMSException {
        AQjmsOracleDebug.trace(3, "startAQjmsEventListener", "enter");
        if (!this.stopped) {
            AQjmsOracleDebug.trace(4, "AQjmsEventListener", "already started");
            return;
        }
        this.stopped = false;
        AQjmsOracleDebug.trace(4, "AQjmsEventListener.startAQjmsListener", "entry");
        this.myThread = new Thread((Runnable)this, "AQjmsEventListener");
        this.myThread.start();
        this.pollMessages();
        AQjmsOracleDebug.trace(3, "startAQjmsEventListener", "exit");
    }

    void notifyEventListener(Hashtable hashtable) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.notifyEventListener", "enter");
        this.theSession.notifySession(hashtable, this.theConsumerList);
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.notifyEventListener", "exit");
    }

    public synchronized void stopAQjmsEventListener() {
        AQjmsOracleDebug.trace(4, "AQjmsEventListener", "enter");
        if (this.stopped) {
            AQjmsOracleDebug.trace(4, "stopAQjmsEventListener", "already stopped");
            return;
        }
        this.stopped = true;
        AQjmsOracleDebug.trace(4, "AQjmsEventListener", "set state to stop");
        try {
            AQjmsOracleDebug.trace(4, "stopAQjmsEventListener", "before close socket");
            this.theListenSock.close();
            AQjmsOracleDebug.trace(4, "stopAQjmsEventListener", "after close socket");
        }
        catch (Throwable throwable) {
            AQjmsOracleDebug.trace(4, "stopAQjmsEventListener", "ServerSocket.close ()");
        }
        this.theConManager.closeConnectionManager();
        this.thePollerManager.closePollerManager();
        AQjmsOracleDebug.trace(4, "stopAQjmsEventListener", "exit");
    }

    public int getPort() {
        return this.thePort;
    }

    synchronized void pollMessages() throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.pollMessages", "enter");
        Enumeration enumeration = this.theConsumerList.elements();
        while (enumeration.hasMoreElements()) {
            AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
            AQjmsOracleDebug.println("Added poller for consumer ");
            Poller poller = new Poller(this.theSession, aQjmsConsumer);
            this.thePollerManager.addPoller(poller);
        }
        AQjmsOracleDebug.trace(3, "AQjmsEventListener.pollMessages", "exit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block7: {
            AQjmsOracleDebug.trace(3, "AQjmsEventListener.run", "enter");
            try {
                try {
                    while (!this.stopped) {
                        try {
                            AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "before Accept");
                            Socket socket = this.theListenSock.accept();
                            socket.setSoTimeout(120000);
                            this.theConManager.addConnection(socket, this.theService);
                            AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "After adding Connection");
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            AQjmsOracleDebug.traceEx(3, "AQjmsEventListener-int-ioex", interruptedIOException);
                        }
                    }
                }
                catch (Exception exception) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsEventListener-ex", exception);
                    Object var3_5 = null;
                    AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "finally");
                    break block7;
                }
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "finally");
                throw throwable;
            }
            AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "finally");
        }
        AQjmsOracleDebug.trace(4, "AQjmsEventListener.run", "exit");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Connection
    extends Thread {
        Socket theClient;
        Service theService;

        public Connection(Socket socket, Service service) {
            super("Server.Connection:" + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
            this.theClient = socket;
            this.theService = service;
        }

        public void stopConnection() {
            AQjmsOracleDebug.trace(4, "AQjmsEventListener.stopConenction", "stop");
            this.theService.stopService();
            AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.stopConnection", "after stopService");
            this.cleanup();
            AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.stopConnection", "after cleanup");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block6: {
                try {
                    try {
                        AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "enter");
                        InputStream inputStream = this.theClient.getInputStream();
                        OutputStream outputStream = this.theClient.getOutputStream();
                        this.theService.serve(inputStream, outputStream);
                    }
                    catch (IOException iOException) {
                        AQjmsOracleDebug.traceEx(3, "AQjmsEventListener.Connection.run-ioex", iOException);
                        Object var5_6 = null;
                        AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "before cleanup");
                        this.cleanup();
                        AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "after cleanup");
                        break block6;
                    }
                    catch (JMSException jMSException) {
                        AQjmsOracleDebug.traceEx(3, "AQjmsEventListener.Connection.run-jmsex", (Exception)((Object)jMSException));
                        Object var5_7 = null;
                        AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "before cleanup");
                        this.cleanup();
                        AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "after cleanup");
                        break block6;
                    }
                    catch (Exception exception) {
                        AQjmsOracleDebug.traceEx(3, "AQjmsEventListener.Connection.run-throwable", exception);
                        Object var5_8 = null;
                        AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "before cleanup");
                        this.cleanup();
                        AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "after cleanup");
                        break block6;
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "before cleanup");
                    this.cleanup();
                    AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "after cleanup");
                    throw throwable;
                }
                AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "before cleanup");
                this.cleanup();
                AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "after cleanup");
            }
            AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.run", "exit");
        }

        synchronized void cleanup() {
            AQjmsOracleDebug.trace(3, "AQjmsEventListener.Connection.cleanup", "entry");
            try {
                AQjmsEventListener.this.theConManager.removeConnection(this);
                AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.cleanup", "before close socket");
                this.theClient.close();
                AQjmsOracleDebug.trace(4, "AQjmsEventListener.Connection.cleanup", "after close socket");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class Poller
    extends Thread {
        AQjmsSession theSession;
        AQjmsConsumer theConsumer;
        volatile boolean stopped;

        public Poller(AQjmsSession aQjmsSession, AQjmsConsumer aQjmsConsumer) {
            this.theSession = aQjmsSession;
            this.theConsumer = aQjmsConsumer;
            this.stopped = false;
        }

        public void stopPoller() {
            this.stopped = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            AQjmsOracleDebug.trace(3, "PollerManager.run", "enter");
            try {
                try {
                    while (!this.stopped && this.theSession.pollMessage(this.theConsumer)) {
                        AQjmsOracleDebug.trace(3, "PollerManager.run", "found a message");
                    }
                }
                catch (AQjmsException aQjmsException) {
                    AQjmsOracleDebug.trace(3, "Polling:run", "exception");
                    Object var4_2 = null;
                    AQjmsEventListener.this.thePollerManager.removePoller(this);
                    AQjmsOracleDebug.trace(3, "Polling:run", "exit");
                    return;
                }
                catch (Exception exception) {
                    AQjmsOracleDebug.trace(3, "Polling:run", "exception2");
                    Object var4_3 = null;
                    AQjmsEventListener.this.thePollerManager.removePoller(this);
                    AQjmsOracleDebug.trace(3, "Polling:run", "exit");
                    return;
                }
                Object var4_1 = null;
                AQjmsEventListener.this.thePollerManager.removePoller(this);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                AQjmsEventListener.this.thePollerManager.removePoller(this);
                AQjmsOracleDebug.trace(3, "Polling:run", "exit");
                throw throwable;
            }
            AQjmsOracleDebug.trace(3, "Polling:run", "exit");
        }
    }

    public class PollerManager {
        int maxThreads;
        Hashtable m_pollerList;

        public PollerManager(int n) {
            this.maxThreads = n;
            this.m_pollerList = new Hashtable();
            AQjmsOracleDebug.trace(4, "PollerManager-constructor", "Created poller manager.  Max threads: " + this.maxThreads);
        }

        public synchronized boolean addPoller(Poller poller) {
            AQjmsOracleDebug.trace(3, "PollerManager.addPoller", "enter");
            if (this.m_pollerList.size() >= this.maxThreads) {
                return false;
            }
            this.m_pollerList.put(poller, poller);
            poller.start();
            AQjmsOracleDebug.trace(3, "PollerManager.addPoller", "exit");
            return true;
        }

        synchronized boolean removePoller(Poller poller) {
            return this.m_pollerList.remove(poller) != null;
        }

        public synchronized void closePollerManager() {
            AQjmsOracleDebug.trace(3, "PollerManager.closePollerManager", "entry");
            Enumeration enumeration = this.m_pollerList.elements();
            while (enumeration.hasMoreElements()) {
                Poller poller = (Poller)enumeration.nextElement();
                AQjmsOracleDebug.trace(4, "PollerManager.closePollerManager", "bef stopPoller");
                poller.stopPoller();
                AQjmsOracleDebug.trace(4, "PollerManager.closePollerManager", "after stopPoller");
            }
            AQjmsOracleDebug.trace(3, "PollerManager.closePollerManager", "exit");
        }
    }

    public class ConnectionManager {
        int maxCon;
        Hashtable m_connectionList;

        public ConnectionManager(int n) {
            this.maxCon = n;
            this.m_connectionList = new Hashtable();
            AQjmsOracleDebug.trace(4, "ConnectionManager-constructor", "Created connection manager.  Max connnections: " + n);
        }

        synchronized void addConnection(Socket socket, Service service) {
            if (this.m_connectionList.size() >= this.maxCon) {
                try {
                    AQjmsOracleDebug.trace(3, "ConectionManager.addConnection", "Connection refused; server has reached maximum number of clients.");
                    socket.close();
                    AQjmsOracleDebug.trace(3, "ConectionManager.addConnection", "Connection refused to " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + ": max conVec reached.");
                }
                catch (IOException iOException) {
                    AQjmsOracleDebug.traceEx(3, "ConectionManager.addConnection-ioex", iOException);
                }
            } else {
                Connection connection = new Connection(socket, service);
                this.m_connectionList.put(connection, connection);
                AQjmsOracleDebug.trace(3, "ConectionManager.addConnection", "Connected to " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + " on port " + socket.getLocalPort() + " for service " + service.getClass().getName());
                connection.start();
            }
        }

        public synchronized void removeConnection(Connection connection) {
            if (this.m_connectionList.remove(connection) != null) {
                AQjmsOracleDebug.trace(3, "ConectionManager.removeConnection", "remove connection");
            }
        }

        public synchronized void setMaxConnections(int n) {
            this.maxCon = n;
        }

        synchronized void printConnections(PrintWriter printWriter) {
            Enumeration enumeration = this.m_connectionList.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                printWriter.println("CONNECTED TO " + connection.theClient.getInetAddress().getHostAddress() + ":" + connection.theClient.getPort() + " ON PORT " + connection.theClient.getLocalPort() + " FOR SERVICE " + connection.theService.getClass().getName());
            }
        }

        public synchronized void closeConnectionManager() {
            AQjmsOracleDebug.trace(3, "ConectionManager.closeConnectionManager", "stopping ConnManager");
            Enumeration enumeration = this.m_connectionList.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                AQjmsOracleDebug.trace(4, "closeConnectionManager", "before stopConnection");
                connection.stopConnection();
                AQjmsOracleDebug.trace(4, "closeConnectionManager", "after stopConnection");
            }
        }
    }
}

