/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;

class AQjmsExceptionListener
extends Thread
implements ExceptionListener {
    public static final long DEFAULT_PING_PERIOD = 120000L;
    private static final String PING_QUERY = "SELECT banner FROM v$version where 1<>1";
    private PreparedStatement m_pstmt;
    private ExceptionListener m_el;
    private long m_period;
    private boolean m_stop;
    private boolean m_suspended;
    private boolean m_registered;
    private boolean using_cpool;
    private Connection db_conn;

    AQjmsExceptionListener(Connection connection) throws AQjmsException {
        this.using_cpool = false;
        this.init(connection);
    }

    AQjmsExceptionListener(OracleOCIConnectionPool oracleOCIConnectionPool) throws AQjmsException {
        try {
            Connection connection = oracleOCIConnectionPool.getConnection();
            this.using_cpool = true;
            this.init(connection);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsExceptionListener constructor", sQLException);
            throw new AQjmsException(sQLException);
        }
    }

    private void init(Connection connection) throws AQjmsException {
        this.m_stop = false;
        this.m_suspended = true;
        this.m_registered = false;
        this.m_period = 120000L;
        if (connection != null) {
            try {
                this.m_pstmt = connection.prepareStatement(PING_QUERY);
                this.m_pstmt.setQueryTimeout(1);
            }
            catch (SQLException sQLException) {
                AQjmsOracleDebug.traceEx(3, "AQjmsExceptionListener constructor", sQLException);
                throw new AQjmsException(sQLException);
            }
            this.db_conn = this.using_cpool ? connection : null;
        }
    }

    synchronized void setExceptionListener(ExceptionListener exceptionListener) {
        if (exceptionListener == null) {
            this.m_registered = false;
        } else {
            this.m_registered = true;
            if (!this.isAlive()) {
                this.start();
            }
        }
        this.m_el = exceptionListener;
    }

    ExceptionListener getExceptionListener() {
        return this.m_el;
    }

    public synchronized void onException(JMSException jMSException) {
        if (this.m_el != null) {
            try {
                this.m_el.onException(jMSException);
            }
            catch (RuntimeException runtimeException) {
                AQjmsOracleDebug.traceEx(2, "Exception thrown by onException()", runtimeException);
                throw runtimeException;
            }
            catch (Error error) {
                AQjmsOracleDebug.traceErr(2, "Error thrown by onException()", error);
                throw error;
            }
        }
    }

    void setPingPeriod(long l) {
        if (l <= 0L) {
            return;
        }
        this.m_period = l;
    }

    long getPingPeriod() {
        return this.m_period;
    }

    public void run() {
        boolean bl = false;
        while (!this.m_stop) {
            try {
                Thread.sleep(this.m_period);
                if (!this.m_registered || this.m_suspended) continue;
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "executing query");
                this.m_pstmt.executeQuery();
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "done executing query");
            }
            catch (InterruptedException interruptedException) {
                if (!this.m_stop) continue;
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "run stopped");
                return;
            }
            catch (SQLException sQLException) {
                JMSException jMSException = new JMSException(sQLException.toString());
                this.onException(jMSException);
                this.m_stop = true;
            }
        }
    }

    synchronized void resumeExceptionListener() {
        if (this.m_suspended) {
            this.m_suspended = false;
        }
    }

    synchronized void suspendExceptionListener() {
        this.m_suspended = true;
    }

    void close() {
        try {
            if (!this.m_stop) {
                this.m_stop = true;
                if (this.isAlive()) {
                    this.interrupt();
                    try {
                        this.join(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "in close, InterruptedException caught");
                    }
                }
            }
            if (this.m_pstmt != null) {
                try {
                    this.m_pstmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.m_pstmt = null;
            }
            try {
                if (this.using_cpool && this.db_conn != null) {
                    this.db_conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() throws Throwable {
        try {
            this.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }
}

