/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.Referenceable;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMessageFormatException;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropDatum;
import oracle.jms.AQjmsProperty;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSignature;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

public class AQjmsMessage
implements Message {
    static final Class m_boolClass = new Boolean(false).getClass();
    static final Class m_byteClass = new Byte(0).getClass();
    static final Class m_shortClass = new Byte(0).getClass();
    static final Class m_intClass = new Integer(0).getClass();
    static final Class m_longClass = new Long(0L).getClass();
    static final Class m_floatClass = new Float(0.0f).getClass();
    static final Class m_doubleClass = new Double(0.0).getClass();
    static final Class m_strClass = new String(" ").getClass();
    static Hashtable m_systemProperties;
    AQjmsMessageHeaderExt header_ext;
    byte[] message_id = null;
    Date enqueue_time = null;
    String corr_id = "";
    Destination msg_dest = null;
    int del_mode = 2;
    boolean redelivered = false;
    long expiration = 0L;
    int priority;
    Hashtable msg_properties;
    int access_mode;
    boolean prop_read_only;
    long recv_time;
    int msg_state;
    String excp_queue;
    int msg_delay;
    byte[] orig_msg_id;
    AQjmsAgent sender_id;
    int attempts;
    AQjmsSignature m_signature;
    AQjmsSession session;
    boolean m_hdrOnly;
    boolean m_isjmsbody;
    private static final String JMS_REPLY_TO = "JMSReplyTo";

    public AQjmsMessage(boolean bl) {
        this.priority = bl && AQjmsConstants.isJ2eeCompliant() ? 4 : 1;
        this.msg_properties = new Hashtable();
        this.access_mode = 2;
        this.prop_read_only = false;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.m_signature = null;
        this.m_hdrOnly = false;
        this.m_isjmsbody = bl;
        this.header_ext = new AQjmsMessageHeaderExt();
    }

    public AQjmsMessage(AQjmsSession aQjmsSession, boolean bl) {
        this(bl);
        this.session = aQjmsSession;
    }

    public AQjmsMessage(AQjmsMessage aQjmsMessage) {
        this(aQjmsMessage.session, aQjmsMessage.m_isjmsbody);
        this.header_ext = aQjmsMessage.header_ext;
        this.message_id = aQjmsMessage.message_id;
        this.enqueue_time = aQjmsMessage.enqueue_time;
        this.corr_id = aQjmsMessage.corr_id;
        this.msg_dest = aQjmsMessage.msg_dest;
        this.del_mode = aQjmsMessage.del_mode;
        this.redelivered = aQjmsMessage.redelivered;
        this.expiration = aQjmsMessage.expiration;
        this.priority = aQjmsMessage.priority;
        this.msg_properties = aQjmsMessage.msg_properties;
        this.access_mode = aQjmsMessage.access_mode;
        this.prop_read_only = aQjmsMessage.prop_read_only;
        this.recv_time = aQjmsMessage.recv_time;
        this.msg_state = aQjmsMessage.msg_state;
        this.excp_queue = aQjmsMessage.excp_queue;
        this.msg_delay = aQjmsMessage.msg_delay;
        this.orig_msg_id = aQjmsMessage.orig_msg_id;
        this.sender_id = aQjmsMessage.sender_id;
        this.attempts = aQjmsMessage.attempts;
        this.m_signature = aQjmsMessage.m_signature;
        this.m_hdrOnly = aQjmsMessage.m_hdrOnly;
    }

    AQjmsMessageHeaderExt getMessageHeaderExt() {
        return this.header_ext;
    }

    Hashtable getPropertiesHashtable() {
        return this.msg_properties;
    }

    void setPropertiesHashtable(Hashtable hashtable) {
        this.msg_properties = hashtable;
    }

    public String getJMSMessageID() throws JMSException {
        if (this.message_id != null) {
            String string = RepConversion.bArray2String((byte[])this.message_id);
            return new String("ID:" + string);
        }
        return null;
    }

    public byte[] getJMSMessageIDAsBytes() throws JMSException {
        if (this.message_id != null) {
            byte[] byArray = new byte[this.message_id.length];
            System.arraycopy(this.message_id, 0, byArray, 0, this.message_id.length);
            return byArray;
        }
        return this.message_id;
    }

    void setJMSMessageID(byte[] byArray) throws JMSException {
        this.message_id = byArray;
    }

    public void setJMSMessageID(String string) throws JMSException {
        this.message_id = string == null ? null : string.getBytes();
    }

    public long getJMSTimestamp() throws JMSException {
        if (this.enqueue_time != null) {
            return this.enqueue_time.getTime();
        }
        return 0L;
    }

    public void setJMSTimestamp(long l) throws JMSException {
        this.enqueue_time = new Date(l);
        AQjmsOracleDebug.println("setJMSTimestamp. Enq Time: " + this.enqueue_time);
        AQjmsOracleDebug.println("setJMSTimestamp. Enq Time: " + this.enqueue_time.getTime());
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.corr_id.getBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        this.corr_id = new String(byArray);
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        this.corr_id = string;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.corr_id;
    }

    public Destination getJMSReplyTo() throws JMSException {
        Referenceable referenceable = null;
        try {
            referenceable = this.header_ext.getReplyto();
            if (referenceable != null) {
                String string = referenceable.getName();
                if (string != null && string.equalsIgnoreCase(JMS_REPLY_TO)) {
                    referenceable = AQjmsMessage.deserializeDest(referenceable.getAddress());
                }
                if (referenceable instanceof AQjmsAgent) {
                    String string2 = referenceable.getAddress();
                    if ((string == null || string.equals("") || string.equals(" ")) && (string2 == null || string2.equals(""))) {
                        referenceable = null;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        return referenceable;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        try {
            if (destination instanceof AQjmsAgent) {
                String string = ((AQjmsAgent)destination).getName();
                if (string != null && string.equalsIgnoreCase(JMS_REPLY_TO)) {
                    AQjmsError.throwEx(147);
                }
                this.header_ext.setReplyto((AQjmsAgent)destination);
            } else if (destination instanceof AQjmsDestination) {
                this.header_ext.setReplyto(new AQjmsAgent(JMS_REPLY_TO, AQjmsMessage.serializeDest((AQjmsDestination)destination)));
            } else {
                AQjmsError.throwEx(147);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public Destination getJMSDestination() throws JMSException {
        return this.msg_dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.msg_dest = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.del_mode;
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        if (n != 2 && n != 1) {
            AQjmsError.throwEx(101, Integer.toString(n));
        }
        this.del_mode = n;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        this.redelivered = bl;
    }

    public String getJMSType() throws JMSException {
        try {
            return this.header_ext.getType();
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public void setJMSType(String string) throws JMSException {
        try {
            this.header_ext.setType(string);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long l) throws JMSException {
        this.expiration = l;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int n) throws JMSException {
        this.priority = n;
    }

    public void clearProperties() throws JMSException {
        if (this.msg_properties != null) {
            this.msg_properties.clear();
        }
        if (this.header_ext != null) {
            try {
                this.header_ext.setReplyto(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setType(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setUserid(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setAppid(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setGroupid(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setGroupseq(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.header_ext.setProperties(null);
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.clearProperties", exception);
            }
        }
        this.redelivered = false;
        this.msg_dest = null;
        this.expiration = 0L;
        this.priority = this.m_isjmsbody && AQjmsConstants.isJ2eeCompliant() ? 4 : 1;
        this.corr_id = "";
        this.message_id = null;
        this.del_mode = 2;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.m_signature = null;
        this.setPropReadOnly(false);
    }

    public boolean propertyExists(String string) throws JMSException {
        if (m_systemProperties.containsKey(string)) {
            try {
                return this.getSystemProperty(string) != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.msg_properties.containsKey(string);
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        Object object;
        block12: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            if (string == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null && clazz == m_strClass) {
                        String string2 = (String)object;
                        return Boolean.valueOf(string2);
                    }
                    break block12;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 20: {
                            int n2 = ((Datum)object).intValue();
                            return n2 != 0;
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Boolean.valueOf(string3);
                        }
                    }
                    break block12;
                }
                return false;
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public byte getByteProperty(String string) throws JMSException {
        Object object;
        block13: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            if (string == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null && clazz == m_strClass) {
                        String string2 = (String)object;
                        return Byte.parseByte(string2);
                    }
                    break block13;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 21: {
                            int n2 = ((Datum)object).intValue();
                            return (byte)n2;
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Byte.parseByte(string3);
                        }
                    }
                    break block13;
                }
                throw new NumberFormatException("getByteProperty() -> null");
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public short getShortProperty(String string) throws JMSException {
        Object object;
        block13: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            if (string == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null && clazz == m_strClass) {
                        String string2 = (String)object;
                        return Short.parseShort(string2);
                    }
                    break block13;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 21: 
                        case 22: {
                            int n2 = ((Datum)object).intValue();
                            return (short)n2;
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Short.parseShort(string3);
                        }
                    }
                    break block13;
                }
                throw new NumberFormatException("getShortProperty() -> null");
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public int getIntProperty(String string) throws JMSException {
        Object object;
        block14: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            if (string == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null) {
                        if (clazz == m_strClass) {
                            String string2 = (String)object;
                            return Integer.parseInt(string2);
                        }
                        return ((Datum)object).intValue();
                    }
                    break block14;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)object).intValue();
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Integer.parseInt(string3);
                        }
                    }
                    break block14;
                }
                throw new NumberFormatException("getIntProperty() -> null");
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public long getLongProperty(String string) throws JMSException {
        Object object;
        block16: {
            AQjmsPropDatum aQjmsPropDatum = null;
            object = null;
            if (string == null) {
                AQjmsError.throwEx(139);
            }
            try {
                Class clazz = (Class)m_systemProperties.get(string);
                if (clazz != null) {
                    object = this.getSystemProperty(string);
                    if (object != null && clazz == m_strClass) {
                        String string2 = (String)object;
                        return Long.parseLong(string2);
                    }
                    if (clazz == m_intClass) {
                        return ((Datum)object).intValue();
                    }
                    if (clazz == m_longClass) {
                        return ((Datum)object).longValue();
                    }
                    break block16;
                }
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)object).intValue();
                        }
                        case 24: {
                            return ((Datum)object).longValue();
                        }
                        case 27: {
                            String string3 = (String)object;
                            return Long.parseLong(string3);
                        }
                    }
                    break block16;
                }
                throw new NumberFormatException("getLongProperty() -> null");
            }
            catch (SQLException sQLException) {
                throw new AQjmsMessageFormatException(sQLException);
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public float getFloatProperty(String string) throws JMSException {
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
        }
        try {
            Class clazz = (Class)m_systemProperties.get(string);
            if (clazz != null) {
                object = this.getSystemProperty(string);
                if (object != null && clazz == m_strClass) {
                    String string2 = (String)object;
                    return new Float(string2).floatValue();
                }
            } else {
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 25: {
                            return ((Datum)object).floatValue();
                        }
                        case 27: {
                            String string3 = (String)object;
                            return new Float(string3).floatValue();
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsMessageFormatException(sQLException);
        }
        catch (Exception exception) {
            AQjmsError.throwMsgFormatEx(117, exception.getMessage());
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public double getDoubleProperty(String string) throws JMSException {
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
        }
        try {
            Class clazz = (Class)m_systemProperties.get(string);
            if (clazz != null) {
                object = this.getSystemProperty(string);
                if (object != null && clazz == m_strClass) {
                    String string2 = (String)object;
                    return new Double(string2);
                }
            } else {
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 25: {
                            return ((Datum)object).floatValue();
                        }
                        case 26: {
                            return ((Datum)object).doubleValue();
                        }
                        case 27: {
                            String string3 = (String)object;
                            return new Double(string3);
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsMessageFormatException(sQLException);
        }
        catch (Exception exception) {
            AQjmsError.throwMsgFormatEx(117, exception.getMessage());
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public String getStringProperty(String string) throws JMSException {
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
        }
        try {
            Class clazz = (Class)m_systemProperties.get(string);
            if (clazz != null) {
                object = this.getSystemProperty(string);
                if (object != null) {
                    if (clazz == m_strClass) {
                        return (String)object;
                    }
                    return ((Datum)object).stringValue();
                }
            } else {
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 20: {
                            int n2 = ((Datum)object).intValue();
                            if (n2 > 0) {
                                return "true";
                            }
                            return "false";
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: {
                            return ((Datum)object).stringValue();
                        }
                    }
                    return (String)object;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsMessageFormatException(sQLException);
        }
        catch (Exception exception) {
            AQjmsError.throwMsgFormatEx(117, exception.getMessage());
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public Object getObjectProperty(String string) throws JMSException {
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        if (string == null) {
            AQjmsError.throwEx(139);
        }
        try {
            Class clazz = (Class)m_systemProperties.get(string);
            if (clazz != null) {
                if (clazz == m_strClass && (object = this.getSystemProperty(string)) != null) {
                    return object;
                }
                if (clazz == m_intClass && (object = this.getSystemProperty(string)) != null) {
                    return new Integer(((Datum)object).intValue());
                }
                if (clazz == m_longClass && (object = this.getSystemProperty(string)) != null) {
                    return new Long(((Datum)object).longValue());
                }
            } else {
                aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                if (aQjmsPropDatum != null) {
                    object = aQjmsPropDatum.getValue();
                    int n = aQjmsPropDatum.getType();
                    switch (n) {
                        case 20: {
                            int n2 = ((Datum)object).intValue();
                            return new Boolean(n2 > 0);
                        }
                        case 21: {
                            int n3 = ((Datum)object).intValue();
                            return new Byte((byte)n3);
                        }
                        case 22: {
                            int n4 = ((Datum)object).intValue();
                            return new Short((short)n4);
                        }
                        case 23: {
                            int n5 = ((Datum)object).intValue();
                            return new Integer(n5);
                        }
                        case 24: {
                            long l = ((Datum)object).longValue();
                            return new Long(l);
                        }
                        case 25: {
                            float f = ((Datum)object).floatValue();
                            return new Float(f);
                        }
                        case 26: {
                            double d = ((Datum)object).doubleValue();
                            return new Double(d);
                        }
                        case 27: {
                            return object;
                        }
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsMessageFormatException(sQLException);
        }
        catch (Exception exception) {
            AQjmsError.throwMsgFormatEx(117, exception.getMessage());
        }
        if (object != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public synchronized Enumeration getPropertyNames() throws JMSException {
        Vector<String> vector = new Vector<String>(this.msg_properties.size() + m_systemProperties.size());
        Enumeration enumeration = m_systemProperties.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        enumeration = this.msg_properties.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        return vector.elements();
    }

    public synchronized Enumeration getUserPropertyNames() throws JMSException {
        Vector<String> vector = new Vector<String>(this.msg_properties.size());
        Enumeration enumeration = this.msg_properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("JMS")) continue;
            vector.addElement(string);
        }
        return vector.elements();
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(bl);
            if (string.startsWith("JMS")) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(20, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(by);
            if (string.startsWith("JMS")) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(21, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setShortProperty(String string, short s) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(s);
            if (string.startsWith("JMS")) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(22, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setIntProperty(String string, int n) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(n);
            if (string.startsWith("JMS")) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsOracleDebug.println("setIntProperty: Property: " + string + " Value:  " + n);
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(23, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setLongProperty(String string, long l) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(l);
            if (string.startsWith("JMS")) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(24, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(f);
            if (string.startsWith("JMS")) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(25, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        try {
            NUMBER nUMBER = new NUMBER(d);
            if (string.startsWith("JMS")) {
                this.setSystemProperty(string, nUMBER);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(26, (Datum)nUMBER);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        this.checkPropertyValue(string, string2);
        try {
            if (string.startsWith("JMS")) {
                this.setSystemProperty(string, string2);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(27, string2);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    void setStringProperty2(String string, String string2) throws JMSException {
        this.checkPropertyName(string);
        this.checkPropertyValue(string, string2);
        try {
            if (string.startsWith("JMS")) {
                this.setSystemProperty(string, string2);
            } else {
                AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(27, string2);
                this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
            }
        }
        catch (SQLException sQLException) {
            AQjmsError.throwEx(119, sQLException);
        }
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(string);
        if (object == null) {
            AQjmsError.throwMsgFormatEx(119, null);
        }
        if (object instanceof Boolean) {
            this.setBooleanProperty(string, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByteProperty(string, (Byte)object);
        } else if (object instanceof Short) {
            this.setShortProperty(string, (Short)object);
        } else if (object instanceof Integer) {
            this.setIntProperty(string, (Integer)object);
        } else if (object instanceof Long) {
            this.setLongProperty(string, (Long)object);
        } else if (object instanceof Float) {
            this.setFloatProperty(string, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDoubleProperty(string, (Double)object);
        } else if (object instanceof String) {
            this.setStringProperty(string, (String)object);
        } else {
            AQjmsError.throwMsgFormatEx(119, null);
        }
    }

    public void acknowledge() throws JMSException {
        Connection connection = null;
        if (this.session.getAckMode() == 2) {
            connection = this.session.getDBConnection();
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
        }
    }

    public void clearBody() throws JMSException {
        AQjmsError.throwEx(103);
    }

    public AQjmsAgent getSenderID() throws JMSException {
        return this.sender_id;
    }

    public void setSenderID(AQjmsAgent aQjmsAgent) throws JMSException {
        this.sender_id = aQjmsAgent;
    }

    public int getAttempts() throws JMSException {
        return this.attempts;
    }

    void setAttempts(int n) throws JMSException {
        this.attempts = n;
    }

    boolean isPropReadOnly() {
        return this.prop_read_only;
    }

    void setPropReadOnly(boolean bl) {
        this.prop_read_only = bl;
    }

    boolean isBodyReadOnly() {
        return this.access_mode == 0;
    }

    boolean isBodyWriteOnly() {
        return this.access_mode == 1;
    }

    boolean isBodyReadWrite() {
        return this.access_mode == 2;
    }

    void setAccessMode(int n) throws JMSException {
        if (n == 0 || n == 1 || n == 2) {
            this.access_mode = n;
        } else {
            AQjmsError.throwEx(152);
        }
    }

    static String ByteArraytoString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray == null) {
            stringBuffer.append("");
        } else {
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = byArray[n2] & 0xFF;
                if (n3 < 16) {
                    stringBuffer.append("0" + Integer.toHexString(n3));
                } else {
                    stringBuffer.append(Integer.toHexString(n3));
                }
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public static AQjmsPropertyList convertHashtableToPropertyList(Hashtable hashtable) throws JMSException {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        String string = null;
        AQjmsPropDatum aQjmsPropDatum = null;
        Object object = null;
        n = hashtable.size();
        AQjmsOracleDebug.println("Num props " + n);
        AQjmsProperty[] aQjmsPropertyArray = new AQjmsProperty[n];
        enumeration2 = hashtable.keys();
        enumeration = hashtable.elements();
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "entry");
        try {
            n2 = 0;
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                aQjmsPropDatum = (AQjmsPropDatum)enumeration.nextElement();
                object = aQjmsPropDatum.getValue();
                aQjmsPropertyArray[n2] = new AQjmsProperty();
                AQjmsOracleDebug.println("Property: " + n2);
                AQjmsOracleDebug.println("Name: " + string + "  Type: " + aQjmsPropDatum.getType());
                if (object instanceof String) {
                    aQjmsPropertyArray[n2].setName(string);
                    aQjmsPropertyArray[n2].setType(new Integer(100));
                    aQjmsPropertyArray[n2].setStrValue((String)object);
                    aQjmsPropertyArray[n2].setNumValue(null);
                    aQjmsPropertyArray[n2].setJavaType(new Integer(aQjmsPropDatum.getType()));
                    AQjmsOracleDebug.println("Name: " + string + "  Value: " + (String)object + "  Str Type: " + aQjmsPropDatum.getType());
                } else if (object instanceof NUMBER) {
                    aQjmsPropertyArray[n2].setName(string);
                    aQjmsPropertyArray[n2].setType(new Integer(200));
                    aQjmsPropertyArray[n2].setStrValue(null);
                    aQjmsPropertyArray[n2].setNumValue(((Datum)object).bigDecimalValue());
                    aQjmsPropertyArray[n2].setJavaType(new Integer(aQjmsPropDatum.getType()));
                    AQjmsOracleDebug.println("Name: " + string + "  Value: " + ((Datum)object).bigDecimalValue() + "  Num Type: " + aQjmsPropDatum.getType());
                } else {
                    AQjmsOracleDebug.trace(1, "AQjmsMessage.convertHashtableToPropertyList", "Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertHashtableToPropertyList", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsPropertyList aQjmsPropertyList = new AQjmsPropertyList(aQjmsPropertyArray);
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "exit");
        return aQjmsPropertyList;
    }

    static Hashtable convertPropertyListToHashtable(AQjmsPropertyList aQjmsPropertyList) throws JMSException {
        Hashtable<String, AQjmsPropDatum> hashtable;
        int n = 0;
        int n2 = 0;
        Object var5_3 = null;
        Object var6_4 = null;
        String string = null;
        AQjmsPropDatum aQjmsPropDatum = null;
        NUMBER nUMBER = null;
        String string2 = null;
        int n3 = 0;
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "entry");
        try {
            n = aQjmsPropertyList.length();
            hashtable = new Hashtable<String, AQjmsPropDatum>();
            AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "num_props: " + n);
            AQjmsProperty[] aQjmsPropertyArray = new AQjmsProperty[n];
            n2 = 0;
            while (n2 < n) {
                aQjmsPropertyArray[n2] = aQjmsPropertyList.getElement(n2);
                string = aQjmsPropertyArray[n2].getName();
                Integer n4 = aQjmsPropertyArray[n2].getType();
                n3 = aQjmsPropertyArray[n2].getJavaType();
                if (n4 == 100) {
                    string2 = aQjmsPropertyArray[n2].getStrValue();
                    aQjmsPropDatum = new AQjmsPropDatum(n3, string2);
                } else if (n4 == 200) {
                    nUMBER = new NUMBER(aQjmsPropertyArray[n2].getNumValue());
                    aQjmsPropDatum = new AQjmsPropDatum(n3, (Datum)nUMBER);
                } else {
                    AQjmsOracleDebug.trace(1, "AQjmsMessage.converPropertyListToHashtable", "Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                hashtable.put(string, aQjmsPropDatum);
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertPropertyListToHashtable", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "exit");
        return hashtable;
    }

    static void printPropertyList(AQjmsProperty[] aQjmsPropertyArray) throws JMSException {
        int n = 0;
        int n2 = 0;
        Object var3_3 = null;
        Object var4_4 = null;
        String string = null;
        Object var6_6 = null;
        Object var7_7 = null;
        int n3 = 0;
        AQjmsOracleDebug.println("[PropertyList]");
        try {
            n = aQjmsPropertyArray.length;
            n2 = 0;
            while (n2 < n) {
                string = aQjmsPropertyArray[n2].getName();
                Integer n4 = aQjmsPropertyArray[n2].getType();
                AQjmsOracleDebug.print("Prop:" + n2 + "  Type: " + n4);
                if (n4 == 100) {
                    AQjmsOracleDebug.println("  StrVal: " + aQjmsPropertyArray[n2].getStrValue());
                } else if (n4 == 200) {
                    AQjmsOracleDebug.println("  NumVal: " + aQjmsPropertyArray[n2].getNumValue());
                } else {
                    AQjmsOracleDebug.println("Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                n3 = aQjmsPropertyArray[n2].getJavaType();
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertPropertyListToHashtable", sQLException);
            throw new AQjmsException(sQLException);
        }
    }

    void setSystemProperty(String string, Object object) throws JMSException, SQLException {
        try {
            if (m_systemProperties.containsKey(string)) {
                if (string.equals("JMSXUserID")) {
                    AQjmsError.throwEx(110, string);
                } else if (string.equals("JMSXAppID")) {
                    if (object instanceof String) {
                        this.header_ext.setAppid((String)object);
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (string.equals("JMSXDeliveryCount")) {
                    AQjmsError.throwEx(110, string);
                } else if (string.equals("JMSXGroupID")) {
                    if (object instanceof String) {
                        this.header_ext.setGroupid((String)object);
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (string.equals("JMSXGroupSeq")) {
                    if (object instanceof NUMBER) {
                        this.header_ext.setGroupseq(new Integer(((Datum)object).intValue()));
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (string.equals("JMSXProducerTXID")) {
                    AQjmsError.throwEx(110);
                } else if (string.equals("JMSXConsumerTXID")) {
                    AQjmsError.throwEx(110);
                } else if (string.equals("JMSXRecvTimestamp")) {
                    AQjmsError.throwEx(110, string);
                } else if (string.equals("JMSXState")) {
                    AQjmsError.throwEx(110, string);
                } else if (string.equals("JMS_OracleExcpQ")) {
                    if (object instanceof String) {
                        this.excp_queue = (String)object;
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (string.equals("JMS_OracleDelay")) {
                    if (object instanceof NUMBER) {
                        this.msg_delay = ((Datum)object).intValue();
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else if (string.equals("JMS_OracleOriginalMessageID")) {
                    AQjmsError.throwEx(110, string);
                } else if (string.equals("JMS_OracleHeaderOnly")) {
                    AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(27, "yes");
                    this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
                } else if (string.equals("JMS_OracleDeliveryMode")) {
                    AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(27, (String)object);
                    this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
                } else if (string.equals("JMS_OracleConnectionID")) {
                    if (object instanceof String) {
                        AQjmsPropDatum aQjmsPropDatum = new AQjmsPropDatum(27, (String)object);
                        this.insertPropertyIntoTable(this.msg_properties, string, aQjmsPropDatum);
                    } else {
                        AQjmsError.throwEx(153);
                    }
                } else {
                    AQjmsError.throwEx(140);
                }
            } else {
                AQjmsError.throwEx(140);
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.setSystemProperty-sqlex", sQLException);
            throw sQLException;
        }
    }

    Object getSystemProperty(String string) throws SQLException {
        Object object;
        block19: {
            object = null;
            Object var3_3 = null;
            int n = 0;
            try {
                if (m_systemProperties.containsKey(string)) {
                    if (string.equals("JMSXUserID")) {
                        object = this.header_ext.getUserid();
                        break block19;
                    }
                    if (string.equals("JMSXAppID")) {
                        object = this.header_ext.getAppid();
                        break block19;
                    }
                    if (string.equals("JMSXDeliveryCount")) {
                        return null;
                    }
                    if (string.equals("JMSXGroupID")) {
                        object = this.header_ext.getGroupid();
                        break block19;
                    }
                    if (string.equals("JMSXGroupSeq")) {
                        if (this.header_ext.getGroupseq() != null) {
                            n = this.header_ext.getGroupseq();
                            object = new NUMBER(n);
                            break block19;
                        }
                        return null;
                    }
                    if (string.equals("JMSXProducerTXID")) {
                        return null;
                    }
                    if (string.equals("JMSXConsumerTXID")) {
                        return null;
                    }
                    if (string.equals("JMSXRecvTimestamp")) {
                        object = new NUMBER(this.recv_time);
                        break block19;
                    }
                    if (string.equals("JMSXState")) {
                        object = new NUMBER(this.msg_state);
                        break block19;
                    }
                    if (string.equals("JMS_OracleExcpQ")) {
                        object = this.excp_queue;
                        break block19;
                    }
                    if (string.equals("JMS_OracleDelay")) {
                        object = new NUMBER(this.msg_delay);
                        break block19;
                    }
                    if (string.equals("JMS_OracleOriginalMessageID")) {
                        object = this.orig_msg_id == null ? null : "ID:" + RepConversion.bArray2String((byte[])this.orig_msg_id);
                        break block19;
                    }
                    if (string.equals("JMS_OracleHeaderOnly")) {
                        Object v = this.msg_properties.get(string);
                        object = v != null ? "yes" : null;
                        break block19;
                    }
                    if (string.equals("JMS_OracleConnectionID")) {
                        AQjmsPropDatum aQjmsPropDatum = (AQjmsPropDatum)this.msg_properties.get(string);
                        object = aQjmsPropDatum != null ? aQjmsPropDatum.getValue() : null;
                        break block19;
                    }
                    if (string.equals("JMS_OracleDeliveryMode")) {
                        Object v = this.msg_properties.get(string);
                        object = v != null ? ((AQjmsPropDatum)v).getStringValue() : null;
                        break block19;
                    }
                    return null;
                }
                return null;
            }
            catch (SQLException sQLException) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getSystemProperty-sqlex", sQLException);
                throw sQLException;
            }
        }
        return object;
    }

    void setReceiveTime(long l) {
        this.recv_time = l;
    }

    void setMessageState(int n) throws JMSException {
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            this.msg_state = n;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsMessage.setMessageState", "Internal error - invalid message state, msg_state: " + n);
            AQjmsError.throwEx(122);
        }
    }

    void setOriginalMessageId(byte[] byArray) throws JMSException {
        this.orig_msg_id = byArray;
    }

    void setExceptionQueue(String string) {
        this.excp_queue = string;
    }

    String getExceptionQueue() {
        return this.excp_queue;
    }

    void setDelay(int n) {
        this.msg_delay = n;
    }

    int getDelay() {
        return this.msg_delay;
    }

    public void setSignature(AQjmsSignature aQjmsSignature) {
        this.m_signature = aQjmsSignature;
    }

    public AQjmsSignature getSignature() {
        return this.m_signature;
    }

    void setHeaderOnly() {
        this.m_hdrOnly = true;
    }

    boolean isHeaderOnly() {
        return this.m_hdrOnly;
    }

    int getMsgState() {
        return this.msg_state;
    }

    String getMsgStateAsString() {
        if (this.msg_state == 0) {
            return "READY";
        }
        if (this.msg_state == 1) {
            return "WAITING";
        }
        if (this.msg_state == 2) {
            return "PROCESSED";
        }
        return "EXPIRED";
    }

    void checkPropertyName(String string) throws JMSException {
        if (string == null) {
            AQjmsError.throwEx(139);
        }
        if (string.length() > 100) {
            AQjmsError.throwEx(148);
        }
    }

    void checkPropertyValue(String string, String string2) throws JMSException {
        if (string2 != null) {
            if (string.equalsIgnoreCase("JMSXAppID") || string.equalsIgnoreCase("JMSXUserID") || string.equalsIgnoreCase("JMSXGroupID") || string.equalsIgnoreCase("JMSXType")) {
                if (string2.length() > 100) {
                    AQjmsError.throwEx(165);
                }
            } else if (string2.length() > 2000) {
                AQjmsError.throwEx(165);
            }
        }
    }

    void insertPropertyIntoTable(Hashtable hashtable, String string, AQjmsPropDatum aQjmsPropDatum) throws JMSException {
        if (hashtable.size() < 100) {
            hashtable.put(string, aQjmsPropDatum);
        } else {
            AQjmsError.throwEx(132);
        }
    }

    private static void initSystemPropertyTypeTable() {
        m_systemProperties = new Hashtable();
        m_systemProperties.put("JMSXAppID", m_strClass);
        m_systemProperties.put("JMSXUserID", m_strClass);
        m_systemProperties.put("JMSXRecvTimestamp", m_longClass);
        m_systemProperties.put("JMSXState", m_intClass);
        m_systemProperties.put("JMSXDeliveryCount", m_intClass);
        m_systemProperties.put("JMSXGroupID", m_strClass);
        m_systemProperties.put("JMSXGroupSeq", m_intClass);
        m_systemProperties.put("JMS_OracleExcpQ", m_strClass);
        m_systemProperties.put("JMS_OracleDelay", m_longClass);
        m_systemProperties.put("JMS_OracleOriginalMessageID", m_strClass);
        m_systemProperties.put("JMS_OracleHeaderOnly", m_strClass);
        m_systemProperties.put("JMS_OracleDeliveryMode", m_strClass);
        m_systemProperties.put("JMS_OracleConnectionID", m_strClass);
    }

    public void printSystemProperties() {
        AQjmsOracleDebug.trace(5, "printSystemProperties", "SYSTEM PROPERTIES");
        try {
            if (this.propertyExists("JMSXAppID")) {
                AQjmsOracleDebug.trace(5, "  JMSXAppID: ", this.getStringProperty("JMSXAppID"));
            }
            if (this.propertyExists("JMSXUserID")) {
                AQjmsOracleDebug.trace(5, "  JMSXUserID: ", this.getStringProperty("JMSXUserID"));
            }
            if (this.propertyExists("JMSXRecvTimestamp")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXRecvTimestamp: " + this.getLongProperty("JMSXRecvTimestamp"));
            }
            if (this.propertyExists("JMSXState")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXState: " + this.getIntProperty("JMSXState"));
            }
            if (this.propertyExists("JMSXDeliveryCount")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXDeliveryCount: " + this.getIntProperty("JMSXDeliveryCount"));
            }
            if (this.propertyExists("JMSXGroupID")) {
                AQjmsOracleDebug.trace(5, "  JMSXGroupID: ", this.getStringProperty("JMSXGroupID"));
            }
            if (this.propertyExists("JMSXGroupSeq")) {
                AQjmsOracleDebug.trace(5, "  JMSXGroupSeq: ", this.getStringProperty("JMSXGroupSeq"));
            }
            if (this.propertyExists("JMS_OracleExcpQ")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleExcpQ: ", this.getStringProperty("JMS_OracleExcpQ"));
            }
            if (this.propertyExists("JMS_OracleDelay")) {
                AQjmsOracleDebug.trace(5, "", "  JMS_OracleDelay: " + this.getLongProperty("JMS_OracleDelay"));
            }
            if (this.propertyExists("JMS_OracleOriginalMessageID")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleOriginalMessageID: ", this.getStringProperty("JMS_OracleOriginalMessageID"));
            }
            if (this.propertyExists("JMS_OracleDeliveryMode")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleDeliveryMode: ", this.getStringProperty("JMS_OracleDeliveryMode"));
            }
            if (this.propertyExists("JMS_OracleConnectionID")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleConnectionID: ", this.getStringProperty("JMS_OracleConnectionID"));
            }
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.trace(5, "PrintSystemPropertied", "Caught JMSException " + (Object)((Object)jMSException));
        }
    }

    private static String serializeDest(AQjmsDestination aQjmsDestination) throws JMSException {
        StringWriter stringWriter = new StringWriter();
        try {
            stringWriter.write("type=" + (aQjmsDestination.isQueue() ? 10 : 20) + "\n");
            stringWriter.write("owner=" + (aQjmsDestination.isQueue() ? aQjmsDestination.getQueueOwner() : aQjmsDestination.getTopicOwner()) + "\n");
            stringWriter.write("name=" + (aQjmsDestination.isQueue() ? aQjmsDestination.getQueueName() : aQjmsDestination.getTopicName()) + "\n");
            stringWriter.write("table=" + aQjmsDestination.getQueueTableName() + "\n");
            stringWriter.write("pload_type=" + aQjmsDestination.getPloadType() + "\n");
            stringWriter.write("adt_type=" + aQjmsDestination.getAdtType() + "\n");
            if (aQjmsDestination.isSecure()) {
                stringWriter.write("secure=true\n");
            } else {
                stringWriter.write("secure=false\n");
            }
            AQjmsDestinationProperty aQjmsDestinationProperty = aQjmsDestination.getProperty();
            stringWriter.write("property.queue_type=" + aQjmsDestinationProperty.getQueueType() + "\n");
            stringWriter.write("property.max_retries=" + aQjmsDestinationProperty.getMaxRetries() + "\n");
            stringWriter.write("property.retry_interval=" + aQjmsDestinationProperty.getRetryInterval() + "\n");
            stringWriter.write("property.retention_time=" + aQjmsDestinationProperty.getRetentionTime() + "\n");
            stringWriter.write("property.comment=" + aQjmsDestinationProperty.getComment() + "\n");
            stringWriter.flush();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(147);
        }
        return stringWriter.toString();
    }

    /*
     * Loose catch block
     */
    private static AQjmsDestination deserializeDest(String string) throws JMSException {
        AQjmsDestination aQjmsDestination;
        block13: {
            if (string == null) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            aQjmsDestination = null;
            boolean bl = false;
            Properties properties = new Properties();
            properties.load(byteArrayInputStream);
            AQjmsDestinationProperty aQjmsDestinationProperty = new AQjmsDestinationProperty();
            aQjmsDestinationProperty.setQueueType(Integer.parseInt(properties.getProperty("property.queue_type")));
            aQjmsDestinationProperty.setMaxRetries(Integer.parseInt(properties.getProperty("property.max_retries")));
            aQjmsDestinationProperty.setRetryInterval((double)new Double(properties.getProperty("property.retry_interval")));
            aQjmsDestinationProperty.setRetentionTime((double)new Double(properties.getProperty("property.retention_time")));
            aQjmsDestinationProperty.setComment(properties.getProperty("property.comment"));
            int n = Integer.parseInt(properties.getProperty("type"));
            String string2 = properties.getProperty("owner");
            String string3 = properties.getProperty("name");
            String string4 = properties.getProperty("table");
            int n2 = Integer.parseInt(properties.getProperty("pload_type"));
            String string5 = properties.getProperty("adt_type");
            String string6 = properties.getProperty("secure");
            if (string6.equalsIgnoreCase("true")) {
                bl = true;
            }
            aQjmsDestination = new AQjmsDestination(string2, string3, n, n2, string5, aQjmsDestinationProperty, string4, bl);
            Object var14_14 = null;
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                break block13;
            }
            catch (Exception exception) {}
            break block13;
            {
                catch (Exception exception) {
                    AQjmsError.throwEx(147);
                    Object var14_15 = null;
                    try {
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                        break block13;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return aQjmsDestination;
    }

    boolean isJMSBody() {
        return this.m_isjmsbody;
    }

    public static int toJMSPriority(int n) {
        return 9 - n;
    }

    static {
        AQjmsMessage.initSystemPropertyTypeTable();
    }
}

