/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.sql.BLOB;
import oracle.sql.ORADataFactory;

public class AQjmsObjectMessage
extends AQjmsMessage
implements ObjectMessage {
    AQjmsObjectMessage_C obj_msg_cont;
    Serializable serial_obj;
    byte[] bytes_data;

    public AQjmsObjectMessage() throws JMSException {
        super(true);
        this.serial_obj = null;
        try {
            this.obj_msg_cont = new AQjmsObjectMessage_C();
            this.obj_msg_cont.setHeader(this.header_ext);
            this.bytes_data = null;
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "Constructor", sQLException);
            throw new AQjmsException(sQLException);
        }
    }

    public AQjmsObjectMessage(AQjmsSession aQjmsSession) throws JMSException {
        super(aQjmsSession, true);
        this.serial_obj = null;
        try {
            this.obj_msg_cont = new AQjmsObjectMessage_C();
            this.obj_msg_cont.setHeader(this.header_ext);
            this.bytes_data = null;
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "Constructor", sQLException);
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsObjectMessage(AQjmsSession aQjmsSession, AQjmsObjectMessage_C aQjmsObjectMessage_C) throws JMSException {
        super(aQjmsSession, true);
        this.serial_obj = null;
        try {
            this.obj_msg_cont = aQjmsObjectMessage_C;
            this.header_ext = aQjmsObjectMessage_C.getHeader();
            this.readObjectMessageContainer(false);
            this.bytes_data = null;
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "Constructor w/container", sQLException);
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsObjectMessage(AQjmsSession aQjmsSession, AQjmsObjectMessage_C aQjmsObjectMessage_C, boolean bl) throws JMSException {
        super(aQjmsSession, true);
        this.serial_obj = null;
        try {
            this.obj_msg_cont = aQjmsObjectMessage_C;
            this.bytes_data = null;
            this.header_ext = aQjmsObjectMessage_C.getHeader();
            this.readObjectMessageContainer(bl);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "Constructor w/container: xml_receive: " + bl, sQLException);
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsObjectMessage(AQjmsSession aQjmsSession, byte[] byArray, boolean bl) throws JMSException {
        super(aQjmsSession, true);
        if (bl) {
            this.bytes_data = byArray;
        } else {
            this.serial_obj = AQjmsObjectMessage.convertByteArrayToSerializable(byArray);
        }
    }

    public byte[] getSerialObject() throws JMSException {
        Serializable serializable = this.getObject();
        if (this.bytes_data != null) {
            return this.bytes_data;
        }
        return AQjmsObjectMessage.convertSerializableToByteArray(serializable);
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        AQjmsOracleDebug.println("ObjectMessage.clearprop-1");
        try {
            if (this.obj_msg_cont != null) {
                this.obj_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.println("Message.clearprop-ex-2" + sQLException);
            throw new AQjmsException(sQLException);
        }
    }

    public void setObject(Serializable serializable) throws JMSException {
        Object var2_2 = null;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else if (serializable instanceof Serializable) {
            this.serial_obj = AQjmsObjectMessage.convertByteArrayToSerializable(AQjmsObjectMessage.convertSerializableToByteArray(serializable));
        } else {
            AQjmsError.throwMsgFormatEx(161, "invalid object type");
        }
    }

    public Serializable getObject() throws JMSException {
        return this.serial_obj;
    }

    static byte[] convertSerializableToByteArray(Serializable serializable) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertSerializableToByteArray", "entry");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertSerializableToByteArray", "exit");
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsObjectMessage.ioexp-1", iOException);
            AQjmsError.throwEx(157, iOException.getMessage());
            return null;
        }
    }

    static Serializable convertByteArrayToSerializable(byte[] byArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "entry");
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Serializable serializable = (Serializable)objectInputStream.readObject();
            AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.convertByteArrayToSerializable", "exit");
            return serializable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwEx(109, classNotFoundException.getMessage());
        }
        catch (InvalidClassException invalidClassException) {
            AQjmsError.throwEx(109, invalidClassException.getMessage());
        }
        catch (IOException iOException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsObjectMessage.ioexp-2", iOException);
            AQjmsError.throwEx(157, iOException.getMessage());
        }
        return null;
    }

    public void clearBody() throws JMSException {
        this.serial_obj = null;
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    AQjmsObjectMessage_C getMessageCont() {
        return this.obj_msg_cont;
    }

    void populateObjectMessageContainer() throws JMSException {
        Object var1_1 = null;
        int n = 0;
        byte[] byArray = null;
        try {
            this.obj_msg_cont.setHeader(this.header_ext);
            byArray = this.bytes_data == null ? AQjmsObjectMessage.convertSerializableToByteArray(this.serial_obj) : this.bytes_data;
            n = byArray.length;
            this.obj_msg_cont.setBytesLen(new Integer(n));
            if (n > 2000) {
                this.obj_msg_cont.setBytesRaw(null);
            } else {
                this.obj_msg_cont.setBytesRaw(byArray);
                this.obj_msg_cont.setBytesLob(null);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    void write_blob(Connection connection, String string, byte[] byArray, boolean bl, boolean bl2) throws JMSException {
        BLOB bLOB = null;
        int n = 0;
        byte[] byArray2 = null;
        int n2 = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.write_blob", "entry");
        try {
            byArray2 = this.bytes_data == null ? AQjmsObjectMessage.convertSerializableToByteArray(this.serial_obj) : this.bytes_data;
            n = byArray2.length;
            if (string == null) {
                AQjmsOracleDebug.trace(1, "AQjmsObjectMessage.write_blob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsObjectMessage.write_blob", "- bytes_len: " + n);
            if (n > 2000) {
                ORADataFactory oRADataFactory = bl ? AQjmsGenMessage_C.getFactory() : AQjmsObjectMessage_C.getFactory();
                AQjmsOracleDebug.trace(5, "AQjmsObjectMessage.write_blob", "is_anydata_dest: " + bl2);
                statement = bl2 ? (OracleCallableStatement)connection.prepareCall("SELECT dbms_aqin.aq$_getblob_from_jmsanydata(user_data) FROM " + string + " where msgid = ?") : (OracleCallableStatement)connection.prepareCall("SELECT user_data FROM " + string + " where msgid = ?");
                statement.setBytes(1, byArray);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    if (bl2) {
                        bLOB = ((OracleResultSet)resultSet).getBLOB(1);
                    } else if (bl) {
                        AQjmsGenMessage_C aQjmsGenMessage_C = (AQjmsGenMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        bLOB = aQjmsGenMessage_C.getBytesLob();
                    } else {
                        AQjmsObjectMessage_C aQjmsObjectMessage_C = (AQjmsObjectMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        bLOB = aQjmsObjectMessage_C.getBytesLob();
                    }
                }
                if (bLOB == null) {
                    AQjmsError.throwEx(122, "blob is null");
                }
                n2 = bLOB.putBytes(1L, byArray2);
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.write_blob", "exit");
    }

    void readObjectMessageContainer(boolean bl) throws JMSException {
        BLOB bLOB = null;
        int n = 0;
        byte[] byArray = null;
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.readObjectMessageContainer", "entry");
        try {
            n = this.obj_msg_cont.getBytesLen();
            AQjmsOracleDebug.trace(5, "AQjmsObjectMessage.readObjectMessageContainer", "- bytes_len: " + n);
            if (n > 2000) {
                bLOB = this.obj_msg_cont.getBytesLob();
                if (bLOB != null) {
                    byArray = bLOB.getBytes(1L, n);
                }
            } else {
                byArray = this.obj_msg_cont.getBytesRaw();
            }
            if (!bl) {
                this.serial_obj = AQjmsObjectMessage.convertByteArrayToSerializable(byArray);
                this.bytes_data = null;
            } else {
                this.bytes_data = byArray;
                this.serial_obj = null;
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsObjectMessage.readObjectMessageContainer", "exit");
    }

    public void setBytesData(byte[] byArray) {
        this.bytes_data = byArray;
    }

    public byte[] getBytesData() {
        return this.bytes_data;
    }
}

