/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.Reference;
import javax.naming.Referenceable;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;

public class AQjmsQueueConnectionFactory
implements QueueConnectionFactory,
Referenceable,
Serializable {
    String hostname;
    String oracle_sid;
    int portno;
    String jdbc_driver;
    String jdbc_conn_str;
    Properties jdbc_info;

    AQjmsQueueConnectionFactory(String string, String string2, int n, String string3) throws JMSException {
        this.hostname = string;
        this.oracle_sid = string2;
        this.portno = n;
        if (string3 != null) {
            if (string3.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (string3.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else if (string3.equalsIgnoreCase("oci")) {
                this.jdbc_driver = "oci";
            } else {
                AQjmsError.throwEx(135, string3);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "hostname: " + string + "  oracle_sid: " + string2 + "  port_no: " + n + "  driver: " + string3);
    }

    AQjmsQueueConnectionFactory(String string, Properties properties) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = string;
        this.jdbc_info = properties;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory - constructor", "jdbc connect string: " + string);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 10) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 10);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection", "Connection created successfully");
        return aQjmsConnection;
    }

    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        Properties properties = null;
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection", "Username: " + string);
        if (this.jdbc_conn_str != null) {
            if (this.jdbc_info != null) {
                if (string != null || string2 != null) {
                    properties = (Properties)((Hashtable)this.jdbc_info).clone();
                    ((Hashtable)properties).put("user", string);
                    ((Hashtable)properties).put("password", string2);
                } else {
                    properties = this.jdbc_info;
                }
                aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, properties, 10);
            } else {
                aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, string, string2, 10);
            }
        } else {
            aQjmsConnection = new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, string, string2, this.jdbc_driver, 10);
        }
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/username/password", "Connection created successfully");
        return aQjmsConnection;
    }

    public static QueueConnection createQueueConnection(Connection connection) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(connection, 10);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/jdbc_conn", "Connection created successfully");
        return aQjmsConnection;
    }

    public static QueueConnection createQueueConnection(OracleOCIConnectionPool oracleOCIConnectionPool) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(oracleOCIConnectionPool, 10);
        AQjmsOracleDebug.trace(5, "AQjmsQueueConnectionFactory.createQueueConnection w/OCI_conn_pool", "Connection created successfully");
        return aQjmsConnection;
    }

    public Reference getReference() {
        Reference reference = new Reference("oracle.jms.AQjmsQueueConnectionFactory", "oracle.jms.AQjmsConnectionFactory", null);
        return reference;
    }
}

