/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;

public class AQjmsSubscriberFactory
implements ObjectFactory {
    private String ag_name = null;
    private String address = null;
    private int protocol = 0;
    private String certificate = null;
    private String rule = null;
    private String transformation = null;
    private String sub_owner = null;
    static final String ALIAS_TYPE = "alias";
    static final String AGENT_TYPE = "agent";
    static final String AQSUB_TYPE = "aq_subscriber";
    static final String JMSUB_TYPE = "jms_subscriber";
    static final String RULE_ATTR = "rule";
    static final String TRANS_ATTR = "transformation";

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws JMSException {
        Reference reference = (Reference)object;
        AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "entry");
        if (reference == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        if (!reference.getClassName().equals("oracle.jms.AQjmsConsumer") && !reference.getClassName().equals("oracle.jms.AQjmsAgent")) {
            AQjmsOracleDebug.trace(3, "AQjmsConnectionFactory.getObjectInstance", "unable to manufacture object of class: " + reference.getClassName());
            return null;
        }
        try {
            Object object2;
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            NamingEnumeration<SearchResult> namingEnumeration = ((DirContext)context).search(name, "(objectclass=*)", searchControls);
            if (namingEnumeration == null) {
                AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "failed to search attributes of subscriber " + name.get(0));
                return null;
            }
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            String string = (String)attributes.get("orclDBAQObjType").get();
            while (string.toLowerCase().equals(ALIAS_TYPE)) {
                InitialDirContext initialDirContext = new InitialDirContext(hashtable);
                object2 = (String)attributes.get("orclDBAQPointerAttr").get();
                namingEnumeration = initialDirContext.search((String)object2, "(objectclass=*)", searchControls);
                if (namingEnumeration == null) {
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "failed to search attributes of object " + (String)object2);
                    return null;
                }
                searchResult = namingEnumeration.next();
                attributes = searchResult.getAttributes();
                string = (String)attributes.get("orclDBAQObjType").get();
            }
            if (string.toLowerCase().equals(AGENT_TYPE) || string.toLowerCase().equals(AQSUB_TYPE) || string.toLowerCase().equals(JMSUB_TYPE)) {
                int n;
                object2 = (String)attributes.get("cn").get();
                int n2 = string.toLowerCase().equals(JMSUB_TYPE) ? ((String)object2).indexOf(46) : 0;
                int n3 = ((String)object2).indexOf(58);
                int n4 = n = n3 == -1 ? -1 : ((String)object2).indexOf(58, n3 + 1);
                if (n == -1 || n2 == -1) {
                    AQjmsOracleDebug.trace(3, "AQjmsSubscriberFactory.getObjectInstance", "attribute cn is of bad format " + (String)object2);
                    return null;
                }
                if (n3 > 0) {
                    this.ag_name = ((String)object2).substring(n2, n3 - 1);
                }
                if (n - n3 > 1) {
                    this.address = ((String)object2).substring(n3 + 1, n - 1);
                }
                if (n < ((String)object2).length() - 1) {
                    String string2 = ((String)object2).substring(n + 1, ((String)object2).length() - 1);
                    this.protocol = Integer.valueOf(string2);
                }
            }
            if (string.toLowerCase().equals(AGENT_TYPE)) {
                this.certificate = (String)attributes.get("orclDBAQPointerAttr").get();
                object2 = new AQjmsAgent(this.ag_name, this.address, this.protocol);
                AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "exit");
                return object2;
            }
            if (string.toLowerCase().equals(AQSUB_TYPE)) {
                object2 = attributes.get("orclDBAQGeneric");
                int n = 0;
                while (n < object2.size()) {
                    String string3 = (String)object2.get(n);
                    if (string3.toLowerCase().startsWith(RULE_ATTR)) {
                        this.rule = string3.substring(RULE_ATTR.length() + 1);
                    } else if (string3.toLowerCase().startsWith(TRANS_ATTR)) {
                        this.transformation = string3.substring(TRANS_ATTR.length() + 1);
                    }
                    ++n;
                }
                AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "exit");
                return null;
            }
        }
        catch (NamingException namingException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSubscriberFactory.getObjectInstance", namingException);
            AQjmsError.throwEx(205, namingException);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSubscriberFactory.getObjectInstance", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSubscriberFactory.getObjectInstance", "exit");
        return null;
    }
}

