/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsTextMessage_C;
import oracle.sql.CLOB;
import oracle.sql.ORADataFactory;

public class AQjmsTextMessage
extends AQjmsMessage
implements TextMessage {
    String text_data = null;
    AQjmsTextMessage_C text_msg_cont;

    public AQjmsTextMessage() throws JMSException {
        super(true);
        try {
            this.text_msg_cont = new AQjmsTextMessage_C();
            this.text_msg_cont.setHeader(this.header_ext);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public AQjmsTextMessage(AQjmsSession aQjmsSession) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.text_msg_cont = new AQjmsTextMessage_C();
            this.text_msg_cont.setHeader(this.header_ext);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsTextMessage(AQjmsSession aQjmsSession, AQjmsTextMessage_C aQjmsTextMessage_C, OracleConnection oracleConnection) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.text_msg_cont = aQjmsTextMessage_C;
            this.header_ext = aQjmsTextMessage_C.getHeader();
            this.readTextMessageContainer();
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        try {
            if (this.text_msg_cont != null) {
                this.text_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public void setText(String string) throws JMSException {
        if (this.isHeaderOnly()) {
            return;
        }
        Object var2_2 = null;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            this.text_data = string;
        }
    }

    public String getText() throws JMSException {
        if (this.isHeaderOnly()) {
            return null;
        }
        return this.text_data;
    }

    public void clearBody() throws JMSException {
        if (this.isHeaderOnly()) {
            return;
        }
        this.text_data = null;
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    AQjmsTextMessage_C getMessageCont() {
        return this.text_msg_cont;
    }

    void populateTextMessageContainer(OracleConnection oracleConnection) throws JMSException {
        Object var2_2 = null;
        int n = 0;
        String string = null;
        boolean bl = false;
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.populateTextMessageContainer", "entry");
        try {
            this.text_msg_cont.setHeader(this.header_ext);
            this.text_msg_cont.setHeader(this.header_ext);
            string = this.text_data;
            if (string != null) {
                n = string.length();
            }
            AQjmsOracleDebug.trace(5, "AQjmsTextMessage.populateTextMessageContainer", "text_len: " + n);
            if (n > 4000) {
                this.text_msg_cont.setTextLen(new Integer(n));
                this.text_msg_cont.setTextVc(null);
            } else {
                this.text_msg_cont.setTextLen(new Integer(n));
                this.text_msg_cont.setTextVc(string);
                this.text_msg_cont.setTextLob(null);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.populateTextMessageContainer", "exit");
    }

    void write_lob(Connection connection, String string, byte[] byArray, boolean bl, boolean bl2) throws JMSException {
        CLOB cLOB = null;
        int n = 0;
        String string2 = null;
        long l = 0L;
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Object var20_15 = null;
        try {
            string2 = this.text_data;
            if (string2 != null) {
                n = string2.length();
            }
            AQjmsOracleDebug.trace(5, "AQjmsTextMessage.write_clob", "text_len: " + n);
            if (string == null) {
                AQjmsOracleDebug.trace(1, "AQjmsTextMessage.write_lob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            if (n > 4000) {
                ORADataFactory oRADataFactory = bl ? AQjmsGenMessage_C.getFactory() : AQjmsTextMessage_C.getFactory();
                AQjmsOracleDebug.trace(4, "AQjmsTextMessage.write_lob", "msg_id: " + RepConversion.bArray2String((byte[])byArray));
                AQjmsOracleDebug.trace(5, "AQjmsTextMessage.write_lob", "is_anydata_dest: " + bl2);
                statement = bl2 ? (OracleCallableStatement)connection.prepareCall("SELECT dbms_aqin.aq$_getclob_from_jmsanydata(user_data) FROM " + string + " where msgid = ?") : (OracleCallableStatement)connection.prepareCall("SELECT user_data FROM " + string + " where msgid = ?");
                statement.setBytes(1, byArray);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    AQjmsOracleDebug.trace(4, "AQjmsTextMessage.write_lob", "found the msg");
                    if (bl2) {
                        cLOB = ((OracleResultSet)resultSet).getCLOB(1);
                    } else if (bl) {
                        AQjmsGenMessage_C aQjmsGenMessage_C = (AQjmsGenMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        cLOB = aQjmsGenMessage_C.getTextLob();
                    } else {
                        AQjmsTextMessage_C aQjmsTextMessage_C = (AQjmsTextMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        cLOB = aQjmsTextMessage_C.getTextLob();
                    }
                }
                if (cLOB == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsTextMessage.write_lob", "Internal error - text_lob is null");
                    AQjmsError.throwEx(122, "text_lob is null");
                }
                l = cLOB.putString(1L, string2);
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsTextMessage.write_lob", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.write_lob", "exit");
    }

    void readTextMessageContainer() throws JMSException {
        CLOB cLOB = null;
        int n = 0;
        String string = null;
        boolean bl = false;
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.readTextMessageContainer", "entry");
        try {
            n = this.text_msg_cont.getTextLen();
            AQjmsOracleDebug.trace(5, "AQjmsTextMessage.readTextMessageContainer", "text_len: " + n);
            if (n > 4000) {
                cLOB = this.text_msg_cont.getTextLob();
                if (cLOB != null) {
                    string = cLOB.getSubString(1L, n);
                }
                this.text_data = string;
            } else {
                this.text_data = string = this.text_msg_cont.getTextVc();
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsTextMessage.readTextMessageContainer", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsTextMessage.readTextMessageContainer", "exit");
    }
}

