/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsSession;
import oracle.jms.TopicBrowser;
import oracle.jms.TopicReceiver;

public class AQjmsTopicBrowser
implements TopicBrowser,
Enumeration {
    TopicReceiver receiver = null;
    byte[] next_msg_id = null;
    int dequeue_mode = 0;
    int browse_counter = 0;
    boolean sel_msgid_flag = false;
    AQjmsSession jms_sess = null;
    AQjmsSelector b_selector = null;
    AQjmsDestination jms_dest = null;
    AQjmsMessage msg = null;
    AQjmsMessage new_msg = null;
    Hashtable msgid_seen = null;

    AQjmsTopicBrowser(Session session, Destination destination, int n, int n2, String string, AQjmsSelector aQjmsSelector, Object object) throws JMSException {
        this.jms_sess = (AQjmsSession)session;
        this.dequeue_mode = n2;
        this.jms_dest = (AQjmsDestination)destination;
        this.b_selector = aQjmsSelector;
        this.msgid_seen = new Hashtable();
        this.receiver = new AQjmsConsumer(this.jms_sess, destination, n, n2, string, object, aQjmsSelector, null);
    }

    public void close() {
        try {
            AQjmsOracleDebug.trace(5, "AQjmsTopicBrowser.close", "closing receiver");
            this.receiver.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AQjmsOracleDebug.trace(5, "AQjmsTopicBrowser.close", "closing the browser");
            this.jms_sess.closeTopicBrowser(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Topic getTopic() throws JMSException {
        if (this.jms_dest != null) {
            return this.jms_dest;
        }
        AQjmsError.throwEx(166);
        return null;
    }

    public Enumeration getEnumeration() {
        return this;
    }

    public String getMessageSelector() throws JMSException {
        return this.receiver.getMessageSelector();
    }

    public Object nextElement() throws NoSuchElementException {
        AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.nextElement", "entry");
        try {
            if (this.msg != null) {
                this.new_msg = this.msg;
                this.msg = null;
            } else {
                if (this.sel_msgid_flag) {
                    AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.nextElement", "no such element exception - deq by msgid");
                    throw new NoSuchElementException();
                }
                this.new_msg = (AQjmsMessage)this.receiver.receiveNoWait();
                if (this.new_msg == null) {
                    AQjmsOracleDebug.trace(3, "AQjmsTopicBrowser.nextElement", "no such element exception");
                    throw new NoSuchElementException();
                }
            }
            AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.nextElement", "exit");
            if (this.b_selector != null && this.b_selector.getSelectorType() == 30) {
                this.sel_msgid_flag = true;
            }
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsTopicBrowser.nextElement", (Exception)((Object)jMSException));
            throw new NoSuchElementException();
        }
        try {
            String string = this.new_msg.getJMSMessageID();
            this.msgid_seen.put(string, string);
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsTopicBrowser.nextElement", (Exception)((Object)jMSException));
        }
        return this.new_msg;
    }

    public boolean hasMoreElements() {
        if (this.sel_msgid_flag) {
            AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.hasMoreElements", "null message returned from receive-deq by msgid");
            return false;
        }
        if (this.msg != null) {
            AQjmsOracleDebug.trace(5, "AQjmsTopicBrowser.hasMoreElements", "message already exists");
            return true;
        }
        try {
            this.msg = (AQjmsMessage)this.receiver.receiveNoWait();
            if (this.msg == null) {
                AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.hasMoreElements", "null message returned from receive");
                return false;
            }
        }
        catch (JMSException jMSException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsTopicBrowser.hasMoreElements - no message", (Exception)((Object)jMSException));
            return false;
        }
        AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.hasMoreElements", "received message");
        if (this.b_selector != null && this.b_selector.getSelectorType() == 30) {
            this.sel_msgid_flag = true;
        }
        return true;
    }

    public void purgeSeen() throws JMSException {
        String string = null;
        int n = 0;
        AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.purgeSeen", "entry");
        if (this.dequeue_mode != 2) {
            AQjmsOracleDebug.trace(3, "AQjmsTopicBrowser.purgeSeen", "invalid dequeue mode, not LOCKED");
            AQjmsError.throwEx(124);
        }
        n = (string = this.jms_dest.getAdtType()).equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE") ? 1 : (string.equalsIgnoreCase("SYS.ANYDATA") ? 3 : 2);
        ((AQjmsConsumer)this.receiver).purgeSeen(this.msgid_seen, n);
        this.msgid_seen.clear();
        AQjmsOracleDebug.trace(4, "AQjmsTopicBrowser.purgeSeen", "purged");
    }

    public void setTransformation(String string) {
        ((AQjmsConsumer)this.receiver).setTransformation(string);
    }

    public String getTransformation() {
        return ((AQjmsConsumer)this.receiver).getTransformation();
    }
}

