/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Reference;
import javax.naming.Referenceable;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsError;

public class AQjmsTopicConnectionFactory
implements TopicConnectionFactory,
Referenceable,
Serializable {
    String hostname;
    String oracle_sid;
    int portno;
    String jdbc_driver;
    String jdbc_conn_str;
    Properties jdbc_info;

    AQjmsTopicConnectionFactory(String string, String string2, int n, String string3) throws JMSException {
        this.hostname = string;
        this.oracle_sid = string2;
        this.portno = n;
        if (string3 != null) {
            if (string3.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (string3.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else if (string3.equalsIgnoreCase("oci")) {
                this.jdbc_driver = "oci";
            } else {
                AQjmsError.throwEx(135, string3);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
    }

    AQjmsTopicConnectionFactory(String string, Properties properties) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = string;
        this.jdbc_info = properties;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 20) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 20);
        return aQjmsConnection;
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        Properties properties = null;
        if (this.jdbc_conn_str != null) {
            if (this.jdbc_info != null) {
                if (string != null || string2 != null) {
                    properties = (Properties)((Hashtable)this.jdbc_info).clone();
                    ((Hashtable)properties).put("user", string);
                    ((Hashtable)properties).put("password", string2);
                } else {
                    properties = this.jdbc_info;
                }
                aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, properties, 20);
            } else {
                aQjmsConnection = new AQjmsConnection(this.jdbc_conn_str, string, string2, 20);
            }
        } else {
            aQjmsConnection = new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, string, string2, this.jdbc_driver, 20);
        }
        return aQjmsConnection;
    }

    public static TopicConnection createTopicConnection(Connection connection) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(connection, 20);
        return aQjmsConnection;
    }

    public static TopicConnection createTopicConnection(OracleOCIConnectionPool oracleOCIConnectionPool) throws JMSException {
        AQjmsConnection aQjmsConnection = null;
        aQjmsConnection = new AQjmsConnection(oracleOCIConnectionPool, 20);
        return aQjmsConnection;
    }

    public Reference getReference() {
        Reference reference = new Reference("oracle.jms.AQjmsTopicConnectionFactory", "oracle.jms.AQjmsConnectionFactory", null);
        return reference;
    }
}

