/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import oracle.xdb.dom.XDBAttribute;
import oracle.xdb.dom.XDBDOMException;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XDBNamedNodeMap
implements NamedNodeMap {
    private XDBDocument m_owner;
    private long m_mapcstate;

    XDBNamedNodeMap(XDBDocument xDBDocument, long l) {
        this.m_owner = xDBDocument;
        this.m_mapcstate = l;
    }

    private native long getAttributeNodeNative(long var1, long var3, String var5, String var6);

    public int getLength() {
        return (int)this.getNumAttrsNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate);
    }

    public Node getNamedItem(String string) {
        long l = this.getAttributeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, null, string);
        if (l != 0L) {
            return new XDBAttribute(this.m_owner, l);
        }
        return null;
    }

    public Node getNamedItemNS(String string, String string2) {
        long l = this.getAttributeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, string, string2);
        if (l != 0L) {
            return new XDBAttribute(this.m_owner, l);
        }
        return null;
    }

    private native long getNodeItemAtNative(long var1, long var3, long var5);

    private native long getNumAttrsNative(long var1, long var3);

    public Node item(int n) {
        long l = this.getNodeItemAtNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, n);
        if (l != 0L) {
            return new XDBAttribute(this.m_owner, l);
        }
        return null;
    }

    private native long removeAttributeNodeNative(long var1, long var3, String var5, String var6);

    public Node removeNamedItem(String string) {
        long l = this.removeAttributeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, null, string);
        if (l != 0L) {
            return new XDBAttribute(this.m_owner, l);
        }
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) {
        long l = this.removeAttributeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, string, string2);
        if (l != 0L) {
            return new XDBAttribute(this.m_owner, l);
        }
        return null;
    }

    private native long setAttributeNodeNative(long var1, long var3, long var5);

    public Node setNamedItem(Node node) {
        if (node.getNodeType() != 2) {
            throw new XDBDOMException(3, "Only attribute nodes can be inserted here");
        }
        long l = this.setAttributeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, ((XDBNode)node).toCState());
        if (l == 0L) {
            return null;
        }
        return new XDBAttribute(this.m_owner, l);
    }

    public Node setNamedItemNS(Node node) {
        if (node.getNodeType() != 2) {
            throw new XDBDOMException(3, "Only attribute nodes can be inserted here");
        }
        long l = this.setAttributeNodeNative(XDBDocument.getGP(this.m_owner.m_conn), this.m_mapcstate, ((XDBNode)node).toCState());
        if (l == 0L) {
            return null;
        }
        return new XDBAttribute(this.m_owner, l);
    }
}

