/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.comp;

import java.util.Hashtable;

public class CXMLCodeSpace {
    Hashtable tokenTable;
    String[] tokenArray;
    public static int DEFAULT_SMALL = 32;
    int stackSize = DEFAULT_SMALL;
    int curToken = 0;

    public CXMLCodeSpace() {
        this.tokenTable = new Hashtable(DEFAULT_SMALL);
        this.tokenArray = new String[DEFAULT_SMALL];
    }

    public boolean addToken(String string) {
        String string2 = (String)this.tokenTable.get(string);
        if (string2 != null) {
            return false;
        }
        this.tokenTable.put(string, string);
        if (this.curToken < this.stackSize - 1) {
            this.tokenArray[this.curToken] = string;
        } else {
            String[] stringArray = this.tokenArray;
            this.tokenArray = new String[this.stackSize * 2];
            System.arraycopy(stringArray, 0, this.tokenArray, 0, this.stackSize);
            this.stackSize *= 2;
            this.tokenArray[this.curToken] = string;
        }
        this.setCurToken();
        return true;
    }

    public static int extractTokenValueFromThreeByteToken(byte by, byte by2, byte by3) {
        int n = 0;
        byte by4 = (byte)(by >> 2 & 7);
        n = by4 << 16 | by2 << 8 & 0xFF | by3 & 0xFF;
        return n;
    }

    public static int extractTokenValueFromTwoByteToken(byte by, byte by2) {
        int n = 0;
        byte by3 = (byte)(by >> 2 & 0xF);
        n = by3 << 8 | 0xFF & by2;
        return n;
    }

    public String getElementFromToken(int n) {
        try {
            return this.tokenArray[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " < 0");
        }
    }

    public byte getToken(String string, int n) {
        return this.getToken(string, n, false, false);
    }

    public byte getToken(String string, int n, boolean bl, boolean bl2) {
        byte by = 0;
        int n2 = this.getTokenArrayIndexOf(string);
        if (n == 0) {
            if (!bl && !bl2 && n2 < 128) {
                return (byte)n2;
            }
            if (bl) {
                by = (byte)(by | 2);
                by = (byte)(by | 0x80);
            }
            if (bl2) {
                by = (byte)(by | 1);
                by = (byte)(by | 0x80);
            }
            if (n2 < 128) {
                return by;
            }
            if (n2 >= 128 && n2 < 4096) {
                by = (byte)(by | 0x80);
                byte by2 = (byte)(n2 >> 8);
                by2 = (byte)(by2 << 2);
                by = (byte)(by2 | by);
                return by;
            }
            if (n2 >= 4096) {
                by = (byte)(by | 0xC0);
                byte by3 = (byte)(n2 >> 16);
                by3 = (byte)(by3 << 2);
                by = (byte)(by3 | by);
                return by;
            }
        } else if (n == 1) {
            if (n2 < 128) {
                return (byte)n2;
            }
            if (n2 >= 128 && n2 < 4096) {
                return (byte)(0xFF & n2);
            }
            if (n2 >= 4096) {
                return (byte)(0xFF & n2 >> 8);
            }
        } else {
            if (n == 2) {
                return (byte)(0xFF & n2);
            }
            System.out.println("Token is too large: Not supported yet!");
        }
        return 0;
    }

    private int getTokenArrayIndexOf(String string) {
        int n = 0;
        while (n < this.curToken) {
            if (string.equals(this.tokenArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public byte getTokenLength(String string) {
        return this.getTokenLength(string, false, false);
    }

    public byte getTokenLength(String string, boolean bl, boolean bl2) {
        int n = this.getTokenArrayIndexOf(string);
        if (!bl && !bl2 && n < 128) {
            return 1;
        }
        if ((bl || bl2) && n < 128) {
            return 2;
        }
        if (n >= 128 && n < 4096) {
            return 2;
        }
        if (n >= 4096 && n < 524288) {
            return 3;
        }
        if (n > 524288) {
            System.out.println("Error: Too many tokens! Not supported!");
            System.exit(1);
        }
        return 0;
    }

    public static boolean isNamespacePresent(byte by) {
        return (by & 2) == 2;
    }

    public static boolean isPrefixPresent(byte by) {
        return (by & 1) == 1;
    }

    void setCurToken() {
        ++this.curToken;
    }
}

