/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.UTFDataFormatException;
import oracle.xml.util.ArrayPool;

public class XMLObjectInput {
    ObjectInput ois;
    byte[] buf;
    int pos;
    int end;

    public XMLObjectInput(ObjectInput objectInput) {
        this.ois = objectInput;
        this.buf = ArrayPool.allocByteArrDefault();
        this.pos = 0;
        this.end = 0;
    }

    public XMLObjectInput(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.end = n + n2;
    }

    public int available() throws IOException {
        if (this.pos < this.end) {
            return this.end - this.pos;
        }
        return this.ois.available();
    }

    public void close() throws IOException {
        if (this.ois != null) {
            this.ois.close();
        }
    }

    private void ensureCapacity(int n) throws IOException {
        int n2;
        int n3;
        if (this.ois == null || this.pos + n <= this.end) {
            return;
        }
        if (this.pos < this.end) {
            n3 = this.pos;
            n2 = 0;
            while (n3 < this.end) {
                this.buf[n2] = this.buf[n3];
                ++n3;
                ++n2;
            }
        }
        this.end -= this.pos;
        this.pos = 0;
        n3 = this.buf.length - this.end;
        while (n3 != 0) {
            n2 = this.ois.read(this.buf, this.end, n3);
            if (n2 == -1) break;
            this.end += n2;
            n3 -= n2;
        }
    }

    public int getPosition() {
        return this.pos;
    }

    public byte peekByte() throws IOException {
        this.ensureCapacity(1);
        return this.buf[this.pos];
    }

    public int read() throws IOException {
        this.ensureCapacity(1);
        return this.buf[this.pos++] & 0xFF;
    }

    public boolean readBoolean() throws IOException {
        this.ensureCapacity(1);
        int n = this.buf[this.pos++] & 0xFF;
        return n != 0;
    }

    public byte readByte() throws IOException {
        this.ensureCapacity(1);
        return this.buf[this.pos++];
    }

    public char readChar() throws IOException {
        this.ensureCapacity(2);
        int n = this.buf[this.pos++] & 0xFF;
        int n2 = this.buf[this.pos++] & 0xFF;
        return (char)((n << 8) + n2);
    }

    public int readInt() throws IOException {
        this.ensureCapacity(4);
        int n = this.buf[this.pos++] & 0xFF;
        int n2 = this.buf[this.pos++] & 0xFF;
        int n3 = this.buf[this.pos++] & 0xFF;
        int n4 = this.buf[this.pos++] & 0xFF;
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public int readShort() throws IOException {
        this.ensureCapacity(2);
        int n = this.buf[this.pos++] & 0xFF;
        int n2 = this.buf[this.pos++] & 0xFF;
        return (n << 8) + n2;
    }

    public String readUTF() throws IOException {
        int n = this.readShort();
        this.ensureCapacity(n);
        char[] cArray = new char[n];
        int n2 = this.pos + n;
        int n3 = 0;
        while (this.pos < n2) {
            int n4 = this.buf[this.pos] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++this.pos;
                    cArray[n3++] = (char)n4;
                    break;
                }
                case 12: 
                case 13: {
                    this.pos += 2;
                    if (this.pos > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = this.buf[this.pos - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0x1F) << 6 | by & 0x3F);
                    break;
                }
                case 14: {
                    this.pos += 3;
                    if (this.pos > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = this.buf[this.pos - 2];
                    byte by2 = this.buf[this.pos - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n3++] = (char)((n4 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(cArray, 0, n3);
    }

    public void setPosition(int n) {
        this.pos = n;
    }

    public int skip(int n) throws IOException {
        this.ensureCapacity(n);
        this.pos += n;
        return n;
    }

    public void skipBoolean() throws IOException {
        this.skip(1);
    }

    public void skipByte() throws IOException {
        this.skip(1);
    }

    public void skipChar() throws IOException {
        this.skip(2);
    }

    public void skipInt() throws IOException {
        this.skip(4);
    }

    public void skipUTF() throws IOException {
        this.ensureCapacity(2);
        int n = this.buf[this.pos++] & 0xFF;
        int n2 = this.buf[this.pos++] & 0xFF;
        int n3 = (n << 8) + n2;
        this.ensureCapacity(n3);
        this.pos += n3;
    }
}

