/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.jaxp.JXEntityResolver;
import oracle.xml.jaxp.JXSAXData;
import oracle.xml.jaxp.JXTransformer;
import oracle.xml.jaxp.JXTransformerHandler;
import oracle.xml.jaxp.JXXMLFilter;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLBuilder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class JXSAXTransformerFactory
extends SAXTransformerFactory
implements XMLConstants {
    URIResolver m_uriResolver;
    ErrorListener m_errorListener;
    XMLError m_err = new XMLError();

    private Source getAssociatedStylesheet(Source source) throws TransformerConfigurationException {
        String string = source.getSystemId();
        String string2 = null;
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            string2 = this.getAssociatedStylesheet(node, string);
        } else if (source instanceof SAXSource) {
            InputSource inputSource = ((SAXSource)source).getInputSource();
            string2 = this.getAssociatedStylesheet(inputSource, string);
        } else if (source instanceof StreamSource) {
            string2 = this.getAssociatedStylesheet((StreamSource)source, string);
        }
        if (string2 == null) {
            this.reportConfigException(null, 0, 1121, null);
        }
        return new StreamSource(string2);
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        return this.getAssociatedStylesheet(source);
    }

    private String getAssociatedStylesheet(StreamSource streamSource, String string) throws TransformerConfigurationException {
        InputSource inputSource = this.streamSource2InputSource(streamSource);
        return this.getAssociatedStylesheet(inputSource, string);
    }

    private String getAssociatedStylesheet(Node node, String string) throws TransformerConfigurationException {
        Node node2;
        if (!(node instanceof XMLDocument)) {
            return null;
        }
        XMLDocument xMLDocument = (XMLDocument)node;
        NodeList nodeList = xMLDocument.getChildrenByTagName("xml-stylesheet");
        int n = nodeList.getLength();
        String string2 = null;
        if (n > 0 && (node2 = nodeList.item(0)).getNodeType() == 7) {
            String string3 = node2.getNodeValue();
            string2 = JXSAXData.searchLinkedXSL(string3);
            string2 = this.resolvedHref(string2, string);
        }
        return string2;
    }

    private String getAssociatedStylesheet(InputSource inputSource, String string) throws TransformerConfigurationException {
        if (inputSource == null) {
            return null;
        }
        JXSAXData jXSAXData = new JXSAXData();
        SAXParser sAXParser = new SAXParser();
        sAXParser.setDocumentHandler(jXSAXData);
        sAXParser.setEntityResolver(jXSAXData);
        sAXParser.setDTDHandler(jXSAXData);
        sAXParser.setErrorHandler(jXSAXData);
        try {
            sAXParser.parse(inputSource);
        }
        catch (Exception exception) {
            this.reportConfigException(exception, 1000, 0, null);
        }
        String string2 = jXSAXData.getXMLStylesheetHref();
        if (string2 == null || string2.trim().length() == 0) {
            this.reportConfigException(null, 0, 1121, null);
            return null;
        }
        string2 = this.resolvedHref(string2, string);
        return string2;
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public boolean getFeature(String string) {
        if (string.equals(DOMResult.FEATURE)) {
            return true;
        }
        if (string.equals(DOMSource.FEATURE)) {
            return true;
        }
        if (string.equals(SAXSource.FEATURE)) {
            return true;
        }
        if (string.equals(SAXResult.FEATURE)) {
            return true;
        }
        if (string.equals(SAXTransformerFactory.FEATURE)) {
            return true;
        }
        return string.equals(SAXTransformerFactory.FEATURE_XMLFILTER);
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        Object object;
        XSLBuilder xSLBuilder = new XSLBuilder();
        if (this.m_uriResolver != null) {
            object = new JXEntityResolver(this.m_uriResolver, source);
            xSLBuilder.setEntityResolver((EntityResolver)object);
        }
        if ((object = source.getSystemId()) != null) {
            try {
                xSLBuilder.setBaseURL(new URL((String)object));
            }
            catch (MalformedURLException malformedURLException) {
                this.reportConfigException(malformedURLException, 1, 1108, null);
            }
        }
        if (!(source instanceof DOMSource)) {
            XMLReader xMLReader = null;
            InputSource inputSource = SAXSource.sourceToInputSource(source);
            if (source instanceof SAXSource) {
                xMLReader = ((SAXSource)source).getXMLReader();
            }
            if (xMLReader == null) {
                xMLReader = new SAXParser();
            }
            try {
                ((SAXParser)xMLReader).setPreserveWhitespace(true);
                xMLReader.setContentHandler(xSLBuilder);
                xMLReader.parse(inputSource);
            }
            catch (Exception exception) {
                DOMLocator dOMLocator = new DOMLocator(xSLBuilder.getLocator());
                this.reportConfigException(exception, 0, 1000, dOMLocator);
            }
        } else {
            Node node = ((DOMSource)source).getNode();
            if (!(node instanceof XMLNode)) {
                this.reportConfigException(null, 0, 1101, null);
            }
            XMLNode xMLNode = (XMLNode)node;
            try {
                if (!(xMLNode instanceof XMLDocument)) {
                    xSLBuilder.startDocument();
                }
                xMLNode.reportSAXEvents(xSLBuilder);
                if (!(xMLNode instanceof XMLDocument)) {
                    xSLBuilder.endDocument();
                }
            }
            catch (SAXException sAXException) {
                DOMLocator dOMLocator = new DOMLocator(xSLBuilder.getLocator());
                this.reportConfigException(sAXException, 1900, 0, dOMLocator);
            }
        }
        return xSLBuilder.getTemplates();
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new XSLBuilder();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new JXTransformer();
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return templates.newTransformer();
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return new JXTransformerHandler();
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        TransformerHandler transformerHandler = this.newTransformerHandler(templates);
        String string = source.getSystemId();
        if (string != null) {
            transformerHandler.setSystemId(string);
        }
        return transformerHandler;
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        JXTransformerHandler jXTransformerHandler = new JXTransformerHandler(transformer);
        return jXTransformerHandler;
    }

    public XMLFilter newXMLFilter(Source source) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(source);
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        JXXMLFilter jXXMLFilter = new JXXMLFilter();
        jXXMLFilter.setTemplates(templates);
        return jXXMLFilter;
    }

    private void reportConfigException(Exception exception, int n, int n2, SourceLocator sourceLocator) throws TransformerConfigurationException {
        String string = null;
        this.m_err.reset();
        if (exception == null) {
            this.m_err.error0(n2, n);
        } else if (exception.getMessage() == null) {
            this.m_err.error1(n2, n, "null");
        } else {
            this.m_err.error1(n2, n, exception.getMessage());
        }
        string = this.m_err.formatErrorMesg(0);
        TransformerConfigurationException transformerConfigurationException = sourceLocator != null ? (exception != null ? new TransformerConfigurationException(string, sourceLocator, exception) : new TransformerConfigurationException(string, sourceLocator)) : (exception != null ? new TransformerConfigurationException(string, exception) : new TransformerConfigurationException(string));
        if (this.m_errorListener == null) {
            try {
                this.m_err.setErrorStream(System.err);
                this.m_err.printErrorListener();
                if (n == 0) {
                    throw transformerConfigurationException;
                }
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException(iOException);
            }
            return;
        }
        try {
            switch (n) {
                case 0: {
                    this.m_errorListener.fatalError(transformerConfigurationException);
                    throw transformerConfigurationException;
                }
                case 1: {
                    this.m_errorListener.error(transformerConfigurationException);
                    break;
                }
                case 2: {
                    this.m_errorListener.warning(transformerConfigurationException);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }

    private String resolve(String string, String string2) throws TransformerConfigurationException {
        String string3 = null;
        try {
            URL uRL = new URL(string2);
            URL uRL2 = new URL(uRL, string);
            string3 = uRL2.toString();
        }
        catch (MalformedURLException malformedURLException) {
            this.reportConfigException(malformedURLException, 0, 1117, null);
        }
        return string3;
    }

    private String resolvedHref(String string, String string2) throws TransformerConfigurationException {
        String string3 = null;
        Source source = null;
        if (this.m_uriResolver != null) {
            try {
                source = this.m_uriResolver.resolve(string, string2);
                string3 = source.getSystemId();
            }
            catch (TransformerException transformerException) {
                throw new TransformerConfigurationException(transformerException);
            }
            return string3;
        }
        if (string2 == null) {
            return string;
        }
        return this.resolve(string, string2);
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.m_errorListener = errorListener;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    private InputSource streamSource2InputSource(StreamSource streamSource) throws TransformerConfigurationException {
        InputStream inputStream = streamSource.getInputStream();
        if (inputStream != null) {
            return new InputSource(inputStream);
        }
        Reader reader = streamSource.getReader();
        if (reader != null) {
            return new InputSource(reader);
        }
        String string = streamSource.getSystemId();
        if (string != null) {
            return new InputSource(string);
        }
        this.reportConfigException(null, 0, 1106, null);
        return null;
    }
}

