/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import oracle.xml.jaxp.JXTransformerHandler;
import oracle.xml.jaxp.JXUtil;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XSLDocumentBuilder;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLOutput;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLSAXPrintDriver;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.util.XMLError;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class JXTransformer
extends Transformer
implements XMLConstants {
    URIResolver m_uriResolver;
    ErrorListener m_errorListener;
    XSLStylesheet m_templates;
    XSLOutput m_output;
    Properties m_transXSLT;
    Properties m_transDefault;
    Properties m_transProps;
    XMLError m_err = new XMLError();
    XSLProcessor m_processor = new XSLProcessor();

    public JXTransformer() {
        try {
            this.m_output = new XSLOutput();
            XSLOutput xSLOutput = new XSLOutput();
            this.m_transXSLT = xSLOutput.getDefaultProps();
            this.m_transDefault = xSLOutput.getProps();
            this.m_transProps = new Properties(this.m_transDefault);
        }
        catch (XSLException xSLException) {
            try {
                this.reportException(xSLException, 0, 1900, null);
            }
            catch (TransformerException transformerException) {}
        }
    }

    public JXTransformer(XSLStylesheet xSLStylesheet) {
        try {
            this.m_output = new XSLOutput();
            this.m_templates = xSLStylesheet;
            this.m_transXSLT = xSLStylesheet.getXSLOutput().getDefaultProps();
            this.m_transDefault = xSLStylesheet.getOutputProperties();
            this.m_transProps = new Properties(this.m_transDefault);
        }
        catch (XSLException xSLException) {
            try {
                this.reportException(xSLException, 0, 1900, null);
            }
            catch (TransformerException transformerException) {}
        }
    }

    public void clearParameters() {
        try {
            this.m_processor.resetParams();
        }
        catch (XSLException xSLException) {
            try {
                this.reportException(xSLException, 0, 1900, null);
            }
            catch (TransformerException transformerException) {}
        }
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public Properties getOutputProperties() {
        return (Properties)((Hashtable)this.m_transProps).clone();
    }

    public String getOutputProperty(String string) throws IllegalArgumentException {
        return this.m_transProps.getProperty(string);
    }

    public Object getParameter(String string) {
        Object object = null;
        String string2 = JXUtil.getURI(string);
        String string3 = JXUtil.getLocalName(string);
        try {
            if (string2 == null) {
                this.reportException(null, 1, 1113, null);
                return null;
            }
            if (string3 == null) {
                this.reportException(null, 1, 1112, null);
                return null;
            }
            try {
                object = this.m_processor.getParam(string2, string3);
            }
            catch (XSLException xSLException) {
                this.reportException(xSLException, 0, 1900, null);
            }
        }
        catch (TransformerException transformerException) {}
        return object;
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    private void reportException(Exception exception, int n, int n2, SourceLocator sourceLocator) throws TransformerException {
        String string = null;
        this.m_err.reset();
        if (exception == null) {
            this.m_err.error0(n2, n);
        } else if (exception.getMessage() == null) {
            this.m_err.error1(n2, n, "null");
        } else {
            this.m_err.error1(n2, n, exception.getMessage());
        }
        string = this.m_err.formatErrorMesg(0);
        TransformerException transformerException = sourceLocator != null ? (exception != null ? new TransformerException(string, sourceLocator, exception) : new TransformerException(string, sourceLocator)) : (exception != null ? new TransformerException(string, exception) : new TransformerException(string));
        if (this.m_errorListener == null) {
            try {
                this.m_err.setErrorStream(System.err);
                this.m_err.printErrorListener();
                if (n == 0) {
                    throw transformerException;
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
            return;
        }
        switch (n) {
            case 0: {
                this.m_errorListener.fatalError(transformerException);
                throw transformerException;
            }
            case 1: {
                this.m_errorListener.error(transformerException);
                break;
            }
            case 2: {
                this.m_errorListener.warning(transformerException);
                break;
            }
        }
    }

    private void reportXSLException(XSLException xSLException) throws TransformerException {
        XMLError xMLError = xSLException.getXMLError();
        DOMLocator dOMLocator = new DOMLocator(xMLError.getLocator());
        int n = xSLException.getMessageType(0);
        String string = xMLError.formatErrorMesg(0);
        TransformerException transformerException = new TransformerException(string, dOMLocator, xSLException);
        if (this.m_errorListener == null) {
            try {
                xMLError.setErrorStream(System.err);
                xMLError.printErrorListener();
                if (n == 0) {
                    throw transformerException;
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
            return;
        }
        switch (n) {
            case 0: {
                this.m_errorListener.fatalError(transformerException);
                throw transformerException;
            }
            case 1: {
                this.m_errorListener.error(transformerException);
                break;
            }
            case 2: {
                this.m_errorListener.warning(transformerException);
                break;
            }
        }
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.m_errorListener = errorListener;
    }

    public void setOutputProperties(Properties properties) throws IllegalArgumentException {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object v = ((Hashtable)properties).get(string);
                if (v != null) {
                    ((Hashtable)this.m_transProps).put(string, v);
                } else {
                    ((Hashtable)this.m_transProps).remove(string);
                }
                if (!string.equals(OutputKeys.METHOD)) continue;
                if (v != null) {
                    JXUtil.setDefaultProps(this.m_transXSLT, (String)v);
                    continue;
                }
                JXUtil.setDefaultProps(this.m_transXSLT, "xml");
            }
        } else {
            ((Hashtable)this.m_transProps).clear();
        }
    }

    public void setOutputProperty(String string, String string2) throws IllegalArgumentException {
        ((Hashtable)this.m_transProps).put(string, string2);
        if (string.equals(OutputKeys.METHOD)) {
            if (string2 != null) {
                JXUtil.setDefaultProps(this.m_transXSLT, string2);
            } else {
                JXUtil.setDefaultProps(this.m_transXSLT, "xml");
            }
        }
    }

    public void setParameter(String string, Object object) {
        String string2 = JXUtil.getURI(string);
        String string3 = JXUtil.getLocalName(string);
        try {
            if (string2 == null) {
                this.reportException(null, 1, 1113, null);
                return;
            }
            if (string3 == null) {
                this.reportException(null, 1, 1112, null);
                return;
            }
            try {
                if (object instanceof String) {
                    object = "'" + object + "'";
                }
                this.m_processor.setParam(string2, string3, object);
            }
            catch (XSLException xSLException) {
                this.reportException(xSLException, 0, 1900, null);
            }
        }
        catch (TransformerException transformerException) {}
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.m_uriResolver = uRIResolver;
    }

    public void transform(Source source, Result result) throws TransformerException {
        DOMLocator dOMLocator;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        XMLElement xMLElement = null;
        if (source instanceof DOMSource) {
            object4 = ((DOMSource)source).getNode();
            if (!(object4 instanceof XMLElement)) {
                this.reportException(null, 0, 1101, null);
            }
            xMLElement = (XMLElement)object4;
        } else {
            object4 = null;
            object3 = SAXSource.sourceToInputSource(source);
            object2 = new DocumentBuilder();
            if (source instanceof SAXSource) {
                object4 = (SAXParser)((SAXSource)source).getXMLReader();
            }
            if (object4 == null) {
                object4 = new SAXParser();
            }
            if ((object = source.getSystemId()) != null) {
                try {
                    ((XMLParser)object4).setBaseURL(new URL((String)object));
                }
                catch (MalformedURLException malformedURLException) {
                    this.reportException(malformedURLException, 1, 1108, null);
                }
            }
            try {
                ((SAXParser)object4).setContentHandler((ContentHandler)object2);
                ((XMLParser)object4).parse((InputSource)object3);
            }
            catch (Exception exception) {
                dOMLocator = new DOMLocator(((DocumentBuilder)object2).getLocator());
                this.reportException(exception, 0, 1004, dOMLocator);
            }
            xMLElement = ((DocumentBuilder)object2).getDocument();
        }
        object4 = null;
        if (result instanceof DOMResult) {
            object3 = ((DOMResult)result).getNode();
            if (!(object3 instanceof XMLElement)) {
                this.reportException(null, 0, 1103, null);
            }
            object4 = new XSLDocumentBuilder((XMLElement)object3);
        } else if (result instanceof SAXResult) {
            object4 = ((SAXResult)result).getHandler();
        } else {
            object3 = (StreamResult)result;
            object2 = ((StreamResult)object3).getOutputStream();
            object = ((StreamResult)object3).getWriter();
            String string = ((StreamResult)object3).getSystemId();
            dOMLocator = null;
            if (object2 == null && object == null) {
                if (string == null) {
                    this.reportException(null, 0, 1122, null);
                }
                try {
                    object2 = new FileOutputStream(string);
                }
                catch (IOException iOException) {
                    this.reportException(iOException, 0, 1110, null);
                }
            }
            this.m_output.setProps(this.m_transProps);
            if (object2 != null) {
                object4 = new XSLSAXPrintDriver((OutputStream)object2, this.m_output);
            } else {
                PrintWriter printWriter = null;
                printWriter = object instanceof PrintWriter ? (PrintWriter)object : new PrintWriter((Writer)object);
                object4 = new XSLSAXPrintDriver(printWriter, this.m_output);
            }
        }
        try {
            if (this.m_templates == null) {
                xMLElement.reportSAXEvents((ContentHandler)object4);
            } else {
                this.m_processor.processXSL(this.m_templates, xMLElement, (ContentHandler)object4);
            }
            if (object4 instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)object4).flush();
            }
            if (object4 instanceof JXTransformerHandler) {
                object4.endDocument();
            }
        }
        catch (XSLException xSLException) {
            this.reportXSLException(xSLException);
        }
        catch (Exception exception) {
            this.reportException(exception, 0, 1900, null);
        }
    }
}

