/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;

class XSDAttrGroup
extends XSDNode {
    String refNamespace;
    String refLocalname;
    int refState;
    XSDNode[] nodeVector;
    int vectorSize = 0;
    XSDAny wildcard;
    XSDAttrGroup base;
    boolean restriction;
    boolean resolved;

    XSDAttrGroup(int n) {
        this.nodeType = 6;
        this.nodeVector = new XSDNode[10];
        this.refState = 0;
    }

    void addNode(XSDNode xSDNode) {
        this.ensureCapacity(this.vectorSize + 1);
        this.nodeVector[this.vectorSize++] = xSDNode;
        if (xSDNode.parent == null) {
            xSDNode.parent = this;
        }
    }

    private void compactNodes() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.vectorSize) {
            if (this.nodeVector[n2] != null && ((XSDAttribute)this.nodeVector[n2]).maxOccurs != 0) {
                this.nodeVector[n++] = this.nodeVector[n2];
            }
            ++n2;
        }
        this.vectorSize = n;
    }

    private void ensureCapacity(int n) {
        int n2 = this.nodeVector.length;
        while (n2 < n) {
            n2 *= 2;
        }
        XSDNode[] xSDNodeArray = this.nodeVector;
        this.nodeVector = new XSDNode[n2];
        System.arraycopy(xSDNodeArray, 0, this.nodeVector, 0, this.vectorSize);
    }

    XSDNode item(int n) {
        if (n >= 0 && n < this.vectorSize) {
            return this.nodeVector[n];
        }
        return null;
    }

    private XSDNode item(XSDNode xSDNode) {
        int n = 0;
        while (n < this.vectorSize) {
            XSDNode xSDNode2 = this.nodeVector[n];
            if (xSDNode2 != null && xSDNode != null && xSDNode.name == xSDNode2.name && xSDNode.getTargetNS() == xSDNode2.getTargetNS()) {
                return xSDNode2;
            }
            ++n;
        }
        return null;
    }

    int length() {
        return this.vectorSize;
    }

    void mergeGroup(XSDAttrGroup xSDAttrGroup) {
        int n = xSDAttrGroup.length();
        this.ensureCapacity(n + this.vectorSize);
        int n2 = 0;
        while (n2 < n) {
            XSDNode xSDNode = xSDAttrGroup.item(n2);
            if (this.item(xSDNode) == null) {
                this.nodeVector[this.vectorSize++] = xSDNode;
            }
            ++n2;
        }
    }

    void print(int n) {
        boolean bl = false;
        if (this.refLocalname != null) {
            bl = true;
        }
        if (!bl && this.vectorSize == 0) {
            return;
        }
        this.printSTag(n);
        this.printSTagEnd(n);
        if (!bl) {
            int n2 = 0;
            while (n2 < this.vectorSize) {
                this.nodeVector[n2].print(n + 3);
                ++n2;
            }
        }
        if (this.wildcard != null) {
            this.wildcard.print(n + 3);
        }
        this.printETag(n);
    }

    private void resolveDerivation() {
        this.base.resolveGroup();
        this.mergeGroup(this.base);
        if (this.base.wildcard != null && !this.restriction) {
            this.wildcard = this.wildcard == null ? this.base.wildcard : this.wildcard.unionWith(this.base.wildcard);
        }
    }

    void resolveGroup() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        XSDNode xSDNode = null;
        Object var2_2 = null;
        int n = this.vectorSize;
        int n2 = 0;
        while (n2 < n) {
            xSDNode = this.nodeVector[n2];
            if (xSDNode instanceof XSDAttrGroup) {
                XSDAttrGroup xSDAttrGroup = (XSDAttrGroup)xSDNode;
                xSDAttrGroup.resolveGroup();
                this.nodeVector[n2] = null;
                this.mergeGroup(xSDAttrGroup);
                if (this.wildcard == null && xSDAttrGroup.wildcard != null) {
                    this.wildcard = xSDAttrGroup.wildcard;
                } else if (xSDAttrGroup.wildcard != null) {
                    this.wildcard = this.wildcard.intersectWith(xSDAttrGroup.wildcard);
                }
            }
            ++n2;
        }
        if (this.base != null) {
            this.resolveDerivation();
        }
        this.compactNodes();
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDAttrGroup xSDAttrGroup = (XSDAttrGroup)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDAttrGroup != null && xSDAttrGroup.refState == 0) {
            this.name = xSDAttrGroup.name;
            this.refState = 0;
            this.ensureCapacity(xSDAttrGroup.vectorSize);
            this.vectorSize = xSDAttrGroup.vectorSize;
            System.arraycopy(xSDAttrGroup.nodeVector, 0, this.nodeVector, 0, this.vectorSize);
        }
    }

    void setAttribute(XSDNode xSDNode, int n) {
        this.nodeVector[n] = xSDNode;
    }

    void setRef(String string, String string2) {
        this.refLocalname = string2;
        this.refNamespace = string;
        this.refState = 1;
    }

    void setWildcard(XSDAny xSDAny) {
        this.wildcard = xSDAny;
        if (xSDAny.parent == null) {
            xSDAny.parent = this;
        }
    }
}

