/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDNotation;
import oracle.xml.parser.schema.XSDSchemaDefaults;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.DOMLocator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.ObjectBuilder;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XSDBuilder
implements ObjectBuilder,
XSDConstantValues {
    private Vector unresolvedNodes;
    private XSDSchemaDefaults schemaDefs;
    private EntityResolver entResolver;
    private DOMParser domParser;
    private DOMLocator domLocator;
    private XMLSchema schemaxml = new XMLSchema(10);
    private Locale locale;
    private boolean localErr = true;
    private XMLError err;
    private String xsdNamespace;
    private boolean redefine;
    private String includingNS;
    private boolean debugMode = true;
    private XMLDocument doc;

    public XSDBuilder() throws XSDException {
        this.schemaDefs = new XSDSchemaDefaults();
        this.unresolvedNodes = new Vector(10);
        this.err = new XMLError();
        this.domLocator = new DOMLocator();
        this.doc = new XMLDocument();
        this.err.setErrorStream(new PrintWriter(System.out));
        this.err.setLocator(this.domLocator);
    }

    void addUnresolvedNode(XSDNode xSDNode) {
        this.unresolvedNodes.addElement(xSDNode);
    }

    public Object build(InputStream inputStream, URL uRL) throws Exception {
        this.initParser(uRL);
        this.domParser.parse(inputStream);
        XMLDocument xMLDocument = this.domParser.getDocument();
        return this.build(xMLDocument, uRL);
    }

    public Object build(Reader reader, URL uRL) throws Exception {
        this.initParser(uRL);
        this.domParser.parse(reader);
        XMLDocument xMLDocument = this.domParser.getDocument();
        return this.build(xMLDocument, uRL);
    }

    public Object build(String string) throws Exception {
        this.initParser(null);
        if (!this.schemaxml.newSchema(string)) {
            return this.schemaxml;
        }
        this.domParser.parse(string);
        XMLDocument xMLDocument = this.domParser.getDocument();
        return this.build(xMLDocument, new URL(string));
    }

    public Object build(String string, String string2) throws Exception {
        this.initParser(null);
        if (!this.schemaxml.newSchema(string2)) {
            return this.schemaxml;
        }
        this.domParser.parse(string2);
        XMLDocument xMLDocument = this.domParser.getDocument();
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        if (!this.sameTargetNS(xMLElement, string.intern())) {
            this.error(xMLElement, 2019, string, false);
        }
        return this.build(xMLDocument, new URL(string2));
    }

    public Object build(String string, URL uRL) throws Exception {
        this.initParser(null);
        if (!this.schemaxml.newSchema(uRL.getFile())) {
            return this.schemaxml;
        }
        this.domParser.parse(uRL);
        XMLDocument xMLDocument = this.domParser.getDocument();
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        if (!this.sameTargetNS(xMLElement, string.intern())) {
            this.error(xMLElement, 2019, string, false);
        }
        return this.build(xMLDocument, uRL);
    }

    public Object build(URL uRL) throws Exception {
        this.initParser(null);
        if (!this.schemaxml.newSchema(uRL.getFile())) {
            return this.schemaxml;
        }
        this.domParser.parse(uRL);
        XMLDocument xMLDocument = this.domParser.getDocument();
        return this.build(xMLDocument, uRL);
    }

    public Object build(XMLDocument xMLDocument, String string, String string2, URL uRL) throws Exception {
        NSResolver nSResolver;
        if (!this.schemaxml.newSchema(string)) {
            return this.schemaxml;
        }
        XMLElement xMLElement = (XMLElement)xMLDocument.selectSingleNode(string = string.substring(1), nSResolver = (NSResolver)((Object)xMLDocument.getDocumentElement()));
        if (!this.sameTargetNS(xMLElement, string2.intern())) {
            this.error(xMLElement, 2019, string2, false);
        }
        this.buildSchema(xMLElement, 0, uRL);
        return this.schemaxml;
    }

    public Object build(XMLDocument xMLDocument, URL uRL) throws Exception {
        if (xMLDocument == null) {
            return null;
        }
        XMLElement xMLElement = (XMLElement)xMLDocument.getDocumentElement();
        this.buildSchema(xMLElement, 0, uRL);
        return this.schemaxml;
    }

    public Object build(XMLDocument[] xMLDocumentArray, URL uRL) throws Exception {
        int n = xMLDocumentArray.length;
        if (xMLDocumentArray == null || n == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            XMLElement xMLElement = (XMLElement)xMLDocumentArray[n2].getDocumentElement();
            if (n2 == n - 1) {
                this.buildSchema(xMLElement, 0, uRL);
            } else {
                this.buildSchema(xMLElement, 2, uRL);
            }
            ++n2;
        }
        return this.schemaxml;
    }

    private void buildSchema(XMLElement xMLElement, int n, URL uRL) throws XSDException {
        XMLSchemaNode xMLSchemaNode = null;
        String string = null;
        switch (n) {
            case 0: {
                this.includingNS = "";
            }
            case 2: {
                string = this.parseSchema(xMLElement);
                xMLSchemaNode = this.schemaxml.getSchemaByTargetNS(string);
                if (xMLSchemaNode == null) {
                    xMLSchemaNode = new XMLSchemaNode(30);
                    xMLSchemaNode.targetNS = string;
                    this.schemaxml.setXMLSchemaNode(string, xMLSchemaNode);
                }
                this.schemaDefs.pushTargetNSDefault(string);
                break;
            }
            case 1: {
                String string2 = this.schemaDefs.getTargetNSDefault();
                string = this.parseSchema(xMLElement);
                if (string.equals("")) {
                    string = string2;
                } else if (!string.equals(string2)) {
                    this.error(xMLElement, 2019, "include", false);
                }
                this.schemaDefs.pushTargetNSDefault(string);
                xMLSchemaNode = this.schemaxml.getSchemaByTargetNS(string);
                break;
            }
        }
        this.parseTopLevelElem(xMLElement, xMLSchemaNode, uRL);
        if (n == 0) {
            this.schemaxml.schemaTargetNS = string;
            this.resolveNodes();
            try {
                try {
                    this.schemaxml.postProcessSchema();
                }
                catch (XSDException xSDException) {
                    this.error(xSDException.getErrorNode(), xSDException.getErrorId(), xSDException.getErrorPara1(), false);
                }
                if (this.localErr) {
                    this.err.flushErrors();
                }
            }
            catch (Exception exception) {
                throw new XSDException(exception.getMessage());
            }
        }
        this.schemaDefs.popDefaults();
    }

    private boolean checkBlockValue(String string) throws XSDException {
        String string2 = string.intern();
        return true;
    }

    private XMLElement checkContent(XSDComplexType xSDComplexType, XMLElement xMLElement) throws XSDException {
        String string;
        String string2;
        String string3;
        XMLAttr xMLAttr;
        XMLElement xMLElement2 = xMLElement;
        NamedNodeMap namedNodeMap = xMLElement2.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            string3 = xMLAttr.getLocalName();
            string2 = xMLAttr.getValue();
            string = xMLAttr.getNamespace();
            if (string == this.xsdNamespace) {
                if (string3 == "mixed" && string2 == "true") {
                    xSDComplexType.setContent(string3);
                } else if (string3 != "id") {
                    this.error2(xMLElement2, 2026, string3, "complexType", false);
                }
            }
            ++n2;
        }
        NodeList nodeList = xMLElement2.getChildNodes();
        int n3 = nodeList.getLength();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        XMLElement xMLElement3 = null;
        int n4 = 0;
        while (n4 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n4);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement4 = (XMLElement)xMLNode;
                String string4 = xMLElement4.getLocalName();
                if (string4 == "annotation" && !bl2) {
                    xSDComplexType.annotation = this.parseAnnotation(xMLElement4, xSDComplexType.annotation);
                    bl2 = true;
                } else if (!(string4 != "restriction" && string4 != "extension" || bl)) {
                    xSDComplexType.setDerivedBy(string4);
                    bl = true;
                    namedNodeMap = xMLElement4.getAttributes();
                    n = namedNodeMap.getLength();
                    int n5 = 0;
                    while (n5 < n) {
                        xMLAttr = (XMLAttr)namedNodeMap.item(n5);
                        string3 = xMLAttr.getLocalName();
                        string2 = xMLAttr.getValue();
                        string = xMLAttr.getNamespace();
                        try {
                            if (string3 != "id") {
                                if (string3 == "base" && !bl3) {
                                    string = this.getNamespace(xMLElement4, string2, this.includingNS);
                                    String string5 = this.getLocalName(string2);
                                    if (string == this.xsdNamespace && string5 == "anyType" && xSDComplexType.derivedBy != "restriction") {
                                        this.error(xMLElement4, 2014, string3, false);
                                    }
                                    xSDComplexType.setBaseRef(string, string5);
                                    bl3 = true;
                                } else {
                                    this.error(xMLElement4, 2023, string3, false);
                                }
                            }
                        }
                        catch (XSDException xSDException) {
                            this.error(xMLElement4, 2023, string3, false);
                        }
                        ++n5;
                    }
                    xMLElement3 = xMLElement4;
                } else {
                    this.error2(xMLElement2, 2027, string4, "complexType", false);
                }
            }
            ++n4;
        }
        if (!bl || !bl3) {
            this.error(xMLElement2, 2014, xMLElement2.getLocalName(), false);
        }
        return xMLElement3;
    }

    private boolean checkFinalValue(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 != "restriction" && string2 != "extension" && string2 != "#all") {
            throw new XSDException();
        }
        return true;
    }

    private void checkTypeAndDefault(XMLElement xMLElement, XSDElement xSDElement) throws XSDException {
        if (xSDElement.defaultVal != null) {
            if (xSDElement.type != 2) {
                this.error2(xMLElement, 2026, "default", xSDElement.name, false);
            } else {
                try {
                    xSDElement.simpleType.validateValue(xSDElement.defaultVal);
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    private boolean checkUseValue(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 != "fixed" && string2 != "default" && string2 != "required" && string2 != "optional" && string2 != "prohibited") {
            throw new XSDException();
        }
        return true;
    }

    private void error(XMLElement xMLElement, int n, String string, boolean bl) throws XSDException {
        if (string == null || string.length() < 1) {
            string = " ";
        }
        this.sendError(xMLElement, n, this.err.getMessage1(n, string), bl);
    }

    private void error2(XMLElement xMLElement, int n, String string, String string2, boolean bl) throws XSDException {
        if (string == null || string.length() < 1) {
            string = " ";
        }
        this.sendError(xMLElement, n, this.err.getMessage2(n, string, string2), bl);
    }

    private boolean getBooleanValue(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 == "false") {
            return false;
        }
        if (string2 == "true") {
            return true;
        }
        throw new XSDException();
    }

    String getLocalName(String string) {
        int n = string.length();
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return string;
        }
        return string.substring(n2 + 1, n);
    }

    private int getMaxValue(String string) throws XSDException {
        try {
            int n = string.equals("*") || string.equals("unbounded") ? 0x7FFFFFF8 : Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            throw new XSDException();
        }
    }

    private int getMinValue(String string) throws XSDException {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new XSDException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getNamespace(XMLElement xMLElement, String string, String string2) throws XSDException {
        String string3;
        String string4 = "#default";
        int n = string.length();
        int n2 = string.indexOf(58);
        if (n2 > 0) {
            string4 = string.substring(0, n2);
        }
        if ((string3 = xMLElement.resolveNamespacePrefix(string4)) == null) {
            if (string4 != "#default") throw new XSDException(2020, string);
            return string2;
        }
        if (!string3.equals("")) return string3;
        return string2;
    }

    public Object getObject() {
        return this.schemaxml;
    }

    private void initParser(URL uRL) throws XSDException {
        try {
            if (this.domParser == null) {
                this.domParser = new DOMParser();
            }
            if (uRL != null) {
                this.domParser.setBaseURL(uRL);
            }
            this.domParser.setPreserveWhitespace(true);
            this.domParser.setValidationMode(0);
            this.domParser.setDebugMode(this.debugMode);
            this.domParser.setErrorStream(System.out);
        }
        catch (Exception exception) {
            throw new XSDException(exception.getMessage());
        }
    }

    private boolean isRef(XMLElement xMLElement) {
        String string = xMLElement.getAttribute("ref");
        return string != null && !string.equals("") && string.length() > 0;
    }

    private boolean isTopLevel(XMLElement xMLElement) {
        XMLElement xMLElement2 = (XMLElement)xMLElement.getParentNode();
        return xMLElement2.getLocalName() == "schema" && xMLElement2.getNamespace() == this.xsdNamespace;
    }

    private XSDAnnotation parseAnnotation(XMLElement xMLElement, XSDAnnotation xSDAnnotation) throws XSDException {
        if (xSDAnnotation == null) {
            xSDAnnotation = new XSDAnnotation();
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                xMLAttr = (XMLAttr)this.doc.importNode(xMLAttr, true);
                xSDAnnotation.addAttribute(xMLAttr);
            } else {
                try {
                    if (string != "id") {
                        this.error2(xMLElement, 2026, string, "notation", false);
                    }
                }
                catch (XSDException xSDException) {
                    this.error2(xMLElement, 2023, string, "notation", false);
                }
            }
            ++n2;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        int n4 = 0;
        while (n4 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n4);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)this.doc.importNode(xMLNode, true);
                String string = xMLElement2.getLocalName();
                if (string == "documentation") {
                    xSDAnnotation.addUserInfo(xMLElement2);
                } else if (string == "appinfo") {
                    xSDAnnotation.addAppInfo(xMLElement2);
                } else {
                    this.error2(xMLElement, 2027, string, "annotation", false);
                }
            }
            ++n4;
        }
        return xSDAnnotation;
    }

    private XSDAny parseAny(XMLElement xMLElement) throws XSDException {
        XSDAny xSDAny = new XSDAny();
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                xMLAttr = (XMLAttr)xMLAttr.cloneNode(true);
                this.doc.importNode(xMLAttr, true);
                xSDAny.addAnnotationAttr(xMLAttr);
            } else {
                try {
                    if (string == "minOccurs") {
                        xSDAny.setMinOccurs(this.getMinValue(string2));
                    } else if (string == "maxOccurs") {
                        xSDAny.setMaxOccurs(this.getMaxValue(string2));
                    } else if (string == "processContents") {
                        xSDAny.setProcessContents(string2);
                    } else if (string == "namespace") {
                        xSDAny.setNamespace(string2);
                    } else {
                        this.error2(xMLElement, 2026, string, "any", false);
                    }
                }
                catch (XSDException xSDException) {
                    this.error2(xMLElement, 2023, string, "any", false);
                }
            }
            ++n2;
        }
        if (xSDAny.maxOccurs < xSDAny.minOccurs) {
            xSDAny.maxOccurs = xSDAny.minOccurs;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n4);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string = xMLElement2.getLocalName();
                if (string == "annotation" && !bl) {
                    xSDAny.annotation = this.parseAnnotation(xMLElement2, xSDAny.annotation);
                    bl = true;
                } else {
                    this.error2(xMLElement, 2027, string, "any", false);
                }
            }
            ++n4;
        }
        return xSDAny;
    }

    private XSDAny parseAnyAttribute(XMLElement xMLElement) throws XSDException {
        XSDAny xSDAny = new XSDAny(7);
        xSDAny.processContents = "skip";
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                xMLAttr = (XMLAttr)xMLAttr.cloneNode(true);
                this.doc.importNode(xMLAttr, true);
                xSDAny.addAnnotationAttr(xMLAttr);
            } else if (string == "namespace") {
                xSDAny.setNamespace(string2);
            } else if (string == "processContents") {
                xSDAny.setProcessContents(string2);
            } else {
                this.error2(xMLElement, 2026, string, "anyAttribute", false);
            }
            ++n2;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        int n4 = 0;
        while (n4 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n4);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                this.error2(xMLElement, 2027, xMLElement2.getLocalName(), "anyAttribute", false);
            }
            ++n4;
        }
        return xSDAny;
    }

    private XSDAttrGroup parseAttrGroup(XMLElement xMLElement) throws XSDException {
        boolean bl = this.isRef(xMLElement);
        boolean bl2 = this.isTopLevel(xMLElement);
        XSDAttrGroup xSDAttrGroup = new XSDAttrGroup(6);
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                xMLAttr = (XMLAttr)xMLAttr.cloneNode(true);
                this.doc.importNode(xMLAttr, true);
                xSDAttrGroup.addAnnotationAttr(xMLAttr);
            } else if (string == "id") {
                xSDAttrGroup.setID(string2);
            } else if (string == "ref" && !bl2) {
                xSDAttrGroup.setRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
            } else if (string == "name" && !bl) {
                xSDAttrGroup.setName(string2);
            } else {
                this.error2(xMLElement, 2026, string, "attributeGroup", false);
            }
            ++n2;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        boolean bl3 = false;
        boolean bl4 = bl;
        int n4 = 0;
        while (n4 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n4);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string = xMLElement2.getLocalName();
                if (string == "annotation" && !bl3) {
                    xSDAttrGroup.annotation = this.parseAnnotation(xMLElement2, xSDAttrGroup.annotation);
                    bl3 = true;
                } else if (string == "attribute" && !bl4) {
                    xSDAttrGroup.addNode(this.parseAttribute(xMLElement2));
                } else if (string == "attributeGroup" && !bl4) {
                    xSDAttrGroup.addNode(this.parseAttrGroup(xMLElement2));
                } else if (string == "anyAttribute" && !bl4) {
                    xSDAttrGroup.setWildcard(this.parseAnyAttribute(xMLElement2));
                    bl4 = true;
                } else {
                    this.error2(xMLElement, 2027, string, "attributeGroup", false);
                }
                bl3 = true;
            }
            ++n4;
        }
        if (bl) {
            if (!this.redefine) {
                xSDAttrGroup.resolveReference(this.schemaxml);
            }
            if (xSDAttrGroup.refState == 1) {
                this.addUnresolvedNode(xSDAttrGroup);
            }
        }
        return xSDAttrGroup;
    }

    private XSDAttribute parseAttribute(XMLElement xMLElement) throws XSDException {
        boolean bl = false;
        boolean bl2 = this.isRef(xMLElement);
        boolean bl3 = this.isTopLevel(xMLElement);
        XSDAttribute xSDAttribute = new XSDAttribute();
        String string = null;
        String string2 = null;
        if ((bl3 ^ true) & (bl2 ^ true)) {
            xSDAttribute.setForm(this.schemaDefs.getAttrFormDefault());
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string3 = xMLAttr.getLocalName();
            String string4 = xMLAttr.getValue().intern();
            String string5 = xMLAttr.getNamespace();
            if (this.skipAttribute(string3, string5)) {
                xMLAttr = (XMLAttr)xMLAttr.cloneNode(true);
                this.doc.importNode(xMLAttr, true);
                xSDAttribute.addAnnotationAttr(xMLAttr);
            } else {
                try {
                    if (string3 == "ref") {
                        xSDAttribute.setRef(this.getNamespace(xMLElement, string4, this.includingNS), this.getLocalName(string4));
                    } else if (string3 == "name" && !bl2) {
                        xSDAttribute.setName(string4);
                    } else if (string3 == "type" && !bl2) {
                        xSDAttribute.setTypeRef(this.getNamespace(xMLElement, string4, this.includingNS), this.getLocalName(string4));
                        bl = true;
                    } else if (string3 == "value") {
                        string = string4;
                    } else if (string3 == "form") {
                        xSDAttribute.setForm(string4);
                    } else if (string3 == "use" && !bl3 && !bl2) {
                        this.checkUseValue(string4);
                        string2 = string4;
                        if (string4 == "required") {
                            xSDAttribute.setMinOccurs(1);
                        } else {
                            xSDAttribute.setMinOccurs(0);
                        }
                        if (string4 == "prohibited") {
                            xSDAttribute.setMaxOccurs(0);
                        } else {
                            xSDAttribute.setMaxOccurs(1);
                        }
                    } else if (string3 == "default") {
                        xSDAttribute.setDefault(string4);
                    } else if (string3 == "fixed") {
                        xSDAttribute.setFixed(string4);
                    } else {
                        this.error2(xMLElement, 2026, string3, "attribute", false);
                    }
                }
                catch (Exception exception) {
                    this.error(xMLElement, 2023, string3, false);
                }
            }
            ++n2;
        }
        if (string != null) {
            if (string2 == "default") {
                xSDAttribute.setDefault(string);
            } else {
                xSDAttribute.setFixed(string);
            }
        } else if (string2 == "default" || string2 == "fixed") {
            this.error(xMLElement, 2023, "value", false);
        }
        if (xSDAttribute.name == null && xSDAttribute.refState != 1) {
            this.error(xMLElement, 2011, "", false);
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        boolean bl4 = false;
        int n4 = 0;
        while (n4 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n4);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string6 = xMLElement2.getLocalName();
                if (string6 == "annotation" && !bl4) {
                    xSDAttribute.annotation = this.parseAnnotation(xMLElement2, xSDAttribute.annotation);
                    bl4 = true;
                } else if (string6 == "simpleType" && !bl) {
                    XSDSimpleType xSDSimpleType = this.parseSimpleType(xMLElement2);
                    if (xSDSimpleType == null) {
                        XSDSimpleType xSDSimpleType2 = new XSDSimpleType();
                        xSDSimpleType2.domNode = xMLElement2;
                        xSDSimpleType2.parent = xSDAttribute;
                        this.addUnresolvedNode(xSDSimpleType2);
                    } else {
                        xSDSimpleType.parent = xSDAttribute;
                        xSDAttribute.setSimpleType(xSDSimpleType);
                    }
                    bl = true;
                } else {
                    this.error2(xMLElement, 2027, string6, "attribute", false);
                }
                bl4 = true;
            }
            ++n4;
        }
        if (!this.redefine) {
            if (xSDAttribute.refState == 3) {
                xSDAttribute.resolveTypeReference(this.schemaxml);
            } else if (xSDAttribute.refState == 1) {
                xSDAttribute.resolveReference(this.schemaxml);
            }
        }
        if (xSDAttribute.refState == 3 || xSDAttribute.refState == 1) {
            xSDAttribute.domNode = xMLElement;
            this.addUnresolvedNode(xSDAttribute);
        } else {
            try {
                if (xSDAttribute.simpleType.bAbstract) {
                    this.error(xMLElement, 2017, xSDAttribute.name, false);
                }
            }
            catch (XSDException xSDException) {
                this.error(xMLElement, 2029, xSDAttribute.name, false);
            }
        }
        return xSDAttribute;
    }

    private XSDComplexType parseComplexType(XMLElement xMLElement) throws XSDException {
        Object object;
        XSDComplexType xSDComplexType = new XSDComplexType();
        XMLElement xMLElement2 = xMLElement;
        xSDComplexType.setBlock(this.schemaDefs.getBlockDefault());
        xSDComplexType.setFinal(this.schemaDefs.getFinalDefault());
        NamedNodeMap namedNodeMap = xMLElement2.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                xMLAttr = (XMLAttr)xMLAttr.cloneNode(true);
                this.doc.importNode(xMLAttr, true);
                xSDComplexType.addAnnotationAttr(xMLAttr);
            } else {
                try {
                    if (string == "name") {
                        xSDComplexType.setName(string2);
                    } else if (string == "abstract") {
                        xSDComplexType.setAbstract(this.getBooleanValue(string2));
                    } else if (string == "block" && this.checkBlockValue(string2)) {
                        xSDComplexType.setBlock(string2);
                    } else if (string == "final" && this.checkFinalValue(string2)) {
                        xSDComplexType.setFinal(string2);
                    } else if (string == "id") {
                        xSDComplexType.setID(string2);
                    } else if (string == "mixed") {
                        xSDComplexType.setMixedContent(string2);
                    } else {
                        this.error2(xMLElement2, 2026, string, "complexType", false);
                    }
                }
                catch (XSDException xSDException) {
                    this.error(xMLElement2, 2023, string, false);
                }
            }
            ++n2;
        }
        NodeList nodeList = xMLElement2.getChildNodes();
        int n3 = nodeList.getLength();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            object = (XMLNode)nodeList.item(n4);
            if (((XMLNode)object).getNodeType() == 1) {
                XMLElement xMLElement3 = (XMLElement)object;
                String string = xMLElement3.getLocalName();
                if (string == "annotation") {
                    xSDComplexType.annotation = this.parseAnnotation(xMLElement3, xSDComplexType.annotation);
                } else {
                    if (string == "simpleContent") {
                        xMLElement2 = this.checkContent(xSDComplexType, xMLElement3);
                        xSDComplexType.simpleContent = true;
                        break;
                    }
                    if (string == "complexContent") {
                        xMLElement2 = this.checkContent(xSDComplexType, xMLElement3);
                        break;
                    }
                    xSDComplexType.setBaseRef(this.xsdNamespace, "anyType");
                    xSDComplexType.setDerivedBy("restriction");
                    break;
                }
            }
            ++n4;
        }
        if (xSDComplexType.refState == 7) {
            object = null;
            if (!this.redefine) {
                object = this.schemaxml.getType(xSDComplexType.refNamespace, xSDComplexType.refLocalname, 1);
            }
            if (object == null) {
                object = this.schemaxml.getType(xSDComplexType.refNamespace, xSDComplexType.refLocalname, 2);
            }
            if (!(object == null || ((XSDNode)object).isNodeType(1) && ((XSDComplexType)object).refState != 6)) {
                xSDComplexType.setBaseType((XSDNode)object);
                this.parseComplexTypeContent(xSDComplexType, xMLElement2);
            } else {
                xSDComplexType.domNode = xMLElement2;
                this.addUnresolvedNode(xSDComplexType);
            }
        } else {
            this.parseComplexTypeContent(xSDComplexType, xMLElement2);
        }
        return xSDComplexType;
    }

    private void parseComplexTypeContent(XSDComplexType xSDComplexType, XMLElement xMLElement) throws XSDException {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        XSDComplexType xSDComplexType2 = null;
        XSDSimpleType xSDSimpleType = null;
        if (xSDComplexType.base != null) {
            if (xSDComplexType.base.isNodeType(2)) {
                xSDSimpleType = (XSDSimpleType)xSDComplexType.base;
                if (xSDComplexType.derivedBy == "restriction" || !xSDComplexType.simpleContent) {
                    this.error(xMLElement, 2014, xMLElement.getLocalName(), false);
                    return;
                }
                xSDComplexType.simpleType = xSDSimpleType;
                bl = false;
            } else {
                xSDComplexType2 = (XSDComplexType)xSDComplexType.base;
                if (xSDComplexType2.simpleContent) {
                    if (!xSDComplexType.simpleContent) {
                        this.error(xMLElement, 2014, xMLElement.getLocalName(), false);
                        return;
                    }
                    xSDComplexType.simpleType = xSDComplexType2.simpleType;
                    bl = false;
                    if (xSDComplexType.derivedBy == "restriction") {
                        xSDComplexType.simpleType = XSDSimpleType.derivedFrom(xSDComplexType.simpleType, "", "restriction");
                        bl3 = true;
                    }
                } else if (xSDComplexType.simpleContent) {
                    this.error(xMLElement, 2014, xMLElement.getLocalName(), false);
                    return;
                }
            }
        }
        XSDAttrGroup xSDAttrGroup = xSDComplexType.getAttrGroup();
        XSDSimpleType xSDSimpleType2 = xSDComplexType.getSimpleType();
        XSDGroup xSDGroup = null;
        NodeList nodeList = xMLElement.getChildNodes();
        int n = nodeList.getLength();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n2 = 0;
        Object object = null;
        int n3 = 0;
        while (n3 < n) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n3);
            if (xMLNode.getNodeType() == 1) {
                Object object2;
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string = xMLElement2.getLocalName();
                if (string == "annotation" && !bl4) {
                    xSDAttrGroup.annotation = this.parseAnnotation(xMLElement2, xSDComplexType.annotation);
                    bl4 = true;
                } else if (string == "attribute" && !bl6 && bl2) {
                    xSDAttrGroup.addNode(this.parseAttribute(xMLElement2));
                    bl5 = true;
                } else if (string == "anyAttribute" && !bl6 && bl2) {
                    xSDAttrGroup.setWildcard(this.parseAnyAttribute(xMLElement2));
                    bl5 = true;
                    bl6 = true;
                } else if (string == "attributeGroup" && !bl6 && bl2) {
                    xSDAttrGroup.addNode(this.parseAttrGroup(xMLElement2));
                    bl5 = true;
                } else if (string == "simpleType" && bl3 && !bl5 && !bl7) {
                    object2 = this.parseSimpleType(xMLElement2);
                    if (object2 == null) {
                        xSDComplexType.domNode = xMLElement;
                        this.addUnresolvedNode(xSDComplexType);
                        return;
                    }
                    xSDComplexType.simpleType = XSDSimpleType.derivedFrom((XSDSimpleType)object2, "", "restriction");
                } else if (bl3 && !bl5) {
                    try {
                        object2 = xMLElement2.getAttribute("value");
                        if (string == "pattern") {
                            object = object == null ? object2 : String.valueOf(object) + "|" + (String)object2;
                        } else {
                            xSDSimpleType2.setFacet(string, (String)object2);
                        }
                        bl7 = true;
                    }
                    catch (Exception exception) {
                        this.error2(xMLElement, 2015, string, "complexType", false);
                    }
                } else if (bl && !bl5 && n2 == 0) {
                    ++n2;
                    if (string == "group") {
                        xSDGroup = this.parseGroup(xMLElement2);
                    } else if (string == "sequence" || string == "choice" || string == "all") {
                        xSDGroup = this.parseCompositor(xMLElement2, string);
                    } else {
                        this.error2(xMLElement, 2027, string, "complexType", false);
                    }
                } else {
                    this.error2(xMLElement, 2027, string, "complexType", false);
                    return;
                }
                bl4 = true;
            }
            ++n3;
        }
        if (object != null) {
            try {
                xSDSimpleType2.setFacet("pattern", (String)object);
            }
            catch (Exception exception) {
                this.error2(xMLElement, 2015, "pattern", "complexType", false);
            }
        }
        if (!xSDComplexType.simpleContent) {
            boolean bl8 = false;
            if (xSDGroup == null) {
                bl8 = true;
            } else if (xSDGroup.length() == 0) {
                if (xSDGroup.order != 0) {
                    bl8 = true;
                } else if (xSDGroup.getMinOccurs() == 0) {
                    bl8 = true;
                }
            }
            if (xSDComplexType.derivedBy == "restriction") {
                if (xSDComplexType.content != 13) {
                    if (bl8) {
                        xSDComplexType.setContent("empty");
                    } else {
                        xSDComplexType.setContent("elementOnly");
                    }
                }
            } else if (xSDComplexType.content != 13) {
                xSDComplexType.setContent("elementOnly");
            }
        } else if (xSDComplexType.simpleType != null) {
            xSDComplexType.setContent("textOnly");
        } else {
            xSDComplexType.setContent("empty");
        }
        if (xSDComplexType2 != null && xSDComplexType2 != XSDComplexType.urType) {
            xSDAttrGroup.restriction = xSDComplexType.derivedBy == "restriction";
            xSDAttrGroup.base = xSDComplexType2.getAttrGroup();
            if (xSDComplexType.derivedBy == "extension" && bl && xSDComplexType2.typeGroup != null) {
                if (xSDGroup == null) {
                    xSDComplexType.typeGroup = xSDComplexType2.typeGroup;
                } else {
                    xSDComplexType.initTypeGroup(0);
                    XSDGroup xSDGroup2 = xSDComplexType.getTypeGroup();
                    xSDGroup2.addParticleNode(xSDComplexType2.typeGroup);
                    xSDGroup2.addParticleNode(xSDGroup);
                }
            }
        }
        if (xSDComplexType.typeGroup == null && xSDGroup != null) {
            xSDComplexType.setTypeGroup(xSDGroup);
        }
        xSDComplexType.domNode = null;
    }

    private XSDGroup parseCompositor(XMLElement xMLElement, String string) throws XSDException {
        XSDGroup xSDGroup = new XSDGroup();
        xSDGroup.order = string == "sequence" ? 0 : (string == "choice" ? 1 : 2);
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string2 = xMLAttr.getLocalName();
            String string3 = xMLAttr.getValue();
            String string4 = xMLAttr.getNamespace();
            if (!this.skipAttribute(string2, string4)) {
                try {
                    if (string2 == "id") {
                        xSDGroup.setID(string3);
                    } else if (string2 == "minOccurs") {
                        xSDGroup.setMinOccurs(this.getMinValue(string3));
                    } else if (string2 == "maxOccurs") {
                        xSDGroup.setMaxOccurs(this.getMaxValue(string3));
                    } else {
                        this.error2(xMLElement, 2026, string2, string, false);
                    }
                }
                catch (XSDException xSDException) {
                    this.error(xMLElement, 2023, string2, false);
                }
            }
            ++n2;
        }
        if (xSDGroup.maxOccurs < xSDGroup.minOccurs) {
            xSDGroup.maxOccurs = xSDGroup.minOccurs;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n4);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string5 = xMLElement2.getLocalName();
                if (string5 == "annotation" && !bl) {
                    bl = true;
                } else if (string5 == "element") {
                    XSDElement xSDElement = this.parseElement(xMLElement2);
                    if (xSDGroup.order == 2 && xSDElement.maxOccurs > 1) {
                        this.error2(xMLElement, 2027, string5, string, false);
                    }
                    xSDGroup.addParticleNode(xSDElement);
                } else if (xSDGroup.order != 2) {
                    if (string5 == "group") {
                        xSDGroup.addParticleNode(this.parseGroup(xMLElement2));
                    } else if (string5 == "any") {
                        xSDGroup.addParticleNode(this.parseAny(xMLElement2));
                    } else if (string5 == "choice" || string5 == "sequence") {
                        xSDGroup.addParticleNode(this.parseCompositor(xMLElement2, string5));
                    } else {
                        this.error2(xMLElement, 2027, string5, string, false);
                    }
                } else {
                    this.error2(xMLElement, 2027, string5, string, false);
                }
                bl = true;
            }
            ++n4;
        }
        return xSDGroup;
    }

    private XSDElement parseElement(XMLElement xMLElement) throws XSDException {
        boolean bl = this.isRef(xMLElement);
        boolean bl2 = this.isTopLevel(xMLElement);
        boolean bl3 = false;
        boolean bl4 = false;
        XSDElement xSDElement = new XSDElement();
        xSDElement.domNode = xMLElement;
        xSDElement.setBlock(this.schemaDefs.getBlockDefault());
        xSDElement.setFinal(this.schemaDefs.getFinalDefault());
        if (!bl2 && !bl) {
            xSDElement.setForm(this.schemaDefs.getElemFormDefault());
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getValue().intern();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                xMLAttr = (XMLAttr)xMLAttr.cloneNode(true);
                this.doc.importNode(xMLAttr, true);
                xSDElement.addAnnotationAttr(xMLAttr);
            } else {
                try {
                    if (string == "ref") {
                        xSDElement.setRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
                    } else if (string == "id") {
                        xSDElement.setID(string2);
                    } else if (string == "default") {
                        xSDElement.setDefault(string2);
                    } else if (string == "form") {
                        xSDElement.setForm(string2);
                    } else if (string == "fixed") {
                        xSDElement.setFixed(string2);
                    } else if (string == "nullable" || string == "nillable") {
                        xSDElement.setNullable(this.getBooleanValue(string2));
                    } else if (string == "block" && this.checkBlockValue(string2)) {
                        xSDElement.setBlock(string2);
                    } else if (string == "final" && !bl && this.checkFinalValue(string2)) {
                        xSDElement.setFinal(string2);
                    } else if (string == "type" && !bl) {
                        xSDElement.setTypeRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
                        bl4 = true;
                    } else if (string == "name" && !bl) {
                        xSDElement.setName(string2);
                    } else if (string == "substitutionGroup" && !bl) {
                        xSDElement.setEquivClassRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
                        bl3 = true;
                    } else if (string == "abstract") {
                        if (!bl) {
                            xSDElement.setAbstract(this.getBooleanValue(string2));
                        }
                    } else if (string == "minOccurs" && !bl2) {
                        xSDElement.setMinOccurs(this.getMinValue(string2));
                    } else if (string == "maxOccurs" && !bl2) {
                        xSDElement.setMaxOccurs(this.getMaxValue(string2));
                    } else {
                        this.error2(xMLElement, 2026, string, "element", false);
                    }
                }
                catch (XSDException xSDException) {
                    this.error(xMLElement, 2023, string, false);
                }
            }
            ++n2;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        boolean bl5 = false;
        int n4 = 0;
        while (n4 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n4);
            if (xMLNode.getNodeType() == 1) {
                XSDNode xSDNode;
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string = xMLElement2.getLocalName();
                if (string == "annotation" && !bl5) {
                    xSDElement.annotation = this.parseAnnotation(xMLElement2, xSDElement.annotation);
                    bl5 = true;
                } else if (string == "complexType" && !bl && !bl4) {
                    xSDNode = this.parseComplexType(xMLElement2);
                    xSDNode.parent = xSDElement;
                    xSDElement.setComplexType((XSDComplexType)xSDNode);
                    bl4 = true;
                } else if (string == "simpleType" && !bl && !bl4) {
                    xSDNode = this.parseSimpleType(xMLElement2);
                    if (xSDNode == null) {
                        XSDSimpleType xSDSimpleType = new XSDSimpleType();
                        xSDSimpleType.domNode = xMLElement2;
                        xSDSimpleType.parent = xSDElement;
                        this.addUnresolvedNode(xSDSimpleType);
                    } else {
                        xSDNode.parent = xSDElement;
                        xSDElement.setSimpleType((XSDSimpleType)xSDNode);
                    }
                    bl4 = true;
                } else if (string == "unique") {
                    xSDElement.addIdentity(this.parseIdentity(xMLElement2, string, xSDElement.getForm()));
                } else if (string == "key") {
                    xSDElement.addIdentity(this.parseIdentity(xMLElement2, string, xSDElement.getForm()));
                } else if (string == "keyref") {
                    xSDElement.addIdentity(this.parseIdentity(xMLElement2, string, xSDElement.getForm()));
                } else {
                    this.error2(xMLElement, 2027, string, "element", false);
                }
                bl5 = true;
            }
            ++n4;
        }
        if (xSDElement.maxOccurs < xSDElement.minOccurs) {
            xSDElement.maxOccurs = xSDElement.minOccurs;
        }
        if (!this.redefine) {
            if (xSDElement.refState == 3) {
                xSDElement.resolveTypeReference(this.schemaxml);
            } else if (xSDElement.refState == 1) {
                xSDElement.resolveReference(this.schemaxml);
            }
        }
        if (xSDElement.refState == 1 || xSDElement.refState == 3 || xSDElement.equivRefState == 5) {
            xSDElement.domNode = xMLElement;
            this.addUnresolvedNode(xSDElement);
        } else {
            this.checkTypeAndDefault(xMLElement, xSDElement);
        }
        return xSDElement;
    }

    private XSDGroup parseGroup(XMLElement xMLElement) throws XSDException {
        boolean bl = this.isRef(xMLElement);
        boolean bl2 = this.isTopLevel(xMLElement);
        XSDGroup xSDGroup = new XSDGroup();
        xSDGroup.order = 0;
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (this.skipAttribute(string, string3)) {
                xMLAttr = (XMLAttr)xMLAttr.cloneNode(true);
                this.doc.importNode(xMLAttr, true);
                xSDGroup.addAnnotationAttr(xMLAttr);
            } else {
                try {
                    if (string == "ref" && !bl2) {
                        xSDGroup.setRef(this.getNamespace(xMLElement, string2, this.includingNS), this.getLocalName(string2));
                    } else if (string == "name" && !bl) {
                        xSDGroup.setName(string2);
                    } else if (string == "id") {
                        xSDGroup.setID(string2);
                    } else if (string == "minOccurs" && !bl2) {
                        xSDGroup.setMinOccurs(this.getMinValue(string2));
                    } else if (string == "maxOccurs" && !bl2) {
                        xSDGroup.setMaxOccurs(this.getMaxValue(string2));
                    } else {
                        this.error2(xMLElement, 2026, string, "group", false);
                    }
                }
                catch (XSDException xSDException) {
                    this.error(xMLElement, 2023, string, false);
                }
            }
            ++n2;
        }
        if (xSDGroup.maxOccurs < xSDGroup.minOccurs) {
            xSDGroup.maxOccurs = xSDGroup.minOccurs;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        int n4 = 0;
        boolean bl3 = false;
        int n5 = 0;
        while (n5 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n5);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string = xMLElement2.getLocalName();
                if (string == "annotation" && !bl3) {
                    xSDGroup.annotation = this.parseAnnotation(xMLElement2, xSDGroup.annotation);
                    bl3 = true;
                } else if (!bl) {
                    if (string == "all" && n4 == 0) {
                        xSDGroup.addParticleNode(this.parseCompositor(xMLElement2, string));
                    } else if ((string == "choice" || string == "sequence") && n4 == 0) {
                        xSDGroup.addParticleNode(this.parseCompositor(xMLElement2, string));
                    } else {
                        --n4;
                        this.error2(xMLElement, 2027, string, "group", false);
                    }
                    ++n4;
                } else {
                    this.error2(xMLElement, 2027, string, "group", false);
                }
                bl3 = true;
            }
            ++n5;
        }
        if (bl) {
            if (!this.redefine) {
                xSDGroup.resolveReference(this.schemaxml);
            }
            if (xSDGroup.refState == 1) {
                this.addUnresolvedNode(xSDGroup);
            }
        }
        return xSDGroup;
    }

    private XSDIdentity parseIdentity(XMLElement xMLElement, String string, int n) throws XSDException {
        Object object;
        XSDIdentity xSDIdentity = new XSDIdentity();
        String string2 = this.schemaDefs.getTargetNSDefault();
        if (string == "unique") {
            xSDIdentity.setNodeType(22);
        } else if (string == "key") {
            xSDIdentity.setNodeType(23);
        } else if (string == "keyref") {
            xSDIdentity.setNodeType(24);
        }
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n2 = namedNodeMap.getLength();
        int n3 = 0;
        while (n3 < n2) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n3);
            String string3 = xMLAttr.getLocalName();
            String string4 = xMLAttr.getValue();
            String string5 = xMLAttr.getNamespace();
            if (this.skipAttribute(string3, string5)) {
                xMLAttr = (XMLAttr)xMLAttr.cloneNode(true);
                this.doc.importNode(xMLAttr, true);
                xSDIdentity.addAnnotationAttr(xMLAttr);
            } else if (string3 == "name") {
                if (n == 1) {
                    xSDIdentity.setName(String.valueOf(string2) + ":" + string4);
                } else {
                    xSDIdentity.setName(string4);
                }
            } else if (string3 == "id") {
                xSDIdentity.setID(string4);
            } else if (string3 == "refer") {
                object = XMLUtil.getPrefix(string4);
                String string6 = xMLElement.resolveNamespacePrefix((String)object);
                if (string6 != null) {
                    string4 = String.valueOf(string6) + ":" + XMLUtil.getLocalName(string4);
                }
                xSDIdentity.setRefer(string4);
            } else {
                this.error2(xMLElement, 2026, string3, "element", false);
            }
            ++n3;
        }
        object = xMLElement.getChildNodes();
        int n4 = object.getLength();
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < n4) {
            XMLNode xMLNode = (XMLNode)object.item(n5);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string7 = xMLElement2.getLocalName();
                if (string7 == "annotation" && !bl) {
                    xSDIdentity.annotation = this.parseAnnotation(xMLElement2, xSDIdentity.annotation);
                    bl = true;
                } else if (string7 == "selector" && !bl2) {
                    xSDIdentity.setSelector(xMLElement2.getAttribute("xpath"));
                    bl2 = true;
                } else if (string7 == "field" && bl2) {
                    xSDIdentity.addField(xMLElement2.getAttribute("xpath"));
                } else {
                    this.error2(xMLElement, 2027, string7, "element", false);
                }
                bl = true;
            }
            ++n5;
        }
        xSDIdentity.compileExpr(xMLElement);
        return xSDIdentity;
    }

    private void parseIncludeAndImport(XMLElement xMLElement, int n, URL uRL) throws XSDException {
        Object object;
        boolean bl = false;
        URL uRL2 = null;
        String string = xMLElement.getAttribute("schemaLocation");
        String string2 = this.schemaDefs.getTargetNSDefault();
        XMLDocument xMLDocument = null;
        if (string.equals("")) {
            return;
        }
        try {
            if (string.charAt(0) == '#') {
                if (!this.schemaxml.newSchema(string)) {
                    return;
                }
                xMLDocument = (XMLDocument)xMLElement.getOwnerDocument();
                string = string.substring(1);
                NSResolver nSResolver = (NSResolver)((Object)xMLDocument.getDocumentElement());
                XMLElement xMLElement2 = (XMLElement)xMLDocument.selectSingleNode(string, nSResolver);
                if (n == 2 && this.sameTargetNS(xMLElement2, string2)) {
                    this.error(xMLElement2, 2019, "import", false);
                    return;
                }
                this.buildSchema(xMLElement2, n, uRL2);
                return;
            }
            if (this.entResolver != null && (object = this.entResolver.resolveEntity(string2, string)) != null) {
                bl = true;
                Reader reader = ((InputSource)object).getCharacterStream();
                if (reader != null) {
                    this.domParser.parse(reader);
                } else {
                    InputStream inputStream = ((InputSource)object).getByteStream();
                    if (inputStream != null) {
                        this.domParser.parse(inputStream);
                    } else {
                        string = ((InputSource)object).getSystemId();
                        if (string != null && this.schemaxml.newSchema(string)) {
                            this.domParser.parse(string);
                        } else {
                            bl = false;
                        }
                    }
                }
            }
            if (!bl) {
                uRL2 = uRL == null ? new URL(string) : new URL(uRL, string);
                if (!this.schemaxml.newSchema(uRL2.getFile())) {
                    return;
                }
                this.domParser.parse(uRL2);
            }
            xMLDocument = this.domParser.getDocument();
        }
        catch (Exception exception) {
            throw new XSDException(exception.getMessage());
        }
        object = (XMLElement)xMLDocument.getDocumentElement();
        if (n == 2 && this.sameTargetNS((XMLElement)object, string2)) {
            this.error((XMLElement)object, 2019, "import", false);
            return;
        }
        this.buildSchema((XMLElement)object, n, uRL2);
    }

    private XSDNotation parseNotation(XMLElement xMLElement) throws XSDException {
        XSDNotation xSDNotation = new XSDNotation();
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string = xMLAttr.getLocalName();
            String string2 = xMLAttr.getValue();
            String string3 = xMLAttr.getNamespace();
            if (!this.skipAttribute(string, string3)) {
                try {
                    if (string == "id") {
                        xSDNotation.setID(string2);
                    } else if (string == "name") {
                        xSDNotation.setName(string2);
                    } else if (string == "public") {
                        xSDNotation.setPublicID(string2);
                    } else if (string == "system") {
                        xSDNotation.setSystemID(string2);
                    } else {
                        this.error2(xMLElement, 2026, string, "notation", false);
                    }
                }
                catch (XSDException xSDException) {
                    this.error2(xMLElement, 2023, string, "notation", false);
                }
            }
            ++n2;
        }
        if (xSDNotation.name == null) {
            this.error(xMLElement, 2011, "", false);
            return null;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n3 = nodeList.getLength();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n4);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string = xMLElement2.getLocalName();
                if (string == "annotation" && !bl) {
                    xSDNotation.annotation = this.parseAnnotation(xMLElement2, xSDNotation.annotation);
                    bl = true;
                } else {
                    this.error2(xMLElement, 2027, string, "notation", false);
                }
            }
            ++n4;
        }
        return xSDNotation;
    }

    private void parseRedefine(XMLElement xMLElement, XMLSchemaNode xMLSchemaNode) throws XSDException {
        NodeList nodeList = xMLElement.getChildNodes();
        int n = nodeList.getLength();
        XSDNode xSDNode = null;
        int n2 = 0;
        while (n2 < n) {
            XMLNode xMLNode = (XMLNode)nodeList.item(n2);
            if (xMLNode.getNodeType() == 1) {
                XMLElement xMLElement2 = (XMLElement)xMLNode;
                String string = xMLElement2.getLocalName();
                if (string == "complexType") {
                    xSDNode = this.parseComplexType(xMLElement2);
                } else if (string == "simpleType") {
                    xSDNode = this.parseSimpleType(xMLElement2);
                } else if (string == "group") {
                    xSDNode = this.parseGroup(xMLElement2);
                } else if (string == "attributeGroup") {
                    xSDNode = this.parseAttrGroup(xMLElement2);
                } else if (string == "notation") {
                    xSDNode = this.parseNotation(xMLElement2);
                } else {
                    this.error2(xMLElement, 2027, string, "schema", false);
                }
                if (xSDNode != null) {
                    xSDNode.domNode = xMLElement2;
                    xMLSchemaNode.addComponent(xSDNode);
                }
            }
            ++n2;
        }
    }

    private String parseSchema(XMLElement xMLElement) throws XSDException {
        String string = "unqualified";
        String string2 = "unqualified";
        String string3 = "#undef";
        String string4 = "#undef";
        String string5 = "";
        Boolean bl = new Boolean(this.redefine);
        NamedNodeMap namedNodeMap = xMLElement.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n2);
            String string6 = xMLAttr.getLocalName();
            String string7 = xMLAttr.getValue();
            String string8 = xMLAttr.getNamespace();
            if (!this.skipAttribute(string6, string8)) {
                try {
                    if (string6 == "targetNamespace") {
                        string5 = string7;
                    } else if (string6 == "blockDefault") {
                        string3 = string7;
                    } else if (string6 == "finalDefault") {
                        string4 = string7;
                    } else if (string6 == "attributeFormDefault") {
                        string = string7;
                    } else if (string6 == "elementFormDefault") {
                        string2 = string7;
                    } else if (string6 != "version" && string6 != "id") {
                        this.error2(xMLElement, 2026, string6, "element", false);
                    }
                }
                catch (XSDException xSDException) {
                    this.error(xMLElement, 2023, string6, false);
                }
            }
            ++n2;
        }
        this.schemaDefs.pushDefaults(string, string2, string3, string4, bl);
        return string5;
    }

    /*
     * Unable to fully structure code
     */
    private XSDSimpleType parseSimpleType(XMLElement var1_1) throws XSDException {
        var2_2 = null;
        var3_3 = var1_1;
        var4_4 = null;
        var5_5 = null;
        var6_6 = var3_3.getNamespace();
        var7_7 = null;
        var8_8 = null;
        var9_9 = null;
        var10_10 = false;
        var11_11 = var3_3.getAttributes();
        var12_12 = var11_11.getLength();
        var17_13 = null;
        var18_14 = 0;
        while (var18_14 < var12_12) {
            var13_15 = (XMLAttr)var11_11.item(var18_14);
            var14_16 = var13_15.getLocalName();
            var15_17 = var13_15.getValue();
            var16_18 = var13_15.getNamespace();
            if (this.skipAttribute(var14_16, var16_18)) {
                if (var17_13 == null) {
                    var17_13 = new XSDAnnotation();
                }
                var13_15 = (XMLAttr)var13_15.cloneNode(true);
                this.doc.importNode(var13_15, true);
                var17_13.addAttribute(var13_15);
            } else {
                try {
                    if (var14_16 == "name") {
                        var7_7 = var15_17;
                    } else if (var14_16 == "id") {
                        var8_8 = var15_17;
                    } else {
                        this.error2(var3_3, 2026, var14_16, "simpleType", false);
                    }
                }
                catch (XSDException v0) {
                    this.error(var3_3, 2023, var14_16, false);
                }
            }
            ++var18_14;
        }
        var19_19 = var3_3.getChildNodes();
        var20_20 = var19_19.getLength();
        var21_21 = false;
        var22_22 = null;
        var23_23 = 0;
        while (var23_23 < var20_20 && var9_9 == null) {
            block35: {
                block42: {
                    block40: {
                        block41: {
                            block37: {
                                block39: {
                                    block38: {
                                        block36: {
                                            var22_22 = (XMLNode)var19_19.item(var23_23);
                                            if (var22_22.getNodeType() != 1) break block35;
                                            var24_24 = (XMLElement)var22_22;
                                            var25_25 = var24_24.getLocalName();
                                            if (var25_25 != "annotation" || var21_21) break block36;
                                            var17_13 = this.parseAnnotation((XMLElement)var24_24, var17_13);
                                            var21_21 = true;
                                            break block35;
                                        }
                                        if (var9_9 != null || var25_25 != "restriction") break block37;
                                        var9_9 = "restriction";
                                        var2_2 = var24_24.getAttribute("base");
                                        var3_3 = var24_24;
                                        if (var2_2 == null || var2_2.equals("")) break block35;
                                        var10_10 = true;
                                        if (!var2_2.equals("anyType")) break block38;
                                        var4_4 = new XSDSimpleType(0, "");
                                        break block35;
                                    }
                                    var5_5 = (XSDSimpleType)this.schemaxml.getType(this.getNamespace((XMLElement)var24_24, var2_2, this.includingNS), this.getLocalName(var2_2), 2);
                                    if (var5_5 == null || this.redefine) break block39;
                                    var4_4 = XSDSimpleType.derivedFrom(var5_5, "", "restriction");
                                    break block35;
                                }
                                return null;
                            }
                            if (var9_9 != null || var25_25 != "list") break block40;
                            var9_9 = "list";
                            var3_3 = var24_24;
                            var2_2 = var24_24.getAttribute("itemType");
                            if (var2_2 == null || var2_2.equals("")) break block35;
                            var10_10 = true;
                            var5_5 = (XSDSimpleType)this.schemaxml.getType(this.getNamespace((XMLElement)var24_24, var2_2, this.includingNS), this.getLocalName(var2_2), 2);
                            if (var5_5 == null) break block41;
                            var4_4 = XSDSimpleType.derivedFrom(var5_5, "", "list");
                            break block35;
                        }
                        return null;
                    }
                    if (var9_9 != null || var25_25 != "union") break block42;
                    var9_9 = "union";
                    var10_10 = true;
                    var4_4 = new XSDSimpleType();
                    var4_4.members = new Vector<E>();
                    var3_3 = var24_24;
                    var2_2 = var24_24.getAttribute("memberTypes");
                    if (var2_2 == null || var2_2.equals("")) break block35;
                    var26_27 = 0;
                    var27_30 = var2_2.length();
                    var30_35 = var2_2.toCharArray();
                    ** GOTO lbl110
                    {
                        ++var26_27;
                        do {
                            if (var26_27 < var27_30 && var30_35[var26_27] == ' ') continue block8;
                            var28_32 = var26_27;
                            while (var26_27 < var27_30 && var30_35[var26_27] != ' ') {
                                ++var26_27;
                            }
                            var29_34 = new String(var30_35, var28_32, var26_27 - var28_32);
                            var5_5 = (XSDSimpleType)this.schemaxml.getType(this.getNamespace((XMLElement)var24_24, var29_34, this.includingNS), this.getLocalName(var29_34), 2);
                            if (var5_5 != null) {
                                var4_4.members.addElement(var5_5);
                                continue;
                            }
                            return null;
lbl110:
                            // 2 sources

                        } while (var26_27 < var27_30);
                    }
                    break block35;
                }
                this.error2(var3_3, 2014, var25_25, "simpleType", false);
            }
            ++var23_23;
        }
        var21_21 = true;
        if (var9_9 == null) {
            this.error2(var3_3, 2014, "missing derivation", "simpleType", false);
            var9_9 = "restriction";
        }
        if (var10_10) {
            var4_4.setVariety(var9_9);
        }
        var19_19 = var3_3.getChildNodes();
        var20_20 = var19_19.getLength();
        var21_21 = false;
        var24_24 = null;
        var25_26 = 0;
        while (var25_26 < var20_20) {
            block43: {
                block34: {
                    block44: {
                        block45: {
                            var22_22 = (XMLNode)var19_19.item(var25_26);
                            if (var22_22.getNodeType() != 1) break block43;
                            var26_29 = (XMLElement)var22_22;
                            var27_31 = var26_29.getLocalName();
                            var28_33 = var26_29.getAttribute("value");
                            if (var27_31 == "annotation" && !var21_21) break block43;
                            if (var27_31 != "simpleType") break block44;
                            if (var9_9 != "restriction" && var9_9 != "list" || var10_10) break block45;
                            var10_10 = true;
                            var5_5 = this.parseSimpleType(var26_29);
                            if (var5_5 == null) {
                                return null;
                            }
                            var4_4 = XSDSimpleType.derivedFrom(var5_5, "", var9_9);
                            var4_4.setVariety(var9_9);
                            break block34;
                        }
                        if (var9_9 != "union") ** GOTO lbl151
                        var5_5 = this.parseSimpleType(var26_29);
                        if (var5_5 != null) {
                            var4_4.members.addElement(var5_5);
                        } else {
                            return null;
lbl151:
                            // 1 sources

                            this.error2(var3_3, 2014, var27_31, "simpleType", false);
                        }
                        break block34;
                    }
                    if (var9_9 == "restriction") {
                        if (!var10_10) {
                            var4_4 = new XSDSimpleType();
                            var4_4.setVariety(var9_9);
                            var10_10 = true;
                        }
                        try {
                            if (var27_31 == "pattern") {
                                var24_24 = var24_24 == null ? var28_33 : String.valueOf(var24_24) + "|" + var28_33;
                                break block34;
                            }
                            var4_4.setFacet(var27_31, var28_33);
                        }
                        catch (Exception v1) {
                            this.error2(var3_3, 2015, var27_31, "simpleType", false);
                        }
                    } else {
                        this.error2(var3_3, 2014, var27_31, "simpleType", false);
                    }
                }
                var21_21 = true;
            }
            ++var25_26;
        }
        if (!var10_10) {
            var4_4 = new XSDSimpleType();
            var4_4.setVariety(var9_9);
        }
        if (var24_24 != null) {
            try {
                var4_4.setFacet("pattern", (String)var24_24);
            }
            catch (Exception v2) {
                this.error2(var3_3, 2015, "pattern", "simpleType", false);
            }
        }
        if (var7_7 != null) {
            var4_4.setName(var7_7);
        }
        if (var8_8 != null) {
            var4_4.setID(var8_8);
        }
        if (var17_13 != null) {
            var4_4.annotation = var17_13;
        }
        return var4_4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void parseTopLevelElem(XMLElement var1_1, XMLSchemaNode var2_2, URL var3_3) throws XSDException {
        if (var1_1 == null) {
            return;
        }
        var4_4 = var1_1.getAttributes();
        var5_5 = var4_4.getLength();
        var7_6 = 0;
        while (var7_6 < var5_5) {
            var6_7 = (XMLAttr)var4_4.item(var7_6);
            if (var6_7.getPrefix() != "xmlns" && var6_7.getName() != "xmlns" && this.skipAttribute(var6_7.getLocalName(), var6_7.getNamespace())) {
                var6_7 = (XMLAttr)var6_7.cloneNode(true);
                this.doc.importNode(var6_7, true);
                var2_2.addAnnotationAttr(var6_7);
            }
            ++var7_6;
        }
        this.xsdNamespace = var1_1.getNamespace().intern();
        if (this.schemaxml.getSchemaNS() != null && this.xsdNamespace != this.schemaxml.getSchemaNS()) {
            this.error2(var1_1, 2030, "schema", this.xsdNamespace, false);
        }
        if (this.xsdNamespace != "http://www.w3.org/2000/10/XMLSchema" && this.xsdNamespace != "http://www.w3.org/2001/XMLSchema") {
            this.error2(var1_1, 2030, "schema", this.xsdNamespace, false);
        }
        this.schemaxml.setSchemaNS(this.xsdNamespace);
        var9_8 /* !! */  = null;
        var10_9 = var1_1.getChildNodes();
        var11_10 = var10_9.getLength();
        var12_11 = this.includingNS;
        var13_12 = this.schemaDefs.getTargetNSDefault();
        var14_13 = 0;
        while (var14_13 < var11_10) {
            block13: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block15: {
                                                    block14: {
                                                        var9_8 /* !! */  = null;
                                                        var8_14 = (XMLNode)var10_9.item(var14_13);
                                                        if (var8_14.getNodeType() != 1) break block13;
                                                        var15_15 = (XMLElement)var8_14;
                                                        var16_16 = var15_15.getLocalName();
                                                        if (var16_16 != "annotation") break block14;
                                                        var2_2.annotation = this.parseAnnotation(var15_15, var2_2.annotation);
                                                        break block13;
                                                    }
                                                    if (var16_16 != "complexType") break block15;
                                                    var9_8 /* !! */  = this.parseComplexType(var15_15);
                                                    ** GOTO lbl95
                                                }
                                                if (var16_16 != "element") break block16;
                                                var9_8 /* !! */  = this.parseElement(var15_15);
                                                ** GOTO lbl95
                                            }
                                            if (var16_16 != "attribute") break block17;
                                            var9_8 /* !! */  = this.parseAttribute(var15_15);
                                            ** GOTO lbl95
                                        }
                                        if (var16_16 != "simpleType") break block18;
                                        var9_8 /* !! */  = this.parseSimpleType(var15_15);
                                        if (var9_8 /* !! */  != null) ** GOTO lbl95
                                        var17_17 = new XSDSimpleType();
                                        var17_17.domNode = var15_15;
                                        var17_17.parent = var2_2;
                                        this.addUnresolvedNode(var17_17);
                                        break block13;
                                    }
                                    if (var16_16 != "group") break block19;
                                    var9_8 /* !! */  = this.parseGroup(var15_15);
                                    ** GOTO lbl95
                                }
                                if (var16_16 != "attributeGroup") break block20;
                                var9_8 /* !! */  = this.parseAttrGroup(var15_15);
                                ** GOTO lbl95
                            }
                            if (var16_16 != "include") break block21;
                            if (!var13_12.equals("")) {
                                this.includingNS = var13_12;
                            }
                            this.parseIncludeAndImport(var15_15, 1, var3_3);
                            this.includingNS = var12_11;
                            ** GOTO lbl95
                        }
                        if (var16_16 != "import") break block22;
                        this.redefine = false;
                        this.includingNS = "";
                        this.parseIncludeAndImport(var15_15, 2, var3_3);
                        this.redefine = this.schemaDefs.getModificationDefault();
                        this.includingNS = var12_11;
                        ** GOTO lbl95
                    }
                    if (var16_16 != "redefine") break block23;
                    this.redefine = true;
                    if (!var13_12.equals("")) {
                        this.includingNS = var13_12;
                    }
                    this.parseIncludeAndImport(var15_15, 1, var3_3);
                    this.redefine = this.schemaDefs.getModificationDefault();
                    this.parseRedefine(var15_15, var2_2);
                    this.includingNS = var12_11;
                    ** GOTO lbl95
                }
                if (var16_16 != "notation") {
                    this.error2(var1_1, 2027, var16_16, "schema", false);
                } else {
                    var9_8 /* !! */  = this.parseNotation(var15_15);
lbl95:
                    // 10 sources

                    if (var9_8 /* !! */  != null) {
                        if (var9_8 /* !! */ .domNode == null) {
                            var9_8 /* !! */ .domNode = var15_15;
                        }
                        if (var2_2.addComponent(var9_8 /* !! */ )) {
                            this.error(var15_15, 2209, var9_8 /* !! */ .name, false);
                        }
                    }
                }
            }
            ++var14_13;
        }
    }

    void resolveNodes() throws XSDException {
        int n = 0;
        boolean bl = false;
        int n2 = this.unresolvedNodes.size();
        String string = null;
        while (n2 > 0) {
            XSDNode xSDNode = (XSDNode)this.unresolvedNodes.elementAt(n);
            switch (xSDNode.nodeType) {
                case 3: {
                    XSDElement xSDElement = (XSDElement)xSDNode;
                    if (xSDElement.equivRefState == 5) {
                        xSDElement.resolveEquivClass(this.schemaxml);
                    }
                    if (xSDElement.equivRefState == 5) {
                        ++n;
                        break;
                    }
                    string = String.valueOf(xSDElement.refNamespace) + ":" + xSDElement.refLocalname;
                    if (xSDElement.refState == 1) {
                        xSDElement.resolveReference(this.schemaxml);
                    } else if (xSDElement.refState == 3) {
                        xSDElement.resolveTypeReference(this.schemaxml);
                    }
                    if (xSDElement.refState == 0 || xSDElement.refState == 2) {
                        this.checkTypeAndDefault(xSDElement.domNode, xSDElement);
                        if (xSDElement.nodeType == 4 && xSDElement.isTypeAbstract()) {
                            this.error(xSDElement.domNode, 2017, xSDElement.name, false);
                        }
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 4: {
                    XSDAttribute xSDAttribute = (XSDAttribute)xSDNode;
                    string = String.valueOf(xSDAttribute.refNamespace) + ":" + xSDAttribute.refLocalname;
                    if (xSDAttribute.refState == 1) {
                        xSDAttribute.resolveReference(this.schemaxml);
                    } else if (xSDAttribute.refState == 3) {
                        xSDAttribute.resolveTypeReference(this.schemaxml);
                    }
                    if (xSDAttribute.refState == 0 || xSDAttribute.refState == 2) {
                        this.unresolvedNodes.removeElementAt(n);
                        xSDAttribute.domNode = null;
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 5: {
                    XSDGroup xSDGroup = (XSDGroup)xSDNode;
                    string = String.valueOf(xSDGroup.refNamespace) + ":" + xSDGroup.refLocalname;
                    if (xSDGroup.refState == 1) {
                        xSDGroup.resolveReference(this.schemaxml);
                    }
                    if (xSDGroup.refState == 0) {
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 6: {
                    XSDAttrGroup xSDAttrGroup = (XSDAttrGroup)xSDNode;
                    string = String.valueOf(xSDAttrGroup.refNamespace) + ":" + xSDAttrGroup.refLocalname;
                    if (xSDAttrGroup.refState == 1) {
                        xSDAttrGroup.resolveReference(this.schemaxml);
                    }
                    if (xSDAttrGroup.refState == 0) {
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 2: {
                    XSDSimpleType xSDSimpleType = this.parseSimpleType(xSDNode.domNode);
                    if (xSDSimpleType != null) {
                        if (xSDNode.parent instanceof XMLSchemaNode) {
                            ((XMLSchemaNode)xSDNode.parent).addComponent(xSDSimpleType);
                        } else if (xSDNode.parent instanceof XSDElement) {
                            ((XSDElement)xSDNode.parent).setSimpleType(xSDSimpleType);
                            xSDSimpleType.parent = xSDNode;
                        }
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
                case 1: {
                    XSDComplexType xSDComplexType = (XSDComplexType)xSDNode;
                    string = String.valueOf(xSDComplexType.refNamespace) + ":" + xSDComplexType.refLocalname;
                    XSDComplexType xSDComplexType2 = (XSDComplexType)this.schemaxml.getComponent(xSDComplexType.refNamespace, xSDComplexType.refLocalname, 1);
                    if (!(xSDComplexType2 == null || xSDComplexType2.isNodeType(1) && xSDComplexType2.refState != 6)) {
                        xSDComplexType.setBaseType(xSDComplexType2);
                        this.parseComplexTypeContent(xSDComplexType, xSDComplexType.domNode);
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    XSDSimpleType xSDSimpleType = (XSDSimpleType)this.schemaxml.getComponent(xSDComplexType.refNamespace, xSDComplexType.refLocalname, 2);
                    if (xSDSimpleType != null) {
                        xSDComplexType.setBaseType(xSDSimpleType);
                        this.parseComplexTypeContent(xSDComplexType, xSDComplexType.domNode);
                        this.unresolvedNodes.removeElementAt(n);
                        bl = true;
                        --n2;
                        break;
                    }
                    ++n;
                    break;
                }
            }
            if (n != n2) continue;
            if (!bl && n2 == this.unresolvedNodes.size()) {
                if (this.unresolvedNodes.size() <= 0) break;
                this.error(xSDNode.domNode, 2028, string, false);
                break;
            }
            bl = false;
            n = 0;
            n2 = this.unresolvedNodes.size();
        }
    }

    private boolean sameTargetNS(XMLElement xMLElement, String string) {
        String string2 = xMLElement.getAttribute("targetNamespace");
        return string2 != null && string2.equals(string);
    }

    private void sendError(XMLElement xMLElement, int n, String string, boolean bl) throws XSDException {
        this.domLocator.setCurrentNode(xMLElement);
        this.err.error(n, 1, string);
        if (bl) {
            throw new XSDException();
        }
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entResolver = entityResolver;
    }

    public void setError(XMLError xMLError) {
        this.localErr = false;
        this.err = xMLError;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    boolean skipAttribute(String string, String string2) {
        return !string2.equals("") || string2.equals("") && string.equals("xmlns");
    }
}

