/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.math.BigDecimal;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDTypeConstants;

public class XSDDataValue
implements XSDTypeConstants {
    int basicType;
    String name;
    private boolean booleanValue;
    private double doubleValue;
    private BigDecimal decimalValue;
    private String lexicalValue;
    private boolean timeZoon;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int minDays;
    private int maxDays;
    private float second;
    private int specialVal;
    static final String _true = "true";
    static final String _false = "false";
    static final int[] mDays = new int[]{31, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int[] minMonthDay;
    static final int[] maxMonthDay;
    static final double FLOATMAX;
    static final double DOUBLEMAX;

    static {
        int[] nArray = new int[13];
        nArray[1] = 28;
        nArray[2] = 59;
        nArray[3] = 89;
        nArray[4] = 120;
        nArray[5] = 150;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 242;
        nArray[9] = 273;
        nArray[10] = 303;
        nArray[11] = 334;
        nArray[12] = 365;
        minMonthDay = nArray;
        int[] nArray2 = new int[13];
        nArray2[1] = 31;
        nArray2[2] = 62;
        nArray2[3] = 92;
        nArray2[4] = 123;
        nArray2[5] = 153;
        nArray2[6] = 184;
        nArray2[7] = 215;
        nArray2[8] = 245;
        nArray2[9] = 276;
        nArray2[10] = 306;
        nArray2[11] = 337;
        nArray2[12] = 366;
        maxMonthDay = nArray2;
        FLOATMAX = Math.pow(2.0, 24.0) * Math.pow(2.0, 104.0);
        DOUBLEMAX = Math.pow(2.0, 53.0) * Math.pow(2.0, 970.0);
    }

    XSDDataValue(int n, String string) throws Exception {
        this.lexicalValue = string.intern();
        this.basicType = n;
        this.name = XSDTypeConstants.sTypes[this.basicType];
        switch (this.basicType) {
            case 2: {
                String string2 = this.lexicalValue.toLowerCase().intern();
                if (string2 == _true || string2.equals("1")) {
                    this.booleanValue = true;
                    break;
                }
                if (string2 == _false || string2.equals("0")) {
                    this.booleanValue = false;
                    break;
                }
                throw new XSDException(2207, string, this.name);
            }
            case 3: 
            case 4: {
                if (string.equals("-INF")) {
                    this.specialVal = 1;
                } else if (string.equals("-0")) {
                    this.specialVal = 2;
                } else if (string.equals("+0")) {
                    this.specialVal = 3;
                } else if (string.equals("INF")) {
                    this.specialVal = 4;
                } else if (string.equals("NaN")) {
                    this.specialVal = 5;
                }
                if (this.specialVal > 0) break;
                this.doubleValue = Double.valueOf(string);
                double d = Math.abs(this.doubleValue);
                if (!(this.basicType == 3 && d > FLOATMAX) && !(d > DOUBLEMAX)) break;
                throw new XSDException(2207, string, this.name);
            }
            case 5: {
                if (string.toLowerCase().indexOf(101) >= 0) {
                    throw new XSDException(2207, string, this.name);
                }
                int n2 = string.length() - 1;
                if (string.charAt(0) == '+') {
                    this.lexicalValue = string.substring(1, n2).intern();
                } else if (string.charAt(n2) == '.') {
                    this.lexicalValue = string.substring(0, n2 - 1).intern();
                }
                this.decimalValue = new BigDecimal(this.lexicalValue);
                break;
            }
            case 6: {
                this.parseTimeDuration(string);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.parseTimeInstant(string);
                break;
            }
            default: {
                throw new XSDException(2207, string, this.name);
            }
            case 0: 
            case 1: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
        }
    }

    private int compareSpecial(int n, double d) {
        switch (n) {
            case 1: {
                return -1;
            }
            case 2: {
                return d >= 0.0 ? -1 : 1;
            }
            case 3: {
                return d > 0.0 ? -1 : 1;
            }
            case 4: 
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int compareTo(XSDDataValue xSDDataValue) throws XSDException {
        if (this.basicType != xSDDataValue.basicType) {
            throw new XSDException(2900, "01");
        }
        switch (this.basicType) {
            case 0: {
                return 0;
            }
            case 1: {
                if (this.lexicalValue == xSDDataValue.lexicalValue) {
                    return 0;
                }
                return -1;
            }
            case 2: {
                if (this.booleanValue == xSDDataValue.booleanValue) {
                    return 0;
                }
                return -1;
            }
            case 3: 
            case 4: {
                if (this.specialVal > 0 && xSDDataValue.specialVal > 0) {
                    return this.specialVal - xSDDataValue.specialVal;
                }
                if (this.specialVal > 0) {
                    return this.compareSpecial(this.specialVal, xSDDataValue.doubleValue);
                }
                if (xSDDataValue.specialVal > 0) {
                    return this.compareSpecial(xSDDataValue.specialVal, this.doubleValue);
                }
                if (this.doubleValue - xSDDataValue.doubleValue > 0.0) {
                    return 1;
                }
                if (this.doubleValue - xSDDataValue.doubleValue < 0.0) {
                    return -1;
                }
                return 0;
            }
            case 5: {
                return this.decimalValue.compareTo(xSDDataValue.decimalValue);
            }
            case 6: {
                if (this.minDays > xSDDataValue.maxDays) {
                    return 1;
                }
                if (this.maxDays < xSDDataValue.minDays) {
                    return -1;
                }
                if (this.minDays == xSDDataValue.minDays && this.maxDays == xSDDataValue.maxDays) {
                    if (this.minute > xSDDataValue.minute) {
                        return 1;
                    }
                    if (this.minute < xSDDataValue.minute) {
                        return -1;
                    }
                    return (int)(this.second - xSDDataValue.second);
                }
                return 0;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (this.year > xSDDataValue.year) {
                    return 1;
                }
                if (this.year < xSDDataValue.year) {
                    return -1;
                }
                if (this.month > xSDDataValue.month) {
                    return 1;
                }
                if (this.month < xSDDataValue.month) {
                    return -1;
                }
                if (this.day > xSDDataValue.day) {
                    return 1;
                }
                if (this.day < xSDDataValue.day) {
                    return -1;
                }
                if (this.hour > xSDDataValue.hour) {
                    return 1;
                }
                if (this.hour < xSDDataValue.hour) {
                    return -1;
                }
                if (this.minute > xSDDataValue.minute) {
                    return 1;
                }
                if (this.minute < xSDDataValue.minute) {
                    return -1;
                }
                if (this.second > xSDDataValue.second) {
                    return 1;
                }
                if (this.second < xSDDataValue.second) {
                    return -1;
                }
                return 0;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (this.lexicalValue == xSDDataValue.lexicalValue) {
                    return 0;
                }
                return -1;
            }
        }
        throw new XSDException(2900, "01");
    }

    public String getEncoding() {
        return "";
    }

    public int getLength() throws XSDException {
        switch (this.basicType) {
            case 1: {
                return this.lexicalValue.length();
            }
            case 15: 
            case 16: {
                return this.lexicalValue.length();
            }
            case 17: 
            case 19: {
                return this.lexicalValue.length();
            }
        }
        throw new XSDException(2900, "");
    }

    public String getLexicalValue() {
        return this.lexicalValue;
    }

    public int getPrecision() throws XSDException {
        if (this.basicType != 5) {
            throw new XSDException(2900, "");
        }
        int n = this.lexicalValue.length();
        if (this.lexicalValue.indexOf(45) >= 0) {
            --n;
        }
        if (this.lexicalValue.indexOf(46) >= 0) {
            --n;
        }
        return n;
    }

    public int getScale() throws XSDException {
        if (this.basicType != 5) {
            throw new XSDException(2900, "");
        }
        int n = this.lexicalValue.length();
        int n2 = this.lexicalValue.indexOf(46);
        if (n2 >= 0) {
            return n - n2 - 1;
        }
        return 0;
    }

    private void parseTimeDuration(String string) throws XSDException {
        int n = 0;
        int n2 = 1;
        float f = 0.0f;
        if (string.charAt(n) == '-') {
            n2 = -1;
        }
        int n3 = ++n;
        ++n;
        if (string.charAt(n3) != 'P') {
            throw new XSDException(2207, string, this.name);
        }
        int n4 = string.indexOf(89, n);
        if (n4 >= 0) {
            f = Float.valueOf(string.substring(n, n4)).floatValue();
            n = n4 + 1;
            if (f < 0.0f) {
                throw new XSDException(2207, string, this.name);
            }
            this.minDays += (int)Math.floor(f) * 365;
            this.maxDays += (int)Math.ceil(f) * 366;
            f = (float)((double)f - Math.floor(f));
        }
        n4 = string.indexOf(77, n);
        int n5 = string.indexOf(84, n);
        if (n5 > 0 && n4 > n5) {
            n4 = -1;
        }
        n5 = string.length();
        if (n4 >= 0 && f == 0.0f) {
            f = Float.valueOf(string.substring(n, n4)).floatValue();
            n = n4 + 1;
            if (f < 0.0f) {
                throw new XSDException(2207, string, this.name);
            }
            this.month = (int)Math.floor(f);
            f -= (float)this.month;
            if (this.month > 12) {
                this.year = this.month / 12;
                this.month -= this.year * 12;
                this.minDays += this.year * 365;
                this.maxDays += this.year * 366;
            }
            this.minDays += minMonthDay[this.month];
            this.maxDays += maxMonthDay[this.month];
            if (f > 0.0f) {
                this.minDays = (int)((float)this.minDays + (float)(minMonthDay[this.month + 1] - minMonthDay[this.month]) * f);
                this.maxDays = (int)((float)this.maxDays + (float)(maxMonthDay[this.month + 1] - maxMonthDay[this.month]) * f);
            }
        }
        if ((n4 = string.indexOf(68, n)) >= 0 && f == 0.0f) {
            f = Float.valueOf(string.substring(n, n4)).floatValue();
            n = n4 + 1;
            if (f < 0.0f) {
                throw new XSDException(2207, string, this.name);
            }
            this.day = (int)Math.floor(f);
            f -= (float)this.day;
            this.minDays += this.day;
            this.maxDays += this.day;
            if (f > 0.0f) {
                f = f * 24.0f * 60.0f;
                this.minute = (int)Math.floor(f);
                this.second = (f - (float)this.minute) * 60.0f;
            }
        }
        if (n < n5 && string.charAt(n) == 'T' && f == 0.0f) {
            if ((n4 = string.indexOf(72, ++n)) >= 0 && f == 0.0f) {
                f = Float.valueOf(string.substring(n, n4)).floatValue();
                n = n4 + 1;
                if (f < 0.0f) {
                    throw new XSDException(2207, string, this.name);
                }
                this.minute = (int)Math.floor(f) * 60;
                this.second = f * 60.0f - (float)this.minute;
                f -= (float)Math.floor(f);
            }
            if ((n4 = string.indexOf(77, n)) > 0 && f == 0.0f) {
                f = Float.valueOf(string.substring(n, n4)).floatValue();
                if (f < 0.0f) {
                    throw new XSDException(2207, string, this.name);
                }
                this.minute += (int)Math.floor(f);
                f -= (float)Math.floor(f);
                this.second += f * 60.0f;
                n = n4 + 1;
            }
            if ((n4 = string.indexOf(83, n)) > 0 && f == 0.0f) {
                this.second += Float.valueOf(string.substring(n, n4)).floatValue();
                n = n4 + 1;
            }
        }
        if (n != n5) {
            throw new XSDException(2207, string, this.name);
        }
        if (n2 < 0) {
            int n6 = this.minDays;
            this.minDays = n2 * this.maxDays;
            this.maxDays = n2 * n6;
            this.minute = n2 * this.minute;
            this.second = (float)n2 * this.second;
        }
    }

    private void parseTimeInstant(String string) throws XSDException {
        int n;
        int n2;
        int n3;
        block33: {
            block36: {
                block37: {
                    block35: {
                        block34: {
                            n3 = 0;
                            n2 = string.length();
                            n = 0;
                            int n4 = 1;
                            if (this.basicType == 8) break block33;
                            if (this.basicType != 9 && this.basicType != 7 && this.basicType != 11 && this.basicType != 10) break block34;
                            n = string.indexOf(45);
                            if (n == 0) {
                                n4 = -1;
                                n3 = 1;
                            }
                            if ((n = string.indexOf(45, n3)) < 0) {
                                n = string.indexOf(84);
                            }
                            if (n < 0) {
                                n = string.indexOf(90);
                            }
                            if (n < 0) {
                                n = string.indexOf(43);
                            }
                            if (n < 0) {
                                n = n2;
                            }
                            this.year = n4 * Integer.parseInt(string.substring(n3, n));
                            if (this.year == 0) {
                                throw new XSDException(2207, string, this.name);
                            }
                            n3 = n + 1;
                            if (this.basicType != 11) break block35;
                            break block33;
                        }
                        if (string.charAt(0) != '-' || string.charAt(1) != '-') {
                            throw new XSDException(2207, string, this.name);
                        }
                        n3 = this.basicType != 14 ? 2 : 3;
                    }
                    if (this.basicType == 14) break block36;
                    n = n3 + 2;
                    this.month = Integer.parseInt(string.substring(n3, n));
                    if (this.month <= 0 || this.month > 12) {
                        throw new XSDException(2207, string, this.name);
                    }
                    n3 = n + 1;
                    if (this.basicType != 12) break block37;
                    if (string.charAt(n3++) != '-') {
                        throw new XSDException(2207, string, this.name);
                    }
                    n = n3;
                    break block33;
                }
                if (this.basicType == 10) break block33;
            }
            n = n3 + 2;
            this.day = Integer.parseInt(string.substring(n3, n));
            if (this.day <= 0 || this.day > mDays[this.month]) {
                throw new XSDException(2207, string, this.name);
            }
            if (this.month == 2 && this.day == 29 && (this.year % 4 != 0 || this.year % 100 == 0 && this.year % 400 != 0)) {
                throw new XSDException(2207, string, this.name);
            }
            n3 = n + 1;
        }
        if (this.basicType == 8 || this.basicType == 7) {
            if (this.basicType != 8 && string.charAt(n) != 'T') {
                throw new XSDException(2207, string, this.name);
            }
            n = n3 + 2;
            this.hour = Integer.parseInt(string.substring(n3, n));
            if (this.hour < 0 || this.hour > 23) {
                throw new XSDException(2207, string, this.name);
            }
            n3 = n + 1;
            n = string.indexOf(58, n3);
            this.minute = Integer.parseInt(string.substring(n3, n));
            if (this.minute < 0 || this.minute > 59) {
                throw new XSDException(2207, string, this.name);
            }
            n3 = n + 1;
            if ((n = string.indexOf(90, n3)) < 0) {
                n = string.indexOf(45, n3);
            }
            if (n < 0) {
                n = string.indexOf(43, n3);
            }
            if (n < 0) {
                n = n2;
            }
            this.second = Float.valueOf(string.substring(n3, n)).floatValue();
            if (this.second < 0.0f || this.second > 59.0f) {
                throw new XSDException(2207, string, this.name);
            }
        }
        if (n < n2) {
            this.timeZoon = true;
            if (++n < n2) {
                int n5 = Integer.parseInt(string.substring(n, n2));
                if (n5 > 12 || n5 < -12) {
                    throw new XSDException(2207, string, this.name);
                }
                this.hour += n5;
                if (this.hour < 0) {
                    this.hour = 24 + this.hour;
                    --this.day;
                    if (this.day == 0) {
                        int n6 = this.month = this.month == 1 ? 12 : this.month - 1;
                        if (this.month == 12) {
                            this.year = this.year == 1 ? -1 : this.year - 1;
                        }
                        this.day = mDays[this.month];
                    }
                } else if (this.hour > 23) {
                    this.hour -= 24;
                    ++this.day;
                    if (this.day > mDays[this.month]) {
                        this.day = 1;
                        int n7 = this.month = this.month == 12 ? 1 : this.month + 1;
                        if (this.month == 1) {
                            this.year = this.year == -1 ? 1 : this.year + 1;
                        }
                    }
                }
            }
        }
    }
}

