/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.util.FastVector;

public class XSDElement
extends XSDNode
implements XSDParticleNode,
XSDTypeConstants {
    int qualified;
    XSDSimpleType simpleType;
    XSDComplexType complexType;
    int type;
    String refNamespace;
    String refLocalname;
    int refState;
    String defaultVal;
    String fixedVal;
    int minOccurs;
    int maxOccurs;
    boolean bAbstract;
    boolean bNullable;
    String sBlock;
    String sFinal;
    Vector equivClass;
    String equivRefNamespace;
    String equivRefLocalname;
    int equivRefState;
    Vector identities;
    String expandedName;
    FastVector ptable;
    static int[][] pathSet = new int[1024][];

    XSDElement() {
        this.init();
    }

    XSDElement(int n) {
        this.init();
        this.nodeType = n;
        if (this.nodeType == 4) {
            this.minOccurs = 0;
            this.maxOccurs = 1;
        }
    }

    XSDElement(String string, String string2) {
        super(string, string2);
        this.init();
    }

    XSDElement(XSDAttribute xSDAttribute) {
        this(4);
        this.simpleType = xSDAttribute.simpleType;
        this.complexType = null;
        this.type = 2;
        this.minOccurs = xSDAttribute.minOccurs;
        this.maxOccurs = 1;
        this.name = xSDAttribute.name;
        this.qualified = xSDAttribute.qualified;
        this.defaultVal = xSDAttribute.defaultVal;
        this.fixedVal = xSDAttribute.fixedVal;
        this.parent = xSDAttribute.parent;
        this.refLocalname = xSDAttribute.refLocalname;
        this.refNamespace = xSDAttribute.refNamespace;
        this.refState = xSDAttribute.refState;
    }

    void addIdentity(XSDIdentity xSDIdentity) {
        if (this.identities == null) {
            this.identities = new Vector(10);
        }
        this.identities.addElement(xSDIdentity);
    }

    static void addPath(Hashtable hashtable, XSDNode xSDNode, int n) {
        int[] nArray;
        int[] nArray2 = (int[])hashtable.get(xSDNode);
        if (nArray2 != null) {
            int n2 = nArray2.length;
            nArray = new int[n2 + 1];
            System.arraycopy(nArray2, 0, nArray, 0, n2);
            nArray[n2] = n;
        } else if (n < 1024) {
            nArray = pathSet[n];
            if (nArray == null) {
                nArray = new int[]{n};
                XSDElement.pathSet[n] = nArray;
            }
        } else {
            nArray = new int[]{n};
        }
        hashtable.put(xSDNode, nArray);
    }

    void addToEquivClass(XSDParticleNode xSDParticleNode) {
        this.equivClass.addElement(xSDParticleNode);
    }

    boolean buildPathTable(FastVector fastVector, byte[] byArray, int n) throws Exception {
        if (fastVector != null) {
            byArray[fastVector.size()] = (byte)(n + 1);
            fastVector.addElement(this);
        }
        if (!this.isClean) {
            XSDGroup xSDGroup;
            this.isClean = true;
            this.domNode = null;
            XSDNode xSDNode = this.getType();
            if (xSDNode.isNodeType(1) && (xSDGroup = ((XSDComplexType)xSDNode).getGroup()) != null) {
                xSDGroup.buildPathTable(null, null, 0);
            }
        }
        return true;
    }

    void buildPaths(Hashtable hashtable, int n) {
        XSDElement.addPath(hashtable, this, n);
        if (this.equivClass != null) {
            int n2 = this.equivClass.size();
            int n3 = 0;
            while (n3 < n2) {
                XSDNode xSDNode = (XSDNode)this.equivClass.elementAt(n3);
                if (xSDNode != this) {
                    XSDElement.addPath(hashtable, xSDNode, n);
                }
                ++n3;
            }
        }
    }

    public XSDElement findEquivClass(String string, String string2) {
        String string3 = this.getTargetNS();
        String string4 = this.getName();
        if (string3.equals(string) && string4.equals(string2) && !this.bAbstract) {
            return this;
        }
        int n = this.equivClass.size();
        int n2 = 0;
        while (n2 < n) {
            XSDElement xSDElement = ((XSDElement)this.equivClass.elementAt(n2)).findEquivClass(string, string2);
            if (xSDElement != null) {
                return xSDElement;
            }
            ++n2;
        }
        return null;
    }

    int getContent() {
        if (this.type == 1) {
            return this.complexType.content;
        }
        return 11;
    }

    public String getDefaultVal() {
        return this.defaultVal;
    }

    public String getEquivClassRef() {
        return this.equivRefLocalname;
    }

    String getExpandedName() {
        if (this.expandedName == null) {
            this.expandedName = String.valueOf(this.getTargetNS()) + ":" + this.getName();
        }
        return this.expandedName;
    }

    public String getFixedVal() {
        return this.fixedVal;
    }

    int getForm() {
        return this.qualified;
    }

    public XSDIdentity[] getIdentities() {
        if (this.identities == null) {
            return null;
        }
        Object[] objectArray = new XSDIdentity[this.identities.size()];
        this.identities.copyInto(objectArray);
        return objectArray;
    }

    XSDNode getMatchingNode(XMLSchema xMLSchema, String string, String string2) throws XSDException {
        String string3 = this.getTargetNS();
        String string4 = this.getName();
        if (this.nodeType == 4) {
            if (string3.equals(string) && string4.equals(string2)) {
                return this;
            }
            return null;
        }
        return this.findEquivClass(string, string2);
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    int getNIdentities() {
        if (this.identities == null) {
            return 0;
        }
        return this.identities.size();
    }

    public String getName() {
        if (this.refState == 0 && this.refLocalname != null) {
            return this.refLocalname;
        }
        return this.name;
    }

    public String getRefLocalname() {
        return this.refLocalname;
    }

    public String getRefNamespace() {
        return this.refNamespace;
    }

    public int getRefState() {
        return this.refState;
    }

    public Vector getSubstitutionGroup() {
        return this.equivClass;
    }

    public String getTargetNS() {
        if (this.refState == 0 && this.refNamespace != null) {
            return this.refNamespace;
        }
        if (this.qualified == 1) {
            return this.parent.getTargetNS();
        }
        return "";
    }

    public XSDNode getType() {
        if (this.type == 1) {
            return this.complexType;
        }
        return this.simpleType;
    }

    boolean hasIdentityContraints() {
        return this.identities == null || this.identities.isEmpty();
    }

    private void init() {
        this.nodeType = 3;
        this.minOccurs = 1;
        this.maxOccurs = 1;
        this.defaultVal = null;
        this.fixedVal = null;
        this.sFinal = "#undef";
        this.sBlock = "#undef";
        this.complexType = null;
        this.simpleType = XSDSimpleType.urType;
        this.bNullable = false;
        this.bAbstract = false;
        this.qualified = 1;
        this.type = 2;
        this.refState = 2;
        this.equivRefState = 4;
        this.equivClass = new Vector(10);
    }

    public boolean isAbstract() {
        return this.bAbstract;
    }

    public boolean isNullable() {
        return this.bNullable;
    }

    boolean isTypeAbstract() throws XSDException {
        if (this.type == 1) {
            return this.complexType.bAbstract;
        }
        if (this.type == 2) {
            return this.simpleType.bAbstract;
        }
        throw new XSDException();
    }

    int postProcess(FastVector fastVector, Hashtable hashtable) throws Exception {
        XSDNode xSDNode;
        if (this.isClean) {
            this.targetNS = this.getTargetNS();
        }
        if (!this.isTopLevel()) {
            xSDNode = (XSDElement)hashtable.get(this);
            if (xSDNode != null && xSDNode != this) {
                if (this.refLocalname == null || this.refNamespace == null || !this.refLocalname.equals(((XSDElement)xSDNode).refLocalname) || !this.refNamespace.equals(((XSDElement)xSDNode).refNamespace)) {
                    throw new XSDException(2209, this.name, this.domNode);
                }
            } else {
                hashtable.put(this, this);
            }
        }
        if (!this.isClean) {
            return 1;
        }
        this.isClean = false;
        xSDNode = this.getType();
        if (xSDNode.isNodeType(1)) {
            fastVector.addElement(this);
        }
        return 1;
    }

    void print(int n) {
        boolean bl = false;
        this.printSTag(n);
        if (this.bAbstract) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "abstract = true");
        } else {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "abstract = false");
        }
        if (this.sBlock != "#undef") {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "block =" + this.sBlock);
        }
        if (this.sFinal != "#undef") {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "final = " + this.sFinal);
        }
        if (this.defaultVal != null) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "default =" + this.defaultVal);
        }
        if (this.fixedVal != null) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "fixed = " + this.fixedVal);
        }
        switch (this.qualified) {
            case 0: {
                System.out.println(String.valueOf(XSDNode.indent(n)) + "form = " + "unqualified");
                break;
            }
            case 1: {
                System.out.println(String.valueOf(XSDNode.indent(n)) + "form = " + "qualified");
                break;
            }
        }
        System.out.println(String.valueOf(XSDNode.indent(n)) + "minOccurs = " + this.minOccurs);
        System.out.println(String.valueOf(XSDNode.indent(n)) + "maxOccurs = " + this.maxOccurs);
        if (this.bNullable) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "nullable = true");
        } else {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "nullable = false");
        }
        switch (this.refState) {
            case 2: 
            case 3: {
                if (this.refLocalname == null) break;
                bl = true;
                System.out.print(String.valueOf(XSDNode.indent(n)) + "type = " + this.refNamespace);
                System.out.println(":" + this.refLocalname);
                break;
            }
            case 0: 
            case 1: {
                if (this.refLocalname == null) break;
                bl = true;
                System.out.print(String.valueOf(XSDNode.indent(n)) + "ref = " + this.refNamespace);
                System.out.println(":" + this.refLocalname);
                break;
            }
        }
        if (this.equivRefLocalname != null) {
            System.out.print(String.valueOf(XSDNode.indent(n)) + "equivClass = " + this.equivRefNamespace);
            System.out.println(":" + this.equivRefLocalname);
        }
        int n2 = 0;
        if (this.equivClass != null) {
            n2 = this.equivClass.size();
        }
        if (n2 != 0) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "equivClassSize = " + n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "equivClassName = " + ((XSDNode)this.equivClass.elementAt(n3)).getTargetNS() + ":" + ((XSDNode)this.equivClass.elementAt(n3)).getName());
            ++n3;
        }
        this.printSTagEnd(n);
        switch (this.type) {
            case 1: {
                if (bl) break;
                this.complexType.print(n + 3);
                break;
            }
            case 2: {
                if (bl) break;
                this.simpleType.print(n + 3);
                break;
            }
        }
        if (this.identities != null) {
            int n4 = 0;
            while (n4 < this.identities.size()) {
                ((XSDIdentity)this.identities.elementAt(n4)).print(n + 3);
                ++n4;
            }
        }
        this.printETag(n);
    }

    void resolveEquivClass(XMLSchema xMLSchema) {
        XSDElement xSDElement = xMLSchema.getElement(this.equivRefNamespace, this.equivRefLocalname);
        if (xSDElement != null && xSDElement.equivRefState == 4) {
            while (xSDElement != null) {
                xSDElement.addToEquivClass(this);
                xSDElement = xSDElement.equivRefLocalname != null ? xMLSchema.getElement(xSDElement.equivRefNamespace, xSDElement.equivRefLocalname) : null;
            }
            this.equivRefState = 4;
        }
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDElement xSDElement = (XSDElement)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDElement != null) {
            if (xSDElement.refState == 3) {
                xSDElement.resolveTypeReference(xMLSchema);
            }
            if (xSDElement.refState == 3) {
                return;
            }
            this.setType(xSDElement.getType());
            this.name = xSDElement.name;
            if (this.defaultVal == null && this.fixedVal == null) {
                this.defaultVal = xSDElement.defaultVal;
                this.fixedVal = xSDElement.fixedVal;
            }
            this.bNullable = xSDElement.bNullable;
            this.sBlock = xSDElement.sBlock;
            this.bAbstract = xSDElement.bAbstract;
            if (this.identities == null) {
                this.identities = xSDElement.identities;
            }
            this.equivClass = xSDElement.equivClass;
            this.refState = 0;
        }
    }

    void resolveTypeReference(XMLSchema xMLSchema) throws XSDException {
        XSDNode xSDNode = xMLSchema.getType(this.refNamespace, this.refLocalname, 1);
        if (xSDNode == null) {
            xSDNode = xMLSchema.getType(this.refNamespace, this.refLocalname, 2);
        }
        if (xSDNode != null) {
            if (xSDNode.isNodeType(2)) {
                this.setSimpleType((XSDSimpleType)xSDNode);
            } else {
                this.setComplexType((XSDComplexType)xSDNode);
            }
        }
    }

    void setAbstract(boolean bl) {
        this.bAbstract = bl;
    }

    void setBlock(String string) {
        this.sBlock = string.intern();
    }

    void setComplexType(XSDComplexType xSDComplexType) {
        this.complexType = xSDComplexType;
        this.type = 1;
        this.refState = 2;
    }

    void setDefault(String string) {
        this.defaultVal = string.intern();
    }

    void setEquivClassRef(String string, String string2) {
        this.equivRefLocalname = string2.intern();
        this.equivRefNamespace = string.intern();
        this.equivRefState = 5;
    }

    void setFinal(String string) {
        this.sFinal = string.intern();
    }

    void setFixed(String string) {
        this.fixedVal = string;
    }

    void setForm(String string) {
        this.qualified = string.equals("qualified") ? 1 : 0;
    }

    public void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    public void setMinOccurs(int n) {
        this.minOccurs = n;
    }

    void setNullable(boolean bl) {
        this.bNullable = bl;
    }

    void setRef(String string, String string2) {
        this.refLocalname = string2.intern();
        this.refNamespace = string.intern();
        this.refState = 1;
    }

    void setSimpleType(XSDSimpleType xSDSimpleType) {
        this.simpleType = xSDSimpleType;
        this.type = 2;
        this.refState = 2;
    }

    void setType(XSDNode xSDNode) {
        if (xSDNode.isNodeType(1)) {
            this.setComplexType((XSDComplexType)xSDNode);
        } else {
            this.setSimpleType((XSDSimpleType)xSDNode);
        }
    }

    void setTypeRef(String string, String string2) {
        this.refLocalname = string2.intern();
        this.refNamespace = string.intern();
        this.refState = 3;
    }
}

