/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.util.FastVector;

public class XSDGroup
extends XSDNode
implements XSDParticleNode {
    String refNamespace;
    String refLocalname;
    int refState;
    int order = 0;
    int minOccurs = 1;
    int maxOccurs = 1;
    Vector nodeVector;
    int[] offsets;
    int vectorSize = 0;
    int width;
    Hashtable pathTable;
    FastVector elemList;
    byte[] viLevel;
    boolean optional = false;
    boolean topGroup = false;
    boolean allElement;

    XSDGroup() {
        this(5);
    }

    XSDGroup(int n) {
        this.nodeType = n;
        if (this.nodeType == 6) {
            this.order = 2;
        }
        this.nodeVector = new Vector(10);
        this.refState = 0;
    }

    void addParticleNode(XSDParticleNode xSDParticleNode) {
        this.nodeVector.addElement(xSDParticleNode);
        this.vectorSize = this.nodeVector.size();
        if (((XSDNode)((Object)xSDParticleNode)).parent == null) {
            ((XSDNode)((Object)xSDParticleNode)).parent = this;
        }
    }

    boolean buildPathTable(FastVector fastVector, byte[] byArray, int n) throws Exception {
        int n2;
        if (this.topGroup) {
            if (this.isClean || this.width == 0) {
                return false;
            }
            if (this.elemList == null) {
                this.elemList = new FastVector(this.width);
            } else {
                this.elemList.setSize(0);
            }
            this.viLevel = new byte[this.width];
            fastVector = this.elemList;
            byArray = this.viLevel;
            n = 0;
        } else {
            ++n;
        }
        int n3 = fastVector.size();
        this.isClean = true;
        this.allElement = true;
        int n4 = this.length();
        boolean bl = true;
        boolean bl2 = false;
        int n5 = -1;
        int n6 = 0;
        while (n6 < n4) {
            XSDNode xSDNode = (XSDNode)this.nodeVector.elementAt(n6);
            if (!xSDNode.buildPathTable(fastVector, byArray, n)) {
                this.allElement = false;
            }
            if (this.minOccurs(n6) == 0) {
                bl2 = true;
            } else {
                bl = false;
            }
            if (this.order == 0 && this.minOccurs(n6) > 0 && n5 < 0) {
                n5 = fastVector.size();
            }
            ++n6;
        }
        if (n5 < 0) {
            n5 = fastVector.size();
        }
        int n7 = n3;
        while (n7 < n5) {
            if (byArray[n7] == n + 1) {
                byArray[n7] = (byte)n;
            }
            ++n7;
        }
        if (this.topGroup) {
            if (this.pathTable != null) {
                this.pathTable.clear();
            } else {
                this.pathTable = new Hashtable((int)((double)this.width * 1.5));
            }
            n4 = fastVector.size();
            n2 = 0;
            while (n2 < n4) {
                ((XSDNode)fastVector.elementAt(n2)).buildPaths(this.pathTable, n2);
                ++n2;
            }
        }
        if (!this.allElement) {
            if (this.offsets == null || this.offsets.length <= n4) {
                this.offsets = new int[n4];
            }
            n7 = 0;
            n4 = this.length();
            n2 = 0;
            while (n2 < n4) {
                this.offsets[n2] = n7 += ((XSDNode)this.nodeVector.elementAt(n2)).getWidth();
                ++n2;
            }
        }
        this.optional = false;
        this.optional = this.minOccurs == 0 || n4 == 0 ? true : (this.order == 1 ? bl2 : bl);
        if (this.optional) {
            this.minOccurs = 0;
        }
        return false;
    }

    int getBranch(int n) {
        if (n < 0 || n >= this.width) {
            return -1;
        }
        if (this.allElement) {
            return n;
        }
        int n2 = 0;
        while (n2 < this.vectorSize) {
            if (n < this.offsets[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public Vector getNodeVector() {
        return this.nodeVector;
    }

    int getOffset(int n) {
        if (n == 0) {
            return 0;
        }
        return this.offsets[n - 1];
    }

    public int getOrder() {
        return this.order;
    }

    int getWidth() {
        return this.width;
    }

    XSDParticleNode item(int n) {
        if (n >= 0 && n < this.vectorSize) {
            return (XSDParticleNode)this.nodeVector.elementAt(n);
        }
        return null;
    }

    int length() {
        return this.nodeVector.size();
    }

    int maxOccurs(int n) {
        if (n >= 0 && n < this.vectorSize) {
            return ((XSDParticleNode)this.nodeVector.elementAt(n)).getMaxOccurs();
        }
        return -1;
    }

    int minOccurs(int n) {
        if (n >= 0 && n < this.vectorSize) {
            return ((XSDParticleNode)this.nodeVector.elementAt(n)).getMinOccurs();
        }
        return -1;
    }

    int postProcess(FastVector fastVector, Hashtable hashtable) throws Exception {
        if (this.topGroup) {
            if (!this.isClean) {
                return this.width;
            }
            hashtable.clear();
        }
        this.isClean = false;
        int n = this.length();
        this.width = 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = ((XSDNode)this.nodeVector.elementAt(n2)).postProcess(fastVector, hashtable);
            this.width += n3;
            ++n2;
        }
        return this.width;
    }

    void print(int n) {
        boolean bl = false;
        if (this.refLocalname != null) {
            bl = true;
        }
        if (!bl && this.vectorSize == 0) {
            return;
        }
        this.printSTag(n);
        if (this.refLocalname != null) {
            System.out.print(String.valueOf(XSDNode.indent(n)) + "ref = " + this.refNamespace);
            System.out.println(":" + this.refLocalname);
        }
        switch (this.order) {
            case 2: {
                System.out.println(String.valueOf(XSDNode.indent(n)) + "order = " + "all");
                break;
            }
            case 0: {
                System.out.println(String.valueOf(XSDNode.indent(n)) + "order = " + "sequence");
                break;
            }
            case 1: {
                System.out.println(String.valueOf(XSDNode.indent(n)) + "order = " + "choice");
                break;
            }
        }
        System.out.println(String.valueOf(XSDNode.indent(n)) + "minOccurs = " + this.minOccurs);
        System.out.println(String.valueOf(XSDNode.indent(n)) + "maxOccurs = " + this.maxOccurs);
        this.printSTagEnd(n);
        if (!bl) {
            int n2 = 0;
            while (n2 < this.vectorSize) {
                ((XSDNode)this.nodeVector.elementAt(n2)).print(n + 3);
                ++n2;
            }
        }
        this.printETag(n);
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDGroup xSDGroup = (XSDGroup)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDGroup != null) {
            this.refState = 0;
            xSDGroup = (XSDGroup)xSDGroup.item(0);
            this.nodeVector = xSDGroup.nodeVector;
            this.vectorSize = xSDGroup.vectorSize;
            this.order = xSDGroup.order;
        }
    }

    public void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    public void setMinOccurs(int n) {
        this.minOccurs = n;
    }

    void setParticleNode(XSDParticleNode xSDParticleNode, int n) {
        this.nodeVector.setElementAt(xSDParticleNode, n);
    }

    void setRef(String string, String string2) {
        this.refLocalname = string2;
        this.refNamespace = string;
        this.refState = 1;
    }
}

