/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.NodeList;

class XSDIdConstraintTable {
    XSDIdentity definition;
    Hashtable idInstances;
    XSDSimpleType[] keyTypes;
    int nkeys;

    XSDIdConstraintTable(XSDIdentity xSDIdentity) {
        this.definition = xSDIdentity;
        this.idInstances = new Hashtable();
        this.nkeys = xSDIdentity.nfields;
    }

    void addConstraint(XMLElement xMLElement) throws XSDException {
        NodeList nodeList;
        try {
            nodeList = xMLElement.selectNodes(this.definition.getSelectorExpr());
        }
        catch (XSLException xSLException) {
            throw new XSDException("XPath error");
        }
        NodeTable nodeTable = (NodeTable)this.idInstances.get(xMLElement);
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            XMLElement xMLElement2 = (XMLElement)nodeList.item(n2);
            nodeTable.addKeySequence(xMLElement2);
            ++n2;
        }
        this.idInstances.put(xMLElement, nodeTable);
    }

    void addElement(XMLElement xMLElement) {
        NodeTable nodeTable = new NodeTable();
        this.idInstances.put(xMLElement, nodeTable);
    }

    void validateIdConstraints() throws XSDException {
        Enumeration enumeration = this.idInstances.keys();
        while (enumeration.hasMoreElements()) {
            this.addConstraint((XMLElement)enumeration.nextElement());
        }
    }

    void validateKeyref(XSDIdConstraintTable xSDIdConstraintTable) throws XSDException {
        Enumeration enumeration = this.idInstances.elements();
        while (enumeration.hasMoreElements()) {
            NodeTable nodeTable = (NodeTable)enumeration.nextElement();
            int n = 0;
            while (n < nodeTable.len) {
                boolean bl = false;
                Enumeration enumeration2 = xSDIdConstraintTable.idInstances.elements();
                while (enumeration2.hasMoreElements()) {
                    NodeTable nodeTable2 = (NodeTable)enumeration2.nextElement();
                    if (!nodeTable2.findKeySeq(nodeTable.keySequences[n])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new XSDException("Key sequence not found in key reference");
                }
                ++n;
            }
        }
    }

    class NodeTable {
        XMLElement[] targetNodes;
        String[][] keySequences;
        int size = 16;
        int len = 0;

        NodeTable() {
            this.keySequences = new String[this.size][XSDIdConstraintTable.this.nkeys];
            this.targetNodes = new XMLElement[this.size];
        }

        void addKeySequence(XMLElement xMLElement) throws XSDException {
            this.ensureCapacity();
            this.targetNodes[this.len] = xMLElement;
            int n = XSDIdConstraintTable.this.definition.nodeType;
            int n2 = 0;
            while (n2 < XSDIdConstraintTable.this.nkeys) {
                NodeList nodeList;
                try {
                    nodeList = xMLElement.selectNodes(XSDIdConstraintTable.this.definition.getFieldExpr(n2));
                }
                catch (XSLException xSLException) {
                    throw new XSDException("XPathe error");
                }
                switch (nodeList.getLength()) {
                    case 0: {
                        if (n != 23 && n != 24) break;
                        throw new XSDException("empty key or keyref");
                    }
                    case 1: {
                        this.keySequences[this.len][n2] = ((XMLNode)nodeList.item(0)).getText();
                        break;
                    }
                    default: {
                        throw new XSDException("constraint is not unique");
                    }
                }
                ++n2;
            }
            if (n != 24) {
                n2 = 0;
                while (n2 < this.len) {
                    if (this.equalKeySeq(n2, this.len)) {
                        throw new XSDException("duplicate keys");
                    }
                    ++n2;
                }
            }
            ++this.len;
        }

        void ensureCapacity() {
            if (this.len >= this.size) {
                XMLElement[] xMLElementArray = this.targetNodes;
                String[][] stringArray = this.keySequences;
                this.targetNodes = new XMLElement[this.size * 2];
                this.keySequences = new String[this.size * 2][XSDIdConstraintTable.this.nkeys];
                System.arraycopy(xMLElementArray, 0, this.targetNodes, 0, this.size);
                System.arraycopy(stringArray, 0, this.keySequences, 0, this.size);
                this.size *= 2;
            }
        }

        boolean equalKeySeq(int n, int n2) {
            int n3 = 0;
            while (n3 < XSDIdConstraintTable.this.nkeys) {
                if (this.keySequences[n][n3].intern() != this.keySequences[n2][n3].intern()) {
                    return false;
                }
                ++n3;
            }
            return true;
        }

        boolean findKeySeq(String[] stringArray) {
            int n = 0;
            while (n < this.len) {
                boolean bl = true;
                int n2 = 0;
                while (n2 < XSDIdConstraintTable.this.nkeys) {
                    if (stringArray[n2].intern() != this.keySequences[n][n2].intern()) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

