/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDIdConstraintTable;
import oracle.xml.parser.schema.XSDIdentity;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLMultiHandler;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLProperties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XSDValidator
extends XMLMultiHandler
implements XSDConstantValues {
    private String charAll;
    private Hashtable idConstraints;
    private Locator locator;
    private ContentHandler cntHandler;
    private SAXAttrList saxAttrList;
    private XMLError err;
    private String lastNodeName;
    private XMLProperties xmlProp;
    private boolean fixedSchema;
    private XMLSchema schema;
    private XSDBuilder xsdBuilder;
    private URL baseUrl;
    private NSResolver nsResolver;
    private State[] st = new State[this.stateMax];
    private int curState;
    private State state;
    private int stateMax = 50;
    private XSDElement elementNode;
    private Hashtable[] nsDecl;
    private int nslen;
    private int elementDepth = -1;
    private int lastEvent;
    private XSDNode keyNode;
    private XSDNode anyNode;
    private XSDGroup simpleTypeGroup;
    private Hashtable attrTable;
    private String xsiNS;
    private DocumentBuilder docBuilder;
    private boolean internalDOM;
    private int buildNode;
    static final int STAG = 1;
    static final int ETAG = 2;
    static final int CHARS = 3;
    static final String _error = "error";

    public XSDValidator() throws XSDException {
        int n = 0;
        while (n < this.stateMax) {
            this.st[n] = new State();
            ++n;
        }
        this.anyNode = new XSDAny();
        this.keyNode = new XSDNode();
        this.curState = 0;
        this.state = this.st[this.curState];
        this.nsDecl = new Hashtable[10];
        this.attrTable = new Hashtable(10);
        this.nslen = -1;
        XSDAny xSDAny = new XSDAny();
        xSDAny.processContents = "strict";
        xSDAny.namespace = "##any";
        xSDAny.maxOccurs = 0x7FFFFFF8;
        this.state.set(xSDAny, null);
        this.state.length = 1;
        this.state.status = 18;
        this.simpleTypeGroup = new XSDGroup();
        this.simpleTypeGroup.order = 0;
        this.simpleTypeGroup.minOccurs = 1;
        this.simpleTypeGroup.maxOccurs = 1;
        this.simpleTypeGroup.addParticleNode(new XSDSimpleType());
        this.simpleTypeGroup.pathTable = new Hashtable();
        this.buildNode = -1;
        this.docBuilder = null;
        this.internalDOM = false;
        this.err = new XMLError();
        this.saxAttrList = new SAXAttrList(4);
    }

    void addIdentityConstraint(XMLElement xMLElement) {
        if (xMLElement.getLocalName() != this.elementNode.name) {
            return;
        }
        XSDIdentity[] xSDIdentityArray = this.elementNode.getIdentities();
        int n = this.elementNode.getNIdentities();
        if (xSDIdentityArray == null) {
            return;
        }
        if (this.idConstraints == null) {
            this.idConstraints = new Hashtable();
        }
        int n2 = 0;
        while (n2 < n) {
            String string = xSDIdentityArray[n2].name;
            if (string == null) {
                this.error(2021, "Identity constraint name missing", false);
            } else {
                XSDIdConstraintTable xSDIdConstraintTable = (XSDIdConstraintTable)this.idConstraints.get(string);
                if (xSDIdConstraintTable == null) {
                    xSDIdConstraintTable = new XSDIdConstraintTable(xSDIdentityArray[n2]);
                }
                xSDIdConstraintTable.addElement(xMLElement);
                this.idConstraints.put(string, xSDIdConstraintTable);
            }
            ++n2;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.elementDepth == -1) {
            super.characters(cArray, n, n2);
            return;
        }
        String string = new String(cArray, n, n2);
        if (string.length() > 0) {
            this.collectChars(string);
            this.lastEvent = 3;
        }
        super.characters(cArray, n, n2);
        if (this.buildNode > 0) {
            this.docBuilder.characters(cArray, n, n2);
        }
    }

    private void chars(String string) {
        block13: {
            if (this.state.content == 13 || this.state.isFake()) {
                return;
            }
            if (string == null) {
                if (!this.state.nullable) {
                    this.error(2032, this.lastNodeName, false);
                }
            } else if (this.state.fixedVal != null) {
                if (!this.state.fixedVal.equals(string)) {
                    this.error2(2033, string, this.state.fixedVal);
                }
            } else if (this.state.content == 11 && this.state.status != 20) {
                XSDSimpleType xSDSimpleType = (XSDSimpleType)this.state.getSimpleType();
                try {
                    if (xSDSimpleType == null) {
                        this.error2(2025, string, this.lastNodeName);
                        break block13;
                    }
                    xSDSimpleType.validateValue(string);
                }
                catch (Exception exception) {
                    this.error2(2025, string, this.lastNodeName);
                }
            } else {
                if (string.trim().equals("")) {
                    return;
                }
                this.error2(2025, string, this.lastNodeName);
            }
        }
        this.state.status = 20;
    }

    private void collectChars(String string) {
        this.charAll = this.lastEvent != 3 ? string : String.valueOf(this.charAll) + string;
    }

    private void eTag(String string) {
        String string2;
        if (this.state.isFake()) {
            this.state = this.state.tag == _error ? this.pop() : this.popState(false);
            return;
        }
        boolean bl = false;
        do {
            string2 = this.state.tag;
            bl = this.state.isAccepted() ^ true;
            if (bl && string2 == string) {
                this.state.status = 19;
            } else if (string2 != null && string2 != string) {
                bl = true;
                break;
            }
            this.state = this.popState(false);
        } while (string2 != string);
        while (this.state.isNestedGroup() && this.state.isDone()) {
            this.state = this.popState(false);
        }
        if (bl) {
            this.error(2021, string, true);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.elementDepth == -1) {
            super.endElement(string, string2, string3);
            return;
        }
        if (this.lastEvent != 3) {
            this.charAll = this.state.defaultVal != null ? this.state.defaultVal : (this.state.fixedVal != null ? this.state.fixedVal : "");
            if (!this.charAll.equals("")) {
                super.characters(this.charAll.toCharArray(), 0, this.charAll.length());
            }
            if (this.buildNode > 0) {
                this.docBuilder.characters(this.charAll.toCharArray(), 0, this.charAll.length());
            }
        }
        this.chars(this.charAll);
        this.eTag(string2);
        super.endElement(string, string2, string3);
        if (this.buildNode > 0) {
            this.docBuilder.endElement(string, string2, string3);
        }
        if (this.curState < this.buildNode) {
            this.buildNode = -1;
        }
        --this.elementDepth;
        if (this.elementDepth == 0) {
            try {
                this.validateIDConstraint();
            }
            catch (XSDException xSDException) {
                this.error(2105, xSDException.getMessage(), false);
            }
            this.elementDepth = -1;
        }
        this.lastEvent = 2;
    }

    private void error(int n, String string, boolean bl) {
        this.sendError(n, this.err.getMessage1(n, string), bl);
    }

    private void error2(int n, String string, String string2) {
        this.sendError(n, this.err.getMessage2(n, string, string2), false);
    }

    DocumentBuilder getDocumentBuilder() {
        if (this.xmlProp != null) {
            String string = "oracle.xml.parser.DocumentBuilder";
            DocumentBuilder documentBuilder = (DocumentBuilder)this.xmlProp.getXMLProperty(string);
            return documentBuilder;
        }
        return null;
    }

    private String getName(String string) {
        int n = string.length();
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return string;
        }
        return string.substring(n2 + 1, n);
    }

    private String getPrefix(String string) {
        int n = string.length();
        int n2 = string.lastIndexOf(58);
        if (n2 < 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    private XSDNode getXsiType(String string) {
        String string2 = this.getPrefix(string);
        String string3 = this.resolve(string2);
        String string4 = this.getName(string);
        return this.schema.getType(string3, string4);
    }

    private State pop() {
        if (this.state.nsptr >= 0) {
            this.nsDecl[this.nslen--].clear();
            this.state.nsptr = -1;
        }
        return this.st[--this.curState];
    }

    private State popState(boolean bl) {
        while (this.curState >= 0) {
            boolean bl2 = this.state.isAccepted();
            this.state = this.pop();
            if (bl2) {
                int n = this.state.cur;
                this.state.numOccur[n] = this.state.numOccur[n] + 1;
            }
            this.state.setStatus();
            if (!this.state.isDone() || !this.state.isNestedGroup()) break;
        }
        return this.state;
    }

    /*
     * Unable to fully structure code
     */
    void processSchemaLocation(String var1_1, boolean var2_2) throws SAXException {
        var3_3 = var1_1.length();
        var4_4 = var1_1.toCharArray();
        var5_5 = 0;
        if (this.xsdBuilder != null) ** GOTO lbl55
        try {
            this.xsdBuilder = new XSDBuilder();
            ** GOTO lbl55
        }
        catch (Exception var8_6) {
            this.xsdBuilder = null;
            this.error(2001, var8_6.getMessage(), false);
            return;
        }
        {
            ++var5_5;
            do {
                if (var5_5 < var3_3 && var4_4[var5_5] == ' ') continue block6;
                if (var5_5 >= var3_3) break block6;
                var6_8 = "";
                var8_7 = var5_5;
                if (!var2_2) {
                    while (var5_5 < var3_3 && var4_4[var5_5] != ' ') {
                        ++var5_5;
                    }
                    if (var5_5 >= var3_3) break block6;
                    var6_8 = new String(var4_4, var8_7, var5_5 - var8_7);
                    while (var5_5 < var3_3 && var4_4[var5_5] == ' ') {
                        ++var5_5;
                    }
                    if (var5_5 >= var3_3) break block6;
                }
                var8_7 = var5_5;
                while (var5_5 < var3_3 && var4_4[var5_5] != ' ') {
                    ++var5_5;
                }
                var7_9 = new String(var4_4, var8_7, var5_5 - var8_7);
                try {
                    var9_10 = null;
                    if (var7_9.startsWith("#")) {
                        var10_12 = null;
                        var11_13 = this.getDocumentBuilder();
                        if (var11_13 != null) {
                            var10_12 = var11_13.getDocument();
                        }
                        if (var10_12 != null) {
                            var9_10 = this.xsdBuilder.build(var10_12, var7_9, var6_8, this.baseUrl);
                        } else {
                            this.err.error2(2000, 1, var6_8, var7_9);
                        }
                    } else {
                        var9_10 = this.xsdBuilder.build(var6_8, new URL(this.baseUrl, var7_9));
                    }
                    if (var9_10 == null) continue;
                    this.setXMLSchema((XMLSchema)var9_10, false);
                }
                catch (Exception var9_11) {
                    try {
                        this.err.setException(var9_11);
                        this.err.error2(2000, 1, var6_8, var7_9);
                    }
                    catch (Exception v0) {}
                }
lbl55:
                // 6 sources

            } while (var5_5 < var3_3);
        }
    }

    private State push() {
        if (++this.curState == this.stateMax) {
            State[] stateArray = this.st;
            this.stateMax *= 2;
            this.st = new State[this.stateMax];
            System.arraycopy(stateArray, 0, this.st, 0, this.curState);
            int n = this.curState;
            while (n < this.stateMax) {
                this.st[n] = new State();
                ++n;
            }
        }
        return this.st[this.curState];
    }

    private void pushGroup(XSDGroup xSDGroup, int n) {
        int n2 = this.state.content;
        int n3 = this.state.basePosition;
        int n4 = this.state.level + 1;
        byte[] byArray = this.state.viLevel;
        Hashtable hashtable = this.state.pathTable;
        FastVector fastVector = this.state.elemList;
        this.state = this.push();
        this.state.set(xSDGroup, null, n2);
        this.state.nullable = false;
        this.state.fixedVal = null;
        this.state.defaultVal = null;
        this.state.basePosition = n3 + n;
        this.state.pathTable = hashtable;
        this.state.level = n4;
        this.state.viLevel = byArray;
        this.state.elemList = fastVector;
    }

    private boolean pushState(XSDNode xSDNode, String string, String string2) {
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        int n = 21;
        XSDAttrGroup xSDAttrGroup = null;
        int n2 = this.state.level + 1;
        int n3 = this.state.basePosition;
        Hashtable hashtable = this.state.pathTable;
        if (xSDNode == XSDConstantValues.FAKE_NODE) {
            this.state = this.push();
            this.state.set(xSDNode, string);
            return true;
        }
        if (xSDNode.nodeType == 3) {
            bl = ((XSDElement)xSDNode).bNullable;
            string3 = ((XSDElement)xSDNode).fixedVal;
            string4 = ((XSDElement)xSDNode).defaultVal;
            xSDNode = ((XSDElement)xSDNode).getType();
        }
        if (string2 != null) {
            XSDNode xSDNode2 = this.getXsiType(string2);
            if (xSDNode2 == null) {
                this.error(2029, string2, false);
            } else if (!xSDNode2.isDerivedFrom(xSDNode)) {
                this.error2(2037, string2, xSDNode.getName());
            } else {
                xSDNode = xSDNode2;
            }
        }
        if (xSDNode.isNodeType(1)) {
            n = ((XSDComplexType)xSDNode).content;
            xSDAttrGroup = ((XSDComplexType)xSDNode).getAttrGroup();
            xSDNode = ((XSDComplexType)xSDNode).getGroup();
        } else if (xSDNode.isNodeType(2)) {
            n = 11;
            this.simpleTypeGroup.setParticleNode((XSDParticleNode)((Object)xSDNode), 0);
            xSDNode = this.simpleTypeGroup;
        }
        this.state = this.push();
        this.state.set((XSDGroup)xSDNode, string, n);
        this.state.nullable = bl;
        this.state.fixedVal = string3;
        this.state.defaultVal = string4;
        this.state.attrGroup = xSDAttrGroup;
        return true;
    }

    String resolve(String string) {
        if (string == null) {
            string = "";
        }
        int n = this.nslen;
        while (n >= 0) {
            String string2 = (String)this.nsDecl[this.nslen].get(string);
            if (string2 != null) {
                return string2;
            }
            if (string == "") {
                return "";
            }
            this.error(2020, string, false);
            --n;
        }
        return "";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sTag(String string, String string2, String string3, int n) {
        void var6_8;
        XSDNode xSDNode;
        block19: {
            Object var6_5 = null;
            if (this.state.isFake()) {
                if (this.state.tag == "lax") {
                    XSDElement xSDElement = this.schema.getElement(string2, string);
                    if (xSDElement != null) {
                        this.pushState(xSDElement, string, string3);
                        return;
                    }
                    if (string3 != null) {
                        XSDNode xSDNode2 = this.getXsiType(string3);
                        if (xSDNode2 != null) {
                            this.pushState(xSDNode2, string, null);
                        }
                        return;
                    }
                }
                this.pushState(XSDConstantValues.FAKE_NODE, this.state.tag, null);
                return;
            }
            if (this.state.isDone()) {
                this.error(n, string, false);
                this.pushState(XSDConstantValues.FAKE_NODE, _error, null);
                return;
            }
            if (this.state.pathTable == null) {
                if (this.curState != 0) {
                    this.error(n, string, false);
                    this.pushState(XSDConstantValues.FAKE_NODE, _error, null);
                    return;
                }
                xSDNode = this.state.curItem();
            } else {
                this.keyNode.setNSName(string2, string);
                while (true) {
                    int n2;
                    int[] nArray;
                    if ((nArray = (int[])this.state.pathTable.get(this.keyNode)) == null) {
                        nArray = (int[])this.state.pathTable.get(this.anyNode);
                        n2 = this.state.eligible(nArray, string2);
                    } else {
                        n2 = this.state.eligible(nArray, null);
                    }
                    if (n2 > -1) {
                        int n3;
                        while ((xSDNode = this.state.getItem(n3 = this.state.getBranch(n2))).isNodeType(5)) {
                            this.pushGroup((XSDGroup)xSDNode, this.state.getOffset(n3));
                        }
                        break block19;
                    }
                    if (this.curState <= 1 || !this.state.isNestedGroup() || !this.state.isAccepted()) break;
                    this.state = this.popState(false);
                }
                this.error(n, string, false);
                this.pushState(XSDConstantValues.FAKE_NODE, _error, null);
                return;
            }
        }
        try {
            XSDNode xSDNode3 = xSDNode.getMatchingNode(this.schema, string2, string);
        }
        catch (XSDException xSDException) {}
        if (var6_8 == null) {
            this.error(2038, string, false);
            this.pushState(XSDConstantValues.FAKE_NODE, _error, null);
            return;
        }
        if (var6_8.isNodeType(3)) {
            this.elementNode = (XSDElement)var6_8;
        }
        if (var6_8 == XSDConstantValues.FAKE_NODE) {
            string = ((XSDAny)xSDNode).processContents;
        }
        this.pushState((XSDNode)var6_8, string, string3);
    }

    private void sendError(int n, String string, boolean bl) {
        if (bl) {
            this.state.status = 17;
        }
        this.err.error(n, 1, string);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void setError(XMLError xMLError) throws SAXException {
        this.err = xMLError;
    }

    private boolean setMode(String string, boolean bl) {
        if (this.curState != 0) {
            return false;
        }
        XSDNode xSDNode = this.state.curItem();
        if (!(xSDNode instanceof XSDAny)) {
            return false;
        }
        ((XSDAny)xSDNode).processContents = string;
        this.elementDepth = bl ? -1 : 0;
        return true;
    }

    public void setXMLProperties(XMLProperties xMLProperties) {
        this.xmlProp = xMLProperties;
    }

    public Object setXMLProperty(String string, Object object) {
        try {
            if (string.equals("validationMode")) {
                String string2 = ((String)object).intern();
                if (string2 == "ORACLE_XSD_LaxValidation") {
                    return this.setMode("lax", false) ? object : null;
                }
                if (string2 == "ORACLE_XSD_StrictValidation") {
                    return this.setMode("strict", false) ? object : null;
                }
                if (string2 == "ORACLE_XSD_AutoValidation" && !this.fixedSchema) {
                    return this.setMode("strict", true) ? object : null;
                }
                return null;
            }
            if (string.equals("fixedSchema")) {
                this.setXMLSchema((XMLSchema)object, true);
            } else if (string.equals("baseURL")) {
                this.baseUrl = (URL)object;
            } else if (string.equals("nsResolver")) {
                this.nsResolver = (NSResolver)object;
            } else {
                return null;
            }
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setXMLSchema(XMLSchema xMLSchema) throws SAXException {
        this.setXMLSchema(xMLSchema, true);
    }

    private void setXMLSchema(XMLSchema xMLSchema, boolean bl) throws SAXException {
        this.schema = xMLSchema;
        if (!this.schema.isPathTableBuilt()) {
            try {
                this.schema.buildSchemaPathTable();
            }
            catch (Exception exception) {
                this.error(2900, "build schema path tables", false);
            }
        }
        if (this.elementDepth < 0) {
            this.elementDepth = 0;
        }
        this.fixedSchema = bl;
        String string = this.schema.getSchemaNS();
        if (string == "http://www.w3.org/1999/XMLSchema") {
            this.xsiNS = "http://www.w3.org/1999/XMLSchema-instance";
        } else if (string == "http://www.w3.org/2000/10/XMLSchema") {
            this.xsiNS = "http://www.w3.org/2000/10/XMLSchema-instance";
        } else if (string == "http://www.w3.org/2001/XMLSchema") {
            this.xsiNS = "http://www.w3.org/2001/XMLSchema-instance";
        } else {
            this.error2(2030, "schema", string);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        String string5;
        SAXAttrList sAXAttrList = XMLContentHandler.createSAXAttrList(attributes, this.saxAttrList);
        boolean bl = false;
        String string6 = null;
        int n = sAXAttrList.getLength();
        int n2 = this.nslen;
        this.attrTable.clear();
        if (n > 0) {
            int n3 = 0;
            while (n3 < n) {
                String string7 = sAXAttrList.getPrefix(n3);
                string5 = sAXAttrList.getLocalName(n3);
                String string8 = sAXAttrList.getValue(n3).intern();
                string4 = sAXAttrList.getURI(n3);
                if (string7 == "xmlns" || string5 == "xmlns") {
                    if (n2 == this.nslen) {
                        ++this.nslen;
                        if (this.nsDecl[this.nslen] == null) {
                            this.nsDecl[this.nslen] = new Hashtable();
                        }
                    }
                    if (string5 == "xmlns") {
                        this.nsDecl[this.nslen].put("", string8);
                    } else {
                        this.nsDecl[this.nslen].put(string5, string8);
                    }
                } else if (string4 == "http://www.w3.org/2001/XMLSchema-instance" || string4 == "http://www.w3.org/2000/10/XMLSchema-instance" || string4 == "http://www.w3.org/1999/XMLSchema-instance") {
                    if (string5 == "null" || string5 == "nil") {
                        bl = string8.equals("true");
                    } else if (string5 == "type") {
                        string6 = string8;
                    } else if (!this.fixedSchema) {
                        if (string5 == "schemaLocation") {
                            this.processSchemaLocation(string8, false);
                        } else if (string5 == "noNamespaceSchemaLocation") {
                            this.processSchemaLocation(string8, true);
                        }
                    }
                } else if (string4 != null && !string4.equals("")) {
                    this.attrTable.put(String.valueOf(string4) + ":" + string5, string8);
                } else {
                    this.attrTable.put(string5, string8);
                }
                ++n3;
            }
        }
        if (this.elementDepth == -1) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        ++this.elementDepth;
        string4 = string;
        string5 = string2;
        this.lastNodeName = string2;
        this.sTag(string5, string4, string6, 2034);
        if (n2 != this.nslen) {
            this.state.nsptr = this.nslen;
        }
        if (!this.state.isFake()) {
            this.validateAttribute(sAXAttrList);
        }
        if (bl) {
            this.chars(null);
        }
        super.startElement(string, string2, string3, attributes);
        if (this.buildNode > 0) {
            this.docBuilder.startElement(string, string2, string3, attributes);
        }
        if (this.elementNode != null && this.elementNode.identities != null) {
            if (this.docBuilder == null) {
                this.docBuilder = this.getDocumentBuilder();
                if (this.docBuilder == null) {
                    this.docBuilder = new DocumentBuilder();
                    this.docBuilder.setDocumentLocator(this.locator);
                    this.docBuilder.startDocument();
                    this.docBuilder.startElement("", "root", "root", attributes);
                    this.internalDOM = true;
                    this.buildNode = this.curState;
                    this.docBuilder.startElement(string, string2, string3, attributes);
                }
            } else if (this.internalDOM && this.buildNode < 0) {
                this.buildNode = this.curState;
                this.docBuilder.startElement(string, string2, string3, attributes);
            }
            XMLElement xMLElement = (XMLElement)this.docBuilder.getCurrentNode();
            this.addIdentityConstraint(xMLElement);
            this.elementNode = null;
        }
        this.lastEvent = 1;
    }

    private void validateAttribute(SAXAttrList sAXAttrList) {
        String string;
        String string2;
        String string3;
        String string4;
        XSDAny xSDAny = null;
        XSDSimpleType xSDSimpleType = null;
        if (this.state.attrGroup != null) {
            XSDAttrGroup xSDAttrGroup = this.state.attrGroup;
            int n = xSDAttrGroup.length();
            xSDAny = xSDAttrGroup.wildcard;
            int n2 = 0;
            while (n2 < n) {
                XSDAttribute xSDAttribute = (XSDAttribute)xSDAttrGroup.item(n2);
                string4 = xSDAttribute.getTargetNS();
                string3 = xSDAttribute.getName();
                string2 = string4.equals("") ? string3 : String.valueOf(string4) + ":" + string3;
                string = (String)this.attrTable.get(string2);
                if (string == null) {
                    if (xSDAttribute.minOccurs > 0) {
                        this.error(2036, string2, false);
                    }
                    if (xSDAttribute.defaultVal != null) {
                        sAXAttrList.addAttr("", string3, string3, xSDAttribute.defaultVal, false, 0);
                    } else if (xSDAttribute.fixedVal != null) {
                        sAXAttrList.addAttr("", string3, string3, xSDAttribute.fixedVal, false, 0);
                    }
                } else {
                    if (xSDAttribute.fixedVal != null) {
                        if (!xSDAttribute.fixedVal.equals(string)) {
                            this.error2(2033, string, xSDAttribute.fixedVal);
                        }
                    } else {
                        xSDSimpleType = (XSDSimpleType)xSDAttribute.getType();
                        if (xSDSimpleType == null) {
                            this.error2(2023, string, string2);
                        } else {
                            try {
                                xSDSimpleType.validateValue(string);
                            }
                            catch (Exception exception) {
                                this.error2(2023, string, string2);
                            }
                        }
                    }
                    this.attrTable.remove(string2);
                }
                ++n2;
            }
        }
        Enumeration enumeration = this.attrTable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = (String)this.attrTable.get(string2);
            if (xSDAny != null) {
                string4 = this.getPrefix(string2);
                XSDNode xSDNode = xSDAny.getMatchingAttr(this.schema, string4, string3 = this.getName(string2));
                if (xSDNode == null) {
                    this.error(2035, string2, false);
                    continue;
                }
                if (!(xSDNode instanceof XSDAttribute)) continue;
                xSDSimpleType = (XSDSimpleType)((XSDAttribute)xSDNode).getType();
                if (xSDSimpleType == null) {
                    this.error2(2023, string, string2);
                    continue;
                }
                try {
                    xSDSimpleType.validateValue(string);
                }
                catch (Exception exception) {
                    this.error2(2023, string, string2);
                }
                continue;
            }
            this.error(2035, string2, false);
        }
    }

    private void validateIDConstraint() throws XSDException {
        XSDIdConstraintTable xSDIdConstraintTable;
        String string;
        if (this.idConstraints == null) {
            return;
        }
        Enumeration<Object> enumeration = this.idConstraints.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            xSDIdConstraintTable = (XSDIdConstraintTable)this.idConstraints.get(string);
            xSDIdConstraintTable.validateIdConstraints();
        }
        enumeration = this.idConstraints.elements();
        while (enumeration.hasMoreElements()) {
            xSDIdConstraintTable = (XSDIdConstraintTable)enumeration.nextElement();
            if (xSDIdConstraintTable.definition.getNodeType() != 24) continue;
            string = xSDIdConstraintTable.definition.getRefer();
            if (string == null) {
                throw new XSDException("Empty key reference");
            }
            XSDIdConstraintTable xSDIdConstraintTable2 = (XSDIdConstraintTable)this.idConstraints.get(string);
            if (xSDIdConstraintTable2 == null) {
                throw new XSDException("Reference to null keys");
            }
            xSDIdConstraintTable.validateKeyref(xSDIdConstraintTable2);
        }
    }

    private class State {
        String tag;
        int numSize = 20;
        int[] numOccur = new int[this.numSize];
        int cur;
        int status;
        int nsptr = -1;
        int length;
        int basePosition;
        int level;
        byte[] viLevel;
        Hashtable pathTable;
        FastVector elemList;
        XSDNode group;
        XSDAttrGroup attrGroup;
        int content;
        int order;
        boolean nullable;
        String fixedVal;
        String defaultVal;

        State() {
        }

        XSDNode curItem() {
            if (this.group instanceof XSDGroup) {
                return (XSDNode)((Object)((XSDGroup)this.group).item(this.cur));
            }
            return this.group;
        }

        int curStatus() {
            return this.nodeStatus(this.cur);
        }

        /*
         * Unable to fully structure code
         */
        int eligible(int[] var1_1, String var2_2) {
            if (var1_1 == null) {
                return -1;
            }
            var4_3 = var1_1.length;
            var5_4 = 0;
            while (var5_4 < var4_3) {
                block9: {
                    block10: {
                        var3_5 = var1_1[var5_4];
                        if (var2_2 != null && !(var6_6 = (XSDAny)this.elemList.elementAt(var3_5)).isMatched(var2_2) || this.viLevel[var3_5] > this.level || (var6_7 = this.getBranch(var3_5)) < 0) break block9;
                        var7_8 = this.nodeStatus(this.cur);
                        if (var6_7 != this.cur || var7_8 == 20) break block10;
                        return var3_5;
                        while (true) {
                            ++this.cur;
                            if (var6_7 == this.cur) {
                                return var3_5;
                            }
                            ** GOTO lbl-1000
                            break;
                        }
                    }
                    switch (this.order) lbl-1000:
                    // 2 sources

                    {
                        case 0: {
                            if (this.nodeStatus(this.cur) >= 19 && this.cur < var6_7) ** continue;
                            break;
                        }
                        case 2: {
                            if (this.status == 17 || var7_8 < 19 || this.numOccur[var6_7] != 0) break;
                            return var3_5;
                        }
                        case 1: {
                            if (this.status != 17) break;
                            return var3_5;
                        }
                    }
                }
                ++var5_4;
            }
            return -1;
        }

        int getBranch(int n) {
            if (n < this.basePosition) {
                return -1;
            }
            return ((XSDGroup)this.group).getBranch(n - this.basePosition);
        }

        XSDNode getItem(int n) {
            if (this.group instanceof XSDGroup) {
                this.cur = n;
                return (XSDNode)((Object)((XSDGroup)this.group).item(n));
            }
            return this.group;
        }

        int getOffset(int n) {
            return ((XSDGroup)this.group).getOffset(n);
        }

        XSDNode getSimpleType() {
            XSDNode xSDNode = this.curItem();
            if (xSDNode.name == "#xmlAttr") {
                ++this.cur;
                xSDNode = this.curItem();
            }
            return xSDNode.isNodeType(2) ? xSDNode : null;
        }

        boolean isAccepted() {
            if (this.status == 17) {
                this.setStatus();
            }
            return this.status == 19 || this.status == 20;
        }

        boolean isCurDone() {
            return this.nodeStatus(this.cur) == 20;
        }

        boolean isDone() {
            return this.status == 20;
        }

        boolean isFake() {
            return this.group == XSDConstantValues.FAKE_NODE;
        }

        boolean isNestedGroup() {
            return this.tag == null;
        }

        boolean isTopGroup() {
            if (this.group.isNodeType(5)) {
                return ((XSDGroup)this.group).topGroup;
            }
            return false;
        }

        int nodeStatus(int n) {
            int n2 = this.numOccur[n];
            if (this.group instanceof XSDGroup) {
                if (n2 >= ((XSDGroup)this.group).maxOccurs(n)) {
                    return 20;
                }
                if (((XSDGroup)this.group).optional) {
                    return 19;
                }
                if (n2 < ((XSDGroup)this.group).minOccurs(n)) {
                    return 18;
                }
                return 19;
            }
            if (this.group instanceof XSDParticleNode) {
                if (n2 < ((XSDParticleNode)((Object)this.group)).getMinOccurs()) {
                    return 18;
                }
                if (n2 < ((XSDParticleNode)((Object)this.group)).getMaxOccurs()) {
                    return 19;
                }
            }
            return 20;
        }

        void set(XSDGroup xSDGroup, String string, int n) {
            this.tag = string;
            this.cur = 0;
            this.content = n;
            this.status = 17;
            this.group = xSDGroup;
            this.order = xSDGroup.order;
            this.length = xSDGroup.length();
            if (this.numOccur.length < this.length) {
                this.numOccur = new int[this.length + 10];
            }
            int n2 = 0;
            while (n2 < this.length) {
                this.numOccur[n2] = 0;
                ++n2;
            }
            this.fixedVal = null;
            this.defaultVal = null;
            this.nullable = false;
            if (xSDGroup.topGroup) {
                this.pathTable = xSDGroup.pathTable;
                this.viLevel = xSDGroup.viLevel;
                this.elemList = xSDGroup.elemList;
                this.basePosition = 0;
                this.level = 1;
            }
        }

        void set(XSDNode xSDNode, String string) {
            this.tag = string;
            this.status = 17;
            this.group = xSDNode;
        }

        void setStatus() {
            int n = 0;
            if (this.group instanceof XSDGroup) {
                n = ((XSDGroup)this.group).order;
            }
            switch (n) {
                case 0: {
                    this.status = 20;
                    int n2 = this.cur;
                    while (n2 < this.length) {
                        switch (this.nodeStatus(n2)) {
                            case 18: {
                                this.status = 18;
                                break;
                            }
                            case 19: {
                                this.status = this.status == 20 ? 19 : this.status;
                                break;
                            }
                        }
                        ++n2;
                    }
                    break;
                }
                case 1: {
                    if (this.status != 17) {
                        this.status = this.nodeStatus(this.cur);
                        break;
                    }
                    this.status = 18;
                    int n3 = 0;
                    while (n3 < this.length) {
                        switch (this.nodeStatus(n3)) {
                            case 20: {
                                this.status = 20;
                                break;
                            }
                            case 19: {
                                this.status = this.status == 18 ? 19 : this.status;
                                break;
                            }
                        }
                        ++n3;
                    }
                    break;
                }
                case 2: {
                    this.status = 20;
                    int n4 = 0;
                    while (n4 < this.length) {
                        switch (this.nodeStatus(n4)) {
                            case 18: {
                                this.status = 18;
                                break;
                            }
                            case 19: {
                                this.status = this.status == 20 ? 19 : this.status;
                                break;
                            }
                        }
                        ++n4;
                    }
                    break;
                }
                default: {
                    this.status = 20;
                }
            }
        }
    }
}

