/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.DTDDecl;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.parser.v2.XMLNotation;
import oracle.xml.parser.v2.XMLOutputStream;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;

public class DTD
extends XMLNode
implements DocumentType,
CXMLConstants,
Externalizable {
    String tag;
    Vector dtdChildren;
    String sysID;
    String pubID;
    Hashtable entities;
    Hashtable parEntities;
    Hashtable elementdecls;
    Hashtable notations;
    static Hashtable builtin = new Hashtable(20);
    static final int INTERNAL_SUBSET = 65536;

    static {
        builtin.put("apos", new XMLEntity("apos", false, 39, true));
        builtin.put("quot", new XMLEntity("quot", false, 34, true));
        builtin.put("amp", new XMLEntity("amp", false, 38, true));
        builtin.put("lt", new XMLEntity("lt", false, 60, true));
        builtin.put("gt", new XMLEntity("gt", false, 62, true));
        builtin.put("nbsp", new XMLEntity("nbsp", false, 160, true));
    }

    public DTD() {
    }

    DTD(String string) {
        this.tag = string;
    }

    final void addElementDecl(ElementDecl elementDecl) {
        if (this.elementdecls == null) {
            this.elementdecls = new Hashtable(20);
        }
        this.elementdecls.put(elementDecl.tag, elementDecl);
        elementDecl.dtd = this;
        this.appendNode(elementDecl);
    }

    final void addEntity(XMLEntity xMLEntity, boolean bl) {
        if (!bl) {
            if (this.entities == null) {
                this.entities = new Hashtable(20);
            }
            this.entities.put(xMLEntity.tag, xMLEntity);
        } else {
            if (this.parEntities == null) {
                this.parEntities = new Hashtable(20);
            }
            this.parEntities.put(xMLEntity.tag, xMLEntity);
        }
        this.appendNode(xMLEntity);
    }

    final void addNotation(XMLNotation xMLNotation) {
        if (this.notations == null) {
            this.notations = new Hashtable(20);
        }
        this.notations.put(xMLNotation.tag, xMLNotation);
        this.appendNode(xMLNotation);
    }

    private void appendNode(Node node) {
        if (this.dtdChildren == null) {
            this.dtdChildren = new Vector();
        }
        this.dtdChildren.addElement(node);
    }

    Node clone_Node(boolean bl, XMLDocument xMLDocument) {
        DTD dTD = (DTD)super.clone_Node(bl, xMLDocument);
        dTD.sysID = this.sysID;
        dTD.pubID = this.pubID;
        if (!bl || this.dtdChildren == null) {
            return dTD;
        }
        int n = this.dtdChildren.size();
        int n2 = 0;
        while (n2 < n) {
            XMLNode xMLNode = (XMLNode)this.dtdChildren.elementAt(n2);
            short s = xMLNode.getNodeType();
            if (s == 13) {
                dTD.addElementDecl((ElementDecl)xMLNode.clone_Node(bl, xMLDocument));
            } else if (s == 12) {
                dTD.addNotation((XMLNotation)xMLNode.clone_Node(bl, xMLDocument));
            } else if (s == 6) {
                dTD.addEntity((XMLEntity)xMLNode.clone_Node(bl, xMLDocument), ((XMLEntity)xMLNode).isParameterEntity());
            }
            ++n2;
        }
        return dTD;
    }

    public final ElementDecl findElementDecl(String string) {
        return this.elementdecls == null ? null : (ElementDecl)this.elementdecls.get(string);
    }

    public final Entity findEntity(String string, boolean bl) {
        Entity entity = null;
        if (!bl) {
            if (this.entities != null) {
                entity = (Entity)this.entities.get(string);
            }
            if (entity == null) {
                entity = builtin.get(string);
            }
        } else if (this.parEntities != null) {
            entity = (Entity)this.parEntities.get(string);
        }
        if (entity != null) {
            return entity;
        }
        return null;
    }

    public final Notation findNotation(String string) {
        return this.notations == null ? null : (Notation)this.notations.get(string);
    }

    public NodeList getChildNodes() {
        return XMLNodeList.EMPTY_NODELIST;
    }

    public NamedNodeMap getElementDecls() {
        if (this.elementdecls != null) {
            return new DTDDecl(this.elementdecls);
        }
        return null;
    }

    public NamedNodeMap getEntities() {
        if (this.entities != null && this.parEntities != null) {
            return new DTDDecl(this.entities, this.parEntities);
        }
        if (this.entities != null) {
            return new DTDDecl(this.entities);
        }
        if (this.parEntities != null) {
            return new DTDDecl(this.parEntities);
        }
        return null;
    }

    public String getInternalSubset() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        XMLOutputStream xMLOutputStream = new XMLOutputStream(byteArrayOutputStream);
        if ((this.flags & 0x10000) == 65536) {
            try {
                xMLOutputStream.writeChars("<!DOCTYPE ");
                xMLOutputStream.writeChars(this.tag);
                xMLOutputStream.writeChars(" [");
                xMLOutputStream.writeNewLine();
                xMLOutputStream.addIndent(1);
                this.printChildren(xMLOutputStream, false);
                xMLOutputStream.addIndent(-1);
                xMLOutputStream.writeChars("]>");
                xMLOutputStream.writeNewLine();
                return byteArrayOutputStream.toString();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return "";
    }

    public String getName() {
        return this.tag;
    }

    public String getNodeName() {
        return this.tag;
    }

    public short getNodeType() {
        return 10;
    }

    public NamedNodeMap getNotations() {
        if (this.notations != null) {
            return new DTDDecl(this.notations);
        }
        return null;
    }

    public XMLDOMImplementation getOwnerImplementation() {
        return (XMLDOMImplementation)XMLDocument.domImpl;
    }

    public String getPublicId() {
        return this.pubID;
    }

    public String getRootTag() {
        return this.tag;
    }

    public String getSystemId() {
        return this.sysID;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public void normalize() {
    }

    void print(OutputStream outputStream, boolean bl) throws IOException {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
        this.print(xMLOutputStream, bl);
        xMLOutputStream.finalFlush();
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (!bl) {
            xMLOutputStream.writeChars("<!DOCTYPE ");
            xMLOutputStream.writeChars(this.tag);
            if (this.pubID != null) {
                xMLOutputStream.writeChars(" PUBLIC ");
                xMLOutputStream.writeQuotedString(this.getPublicId());
                xMLOutputStream.writeChars(" ");
                xMLOutputStream.writeQuotedString(this.getSystemId());
            } else if (this.sysID != null) {
                xMLOutputStream.writeChars(" SYSTEM ");
                xMLOutputStream.writeQuotedString(this.getSystemId());
            }
            if ((this.flags & 0x10000) == 65536) {
                xMLOutputStream.writeChars(" [");
                xMLOutputStream.writeNewLine();
                xMLOutputStream.addIndent(1);
                this.printChildren(xMLOutputStream, false);
                xMLOutputStream.addIndent(-1);
                xMLOutputStream.writeChars("]>");
                xMLOutputStream.writeNewLine();
            } else {
                xMLOutputStream.writeChars(">");
                xMLOutputStream.writeNewLine();
            }
        } else {
            this.printChildren(xMLOutputStream, true);
        }
        xMLOutputStream.flush();
    }

    void printChildren(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (this.dtdChildren != null) {
            int n = this.dtdChildren.size();
            int n2 = 0;
            while (n2 < n) {
                XMLNode xMLNode = (XMLNode)this.dtdChildren.elementAt(n2);
                xMLNode.print(xMLOutputStream, bl);
                ++n2;
            }
            xMLOutputStream.flush();
        }
    }

    public void printExternalDTD(OutputStream outputStream) throws IOException {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
        xMLOutputStream.setEncoding("UTF-8", true, true);
        this.print(xMLOutputStream, true);
        xMLOutputStream.finalFlush();
    }

    public void printExternalDTD(OutputStream outputStream, String string) throws IOException {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
        xMLOutputStream.setEncoding(string, true, true);
        this.print(xMLOutputStream, true);
        xMLOutputStream.finalFlush();
    }

    public void printExternalDTD(PrintWriter printWriter) throws IOException {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(printWriter);
        this.print(xMLOutputStream, true);
        xMLOutputStream.finalFlush();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
        this.readChildNodes(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = xMLObjectInput.readByte();
        if (by != 31) {
            throw new IOException("Error in reading serialized stream corresponding to DTD");
        }
        this.tag = xMLObjectInput.readUTF();
        if (this.tag.equals("null")) {
            this.tag = null;
        }
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(65536);
        }
        this.sysID = xMLObjectInput.readUTF();
        if (this.sysID.equals("null")) {
            this.sysID = null;
        }
        this.pubID = xMLObjectInput.readUTF();
        if (this.pubID.equals("null")) {
            this.pubID = null;
        }
    }

    public void setRootTag(String string) {
        this.tag = string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    public void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        xMLObjectOutput.writeByte(31);
        if (this.tag != null) {
            xMLObjectOutput.writeUTF(this.tag);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        if ((this.flags & 0x10000) == 65536) {
            xMLObjectOutput.writeBoolean(true);
        } else {
            xMLObjectOutput.writeBoolean(false);
        }
        if (this.sysID != null) {
            xMLObjectOutput.writeUTF(this.sysID);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        if (this.pubID != null) {
            xMLObjectOutput.writeUTF(this.pubID);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        if (this.dtdChildren != null) {
            int n = this.dtdChildren.size();
            int n2 = 0;
            while (n2 < n) {
                XMLNode xMLNode = (XMLNode)this.dtdChildren.elementAt(n2);
                xMLNode.writeExternal(xMLObjectOutput, cXMLContext);
                ++n2;
            }
        }
        xMLObjectOutput.writeByte(22);
    }
}

