/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.ContentModel;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DTDDecl;
import oracle.xml.parser.v2.ParserState;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementDecl
extends XMLNode
implements Serializable,
Externalizable,
CXMLConstants {
    ContentModel content;
    Vector attrdecls;
    DTDDecl attrDTDDecl;
    String tag;
    DTD dtd;
    public static final byte EMPTY = 1;
    public static final byte ANY = 2;
    public static final byte MIXED = 3;
    public static final byte ELEMENTS = 4;
    public static final int ELEMENT = 1001;
    public static final int OR = 1002;
    public static final int COMMA = 1003;
    public static final int QMARK = 1004;
    public static final int ASTERISK = 1005;
    public static final int PLUS = 1006;
    public static final int ELEMENT_DECLARED = 65536;
    public static final int ID_ATTR_DECL = 131072;

    public ElementDecl() {
        this.setNodeFlag(65536);
    }

    ElementDecl(String string) {
        this.tag = string;
        this.content = new ContentModel();
        this.setNodeFlag(65536);
    }

    ElementDecl(String string, byte by) {
        this(string);
        this.content.type = by;
    }

    final void addAttrDecl(AttrDecl attrDecl) {
        if (this.attrdecls == null) {
            this.attrdecls = new Vector();
        }
        this.attrdecls.addElement(attrDecl);
        attrDecl.ed = this;
        this.attrDTDDecl = null;
    }

    boolean checkAcceptState(ParserState parserState) throws XMLParseException {
        return this.content.checkAcceptState(parserState);
    }

    boolean checkContent(ParserState parserState, String string) throws XMLParseException {
        return this.content.checkContent(parserState, string);
    }

    public Node cloneNode(boolean bl) {
        return this.clone_Node(bl, this.ownerDocument);
    }

    Node clone_Node(boolean bl, XMLDocument xMLDocument) {
        ElementDecl elementDecl = (ElementDecl)super.clone_Node(bl, xMLDocument);
        elementDecl.content = this.content;
        elementDecl.ownerDocument = xMLDocument;
        if (!bl || this.attrdecls == null) {
            return elementDecl;
        }
        int n = this.attrdecls.size();
        int n2 = 0;
        while (n2 < n) {
            AttrDecl attrDecl = (AttrDecl)this.attrdecls.elementAt(n2);
            elementDecl.addAttrDecl((AttrDecl)attrDecl.clone_Node(bl, xMLDocument));
            ++n2;
        }
        return elementDecl;
    }

    final Vector expectedElements(int n) {
        if (this.content.type == 1) {
            return new Vector(0);
        }
        return this.content.expectedElements(n);
    }

    public Vector expectedElements(Element element) {
        if (this.content.type == 1 || this.content.type == 2) {
            return this.getContentElements();
        }
        return this.content.expectedElements((XMLElement)element, this.dtd);
    }

    public final AttrDecl findAttrDecl(String string) {
        if (this.attrdecls != null) {
            Enumeration enumeration = this.attrdecls.elements();
            while (enumeration.hasMoreElements()) {
                AttrDecl attrDecl = (AttrDecl)enumeration.nextElement();
                if (!attrDecl.tag.equals(string)) continue;
                return attrDecl;
            }
        }
        return null;
    }

    final int getAttrDeclIndex(String string) {
        if (this.attrdecls != null) {
            int n = 0;
            while (n < this.attrdecls.size()) {
                AttrDecl attrDecl = (AttrDecl)this.attrdecls.elementAt(n);
                if (attrDecl.tag.equals(string)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public NamedNodeMap getAttrDecls() {
        if (this.attrDTDDecl == null && this.attrdecls != null) {
            this.attrDTDDecl = new DTDDecl(this.attrdecls);
        }
        return this.attrDTDDecl;
    }

    public final Vector getContentElements() {
        if (!this.isNodeFlag(65536)) {
            return null;
        }
        Vector vector = new Vector();
        if (this.content.type == 1) {
            return null;
        }
        if (this.content.type == 2) {
            if (this.dtd == null) {
                return null;
            }
            Enumeration enumeration = this.dtd.elementdecls.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(((ElementDecl)enumeration.nextElement()).tag);
            }
        } else {
            vector = (Vector)this.content.getContentElements().clone();
        }
        return vector;
    }

    public int getContentType() {
        return this.content.type;
    }

    public String getNodeName() {
        return this.tag;
    }

    public short getNodeType() {
        return 13;
    }

    public final Node getParseTree() {
        return this.content.getRoot();
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(64) && this.isNodeFlag(65536)) {
            xMLOutputStream.writeChars("<!ELEMENT ");
            xMLOutputStream.writeChars(String.valueOf(this.tag) + " ");
            this.content.print(xMLOutputStream);
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
        }
        this.printChildren(xMLOutputStream, bl);
        xMLOutputStream.flush();
    }

    void printChildren(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (this.attrdecls != null) {
            int n = this.attrdecls.size();
            int n2 = 0;
            while (n2 < n) {
                XMLNode xMLNode = (XMLNode)this.attrdecls.elementAt(n2);
                xMLNode.print(xMLOutputStream, bl);
                ++n2;
            }
            xMLOutputStream.flush();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
        this.readChildNodes(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = xMLObjectInput.readByte();
        if (by != 19) {
            throw new IOException("Error in reading serialized stream corresponding to DTD");
        }
        this.tag = xMLObjectInput.readUTF();
        this.content = new ContentModel();
        this.content.type = xMLObjectInput.readByte();
        if (this.content.type != 1 && this.content.type != 2) {
            this.content.parseContentModel(xMLObjectInput.readUTF());
        }
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(65536);
        } else {
            this.resetNodeFlag(65536);
        }
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(131072);
        }
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(64);
        }
    }

    final void removeAttrDeclAt(int n) {
        if (this.attrdecls != null) {
            this.attrdecls.removeElementAt(n);
            this.attrDTDDecl = null;
        }
    }

    public boolean validateContent(Element element) {
        if (this.content.type == 1) {
            return element.hasChildNodes() ^ true;
        }
        if (this.content.type == 2) {
            return true;
        }
        return this.content.validateContent((XMLElement)element, this.dtd);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        xMLObjectOutput.writeByte(19);
        xMLObjectOutput.writeUTF(this.tag);
        xMLObjectOutput.writeByte(this.content.type);
        if (this.content.type != 1 && this.content.type != 2) {
            xMLObjectOutput.writeUTF(this.content.getStringValue());
        }
        xMLObjectOutput.writeBoolean(this.isNodeFlag(65536));
        xMLObjectOutput.writeBoolean(this.isNodeFlag(131072));
        xMLObjectOutput.writeBoolean(this.isNodeFlag(64));
        if (this.attrdecls != null) {
            int n = this.attrdecls.size();
            int n2 = 0;
            while (n2 < n) {
                XMLNode xMLNode = (XMLNode)this.attrdecls.elementAt(n2);
                xMLNode.writeExternal(xMLObjectOutput, cXMLContext);
                ++n2;
            }
        }
        xMLObjectOutput.writeByte(22);
    }
}

