/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.ContentModel;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.ParserState;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLMultiHandler;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class NonValidatingParser
implements XMLConstants {
    int[] idx = new int[2];
    private String[] parseAttrParts = new String[2];
    boolean namespaceFeature = true;
    boolean namespacePrefixFeature = true;
    boolean stringInternFeature = true;
    boolean parsing;
    EntityResolver entResolver;
    DTDHandler dtdHandler;
    LexicalHandler lexHandler;
    DeclHandler declHandler;
    ContentHandler cntHandler;
    XMLError err;
    XMLReader reader;
    URL baseURL;
    DTD dtd;
    int externalDTD = 0;
    boolean doctypePresent = false;
    boolean preserveWS = false;
    boolean fixedDTD;
    boolean standalone = false;
    ParserState currentState;
    ParserState[] parserStates;
    int stateIndex;
    int maxIndex;
    int stateSize = 16;
    int[] index = new int[2];
    int valMode = 0;

    public NonValidatingParser() {
        this.parserStates = new ParserState[this.stateSize];
        this.stateIndex = -1;
        this.maxIndex = -1;
        this.dtd = new DTD();
    }

    public NonValidatingParser(NonValidatingParser nonValidatingParser) {
        this.reader = nonValidatingParser.reader;
        this.baseURL = nonValidatingParser.baseURL;
        this.entResolver = nonValidatingParser.entResolver;
        this.dtdHandler = nonValidatingParser.dtdHandler;
        this.lexHandler = nonValidatingParser.lexHandler;
        this.declHandler = nonValidatingParser.declHandler;
        this.cntHandler = nonValidatingParser.cntHandler;
        this.parserStates = nonValidatingParser.parserStates;
        this.currentState = nonValidatingParser.currentState;
        this.stateIndex = nonValidatingParser.stateIndex;
        this.maxIndex = nonValidatingParser.maxIndex;
        this.dtd = nonValidatingParser.dtd;
        this.err = nonValidatingParser.err;
        this.fixedDTD = nonValidatingParser.fixedDTD;
        this.standalone = nonValidatingParser.standalone;
        this.preserveWS = nonValidatingParser.preserveWS;
        this.doctypePresent = nonValidatingParser.doctypePresent;
        this.valMode = nonValidatingParser.valMode;
        nonValidatingParser = null;
    }

    void addNamespaceDef(String string, String string2, String string3) throws SAXException {
        if (string2 == "xmlns" || string == "xmlns") {
            if (this.currentState.nameSpaceTable == null) {
                this.currentState.nameSpaceTable = new Hashtable(20);
            }
            string3 = string3.intern();
            if (string == "xmlns") {
                this.cntHandler.startPrefixMapping(string2, string3);
                this.currentState.prefixes.addElement(string2);
            } else {
                this.cntHandler.startPrefixMapping("", string3);
                this.currentState.prefixes.addElement("");
            }
            this.currentState.nameSpaceTable.put(string2, string3);
        }
    }

    void checkDefaultAttributes() throws XMLParseException, SAXException {
        NamedNodeMap namedNodeMap;
        if (this.currentState.ed != null && (namedNodeMap = this.currentState.ed.getAttrDecls()) != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                AttrDecl attrDecl = (AttrDecl)namedNodeMap.item(n2);
                String string = attrDecl.getNodeName();
                int n3 = this.currentState.attrlist.indexOf(string);
                if (n3 == -1) {
                    if (attrDecl.def != null) {
                        String string2 = XMLUtil.getPrefix(string);
                        String string3 = XMLUtil.getLocalName(string);
                        this.addNamespaceDef(string2, string3, attrDecl.def);
                        this.currentState.attrlist.addAttr(string2, string3, string, attrDecl.def, false, attrDecl.atttype);
                    }
                } else {
                    this.currentState.attrlist.attrType[n3] = attrDecl.atttype;
                }
                ++n2;
            }
        }
    }

    void checkNames(XMLError xMLError) throws XMLParseException {
    }

    void expandNamespace() throws XMLParseException, SAXException, IOException {
        if (this.currentState.prefix != "") {
            this.currentState.namespace = this.resolveNS(this.currentState.prefix);
            if (this.currentState.namespace == "") {
                this.err.error1(129, 1, this.currentState.prefix);
            }
        } else {
            this.currentState.namespace = this.resolveNS("xmlns");
        }
        SAXAttrList sAXAttrList = this.currentState.attrlist;
        int n = 0;
        while (n < sAXAttrList.count) {
            String string = sAXAttrList.prefix[n];
            if (string != "") {
                sAXAttrList.namespace[n] = string == "xmlns" ? "http://www.w3.org/2000/xmlns/" : this.resolveNS(string);
                if (sAXAttrList.namespace[n] == "") {
                    this.err.error1(129, 1, string);
                }
            }
            ++n;
        }
    }

    URL getBaseURL() throws MalformedURLException {
        if (this.reader.isTopLevelReader() && this.baseURL != null) {
            return this.baseURL;
        }
        return new URL(this.reader.getSystemId());
    }

    DocumentBuilder getDocumentBuilder() {
        if (this.cntHandler instanceof XMLMultiHandler) {
            ContentHandler[] contentHandlerArray = ((XMLMultiHandler)this.cntHandler).getContentHandlers();
            int n = ((XMLMultiHandler)this.cntHandler).getNumContentHandlers();
            int n2 = 0;
            while (n2 < n) {
                if (contentHandlerArray[n2] instanceof DocumentBuilder) {
                    return (DocumentBuilder)contentHandlerArray[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((string = string.intern()) == "http://xml.org/sax/features/namespaces") {
            return this.namespaceFeature;
        }
        if (string == "http://xml.org/sax/features/namespace-prefixes") {
            return this.namespacePrefixFeature;
        }
        if (string == "http://xml.org/sax/features/string-interning") {
            return this.stringInternFeature;
        }
        if (string == "http://xml.org/sax/features/validation") {
            return this.valMode != 0;
        }
        if (string == "http://xml.org/sax/features/external-general-entities") {
            return true;
        }
        if (string == "http://xml.org/sax/features/external-parameter-entities") {
            return true;
        }
        throw new SAXNotRecognizedException(this.err.getMessage1(500, string));
    }

    void init() throws SAXException, IOException {
        this.doctypePresent = false;
        if (this.reader != null) {
            this.reader.close();
        }
        if (!this.fixedDTD) {
            this.dtd = new DTD();
        } else {
            this.doctypePresent = true;
        }
        this.stateIndex = -1;
        this.err.reset();
    }

    void parseAttlistDecl() throws XMLParseException, SAXException, IOException {
        ElementDecl elementDecl = null;
        AttrDecl attrDecl = null;
        boolean bl = false;
        this.reader.requireWhiteSpace();
        String string = this.reader.scanQName();
        elementDecl = this.dtd.findElementDecl(string);
        boolean bl2 = this.reader.skipWhiteSpace();
        while (bl2 && !this.reader.tryRead(62)) {
            int n;
            String string2 = this.reader.scanQName();
            this.reader.requireWhiteSpace();
            if (this.reader.tryRead(XMLConstants.cCDATA, 0, XMLConstants.cCDATA.length)) {
                attrDecl = new AttrDecl(string2, 0);
            } else if (this.reader.tryRead(XMLConstants.cIDREFS, 0, XMLConstants.cIDREFS.length)) {
                attrDecl = new AttrDecl(string2, 3);
            } else if (this.reader.tryRead(XMLConstants.cIDREF, 0, XMLConstants.cIDREF.length)) {
                attrDecl = new AttrDecl(string2, 2);
            } else if (this.reader.tryRead(XMLConstants.cID, 0, XMLConstants.cID.length)) {
                attrDecl = new AttrDecl(string2, 1);
            } else if (this.reader.tryRead(XMLConstants.cENTITY, 0, XMLConstants.cENTITY.length)) {
                attrDecl = new AttrDecl(string2, 4);
            } else if (this.reader.tryRead(XMLConstants.cENTITIES, 0, XMLConstants.cENTITIES.length)) {
                attrDecl = new AttrDecl(string2, 5);
            } else if (this.reader.tryRead(XMLConstants.cNMTOKENS, 0, XMLConstants.cNMTOKENS.length)) {
                attrDecl = new AttrDecl(string2, 7);
            } else if (this.reader.tryRead(XMLConstants.cNMTOKEN, 0, XMLConstants.cNMTOKEN.length)) {
                attrDecl = new AttrDecl(string2, 6);
            } else if (this.reader.tryRead(XMLConstants.cNOTATION, 0, XMLConstants.cNOTATION.length)) {
                attrDecl = new AttrDecl(string2, 8);
                this.reader.requireWhiteSpace();
            } else if (this.reader.tryRead(40)) {
                attrDecl = new AttrDecl(string2, 9);
            } else {
                this.err.error0(133, 0);
                attrDecl = new AttrDecl(string2, 0);
            }
            if (attrDecl.atttype == 8 || attrDecl.atttype == 9) {
                attrDecl.values = new Vector();
                if (attrDecl.atttype == 8 && !this.reader.tryRead(40)) {
                    this.err.error1(100, 0, "(");
                }
                while (!this.reader.isEOF()) {
                    this.reader.skipWhiteSpace();
                    String string3 = attrDecl.atttype == 8 ? this.reader.scanQName() : this.reader.scanNmToken();
                    attrDecl.values.addElement(string3);
                    this.reader.skipWhiteSpace();
                    if (this.reader.tryRead(124)) continue;
                    if (this.reader.tryRead(41)) break;
                    this.err.error2(101, 0, ")", "|");
                    this.err.flushErrors();
                }
            }
            this.reader.requireWhiteSpace();
            if (this.reader.tryRead(35)) {
                if (this.reader.tryRead(XMLConstants.cFIXED, 0, XMLConstants.cFIXED.length)) {
                    if (attrDecl == null) {
                        attrDecl = new AttrDecl(string2, 0);
                    }
                    attrDecl.attpres = 3;
                    this.reader.requireWhiteSpace();
                } else if (this.reader.tryRead(XMLConstants.cREQUIRED, 0, XMLConstants.cREQUIRED.length)) {
                    attrDecl.attpres = 1;
                } else if (this.reader.tryRead(XMLConstants.cIMPLIED, 0, XMLConstants.cIMPLIED.length)) {
                    attrDecl.attpres = 2;
                } else {
                    this.err.error0(288, 0);
                }
            }
            if ((n = this.reader.peek()) == 39 || n == 34) {
                String string4;
                if (attrDecl == null) {
                    attrDecl = new AttrDecl(string2, 0);
                    attrDecl.attpres = 0;
                }
                attrDecl.def = string4 = this.parseAttrValue();
            }
            if (attrDecl != null) {
                if (elementDecl == null) {
                    elementDecl = new ElementDecl(string, 2);
                    elementDecl.resetNodeFlag(65536);
                    this.dtd.addElementDecl(elementDecl);
                    if (this.externalDTD > 0) {
                        elementDecl.setNodeFlag(64);
                    }
                }
                if (this.externalDTD > 0) {
                    attrDecl.setNodeFlag(64);
                }
                if (elementDecl.getAttrDeclIndex(string2) == -1) {
                    elementDecl.addAttrDecl(attrDecl);
                }
                this.declHandler.attributeDecl(string, string2, AttrDecl.typeToString(attrDecl.atttype), attrDecl.attPresToString(), attrDecl.def);
            }
            bl2 = this.reader.skipWhiteSpace();
        }
        if (!bl2 && !this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    void parseAttr() throws XMLParseException, SAXException, IOException {
        String string = this.reader.scanQName(this.parseAttrParts);
        String string2 = this.parseAttrParts[0];
        String string3 = this.parseAttrParts[1];
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(61)) {
            this.err.error0(122, 0);
        }
        this.reader.skipWhiteSpace();
        String string4 = this.parseAttrValue();
        this.addNamespaceDef(string2, string3, string4);
        if (!(this.namespacePrefixFeature || string3 != "xmlns" && string2 != "xmlns")) {
            return;
        }
        int n = this.currentState.attrlist.indexOf(string);
        if (n == -1) {
            this.currentState.attrlist.addAttr(string2, string3, string, string4, true, 0);
        } else {
            this.err.error0(124, 0);
        }
    }

    String parseAttrEntityRef() throws XMLParseException, SAXException, IOException {
        String string = "";
        XMLEntity xMLEntity = this.reader.getEntity(false);
        if (xMLEntity == null) {
            return "";
        }
        if (xMLEntity.getSystemId() != null) {
            this.err.error0(127, 0);
            return "";
        }
        if (xMLEntity.getLength() == -1) {
            return xMLEntity.getNodeValue();
        }
        if (!this.reader.pushEntityRef(xMLEntity)) {
            return "";
        }
        int[] nArray = new int[2];
        while (true) {
            String string2 = this.reader.scanAttrString(65535);
            string = string.concat(string2);
            if (this.reader.isEOF()) {
                this.reader.popXMLReader();
                return string;
            }
            if (this.reader.tryRead(60)) {
                this.err.error0(126, 0);
                continue;
            }
            if (!this.reader.tryRead(38)) continue;
            string = string.concat(this.parseAttrEntityRef());
        }
    }

    String parseAttrValue() throws XMLParseException, SAXException, IOException {
        String string;
        block4: {
            string = null;
            int n = this.reader.read();
            if (n != 34 && n != 39) {
                this.err.error0(125, 0);
                this.err.flushErrors();
            }
            while (true) {
                string = string == null ? this.reader.scanAttrString(n) : string.concat(this.reader.scanAttrString(n));
                if (this.reader.tryRead(n)) break block4;
                if (this.reader.tryRead(60)) {
                    this.err.error0(126, 0);
                    continue;
                }
                if (this.reader.tryRead(38)) {
                    string = string.concat(this.parseAttrEntityRef());
                    continue;
                }
                if (this.reader.isEOF()) break;
            }
            this.err.error0(193, 0);
            this.err.flushErrors();
            return string;
        }
        return string;
    }

    void parseAttributes() throws XMLParseException, SAXException, IOException {
        boolean bl = false;
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(62)) {
            this.checkDefaultAttributes();
            this.expandNamespace();
            return;
        }
        if (this.reader.tryRead(XMLConstants.cEMPTYTAGEND, 0, XMLConstants.cEMPTYTAGEND.length)) {
            this.currentState.empty = true;
            this.checkDefaultAttributes();
            this.expandNamespace();
            return;
        }
        while (true) {
            this.parseAttr();
            bl = this.reader.skipWhiteSpace();
            if (this.reader.tryRead(62)) break;
            if (this.reader.tryRead(XMLConstants.cEMPTYTAGEND, 0, XMLConstants.cEMPTYTAGEND.length)) {
                this.currentState.empty = true;
                break;
            }
            if (bl) continue;
            this.err.error0(190, 0);
        }
        this.checkDefaultAttributes();
        this.expandNamespace();
    }

    void parseComment() throws XMLParseException, SAXException, IOException {
        char[] cArray = this.reader.scanComment(this.index);
        if (this.index[1] != 0) {
            this.lexHandler.comment(cArray, this.index[0], this.index[1]);
        }
    }

    boolean parseContentEntityRef() throws XMLParseException, SAXException, IOException {
        XMLEntity xMLEntity = this.reader.getEntity(false);
        if (xMLEntity == null) {
            return false;
        }
        if (xMLEntity.getLength() == -1) {
            char[] cArray = new char[]{xMLEntity.getChar(0)};
            this.reportCharacters(cArray, 0, 1);
            return false;
        }
        if (xMLEntity.ndata != null) {
            this.err.error0(128, 0);
            return false;
        }
        return this.reader.pushEntityRef(xMLEntity);
    }

    void parseContentModel(ContentModel contentModel) throws XMLParseException, SAXException, IOException {
        if (this.reader.tryRead(XMLConstants.cEMPTY, 0, XMLConstants.cEMPTY.length)) {
            contentModel.type = 1;
        } else if (this.reader.tryRead(XMLConstants.cANY, 0, XMLConstants.cANY.length)) {
            contentModel.type = (byte)2;
        } else if (this.reader.tryRead(40)) {
            this.reader.push(40);
            contentModel.parseContentModel(this.err, this.reader);
        } else {
            this.err.error3(102, 0, "EMPTY", "ANY", "(");
            this.err.flushErrors();
        }
    }

    final void parseDTD(String string) throws SAXException, IOException {
        this.dtd.setRootTag(string);
        this.dtd.pubID = this.reader.getPublicId();
        this.dtd.sysID = this.reader.getSystemId();
        this.reader = this.reader.getExternalReader();
        this.err.setLocator(this.reader);
        ++this.externalDTD;
        this.lexHandler.startDTD(string, this.dtd.pubID, this.dtd.sysID);
        this.parseMarkupDecl();
        this.lexHandler.endDTD();
        --this.externalDTD;
        if (!this.reader.isEOF()) {
            this.err.error1(100, 1, "EOF");
        }
        this.err.flushErrors();
    }

    void parseDoctypeDecl() throws XMLParseException, SAXException, IOException {
        if (!this.reader.tryRead(XMLConstants.cDECLSTART, 0, XMLConstants.cDECLSTART.length)) {
            return;
        }
        if (!this.reader.tryRead(XMLConstants.cDOCTYPE, 0, XMLConstants.cDOCTYPE.length)) {
            this.err.error1(100, 0, "DOCTYPE");
            this.err.flushErrors();
        }
        this.doctypePresent = true;
        this.reader.requireWhiteSpace();
        String string = null;
        String string2 = null;
        String string3 = this.reader.scanQName();
        if (this.reader.skipWhiteSpace()) {
            if (this.reader.tryRead(XMLConstants.cPUBLIC, 0, XMLConstants.cPUBLIC.length)) {
                this.reader.requireWhiteSpace();
                string2 = this.reader.scanPubIdLiteral();
                this.reader.requireWhiteSpace();
                string = this.reader.scanQuotedString();
                this.reader.skipWhiteSpace();
            } else if (this.reader.tryRead(XMLConstants.cSYSTEM, 0, XMLConstants.cSYSTEM.length)) {
                this.reader.requireWhiteSpace();
                string = this.reader.scanQuotedString();
                this.reader.skipWhiteSpace();
            }
        }
        this.lexHandler.startDTD(string3, string2, string);
        if (this.reader.tryRead(91)) {
            this.dtd.setNodeFlag(65536);
            this.parseMarkupDecl();
        }
        if (!this.reader.tryRead(62)) {
            this.err.error0(191, 0);
        }
        if (string != null && !this.fixedDTD) {
            try {
                if (!this.standalone) {
                    URL uRL = new URL(this.getBaseURL(), string);
                    string = uRL.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {}
            if (!(this.standalone || this.reader.isStandalone() && this.reader.valMode == 0)) {
                if (!this.pushExternalDTD(string, string2)) {
                    return;
                }
                this.reader = this.reader.getExternalReader();
                this.err.setLocator(this.reader);
                ++this.externalDTD;
                this.parseMarkupDecl();
                if (!this.reader.isEOF()) {
                    this.err.error0(192, 0);
                }
                --this.externalDTD;
                this.reader = this.reader.getInternalReader();
                this.err.setLocator(this.reader);
            }
        }
        if (!this.fixedDTD) {
            this.dtd.setRootTag(string3);
            this.dtd.sysID = string;
            this.dtd.pubID = string2;
        }
        this.lexHandler.endDTD();
    }

    void parseDocument() throws XMLParseException, SAXException, IOException {
        this.cntHandler.setDocumentLocator(this.reader);
        try {
            this.cntHandler.startDocument();
            if (this.cntHandler instanceof XSDValidator) {
                XSDValidator xSDValidator = (XSDValidator)this.cntHandler;
                try {
                    xSDValidator.setXMLProperty("baseURL", this.getBaseURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        catch (SAXException sAXException) {
            this.err.setException(sAXException);
            this.err.error0(180, 1);
            this.err.flushErrors();
        }
        this.parsing = true;
        this.parseProlog();
        this.parseRootElement();
        this.parseMisc();
        this.parsing = false;
        if (!this.reader.isEOF()) {
            this.err.error1(100, 1, "EOF");
        }
        this.checkNames(this.err);
        if (this.err.getFirstError() == -1) {
            this.cntHandler.endDocument();
        }
        this.err.flushErrors();
    }

    /*
     * Unable to fully structure code
     */
    String parseElement() throws XMLParseException, SAXException, IOException {
        var2_1 = new String[2];
        var3_2 = "";
        block0: while (true) {
            var5_5 = this.reader.scanQName(var2_1);
            var3_2 = var2_1[0];
            var4_4 = var2_1[1];
            this.pushState(var3_2, var4_4, var5_5);
            this.parseAttributes();
            this.cntHandler.startElement(this.currentState.namespace, this.currentState.localname, this.currentState.qname, this.currentState.attrlist);
            if (!this.currentState.empty) ** GOTO lbl47
            this.cntHandler.endElement(this.currentState.namespace, this.currentState.localname, this.currentState.qname);
            this.popState();
            if (this.stateIndex != -1) ** GOTO lbl47
            return this.parserStates[0].qname;
lbl-1000:
            // 1 sources

            {
                this.parseText();
                if (this.reader.tryRead(38)) {
                    if (!this.parseContentEntityRef()) continue;
                    ++this.currentState.markupDepth;
                    continue;
                }
                if (this.reader.tryRead(XMLConstants.cENDTAGSTART, 0, XMLConstants.cENDTAGSTART.length)) {
                    this.parseEndTag();
                    if (this.currentState.markupDepth != 0) {
                        this.err.error0(120, 0);
                    }
                    this.cntHandler.endElement(this.currentState.namespace, this.currentState.localname, this.currentState.qname);
                    this.popState();
                    if (this.stateIndex != -1) continue;
                    return this.parserStates[0].qname;
                }
                if (this.reader.tryRead(XMLConstants.cPISTART, 0, XMLConstants.cPISTART.length)) {
                    this.parsePI();
                    continue;
                }
                if (this.reader.tryRead(XMLConstants.cCOMMENTSTART, 0, XMLConstants.cCOMMENTSTART.length)) {
                    this.parseComment();
                    continue;
                }
                if (this.reader.tryRead(XMLConstants.cCDATASTART, 0, XMLConstants.cCDATASTART.length)) {
                    var1_3 = this.reader.scanCDATA(this.index);
                    if (this.index[1] == 0) continue;
                    this.lexHandler.startCDATA();
                    this.cntHandler.characters(var1_3, this.index[0], this.index[1]);
                    this.lexHandler.endCDATA();
                    continue;
                }
                if (this.reader.tryRead(60)) continue block0;
                if (!this.reader.isEOF()) continue;
                this.reader.popXMLReader();
                --this.currentState.markupDepth;
lbl47:
                // 11 sources

                ** while (this.stateIndex >= 0)
            }
lbl48:
            // 1 sources

        }
    }

    void parseElementDecl() throws XMLParseException, SAXException, IOException {
        this.reader.requireWhiteSpace();
        String string = this.reader.scanQName();
        ElementDecl elementDecl = this.dtd.findElementDecl(string);
        if (elementDecl != null && elementDecl.isNodeFlag(65536)) {
            int n = this.reader.valMode == 2 ? 1 : 2;
            this.err.error1(131, n, string);
        }
        if (elementDecl == null) {
            elementDecl = new ElementDecl(string);
            this.dtd.addElementDecl(elementDecl);
            if (this.externalDTD > 0) {
                elementDecl.setNodeFlag(64);
            }
        } else {
            elementDecl.setNodeFlag(65536);
        }
        this.reader.requireWhiteSpace();
        this.parseContentModel(elementDecl.content);
        this.declHandler.elementDecl(string, elementDecl.content.getStringValue());
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    void parseEndTag() throws XMLParseException, SAXException, IOException {
        String string = "";
        String string2 = this.reader.scanName();
        if (this.reader.tryRead(58)) {
            string = string2;
            string2 = this.reader.scanName();
        }
        if (string != this.currentState.prefix || string2 != this.currentState.localname) {
            this.err.error1(121, 0, this.currentState.qname);
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error0(123, 0);
        }
    }

    XMLEntity parseEntityDecl() throws XMLParseException, SAXException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        this.reader.requireWhiteSpace();
        bl = this.reader.checkParEntity();
        String string = this.reader.scanQName();
        String string2 = bl ? "%" + string : string;
        XMLEntity xMLEntity = (XMLEntity)this.dtd.findEntity(string, bl);
        if (xMLEntity != null) {
            this.err.error1(116, 2, string);
            xMLEntity = new XMLEntity(string, bl);
            if (this.fixedDTD) {
                this.dtd.addEntity(xMLEntity, bl);
                if (this.externalDTD > 0) {
                    xMLEntity.setNodeFlag(64);
                }
            }
        } else {
            xMLEntity = new XMLEntity(string, bl);
            this.dtd.addEntity(xMLEntity, bl);
            if (this.externalDTD > 0) {
                xMLEntity.setNodeFlag(64);
            }
        }
        this.reader.requireWhiteSpace();
        if (this.reader.tryRead(XMLConstants.cPUBLIC, 0, XMLConstants.cPUBLIC.length)) {
            bl2 = true;
            this.reader.requireWhiteSpace();
            xMLEntity.pubid = this.reader.scanPubIdLiteral();
            this.reader.requireWhiteSpace();
            xMLEntity.url = this.reader.scanQuotedString();
        } else if (this.reader.tryRead(XMLConstants.cSYSTEM, 0, XMLConstants.cSYSTEM.length)) {
            bl2 = true;
            this.reader.requireWhiteSpace();
            xMLEntity.url = this.reader.scanQuotedString();
        }
        if (bl2) {
            try {
                URL uRL = new URL(this.getBaseURL(), xMLEntity.url);
                xMLEntity.setURL(uRL.toString());
            }
            catch (MalformedURLException malformedURLException) {}
            boolean bl3 = this.reader.skipWhiteSpace();
            if (this.reader.tryRead(XMLConstants.cNDATA, 0, XMLConstants.cNDATA.length)) {
                if (!bl3) {
                    this.err.error0(190, 0);
                }
                if (bl) {
                    this.err.error0(117, 0);
                }
                this.reader.requireWhiteSpace();
                xMLEntity.ndata = this.reader.scanQName();
                if (!bl && xMLEntity.ndata == null) {
                    this.err.error0(118, 0);
                }
                this.dtdHandler.unparsedEntityDecl(string, xMLEntity.pubid, xMLEntity.url, xMLEntity.ndata);
            }
            this.declHandler.externalEntityDecl(string2, xMLEntity.pubid, xMLEntity.url);
        } else {
            String string3 = this.parseEntityValue();
            xMLEntity.setNodeValue(string3);
            xMLEntity.setNodeFlag(131072);
            this.declHandler.internalEntityDecl(string2, string3);
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
        return xMLEntity;
    }

    String parseEntityRefValue() throws XMLParseException, SAXException, IOException {
        String string = "";
        XMLEntity xMLEntity = this.reader.getEntity(true);
        if (xMLEntity == null) {
            return "";
        }
        if (xMLEntity.getLength() == -1) {
            return xMLEntity.getNodeValue();
        }
        if (!this.reader.pushEntityRef(xMLEntity)) {
            return "";
        }
        while (true) {
            string = string.concat(this.reader.scanEntityString(65535));
            if (this.reader.tryRead(37)) {
                string = string.concat(this.parseEntityRefValue());
                continue;
            }
            if (this.reader.isEOF()) break;
        }
        this.reader.popXMLReader();
        return string;
    }

    String parseEntityValue() throws SAXException, IOException {
        String string;
        block3: {
            string = "";
            int n = this.reader.read();
            if (n != 34 && n != 39) {
                this.err.error0(119, 0);
                this.err.flushErrors();
            }
            while (true) {
                string = string.concat(this.reader.scanEntityString(n));
                if (this.reader.tryRead(n)) break block3;
                if (this.reader.tryRead(37)) {
                    string = string.concat(this.parseEntityRefValue());
                    continue;
                }
                if (this.reader.isEOF()) break;
            }
            this.err.error0(193, 0);
            this.err.flushErrors();
            return string;
        }
        return string;
    }

    void parseMarkupDecl() throws XMLParseException, SAXException, IOException {
        this.reader.skipWhiteSpace();
        while (!this.reader.isEOF()) {
            if (this.reader.tryRead(XMLConstants.cDECLSTART, 0, XMLConstants.cDECLSTART.length)) {
                if (this.reader.tryRead(XMLConstants.cELEMENT, 0, XMLConstants.cELEMENT.length)) {
                    this.parseElementDecl();
                } else if (this.reader.tryRead(XMLConstants.cATTLIST, 0, XMLConstants.cATTLIST.length)) {
                    this.parseAttlistDecl();
                } else if (this.reader.tryRead(XMLConstants.cENTITY, 0, XMLConstants.cENTITY.length)) {
                    this.parseEntityDecl();
                } else if (this.reader.tryRead(XMLConstants.cNOTATION, 0, XMLConstants.cNOTATION.length)) {
                    this.parseNotationDecl();
                } else if (this.reader.tryRead(XMLConstants.cCOMMENTSTART, 2, XMLConstants.cCOMMENTSTART.length - 2)) {
                    this.parseComment();
                } else if (this.externalDTD > 0 && this.reader.tryRead(91)) {
                    this.reader.skipWhiteSpace();
                    if (this.reader.tryRead(XMLConstants.cINCLUDE, 0, XMLConstants.cINCLUDE.length)) {
                        this.reader.skipWhiteSpace();
                        if (!this.reader.tryRead(91)) {
                            this.err.error0(114, 0);
                        }
                        this.parseMarkupDecl();
                        if (!this.reader.tryRead(XMLConstants.cCDATAEND, 1, XMLConstants.cCDATAEND.length - 1)) {
                            this.err.error0(115, 0);
                        }
                    } else if (this.reader.tryRead(XMLConstants.cIGNORE, 0, XMLConstants.cIGNORE.length)) {
                        this.reader.skipIgnoreSection();
                        this.reader.skipWhiteSpace();
                    } else {
                        this.err.error2(101, 0, "IGNORE", "INCLUDE");
                        this.reader.skipIgnoreSection();
                        this.reader.skipWhiteSpace();
                    }
                }
            } else if (this.reader.tryRead(XMLConstants.cPISTART, 0, XMLConstants.cPISTART.length)) {
                this.parsePI();
            } else if (this.reader.tryRead(37)) {
                XMLEntity xMLEntity = this.reader.getEntity(true);
                if (xMLEntity == null) {
                    this.reader.skipWhiteSpace();
                    continue;
                }
                if (!this.reader.pushEntityRef(xMLEntity)) {
                    this.reader.skipWhiteSpace();
                    continue;
                }
                if (xMLEntity.isExternalEntity()) {
                    this.reader = this.reader.getExternalReader();
                    this.err.setLocator(this.reader);
                    ++this.externalDTD;
                }
                this.parseMarkupDecl();
                if (xMLEntity.isExternalEntity()) {
                    --this.externalDTD;
                    this.reader = this.reader.getInternalReader();
                    this.err.setLocator(this.reader);
                } else {
                    this.reader.popXMLReader();
                }
            } else {
                if (this.reader.tryRead(93)) {
                    return;
                }
                this.reader.skipWhiteSpace();
                if (this.reader.isEOF()) {
                    return;
                }
                this.err.error0(192, 0);
                this.err.flushErrors();
            }
            this.reader.skipWhiteSpace();
        }
    }

    void parseMisc() throws XMLParseException, SAXException, IOException {
        while (true) {
            this.reader.skipWhiteSpace();
            if (this.reader.tryRead(XMLConstants.cPISTART, 0, XMLConstants.cPISTART.length)) {
                this.parsePI();
                continue;
            }
            if (!this.reader.tryRead(XMLConstants.cCOMMENTSTART, 0, XMLConstants.cCOMMENTSTART.length)) break;
            this.parseComment();
        }
    }

    void parseNotationDecl() throws XMLParseException, SAXException, IOException {
        this.reader.requireWhiteSpace();
        this.reader.skipQName();
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(XMLConstants.cPUBLIC, 0, XMLConstants.cPUBLIC.length)) {
            this.reader.requireWhiteSpace();
            String string = this.reader.scanPubIdLiteral();
            string = null;
            boolean bl = this.reader.skipWhiteSpace();
            if (!this.reader.tryRead(62)) {
                if (!bl) {
                    this.err.error0(190, 0);
                }
                this.reader.skipQuotedString();
                this.reader.skipWhiteSpace();
                if (!this.reader.tryRead(62)) {
                    this.err.error1(100, 0, ">");
                }
            }
        } else if (this.reader.tryRead(XMLConstants.cSYSTEM, 0, XMLConstants.cSYSTEM.length)) {
            this.reader.requireWhiteSpace();
            this.reader.skipQuotedString();
            this.reader.skipWhiteSpace();
            if (!this.reader.tryRead(62)) {
                this.err.error1(100, 0, ">");
            }
        } else {
            this.err.error2(101, 0, "PUBLIC", "SYSTEM");
            this.err.flushErrors();
            return;
        }
    }

    void parsePI() throws XMLParseException, SAXException, IOException {
        boolean bl = false;
        String string = this.reader.scanQName();
        if (string.toLowerCase().equals("xml")) {
            this.err.error0(109, 0);
            bl = true;
        }
        boolean bl2 = this.reader.skipWhiteSpace();
        String string2 = this.reader.scanPI();
        if (!bl2 && string2.length() != 0) {
            this.err.error0(190, 0);
        }
        if (!bl) {
            this.cntHandler.processingInstruction(string, string2);
        }
    }

    void parseProlog() throws XMLParseException, SAXException, IOException {
        this.parseMisc();
        this.parseDoctypeDecl();
        this.parseMisc();
    }

    void parseRootElement() throws XMLParseException, SAXException, IOException {
        if (this.reader.tryRead(60)) {
            this.parseElement();
        } else {
            this.err.error0(108, 0);
            this.err.flushErrors();
        }
    }

    void parseText() throws XMLParseException, SAXException, IOException {
        char[] cArray;
        boolean bl = false;
        if (!this.preserveWS) {
            cArray = this.reader.scanWhiteSpace(this.idx);
            if (this.idx[1] != 0) {
                if (this.reader.peek() == 60) {
                    bl = true;
                    this.cntHandler.ignorableWhitespace(cArray, this.idx[0], this.idx[1]);
                } else {
                    this.reportCharacters(cArray, this.idx[0], this.idx[1]);
                    char[] cArray2 = this.reader.scanChars(this.index);
                    if (this.index[1] != 0) {
                        this.reportCharacters(cArray2, this.index[0], this.index[1]);
                    }
                }
            }
        }
        if (!bl) {
            cArray = this.reader.scanChars(this.idx);
            if (this.idx[1] != 0) {
                this.reportCharacters(cArray, this.idx[0], this.idx[1]);
            }
        }
    }

    ParserState popState() throws XMLParseException, SAXException, IOException {
        ParserState parserState = this.currentState;
        int n = this.currentState.prefixes.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.currentState.prefixes.elementAt(n2);
            this.cntHandler.endPrefixMapping(string);
            ++n2;
        }
        --this.stateIndex;
        this.currentState = this.stateIndex >= 0 ? this.parserStates[this.stateIndex] : null;
        return parserState;
    }

    boolean pushExternalDTD(String string, String string2) throws SAXException, IOException {
        InputSource inputSource = this.entResolver.resolveEntity(string2, string);
        if (inputSource != null) {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                this.reader.pushXMLReader(reader, inputSource.getSystemId(), inputSource.getPublicId());
            } else {
                InputStream inputStream = inputSource.getByteStream();
                if (inputStream != null) {
                    this.reader.pushXMLReader(inputStream, inputSource.getSystemId(), inputSource.getPublicId());
                } else {
                    string = inputSource.getSystemId();
                    if (string != null) {
                        try {
                            this.reader.pushXMLReader(new URL(string), string, inputSource.getPublicId());
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.err.setException(malformedURLException);
                            this.err.error1(112, 0, string);
                            this.err.flushErrors();
                        }
                    } else {
                        this.err.error1(113, 0, string);
                        this.err.flushErrors();
                    }
                }
            }
        } else {
            try {
                this.reader.pushXMLReader(new URL(string), string, string2);
            }
            catch (MalformedURLException malformedURLException) {
                this.err.setException(malformedURLException);
                this.err.error1(112, 0, string);
                this.err.flushErrors();
                return false;
            }
        }
        return true;
    }

    void pushState(String string, String string2, String string3) throws XMLParseException, SAXException, IOException {
        ElementDecl elementDecl = this.dtd.findElementDecl(string3);
        ++this.stateIndex;
        if (this.stateIndex > this.maxIndex) {
            if (this.stateIndex >= this.stateSize) {
                ParserState[] parserStateArray = this.parserStates;
                this.parserStates = new ParserState[this.stateSize * 2];
                System.arraycopy(parserStateArray, 0, this.parserStates, 0, this.stateSize);
                this.stateSize *= 2;
            }
            this.parserStates[this.stateIndex] = this.currentState = new ParserState(string, string2, string3, elementDecl);
            ++this.maxIndex;
        } else {
            this.currentState = this.parserStates[this.stateIndex];
            this.currentState.reset(string, string2, string3, elementDecl);
        }
    }

    void reportCharacters(char[] cArray, int n, int n2) throws XMLParseException, SAXException, IOException {
        this.cntHandler.characters(cArray, n, n2);
    }

    void reset() {
        this.reader = null;
        if (!this.fixedDTD) {
            this.dtd = null;
        }
        int n = 0;
        while (n < this.stateSize) {
            if (this.parserStates[n] != null) {
                this.parserStates[n].reset(null, null, null, null);
            }
            ++n;
        }
        this.currentState = null;
        this.stateIndex = -1;
    }

    /*
     * Unable to fully structure code
     */
    String resolveNS(String var1_1) {
        var2_2 = null;
        var3_3 = this.stateIndex;
        if (var1_1 != "xml") ** GOTO lbl11
        return "http://www.w3.org/XML/1998/namespace";
lbl-1000:
        // 1 sources

        {
            var4_4 = this.parserStates[var3_3];
            if (var4_4.nameSpaceTable != null) {
                var2_2 = (String)var4_4.nameSpaceTable.get(var1_1);
            }
            if (var2_2 != null) {
                return var2_2;
            }
            --var3_3;
lbl11:
            // 2 sources

            ** while (var3_3 >= 0)
        }
lbl12:
        // 1 sources

        return "";
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((string = string.intern()) == "http://xml.org/sax/features/namespaces" || string == "http://xml.org/sax/features/namespace-prefixes" || string == "http://xml.org/sax/features/string-interning" || string == "http://xml.org/sax/features/validation") {
            if (this.parsing) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
            if (string == "http://xml.org/sax/features/namespaces") {
                if (!bl) {
                    throw new SAXNotSupportedException(this.err.getMessage1(501, string));
                }
                this.namespaceFeature = bl;
            } else if (string == "http://xml.org/sax/features/namespace-prefixes") {
                this.namespacePrefixFeature = bl;
            } else if (string == "http://xml.org/sax/features/string-interning") {
                this.stringInternFeature = bl;
            }
            return;
        }
        if (string == "http://xml.org/sax/features/external-general-entities") {
            if (!bl) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
        } else if (string == "http://xml.org/sax/features/external-parameter-entities") {
            if (!bl) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
        } else {
            throw new SAXNotRecognizedException(this.err.getMessage1(500, string));
        }
    }
}

