/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class SAXParser
extends XMLParser
implements XMLReader,
Parser,
XMLConstants {
    ContentHandler cntHandler;
    static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    static final String DECL_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";

    public SAXParser() {
        HandlerBase handlerBase = new HandlerBase();
        this.parser.entResolver = handlerBase;
        this.parser.dtdHandler = handlerBase;
        this.parser.err = new XMLError();
        XMLContentHandler xMLContentHandler = new XMLContentHandler();
        try {
            this.setProperty(LEXICAL_HANDLER_PROPERTY, xMLContentHandler);
            this.setProperty(DECL_HANDLER_PROPERTY, xMLContentHandler);
            this.setContentHandler(xMLContentHandler);
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
        }
    }

    public ContentHandler getContentHandler() {
        return this.cntHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.parser.dtdHandler;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parser.getFeature(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(LEXICAL_HANDLER_PROPERTY)) {
            return this.parser.lexHandler;
        }
        if (string.equals(DECL_HANDLER_PROPERTY)) {
            return this.parser.declHandler;
        }
        String string2 = this.parser.err.getMessage1(502, string);
        throw new SAXNotRecognizedException(string2);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.setContentHandler(contentHandler, this.cntHandler);
        this.cntHandler = contentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.parser.dtdHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        XMLContentHandler xMLContentHandler = new XMLContentHandler(documentHandler);
        xMLContentHandler.xmlParser = this;
        try {
            this.setProperty(LEXICAL_HANDLER_PROPERTY, xMLContentHandler);
            this.setProperty(DECL_HANDLER_PROPERTY, xMLContentHandler);
            this.setContentHandler(xMLContentHandler);
        }
        catch (Exception exception) {
            this.parser.err.setException(exception);
            this.parser.err.error0(1900, 0);
        }
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        string = string.intern();
        if (!this.parser.parsing && string == "http://xml.org/sax/features/validation") {
            if (bl) {
                this.setValidationMode(2);
            } else {
                this.setValidationMode(0);
            }
        } else {
            this.parser.setFeature(string, bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals(LEXICAL_HANDLER_PROPERTY)) {
            if (object instanceof LexicalHandler) {
                this.parser.lexHandler = (LexicalHandler)object;
                return;
            }
            String string2 = this.parser.err.getMessage1(503, string);
            throw new SAXNotSupportedException(string2);
        }
        if (!string.equals(DECL_HANDLER_PROPERTY)) {
            String string3 = this.parser.err.getMessage1(502, string);
            throw new SAXNotRecognizedException(string3);
        }
        if (object instanceof DeclHandler) {
            this.parser.declHandler = (DeclHandler)object;
            return;
        }
        String string4 = this.parser.err.getMessage1(503, string);
        throw new SAXNotSupportedException(string4);
    }
}

