/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.XMLCharReader;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.Entity;
import org.w3c.dom.Node;

public class XMLEntity
extends XMLNSNode
implements Entity,
CXMLConstants,
Externalizable {
    String url;
    String pubid;
    private char cdata;
    String ndata;
    boolean inStack = false;
    private String text;
    private XMLCharReader reader;
    static final int PARAMETER_ENTITY = 65536;
    static final int PARSED_ENTITY = 131072;

    public XMLEntity() {
    }

    XMLEntity(String string, boolean bl) {
        super(string);
        if (bl) {
            this.setNodeFlag(65536);
        }
    }

    XMLEntity(String string, boolean bl, int n) {
        this(string, bl);
        this.cdata = (char)n;
        this.text = String.valueOf(this.cdata);
    }

    XMLEntity(String string, boolean bl, int n, boolean bl2) {
        this(string, bl);
        this.cdata = (char)n;
        this.text = String.valueOf(this.cdata);
        if (bl2) {
            this.setNodeFlag(131072);
        }
    }

    XMLEntity(String string, boolean bl, String string2) {
        this(string, bl);
        this.text = string2;
    }

    void checkChildType(int n) throws DOMException {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return;
            }
        }
        throw new XMLDOMException(3, this.getXMLError());
    }

    public Node cloneNode(boolean bl) {
        return this.clone_Node(bl, this.ownerDocument);
    }

    Node clone_Node(boolean bl, XMLDocument xMLDocument) {
        XMLEntity xMLEntity = (XMLEntity)super.clone_Node(bl, xMLDocument);
        xMLEntity.url = this.url;
        xMLEntity.pubid = this.pubid;
        xMLEntity.cdata = this.cdata;
        xMLEntity.ndata = this.ndata;
        xMLEntity.inStack = this.inStack;
        xMLEntity.text = this.text;
        xMLEntity.ownerDocument = xMLDocument;
        if (!bl || !this.hasChildNodes()) {
            return xMLEntity;
        }
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null) {
            xMLEntity.appendChild(xMLNode);
            xMLNode = (XMLNode)xMLNode.getNextSibling();
        }
        return xMLEntity;
    }

    char getChar(int n) {
        if (this.text == null) {
            return this.cdata;
        }
        return this.text.charAt(n);
    }

    int getLength() {
        if (this.cdata > '\u0000') {
            return -1;
        }
        if (this.text == null) {
            return 0;
        }
        return this.text.length();
    }

    public short getNodeType() {
        return 6;
    }

    public String getNodeValue() throws DOMException {
        if (this.hasChildNodes()) {
            return this.getText();
        }
        return this.text;
    }

    public String getNotationName() {
        return this.ndata;
    }

    public String getPublicId() {
        return this.pubid;
    }

    XMLCharReader getReader(XMLReader xMLReader) throws IOException {
        if (this.text == null || this.text.length() == 0) {
            return null;
        }
        if (this.reader == null) {
            this.reader = new XMLCharReader(this.text, xMLReader.getSystemId(), xMLReader.getPublicId());
        } else {
            this.reader.reset();
        }
        this.reader.setPrevReader(xMLReader.input);
        return this.reader;
    }

    public String getSystemId() {
        return this.url;
    }

    boolean isExternalEntity() {
        return this.url != null;
    }

    boolean isParameterEntity() {
        return this.isNodeFlag(65536);
    }

    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(64)) {
            xMLOutputStream.writeChars("<!ENTITY ");
            if (this.isNodeFlag(65536)) {
                xMLOutputStream.writeChars("% ");
            }
            xMLOutputStream.writeChars(String.valueOf(this.tag) + " ");
            if (this.pubid != null) {
                xMLOutputStream.writeChars(" PUBLIC ");
                xMLOutputStream.writeQuotedString(this.pubid);
                xMLOutputStream.writeChars(" ");
                xMLOutputStream.writeQuotedString(this.url);
                if (this.ndata != null) {
                    xMLOutputStream.writeChars(" NDATA " + this.ndata);
                }
            } else if (this.url != null) {
                xMLOutputStream.writeChars(" SYSTEM ");
                xMLOutputStream.writeQuotedString(this.url);
                if (this.ndata != null) {
                    xMLOutputStream.writeChars(" NDATA " + this.ndata);
                }
            } else {
                xMLOutputStream.writeQuotedString(this.text);
            }
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
            xMLOutputStream.flush();
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException, EOFException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        CXMLContext cXMLContext = new CXMLContext();
        this.readExternal(xMLObjectInput, cXMLContext);
        this.readChildNodes(xMLObjectInput, cXMLContext);
    }

    public void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        byte by = xMLObjectInput.readByte();
        if (by != 17) {
            throw new IOException("Error in reading the serialized stream  corresponding to the Entity node.");
        }
        this.tag = xMLObjectInput.readUTF();
        this.url = xMLObjectInput.readUTF();
        if (this.url.equals("null")) {
            this.url = null;
        }
        this.pubid = xMLObjectInput.readUTF();
        if (this.pubid.equals("null")) {
            this.pubid = null;
        }
        this.ndata = xMLObjectInput.readUTF();
        if (this.ndata.equals("null")) {
            this.ndata = null;
        }
        this.text = xMLObjectInput.readUTF();
        if (this.text.equals("null")) {
            this.text = null;
        }
        this.cdata = xMLObjectInput.readChar();
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(65536);
        }
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(131072);
        }
        if (xMLObjectInput.readBoolean()) {
            this.setNodeFlag(64);
        }
    }

    public void setNodeValue(String string) {
        this.text = string;
    }

    void setNotationName(String string) {
        this.ndata = string;
    }

    void setURL(String string) {
        this.url = string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        XMLObjectOutput xMLObjectOutput = new XMLObjectOutput(objectOutput);
        CXMLContext cXMLContext = new CXMLContext();
        this.writeExternal(xMLObjectOutput, cXMLContext);
        xMLObjectOutput.flush();
    }

    void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        xMLObjectOutput.writeByte(17);
        xMLObjectOutput.writeUTF(this.tag);
        if (this.url != null) {
            xMLObjectOutput.writeUTF(this.url);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        if (this.pubid != null) {
            xMLObjectOutput.writeUTF(this.pubid);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        if (this.ndata != null) {
            xMLObjectOutput.writeUTF(this.ndata);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        if (this.text != null) {
            xMLObjectOutput.writeUTF(this.text);
        } else {
            xMLObjectOutput.writeUTF("null");
        }
        xMLObjectOutput.writeChar(this.cdata);
        xMLObjectOutput.writeBoolean(this.isNodeFlag(65536));
        xMLObjectOutput.writeBoolean(this.isNodeFlag(131072));
        xMLObjectOutput.writeBoolean(this.isNodeFlag(64));
        XMLNode xMLNode = (XMLNode)this.getFirstChild();
        while (xMLNode != null) {
            xMLNode = (XMLNode)xMLNode.getNextSibling();
            xMLNode.writeExternal(xMLObjectOutput, cXMLContext);
        }
        xMLObjectOutput.writeByte(22);
    }
}

