/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLTraversalEvent;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

class XMLNodeIterator
implements NodeIterator,
Serializable,
EventListener {
    XMLNode ref_node;
    XMLNode root;
    int whatToShow;
    NodeFilter filter;
    int position;
    boolean expandEntityReferences;
    public static int BEFORE = 0;
    public static int AFTER = 1;
    boolean valid;
    XMLNodeIterator next;
    XMLNodeIterator prev;

    XMLNodeIterator(XMLNode xMLNode, int n, NodeFilter nodeFilter, boolean bl) {
        this.root = xMLNode;
        this.ref_node = xMLNode;
        this.position = BEFORE;
        this.filter = nodeFilter;
        this.whatToShow = n;
        this.expandEntityReferences = bl;
        this.valid = true;
        this.next = null;
        this.prev = null;
    }

    void deleteNotify(XMLNode xMLNode) {
        if (xMLNode != this.ref_node) {
            if (!this.ref_node.isAncestor(xMLNode)) {
                return;
            }
            if (this.root.isAncestor(xMLNode) || this.root == xMLNode) {
                return;
            }
            this.ref_node = (XMLNode)xMLNode.getParentNode();
            this.position = AFTER;
            return;
        }
        if (this.ref_node == this.root && this.position == AFTER) {
            this.root = this.ref_node = (XMLNode)this.ref_node.getSuccessor(this.root, this.expandEntityReferences);
            this.position = BEFORE;
            return;
        }
        if (this.ref_node.getSuccessor(this.root, this.expandEntityReferences) == null && this.position == BEFORE) {
            this.ref_node = (XMLNode)this.ref_node.getPredecessor(this.root, this.expandEntityReferences);
            this.position = AFTER;
            return;
        }
        if (this.position == AFTER) {
            this.ref_node = (XMLNode)this.ref_node.getPredecessor(this.root, this.expandEntityReferences);
            return;
        }
        if (this.position == BEFORE) {
            this.ref_node = (XMLNode)this.ref_node.getSuccessor(this.root, this.expandEntityReferences);
            return;
        }
    }

    public void detach() {
        this.valid = false;
        this.ref_node = null;
        this.root = null;
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        if (this.prev != null) {
            this.prev.next = this.next;
        }
        this.prev = null;
        this.next = null;
    }

    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public void handleEvent(Event event) {
        XMLTraversalEvent xMLTraversalEvent = (XMLTraversalEvent)event;
        String string = event.getType();
        XMLNode xMLNode = (XMLNode)xMLTraversalEvent.getRelatedNode();
        if (string.equals("TRAVERSAL_DELETE_EVENT")) {
            this.deleteNotify(xMLNode);
        } else if (string.equals("TRAVERSAL_REPLACE_EVENT")) {
            this.replaceNotify(xMLNode, (XMLNode)xMLTraversalEvent.getReplacingNode());
        }
        xMLTraversalEvent.stopPropagation();
        xMLTraversalEvent.preventDefault();
    }

    public Node nextNode() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11);
        }
        if (this.position == BEFORE) {
            return this.next_Node(this.ref_node);
        }
        return this.next_Node((XMLNode)this.ref_node.getSuccessor(this.root, this.expandEntityReferences));
    }

    Node next_Node(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode;
        if (xMLNode == null) {
            return null;
        }
        if (xMLNode2.getNodeType() == 5 && !this.expandEntityReferences) {
            xMLNode2 = (XMLNode)xMLNode2.getSuccessor(this.root, this.expandEntityReferences);
            return this.next_Node(xMLNode2);
        }
        if (this.skipThisNode(xMLNode2)) {
            xMLNode2 = (XMLNode)xMLNode2.getSuccessor(this.root, this.expandEntityReferences);
        } else {
            if (this.filter.acceptNode(xMLNode2) == 1) {
                this.ref_node = xMLNode2;
                this.position = AFTER;
                return xMLNode2;
            }
            xMLNode2 = (XMLNode)xMLNode2.getSuccessor(this.root, this.expandEntityReferences);
        }
        return this.next_Node(xMLNode2);
    }

    public Node previousNode() throws DOMException {
        if (!this.valid) {
            throw new XMLDOMException(11);
        }
        if (this.position == BEFORE) {
            return this.previous_Node((XMLNode)this.ref_node.getPredecessor(this.root, this.expandEntityReferences));
        }
        return this.previous_Node(this.ref_node);
    }

    Node previous_Node(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode;
        if (xMLNode == null) {
            return null;
        }
        if (xMLNode2.getNodeType() == 5 && !this.expandEntityReferences) {
            xMLNode2 = (XMLNode)xMLNode2.getPredecessor(this.root, this.expandEntityReferences);
            return this.previous_Node(xMLNode2);
        }
        if (this.skipThisNode(xMLNode2)) {
            xMLNode2 = (XMLNode)xMLNode2.getPredecessor(this.root, this.expandEntityReferences);
        } else {
            if (this.filter.acceptNode(xMLNode2) == 1) {
                this.ref_node = xMLNode2;
                this.position = BEFORE;
                return xMLNode2;
            }
            xMLNode2 = (XMLNode)xMLNode2.getPredecessor(this.root, this.expandEntityReferences);
        }
        return this.previous_Node(xMLNode2);
    }

    void replaceNotify(XMLNode xMLNode, XMLNode xMLNode2) {
        if (this.root == xMLNode) {
            this.root = xMLNode2;
            this.ref_node = xMLNode2;
            this.position = BEFORE;
            return;
        }
        if (this.ref_node == xMLNode) {
            this.ref_node = xMLNode2;
        }
    }

    boolean skipThisNode(Node node) {
        return (1 << node.getNodeType() - 1 & this.whatToShow) == 0;
    }
}

