/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLAttrList;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntityReference;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLText;

public class XMLPrintDriver
implements PrintDriver {
    boolean printWriter;
    protected XMLOutputStream out;

    public XMLPrintDriver(OutputStream outputStream) {
        this.out = new XMLOutputStream(outputStream);
        this.printWriter = false;
    }

    public XMLPrintDriver(PrintWriter printWriter) {
        this.out = new XMLOutputStream(printWriter);
        this.printWriter = true;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
        this.out.finalFlush();
    }

    public void printAttribute(XMLAttr xMLAttr) throws IOException {
        xMLAttr.print(this.out, false);
    }

    public final void printAttributeNodes(XMLElement xMLElement) throws IOException {
        XMLAttrList xMLAttrList = (XMLAttrList)xMLElement.getAttributes();
        int n = xMLAttrList.getLength();
        int n2 = 0;
        while (n2 < n) {
            this.printAttribute((XMLAttr)xMLAttrList.item(n2));
            ++n2;
        }
    }

    public void printCDATASection(XMLCDATA xMLCDATA) throws IOException {
        xMLCDATA.print(this.out, false);
    }

    public final void printChildNodes(XMLNode xMLNode) throws IOException {
        XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild();
        while (xMLNode2 != null) {
            switch (xMLNode2.getNodeType()) {
                case 10: {
                    this.printDoctype((DTD)xMLNode2);
                    break;
                }
                case 1: {
                    this.printElement((XMLElement)xMLNode2);
                    break;
                }
                case 11: {
                    this.printDocumentFragment((XMLDocumentFragment)xMLNode2);
                    break;
                }
                case 3: {
                    this.printTextNode((XMLText)xMLNode2);
                    break;
                }
                case 8: {
                    this.printComment((XMLComment)xMLNode2);
                    break;
                }
                case 4: {
                    this.printCDATASection((XMLCDATA)xMLNode2);
                    break;
                }
                case 7: {
                    this.printProcessingInstruction((XMLPI)xMLNode2);
                    break;
                }
                case 5: {
                    this.printEntityReference((XMLEntityReference)xMLNode2);
                    break;
                }
            }
            xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
        }
    }

    public void printComment(XMLComment xMLComment) throws IOException {
        xMLComment.print(this.out, false);
    }

    public void printDoctype(DTD dTD) throws IOException {
        dTD.print(this.out, false);
    }

    public void printDocument(XMLDocument xMLDocument) throws IOException {
        this.setEncoding(xMLDocument.getEncoding());
        this.printChildNodes(xMLDocument);
    }

    public void printDocumentFragment(XMLDocumentFragment xMLDocumentFragment) throws IOException {
        this.printChildNodes(xMLDocumentFragment);
    }

    public void printElement(XMLElement xMLElement) throws IOException {
        boolean bl = true;
        boolean bl2 = this.out.mixed;
        int n = this.out.outstyle;
        this.out.writeIndent();
        this.out.writeChars("<");
        this.out.writeChars(xMLElement.tag);
        if (xMLElement.attrlist != null) {
            this.printAttributeNodes(xMLElement);
        }
        if (xMLElement.hasChildNodes()) {
            this.out.writeChars(">");
            bl = false;
            if (xMLElement.isNodeFlag(65536)) {
                this.out.mixed = true;
            } else if (!xMLElement.isNodeFlag(131072)) {
                XMLNode xMLNode = (XMLNode)xMLElement.getFirstChild();
                while (xMLNode != null) {
                    short s = xMLNode.getNodeType();
                    if (s == 3 || s == 5) {
                        this.out.mixed = true;
                        break;
                    }
                    xMLNode = (XMLNode)xMLNode.getNextSibling();
                }
            }
            this.out.writeNewLine();
            this.out.addIndent(1);
            this.printChildNodes(xMLElement);
            this.out.addIndent(-1);
            this.out.writeIndent();
            this.out.mixed = bl2;
        }
        this.printEndTag(xMLElement, bl);
        this.out.writeNewLine();
        this.out.outstyle = n;
        this.out.flush();
    }

    void printEndTag(XMLElement xMLElement, boolean bl) throws IOException {
        if (bl) {
            this.out.writeChars("/>");
        } else {
            this.out.writeChars("</" + xMLElement.tag + ">");
        }
    }

    public void printEntityReference(XMLEntityReference xMLEntityReference) throws IOException {
        xMLEntityReference.print(this.out, false);
    }

    public void printProcessingInstruction(XMLPI xMLPI) throws IOException {
        xMLPI.print(this.out, false);
    }

    public void printTextNode(XMLText xMLText) throws IOException {
        xMLText.print(this.out, false);
    }

    public void setEncoding(String string) throws IOException {
        if (!this.printWriter) {
            this.out.setEncoding(string, true, true);
        }
    }
}

