/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

class XMLTreeWalker
implements TreeWalker,
Serializable {
    XMLNode root;
    XMLNode currentNode;
    XMLNode marker;
    int whatToShow;
    NodeFilter filter;
    boolean expandEntityReferences;

    XMLTreeWalker(XMLNode xMLNode, int n, NodeFilter nodeFilter, boolean bl) {
        this.root = xMLNode;
        this.currentNode = xMLNode;
        this.filter = nodeFilter;
        this.whatToShow = n;
        this.expandEntityReferences = bl;
    }

    public Node firstChild() {
        this.marker = (XMLNode)this.currentNode.getFirstChild();
        while (this.marker != null) {
            if (this.marker.getNodeType() == 5 && !this.expandEntityReferences) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.skipThisNode(this.marker)) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.filter.acceptNode(this.marker) == 1) {
                this.currentNode = this.marker;
                return this.marker;
            }
            this.marker = (XMLNode)this.marker.getNextSibling();
        }
        return null;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public Node lastChild() {
        this.marker = (XMLNode)this.currentNode.getLastChild();
        while (this.marker != null) {
            if (this.marker.getNodeType() == 5 && !this.expandEntityReferences) {
                this.marker = (XMLNode)this.marker.getPreviousSibling();
                continue;
            }
            if (this.skipThisNode(this.marker)) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.filter.acceptNode(this.marker) == 1) {
                this.currentNode = this.marker;
                return this.marker;
            }
            this.marker = (XMLNode)this.marker.getPreviousSibling();
        }
        return null;
    }

    public Node nextNode() {
        this.marker = (XMLNode)this.currentNode.getSuccessor(this.root, this.expandEntityReferences);
        return this.next_Node(this.marker);
    }

    public Node nextSibling() {
        this.marker = (XMLNode)this.currentNode.getNextSibling();
        while (this.marker != null) {
            if (this.skipThisNode(this.marker)) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.filter.acceptNode(this.marker) == 1) {
                this.currentNode = this.marker;
                return this.marker;
            }
            this.marker = (XMLNode)this.marker.getNextSibling();
        }
        return null;
    }

    Node next_Node(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode;
        if (xMLNode == null) {
            return null;
        }
        if (xMLNode2.getNodeType() == 5 && !this.expandEntityReferences) {
            xMLNode2 = (XMLNode)xMLNode2.getSuccessor(this.root, this.expandEntityReferences);
            return this.next_Node(xMLNode2);
        }
        if (this.skipThisNode(xMLNode2)) {
            xMLNode2 = (XMLNode)xMLNode2.getSuccessor(this.root, this.expandEntityReferences);
        } else {
            if (this.filter.acceptNode(xMLNode2) == 1) {
                this.currentNode = xMLNode2;
                return xMLNode2;
            }
            xMLNode2 = (XMLNode)xMLNode2.getSuccessor(this.root, this.expandEntityReferences);
        }
        return this.next_Node(xMLNode2);
    }

    public Node parentNode() {
        this.marker = this.currentNode;
        return this.parent_Node(this.marker);
    }

    Node parent_Node(XMLNode xMLNode) {
        if (xMLNode.getNodeType() == 2 || xMLNode == null || xMLNode == this.root) {
            return null;
        }
        XMLNode xMLNode2 = (XMLNode)xMLNode.getParentNode();
        if (xMLNode2 == null) {
            return null;
        }
        if (this.skipThisNode(xMLNode2)) {
            return this.parent_Node(xMLNode2);
        }
        if (this.filter.acceptNode(xMLNode2) == 1) {
            this.currentNode = xMLNode2;
            return xMLNode2;
        }
        return this.parent_Node(xMLNode2);
    }

    public Node previousNode() {
        this.marker = (XMLNode)this.currentNode.getPredecessor(this.root, this.expandEntityReferences);
        return this.previous_Node(this.marker);
    }

    public Node previousSibling() {
        this.marker = (XMLNode)this.currentNode.getPreviousSibling();
        while (this.marker != null) {
            if (this.skipThisNode(this.marker)) {
                this.marker = (XMLNode)this.marker.getNextSibling();
                continue;
            }
            if (this.filter.acceptNode(this.marker) == 1) {
                this.currentNode = this.marker;
                return this.marker;
            }
            this.marker = (XMLNode)this.marker.getPreviousSibling();
        }
        return null;
    }

    Node previous_Node(XMLNode xMLNode) {
        XMLNode xMLNode2 = xMLNode;
        if (xMLNode == null) {
            return null;
        }
        if (xMLNode2.getNodeType() == 5 && !this.expandEntityReferences) {
            xMLNode2 = (XMLNode)xMLNode2.getPredecessor(this.root, this.expandEntityReferences);
            return this.previous_Node(xMLNode2);
        }
        if (this.skipThisNode(xMLNode2)) {
            xMLNode2 = (XMLNode)xMLNode2.getPredecessor(this.root, this.expandEntityReferences);
        } else {
            if (this.filter.acceptNode(xMLNode2) == 1) {
                this.currentNode = xMLNode2;
                return xMLNode2;
            }
            xMLNode2 = (XMLNode)xMLNode2.getPredecessor(this.root, this.expandEntityReferences);
        }
        return this.previous_Node(xMLNode2);
    }

    public void setCurrentNode(Node node) throws DOMException {
        if (node == null) {
            throw new XMLDOMException(9);
        }
        this.currentNode = (XMLNode)node;
    }

    boolean skipThisNode(Node node) {
        return (1 << node.getNodeType() - 1 & this.whatToShow) == 0;
    }
}

