/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.PrintWriter;
import java.util.Hashtable;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.parser.v2.XSLTemplate;
import oracle.xml.parser.v2.XSLVariable;
import oracle.xml.util.FastVector;

class XSLCallTemplate
extends XSLNode
implements XSLConstants {
    private NSName templName;
    private XSLTemplate template;
    private FastVector paramList;
    private int nParams;

    XSLCallTemplate(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 4;
    }

    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform" && xSLNode.localName == "with-param") {
            if (this.paramList == null) {
                this.paramList = new FastVector(4);
            }
            this.paramList.addElement(xSLNode);
            ++this.nParams;
            this.children.setSize(this.children.size() - 1);
        }
    }

    public void finalize() throws XSLException {
        int n = 0;
        while (n < this.nParams) {
            ((XSLNode)this.paramList.elementAt(n)).finalize();
            ++n;
        }
        super.finalize();
        if (this.templName != null) {
            this.template = this.xss.getNamedTemplate(this.templName);
            if (this.template == null) {
                this.xss.err.setLocator(this);
                this.xss.err.error1(1049, 1, this.templName.getQualifiedName());
                return;
            }
        }
    }

    void printChildren(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < this.nParams) {
            ((XSLNode)this.paramList.elementAt(n2)).printXSLNode(printWriter, n);
            ++n2;
        }
        super.printChildren(printWriter, n);
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        Hashtable hashtable = null;
        if (this.nParams > 0) {
            hashtable = (Hashtable)XSLNode.hashPool.alloc();
            int n = 0;
            while (n < this.nParams) {
                XSLVariable xSLVariable = (XSLVariable)this.paramList.elementAt(n);
                hashtable.put(xSLVariable.getName(), xSLVariable.getValue(xSLTContext));
                ++n;
            }
        }
        if (this.xss.isForwardCompatibilityMode()) {
            this.processChildren(xSLTContext);
        }
        int n = xSLTContext.getCurrentTmpl();
        xSLTContext.setCurrentTmpl(-2);
        this.template.setParams(hashtable, xSLTContext);
        this.template.processAction(xSLTContext);
        xSLTContext.setCurrentTmpl(n);
        if (hashtable != null) {
            XSLNode.hashPool.free(hashtable);
        }
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        if (string == "" && string3 == "name") {
            this.templName = this.resolveQname(string4);
        }
        super.setAttribute(string, string2, string3, string4);
    }

    public void startContent() throws XSLException {
        if (this.templName == null) {
            this.xss.err.error2(1009, 1, "name", this.getQualifiedName());
        }
    }
}

