/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import oracle.xml.parser.v2.XPathException;
import oracle.xml.parser.v2.XSLExprConstants;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.util.FastVector;

class XSLExtFunctions
implements XSLExprConstants {
    XSLExtFunctions() {
    }

    static void callConstructor(Constructor constructor, FastVector fastVector, XSLExprValue xSLExprValue) throws XPathException {
        Class<?>[] classArray = constructor.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object var5_5 = null;
        int n = 0;
        while (n < classArray.length) {
            objectArray[n] = ((XSLExprValue)fastVector.elementAt(n)).convertType(classArray[n]);
            ++n;
        }
        try {
            var5_5 = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XPathException(1039, constructor.getName());
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
        xSLExprValue.setExtensionValue(var5_5);
    }

    static void callMethod(Method method, FastVector fastVector, XSLExprValue xSLExprValue) throws XPathException {
        Class<?> clazz = method.getDeclaringClass();
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object object = null;
        Object object2 = ((XSLExprValue)fastVector.elementAt(0)).convertType(clazz);
        int n = 0;
        while (n < classArray.length) {
            XSLExprValue xSLExprValue2 = (XSLExprValue)fastVector.elementAt(n + 1);
            objectArray[n] = xSLExprValue2.convertType(classArray[n]);
            ++n;
        }
        try {
            object = method.invoke(object2, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XPathException(1044, method.getName(), invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
        if (object != null) {
            xSLExprValue.setExtensionValue(object);
        } else {
            xSLExprValue.setStringValue("");
        }
    }

    static void callStaticMethod(Method method, FastVector fastVector, XSLExprValue xSLExprValue) throws XPathException {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object object = null;
        int n = 0;
        while (n < classArray.length) {
            objectArray[n] = ((XSLExprValue)fastVector.elementAt(n)).convertType(classArray[n]);
            ++n;
        }
        try {
            object = method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XPathException(1044, method.getName(), invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
        xSLExprValue.setExtensionValue(object);
    }

    static boolean checkMethod(String string, String string2) throws XPathException {
        if (string2.equals("new")) {
            return true;
        }
        Class clazz = null;
        try {
            clazz = XSLExtFunctions.getClass(string);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new XPathException(1045, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XPathException(1045, classNotFoundException.getMessage());
        }
        try {
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (Modifier.isPublic(methodArray[n].getModifiers()) && methodArray[n].getName().equals(string2)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    static Class getClass(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return Class.forName(string);
        }
    }

    static Constructor getConstructor(String string, FastVector fastVector) throws XPathException {
        Class clazz = null;
        try {
            clazz = XSLExtFunctions.getClass(string);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new XPathException(1045, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XPathException(1045, classNotFoundException.getMessage());
        }
        try {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor[] constructorArray2 = new Constructor[constructorArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < constructorArray.length) {
                Class<?>[] classArray = constructorArray[n2].getParameterTypes();
                int n3 = constructorArray[n2].getModifiers();
                if (Modifier.isPublic(n3) && fastVector.size() == classArray.length) {
                    boolean bl = true;
                    int n4 = 0;
                    while (n4 < classArray.length) {
                        if (!((XSLExprValue)fastVector.elementAt(n4)).checkType(classArray[n4])) {
                            bl = false;
                            break;
                        }
                        ++n4;
                    }
                    if (bl) {
                        if (n == 0) {
                            constructorArray2[n++] = constructorArray[n2];
                        } else {
                            throw new XPathException(1040, constructorArray[n2].getName());
                        }
                    }
                }
                ++n2;
            }
            if (n == 0) {
                throw new XPathException(1041, string);
            }
            return constructorArray2[0];
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    static Method getMethod(String string, String string2, FastVector fastVector) throws XPathException {
        Class clazz = null;
        try {
            clazz = XSLExtFunctions.getClass(string);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new XPathException(1045, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XPathException(1045, classNotFoundException.getMessage());
        }
        try {
            Method[] methodArray = clazz.getMethods();
            Method[] methodArray2 = new Method[methodArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < methodArray.length) {
                int n3 = methodArray[n2].getModifiers();
                if (Modifier.isPublic(n3) && methodArray[n2].getName().equals(string2)) {
                    boolean bl = Modifier.isStatic(n3);
                    Class<?>[] classArray = methodArray[n2].getParameterTypes();
                    int n4 = classArray.length;
                    if (bl && fastVector.size() == n4 || !bl && fastVector.size() == n4 + 1) {
                        int n5 = bl ? 0 : 1;
                        boolean bl2 = true;
                        int n6 = 0;
                        while (n6 < classArray.length) {
                            if (!((XSLExprValue)fastVector.elementAt(n6 + n5)).checkType(classArray[n6])) {
                                bl2 = false;
                                break;
                            }
                            ++n6;
                        }
                        if (bl2) {
                            if (n == 0) {
                                methodArray2[n++] = methodArray[n2];
                            } else {
                                throw new XPathException(1042, methodArray[n2].getName());
                            }
                        }
                    }
                }
                ++n2;
            }
            if (n == 0) {
                throw new XPathException(1043, string2);
            }
            return methodArray2[0];
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }
}

