/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLTContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLNodeList
implements NodeList,
Serializable,
Cloneable {
    private XMLNode[] nodeArray;
    private int nodeCount;

    public XSLNodeList() {
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[8];
    }

    public XSLNodeList(int n) {
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[n];
    }

    public XSLNodeList(XMLNode xMLNode) {
        XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild();
        this.nodeArray = new XMLNode[4];
        while (xMLNode2 != null) {
            this.addNode(xMLNode2);
            xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
        }
    }

    public XSLNodeList(NodeList nodeList) {
        this.nodeCount = nodeList.getLength();
        this.nodeArray = new XMLNode[this.nodeCount];
        int n = 0;
        while (n < this.nodeCount) {
            this.nodeArray[n] = (XMLNode)nodeList.item(n);
            ++n;
        }
    }

    public void addNode(Node node) {
        this.ensureCapacity();
        this.nodeArray[this.nodeCount] = (XMLNode)node;
        ++this.nodeCount;
    }

    public void appendNodeList(XSLNodeList xSLNodeList) {
        int n = xSLNodeList.getLength();
        if (n == 0) {
            return;
        }
        if (this.nodeCount == 0 || this.nodeArray[this.nodeCount - 1].docOrderId <= xSLNodeList.nodeArray[0].docOrderId) {
            this.ensureCapacity(this.nodeCount + n, true);
            System.arraycopy(xSLNodeList.nodeArray, 0, this.nodeArray, this.nodeCount, n);
        } else {
            XMLNode[] xMLNodeArray = this.nodeArray;
            this.ensureCapacity(this.nodeCount + n, false);
            System.arraycopy(xMLNodeArray, 0, this.nodeArray, n, this.nodeCount);
            System.arraycopy(xSLNodeList.nodeArray, 0, this.nodeArray, 0, n);
        }
        this.nodeCount += n;
    }

    public Object clone() {
        XSLNodeList xSLNodeList = new XSLNodeList(this.nodeArray.length);
        xSLNodeList.nodeCount = this.nodeCount;
        System.arraycopy(this.nodeArray, 0, xSLNodeList.nodeArray, 0, this.nodeCount);
        return xSLNodeList;
    }

    private void ensureCapacity() {
        if (this.nodeCount >= this.nodeArray.length) {
            int n = this.nodeArray.length;
            XMLNode[] xMLNodeArray = this.nodeArray;
            this.nodeArray = new XMLNode[n * 2];
            System.arraycopy(xMLNodeArray, 0, this.nodeArray, 0, n);
            n *= 2;
        }
    }

    private void ensureCapacity(int n, boolean bl) {
        if (n >= this.nodeArray.length) {
            int n2 = this.nodeArray.length;
            XMLNode[] xMLNodeArray = this.nodeArray;
            while (n2 <= n) {
                n2 *= 2;
            }
            this.nodeArray = new XMLNode[n2];
            if (bl) {
                System.arraycopy(xMLNodeArray, 0, this.nodeArray, 0, this.nodeCount);
            }
        }
    }

    public int getLength() {
        return this.nodeCount;
    }

    public int indexOf(Node node) {
        int n = 0;
        while (n < this.nodeCount) {
            if (this.nodeArray[n] == (XMLNode)node) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void insertNode(Node node, int n) {
        this.ensureCapacity();
        System.arraycopy(this.nodeArray, n, this.nodeArray, n + 1, this.nodeCount - n);
        this.nodeArray[n] = (XMLNode)node;
        ++this.nodeCount;
    }

    void intersectWith(XSLNodeList xSLNodeList) {
        int n = xSLNodeList.getLength() - 1;
        int n2 = 0;
        int n3 = 0;
        XMLNode[] xMLNodeArray = xSLNodeList.nodeArray;
        while (n2 < this.nodeCount && n >= 0) {
            if (this.nodeArray[n2] == xMLNodeArray[n]) {
                this.nodeArray[n3++] = this.nodeArray[n2++];
                --n;
                continue;
            }
            if (this.nodeArray[n2].docOrderId > xMLNodeArray[n].docOrderId) {
                ++n2;
                continue;
            }
            --n;
        }
        this.nodeCount = n3;
    }

    public Node item(int n) {
        if (n >= 0 && n < this.nodeCount) {
            return this.nodeArray[n];
        }
        return null;
    }

    void makeDocOrder() {
        if (this.nodeCount > 1 && this.nodeArray[0].docOrderId > this.nodeArray[this.nodeCount - 1].docOrderId) {
            int n = 0;
            int n2 = this.nodeCount - 1;
            while (n < n2) {
                XMLNode xMLNode = this.nodeArray[n];
                this.nodeArray[n++] = this.nodeArray[n2];
                this.nodeArray[n2--] = xMLNode;
            }
        }
    }

    void mergeOrderedList(XSLNodeList xSLNodeList, boolean bl) {
        int n = this.nodeCount;
        int n2 = xSLNodeList.getLength();
        XMLNode[] xMLNodeArray = this.nodeArray;
        XMLNode[] xMLNodeArray2 = xSLNodeList.nodeArray;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.ensureCapacity(this.nodeCount + n2, false);
        if (xMLNodeArray == this.nodeArray) {
            System.arraycopy(xMLNodeArray, 0, xMLNodeArray, n2, this.nodeCount);
            n4 = n2;
            n = this.nodeCount + n2;
        }
        while (n4 < n && n5 < n2) {
            if (bl) {
                if (xMLNodeArray[n4].docOrderId < xMLNodeArray2[n5].docOrderId) {
                    this.nodeArray[n3++] = xMLNodeArray[n4++];
                    continue;
                }
                if (xMLNodeArray[n4] == xMLNodeArray2[n5]) {
                    ++n5;
                    --this.nodeCount;
                    this.nodeArray[n3++] = xMLNodeArray[n4++];
                    continue;
                }
                this.nodeArray[n3++] = xMLNodeArray2[n5++];
                continue;
            }
            if (xMLNodeArray[n4].docOrderId > xMLNodeArray2[n5].docOrderId) {
                this.nodeArray[n3++] = xMLNodeArray[n4++];
                continue;
            }
            if (xMLNodeArray[n4] == xMLNodeArray2[n5]) {
                ++n5;
                --this.nodeCount;
                this.nodeArray[n3++] = xMLNodeArray[n4++];
                continue;
            }
            this.nodeArray[n3++] = xMLNodeArray2[n5++];
        }
        if (n4 < n) {
            System.arraycopy(xMLNodeArray, n4, this.nodeArray, n3, n - n4);
        } else {
            System.arraycopy(xMLNodeArray2, n5, this.nodeArray, n3, n2 - n5);
        }
        this.nodeCount += n2;
    }

    void removeWhiteSpace(XSLTContext xSLTContext) throws XSLException {
        int n = 0;
        while (n < this.nodeCount) {
            if (xSLTContext.isStrippedWS(this.nodeArray[n])) break;
            ++n;
        }
        if (n == this.nodeCount) {
            return;
        }
        int n2 = n + 1;
        while (n2 < this.nodeCount) {
            if (!xSLTContext.isStrippedWS(this.nodeArray[n2])) {
                this.nodeArray[n++] = this.nodeArray[n2];
            }
            ++n2;
        }
        this.nodeCount = n;
    }

    public void reset() {
        int n = 0;
        while (n < this.nodeCount) {
            this.nodeArray[n] = null;
            ++n;
        }
        this.nodeCount = 0;
    }

    void setLength(int n) {
        if (n >= 0 && n <= this.nodeCount) {
            int n2 = n;
            while (n2 < this.nodeCount) {
                this.nodeArray[n2] = null;
                ++n2;
            }
            this.nodeCount = n;
        }
    }

    void setNode(XMLNode xMLNode, int n) {
        if (xMLNode != null && n >= 0 && n < this.nodeCount) {
            this.nodeArray[n] = xMLNode;
        }
    }
}

