/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.PrintWriter;
import java.net.URL;
import java.util.Hashtable;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLPatternInt;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.parser.v2.XSLVariable;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;

class XSLTemplate
extends XSLNode
implements XSLConstants {
    private XSLPatternInt pattern;
    private float priority;
    private NSName mode;
    int anchorNodeType = -1;
    String anchorNodeLocalName = null;
    private String[] anchorNodeName = new String[2];
    private String anchorNodeNamespace = null;
    URL baseUrl = null;
    String patternString;
    int importPriority;
    int index;
    int importLevel;
    FastVector formalParams;
    private int nParams;
    NSName templateNSName;
    boolean isBuiltInElementTemplate = false;

    XSLTemplate(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.localName = "template";
        this.elementType = 6;
    }

    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (xSLNode instanceof XSLVariable && xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform" && xSLNode.localName == "param") {
            if (this.formalParams == null) {
                this.formalParams = new FastVector(4);
            }
            this.formalParams.addElement(xSLNode);
            ++this.nParams;
            this.children.setSize(this.children.size() - 1);
        }
    }

    void endContent() throws XSLException {
        super.endContent();
    }

    public void finalize() throws XSLException {
        int n = 0;
        while (n < this.nParams) {
            ((XSLNode)this.formalParams.elementAt(n)).finalize();
            ++n;
        }
        super.finalize();
    }

    int getImportPriority() {
        return this.importPriority;
    }

    NSName getMode() {
        return this.mode;
    }

    float getPriority() {
        return this.priority;
    }

    XSLPatternInt matchTemplate(XMLNode xMLNode, NSName nSName, float f, XSLTContext xSLTContext) throws XSLException {
        if (nSName.equals(this.mode) && this.pattern != null) {
            URL uRL = xSLTContext.getBaseURL();
            xSLTContext.setBaseURL(this.baseUrl);
            XSLPatternInt xSLPatternInt = this.pattern.matchPattern(xMLNode, f, xSLTContext);
            xSLTContext.setBaseURL(uRL);
            if (xSLPatternInt != null) {
                return xSLPatternInt;
            }
        }
        return null;
    }

    void printChildren(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < this.nParams) {
            ((XSLNode)this.formalParams.elementAt(n2)).printXSLNode(printWriter, n);
            ++n2;
        }
        super.printChildren(printWriter, n);
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        XMLError xMLError = xSLTContext.getError();
        xMLError.setLocator(this);
        URL uRL = xSLTContext.getBaseURL();
        xSLTContext.setBaseURL(this.baseUrl);
        this.processChildren(xSLTContext);
        xSLTContext.setBaseURL(uRL);
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        if (string == "") {
            if (string3 == "priority") {
                this.priority = new Float(string4).floatValue();
            } else if (string3 == "name") {
                this.templateNSName = this.resolveQname(string4);
                this.xss.addNamedTemplate(this.templateNSName, this);
            } else if (string3 == "match") {
                this.pattern = XSLExprBase.createPattern(string4, this, true, this.xss);
                this.patternString = string4;
            } else if (string3 == "mode") {
                this.mode = this.resolveQname(string4);
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    void setBaseURL(URL uRL) {
        this.baseUrl = uRL;
    }

    void setParams(Hashtable hashtable, XSLTContext xSLTContext) throws XSLException {
        XMLError xMLError = xSLTContext.getError();
        xMLError.setLocator(this);
        URL uRL = xSLTContext.getBaseURL();
        xSLTContext.setBaseURL(this.baseUrl);
        if (hashtable != null) {
            int n = 0;
            while (n < this.nParams) {
                XSLVariable xSLVariable = (XSLVariable)this.formalParams.elementAt(n);
                XSLExprValue xSLExprValue = (XSLExprValue)hashtable.get(xSLVariable.getName());
                if (xSLExprValue == null) {
                    xSLExprValue = xSLVariable.getValue(xSLTContext);
                }
                xSLTContext.pushVariable(xSLExprValue);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.nParams) {
                XSLVariable xSLVariable = (XSLVariable)this.formalParams.elementAt(n);
                XSLExprValue xSLExprValue = xSLVariable.getValue(xSLTContext);
                xSLTContext.pushVariable(xSLExprValue);
                ++n;
            }
        }
        xSLTContext.setBaseURL(uRL);
    }

    public void startContent() throws XSLException {
        if (this.pattern == null && this.templateNSName == null) {
            this.xss.err.error2(1009, 1, "match", "template");
        }
        if (this.getAttribute("", "priority") != null) {
            if (this.pattern != null) {
                this.pattern.setPriority(this.priority);
            }
        } else if (this.pattern != null) {
            this.priority = this.pattern.getPriority();
        }
        if (this.pattern != null) {
            this.anchorNodeType = this.pattern.getAnchorType();
            this.pattern.getAnchorName(this.anchorNodeName);
            this.anchorNodeNamespace = this.anchorNodeName[0];
            this.anchorNodeLocalName = this.anchorNodeName[1];
        }
        if (this.mode == null) {
            this.mode = new NSNameImpl();
        }
    }
}

