/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.net.URL;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XSLConstants;
import oracle.xml.parser.v2.XSLDocumentBuilder;
import oracle.xml.parser.v2.XSLEventHandler;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLExprBase;
import oracle.xml.parser.v2.XSLExprInt;
import oracle.xml.parser.v2.XSLExprValue;
import oracle.xml.parser.v2.XSLNode;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.util.ObjectPool;

class XSLVariable
extends XSLNode
implements XSLConstants {
    private static ObjectPool builderPool = new ObjectPool();
    private static ObjectPool handlerPool;
    private XSLExprInt exp;
    private NSName xslVarName;
    private URL baseUrl;

    static {
        builderPool.setClassName("oracle.xml.parser.v2.XSLDocumentBuilder");
        builderPool.setResetMethod("reset");
        handlerPool = new ObjectPool();
        handlerPool.setClassName("oracle.xml.parser.v2.XSLEventHandler");
    }

    XSLVariable(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 7;
    }

    void endContent() throws XSLException {
        super.endContent();
        if (!this.isTopLevel() && this.localName != "with-param") {
            this.xss.pushVariable(this.xslVarName);
        }
    }

    NSName getName() {
        return this.xslVarName;
    }

    XSLExprValue getValue(XSLTContext xSLTContext) throws XSLException {
        XSLExprValue xSLExprValue = new XSLExprValue(true);
        URL uRL = null;
        if (this.baseUrl != null) {
            uRL = xSLTContext.getBaseURL();
            xSLTContext.setBaseURL(this.baseUrl);
        }
        if (this.exp != null) {
            xSLExprValue.copyValue(this.exp.getValue(xSLTContext));
        } else {
            XSLDocumentBuilder xSLDocumentBuilder = (XSLDocumentBuilder)builderPool.alloc();
            XSLEventHandler xSLEventHandler = (XSLEventHandler)handlerPool.alloc();
            xSLEventHandler.reset(xSLDocumentBuilder, xSLDocumentBuilder, xSLTContext);
            xSLDocumentBuilder.setVariableContext(true);
            XSLEventHandler xSLEventHandler2 = xSLTContext.getEventHandler();
            xSLTContext.setEventHandler(xSLEventHandler);
            this.processChildren(xSLTContext);
            xSLEventHandler.flushEvents();
            xSLExprValue.setDocumentFragmentValue(xSLDocumentBuilder.getResultFragment());
            xSLTContext.setEventHandler(xSLEventHandler2);
            xSLDocumentBuilder.setVariableContext(false);
            builderPool.free(xSLDocumentBuilder);
            handlerPool.free(xSLEventHandler);
        }
        if (this.baseUrl != null) {
            xSLTContext.setBaseURL(uRL);
        }
        return xSLExprValue;
    }

    public void processAction(XSLTContext xSLTContext) throws XSLException {
        XSLExprValue xSLExprValue = this.getValue(xSLTContext);
        xSLTContext.pushVariable(xSLExprValue);
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException {
        if (string == "") {
            if (string3 == "name") {
                this.xslVarName = this.resolveQname(string4);
            } else if (string3 == "select") {
                this.exp = XSLExprBase.createStringExpr(string4, this, this.xss);
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    void setBaseURL(URL uRL) {
        this.baseUrl = uRL;
    }

    public void startContent() throws XSLException {
        if (this.xslVarName == null) {
            this.xss.err.error2(1009, 1, "name", this.getQualifiedName());
        } else if (this.parent.checkDuplicate(this)) {
            this.xss.err.error1(1050, 1, this.xslVarName.getQualifiedName());
        }
    }
}

