/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLParser;

public class oraxml {
    private OutputStream errors = System.err;
    private static final String newline = System.getProperty("line.separator");
    private static final String usageMessage = "usage: oraxml options* <filename>" + newline + "where the options are: " + newline + "    -help                    Prints the help message" + newline + "    -version                 Prints the release version" + newline + "    -novalidate <fileName>   Checks whether the input file is well-formed" + newline + "    -dtd <fileName>          Validates the input file with DTD Validation" + newline + "    -schema <fileName>       Validates the input file with Schema Validation" + newline + "    -log <logfile>           Writes the errors/logs to the output file" + newline + "    -comp <fileName>         Compresses the input xml file" + newline + "    -decomp <fileName>       Decompresses the input compressed file" + newline + "    -enc <fileName>          Prints the encoding of the input file" + newline + "    -warning                 Show warnings" + newline;
    int setOption = -1;
    String fileName;
    static boolean versionFlag = false;
    static boolean warningFlag = false;
    static boolean compFlag = false;
    static boolean decompFlag = false;
    static boolean logFlag = false;
    static boolean encFlag = false;
    static boolean parsingFlag = true;
    static boolean isFile = false;
    static final int DTD = 1;
    static final int SCHEMA = 2;
    static final int NOVALIDATE = 3;
    static String releaseVersion;
    static String encoding;
    DOMParser parser;
    URL input = null;
    XMLDocument doc = null;

    private void compress() {
        try {
            this.input = this.createURL(this.fileName);
        }
        catch (Exception exception) {
            this.exitWithError("Error opening input source" + this.fileName + "(" + exception.getMessage() + ")");
        }
        try {
            this.parser = new DOMParser();
            this.parser.setValidationMode(1);
            this.parser.setPreserveWhitespace(false);
            this.parser.retainCDATASection(true);
            this.parser.parse(this.input);
            this.doc = this.parser.getDocument();
            FileOutputStream fileOutputStream = new FileOutputStream("xml.ser");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.doc);
            objectOutputStream.close();
        }
        catch (XMLParseException xMLParseException) {
            this.exitWithError("Error while compressing the file: " + this.fileName + "(" + xMLParseException.getMessage() + ")");
        }
        catch (Exception exception) {
            this.exitWithError("Error while compressing the file: " + this.fileName + "(" + exception.getMessage() + ")");
        }
    }

    private URL createURL(String string) throws Exception {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = String.valueOf('/') + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                this.exitWithError("Cannot create url for: " + string + "(" + malformedURLException2.getMessage() + ")");
            }
        }
        return uRL;
    }

    private void decompress() {
        XMLDocument xMLDocument = null;
        try {
            FileInputStream fileInputStream = new FileInputStream("xml.ser");
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            xMLDocument = (XMLDocument)objectInputStream.readObject();
            if (xMLDocument != null) {
                xMLDocument.print(System.out);
            } else {
                System.out.println("The serializedDoc is null");
            }
            objectInputStream.close();
        }
        catch (EOFException eOFException) {
            this.exitWithError("Error while de-compressing the file: " + this.fileName + "(" + eOFException.getMessage() + ")");
        }
        catch (Exception exception) {
            this.exitWithError("Error while de-compressing the file: " + this.fileName + "(" + exception.getMessage() + ")");
        }
    }

    private void exitWithError(String string) {
        PrintWriter printWriter = new PrintWriter(this.errors);
        printWriter.println(string);
        printWriter.flush();
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        oraxml oraxml2 = new oraxml();
        oraxml2.process(stringArray);
        if (parsingFlag) {
            oraxml2.parse();
        }
        if (compFlag) {
            oraxml2.compress();
        }
        if (decompFlag) {
            oraxml2.decompress();
        }
        oraxml2.printOutput();
    }

    private void parse() {
        try {
            this.input = this.createURL(this.fileName);
        }
        catch (Exception exception) {
            this.exitWithError("Error opening input source" + this.fileName + "(" + exception.getMessage() + ")");
        }
        this.parser = new DOMParser();
        if (warningFlag) {
            this.parser.showWarnings(true);
        }
        if (versionFlag) {
            releaseVersion = XMLParser.getReleaseVersion();
        }
        try {
            this.parser.setErrorStream(this.errors);
        }
        catch (IOException iOException) {
            this.exitWithError("Error while parsing input file: " + this.fileName + "(" + iOException.getMessage() + ")");
        }
        if (this.setOption == 3) {
            try {
                this.parser.setValidationMode(0);
                this.parser.parse(this.input);
                this.doc = this.parser.getDocument();
                if (encFlag) {
                    encoding = this.doc.getEncoding();
                }
            }
            catch (Exception exception) {
                this.exitWithError("Error while parsing input file: " + this.fileName + "(" + exception.getMessage() + ")");
            }
        } else if (this.setOption == 1) {
            try {
                this.parser.setValidationMode(2);
                this.parser.parse(this.input);
                this.doc = this.parser.getDocument();
                if (encFlag) {
                    encoding = this.doc.getEncoding();
                }
            }
            catch (Exception exception) {
                this.exitWithError("Error while parsing input file: " + this.fileName + "(" + exception.getMessage() + ")");
            }
        } else if (this.setOption == 2) {
            try {
                this.parser.setValidationMode(3);
                this.parser.parse(this.input);
                this.doc = this.parser.getDocument();
                if (encFlag) {
                    encoding = this.doc.getEncoding();
                }
            }
            catch (XMLParseException xMLParseException) {
                this.exitWithError("Error while parsing input file: " + this.fileName + "(" + xMLParseException.getMessage() + ")");
            }
            catch (Exception exception) {
                this.exitWithError("Error while parsing input file: " + this.fileName + "(" + exception.getMessage() + ")");
            }
        } else {
            try {
                this.parser.setValidationMode(1);
                this.parser.parse(this.input);
                this.doc = this.parser.getDocument();
                if (encFlag) {
                    encoding = this.doc.getEncoding();
                }
            }
            catch (Exception exception) {
                this.exitWithError("Error while parsing input file: " + this.fileName + "(" + exception.getMessage() + ")");
            }
        }
    }

    private void printOutput() {
        if (versionFlag) {
            System.out.println("Parser version: " + releaseVersion);
        }
        if (encFlag) {
            System.out.println("\nThe encoding of the input file: " + encoding);
            System.out.println();
        }
        if (isFile) {
            if (this.setOption == 3) {
                System.out.println("The input XML file is parsed without errors using non-validating mode");
            } else if (this.setOption == 1) {
                System.out.println("The input XML file is parsed without errors using DTD validation mode.");
            } else if (this.setOption == 2) {
                System.out.println("The input XML file is parsed without errors using Schema validation mode");
            } else {
                System.out.println("The input XML file is parsed without errors using partial validation mode");
            }
        }
        if (compFlag) {
            System.out.println("The compressed file xml.ser is generated.");
        } else if (decompFlag) {
            System.out.println("The input file id decompressed successfully");
        }
    }

    private void printUsage(String string) {
        System.out.println(String.valueOf(string) + newline + usageMessage);
        System.exit(0);
    }

    private void process(String[] stringArray) {
        int n = stringArray.length;
        int n2 = stringArray.length;
        if (n == 0) {
            this.printUsage("\nError: Atleast one arguement (file name) is required.  \n");
        } else {
            try {
                File file = new File(stringArray[n - 1]);
                if (file.exists()) {
                    this.fileName = stringArray[n - 1];
                    isFile = true;
                    n2 = n - 1;
                } else {
                    isFile = false;
                }
            }
            catch (Exception exception) {
                this.exitWithError("Error opening input file: " + exception.getMessage());
            }
        }
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3].equals("-help")) {
                this.printUsage("");
                System.exit(0);
            } else if (stringArray[n3].equals("-version")) {
                parsingFlag = false;
                versionFlag = true;
                this.parser = new DOMParser();
                releaseVersion = XMLParser.getReleaseVersion();
            } else if (stringArray[n3].equals("-novalidate")) {
                if (isFile) {
                    parsingFlag = true;
                    if (this.setOption == -1) {
                        this.setOption = 3;
                    } else {
                        this.printUsage("\nError: Can have only one of the options:  -novalidate or -dtd or -schema\n");
                    }
                } else {
                    this.printUsage("\nError: Input XML file is required\n");
                }
            } else if (stringArray[n3].equals("-dtd")) {
                if (isFile) {
                    parsingFlag = true;
                    if (this.setOption == -1) {
                        this.setOption = 1;
                    } else {
                        this.printUsage("\nError: Can have only one of the options:  -novalidate or -dtd or -schema\n");
                    }
                } else {
                    this.printUsage("\nError: Input XML file is required\n");
                }
            } else if (stringArray[n3].equals("-schema")) {
                if (isFile) {
                    parsingFlag = true;
                    if (this.setOption == -1) {
                        this.setOption = 2;
                    } else {
                        this.printUsage("\nError: Can have only one of the options:  -novalidate or -dtd or -schema\n");
                    }
                } else {
                    this.printUsage("\nError: Input XML file is required\n");
                }
            } else if (stringArray[n3].equals("-log")) {
                if (++n3 > n - 1) {
                    this.printUsage("\nError: Missing <error log> after -log\n");
                }
                try {
                    logFlag = true;
                    this.errors = new FileOutputStream(stringArray[n3]);
                }
                catch (IOException iOException) {
                    this.printUsage("The specified error log " + stringArray[n3] + " could not be opened for writing: " + iOException.getMessage());
                }
            } else if (stringArray[n3].equals("-comp")) {
                parsingFlag = false;
                if (isFile) {
                    compFlag = true;
                } else {
                    this.printUsage("\nError: Input XML file is required\n");
                }
            } else if (stringArray[n3].equals("-decomp")) {
                parsingFlag = false;
                if (isFile) {
                    decompFlag = true;
                } else {
                    this.printUsage("\nError: Input XML file is required\n");
                }
            } else if (stringArray[n3].equals("-enc")) {
                if (isFile) {
                    encFlag = true;
                    parsingFlag = true;
                } else {
                    this.printUsage("\nError: Input XML File is required\n");
                }
            } else if (stringArray[n3].equals("-warning")) {
                if (isFile) {
                    warningFlag = true;
                } else {
                    this.printUsage("\nError: Input XML File is required\n");
                }
            } else {
                this.printUsage("\nError: Unknown option\n");
                System.exit(1);
            }
            ++n3;
        }
    }
}

