/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import org.w3c.dom.DOMException;

public class XMLUtil
implements XMLConstants {
    static final int[] chartype = new int[256];
    static final int caseDiff = 32;
    static Hashtable encodingMap;
    static Hashtable encodingMap116;

    static {
        int n = 0;
        while (n < 256) {
            char c = (char)n;
            XMLUtil.chartype[n] = 0;
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                XMLUtil.chartype[n] = 1;
            }
            if (Character.isLetter(c)) {
                int n2 = n;
                chartype[n2] = chartype[n2] | 4;
            }
            if (Character.isDigit(c)) {
                int n3 = n;
                chartype[n3] = chartype[n3] | 2;
            }
            ++n;
        }
        chartype[46] = chartype[46] | 8;
        chartype[45] = chartype[45] | 8;
        chartype[95] = chartype[95] | 0x18;
        chartype[183] = chartype[183] | 8;
        encodingMap = new Hashtable(600);
        encodingMap116 = new Hashtable(600);
        encodingMap.put("ASCII", "ASCII");
        encodingMap.put("US-ASCII", "ASCII");
        encodingMap.put("ANSI_X3.4-1986", "ASCII");
        encodingMap.put("US", "ASCII");
        encodingMap.put("CP367", "ASCII");
        encodingMap.put("CSASCII", "ASCII");
        encodingMap.put("IBM367", "ASCII");
        encodingMap.put("ISO-IR-6", "ASCII");
        encodingMap.put("ISO_646.IRV:1991", "ASCII");
        encodingMap.put("ISO646-US", "ASCII");
        encodingMap.put("ANSI_X3.4-1968", "ASCII");
        encodingMap.put("ISO-8859-1", "ISO8859_1");
        encodingMap.put("ISO_8859-1", "ISO8859_1");
        encodingMap.put("ISO_8859-1:1987", "ISO8859_1");
        encodingMap.put("ISO-IR-100", "ISO8859_1");
        encodingMap.put("LATIN1", "ISO8859_1");
        encodingMap.put("L1", "ISO8859_1");
        encodingMap.put("IBM819", "ISO8859_1");
        encodingMap.put("CP819", "ISO8859_1");
        encodingMap.put("CSISOLATIN1", "ISO8859_1");
        encodingMap.put("ISO-8859-2", "ISO8859_2");
        encodingMap.put("ISO_8859-2", "ISO8859_2");
        encodingMap.put("ISO_8859-2:1987", "ISO8859_2");
        encodingMap.put("ISO8859-2", "ISO8859_2");
        encodingMap.put("ISO-IR-101", "ISO8859_2");
        encodingMap.put("LATIN2", "ISO8859_2");
        encodingMap.put("L2", "ISO8859_2");
        encodingMap.put("CSISOLATIN2", "ISO8859_2");
        encodingMap.put("ISO-8859-3", "ISO8859_3");
        encodingMap.put("ISO_8859-3", "ISO8859_3");
        encodingMap.put("ISO_8859-3:1988", "ISO8859_3");
        encodingMap.put("ISO-IR-109", "ISO8859_3");
        encodingMap.put("LATIN3", "ISO8859_3");
        encodingMap.put("L3", "ISO8859_3");
        encodingMap.put("CSISOLATIN3", "ISO8859_3");
        encodingMap.put("ISO-8859-4", "ISO8859_4");
        encodingMap.put("ISO_8859-4", "ISO8859_4");
        encodingMap.put("ISO_8859-4:1988", "ISO8859_4");
        encodingMap.put("ISO-IR-110", "ISO8859_4");
        encodingMap.put("LATIN4", "ISO8859_4");
        encodingMap.put("L4", "ISO8859_4");
        encodingMap.put("CSISOLATIN4", "ISO8859_4");
        encodingMap.put("ISO-8859-5", "ISO8859_5");
        encodingMap.put("ISO_8859-5", "ISO8859_5");
        encodingMap.put("ISO_8859-5:1988", "ISO8859_5");
        encodingMap.put("ISO-IR-144", "ISO8859_5");
        encodingMap.put("CYRILLIC", "ISO8859_5");
        encodingMap.put("CSISOLATINCYRILLIC", "ISO8859_5");
        encodingMap.put("ISO-8859-6", "ISO8859_6");
        encodingMap.put("ISO_8859-6", "ISO8859_6");
        encodingMap.put("ISO_8859-6:1987", "ISO8859_6");
        encodingMap.put("ISO-IR-127", "ISO8859_6");
        encodingMap.put("ECMA-114", "ISO8859_6");
        encodingMap.put("ARABIC", "ISO8859_6");
        encodingMap.put("ASMO-708", "ISO8859_6");
        encodingMap.put("CSISOLATINARABIC", "ISO8859_6");
        encodingMap.put("ISO-8859-7", "ISO8859_7");
        encodingMap.put("ISO_8859-7", "ISO8859_7");
        encodingMap.put("ISO_8859-7:1987", "ISO8859_7");
        encodingMap.put("ISO-IR-126", "ISO8859_7");
        encodingMap.put("ECMA-118", "ISO8859_7");
        encodingMap.put("ELOT_928", "ISO8859_7");
        encodingMap.put("GREEK", "ISO8859_7");
        encodingMap.put("GREEK8", "ISO8859_7");
        encodingMap.put("CSISOLATINGREEK", "ISO8859_7");
        encodingMap.put("ISO-8859-8", "ISO8859_8");
        encodingMap.put("ISO_8859-8", "ISO8859_8");
        encodingMap.put("ISO_8859-8:1988", "ISO8859_8");
        encodingMap.put("ISO-IR-138", "ISO8859_8");
        encodingMap.put("HEBREW", "ISO8859_8");
        encodingMap.put("VISUAL", "ISO8859_8");
        encodingMap.put("ISO-8859-8 VISUAL", "ISO8859_8");
        encodingMap.put("CSISOLATINHEBREW", "ISO8859_8");
        encodingMap.put("ISO-8859-9", "ISO8859_9");
        encodingMap.put("ISO_8859-9", "ISO8859_9");
        encodingMap.put("ISO_8859-9:1989", "ISO8859_9");
        encodingMap.put("ISO-IR-148", "ISO8859_9");
        encodingMap.put("LATIN5", "ISO8859_9");
        encodingMap.put("L5", "ISO8859_9");
        encodingMap.put("CSISOLATIN5", "ISO8859_9");
        encodingMap.put("BIG5", "Big5");
        encodingMap.put("CSBIG5", "Big5");
        encodingMap.put("X-X-BIG5", "Big5");
        encodingMap.put("EBCDIC", "Cp037");
        encodingMap.put("EBCDIC-CP-US", "Cp037");
        encodingMap.put("EBCDIC-CP-CA", "Cp037");
        encodingMap.put("EBCDIC-CP-NL", "Cp037");
        encodingMap.put("EBCDIC-CP-WT", "Cp037");
        encodingMap.put("IBM037", "Cp037");
        encodingMap.put("CP037", "Cp037");
        encodingMap.put("CSIBM037", "Cp037");
        encodingMap.put("IBM273", "Cp273");
        encodingMap.put("CP273", "Cp273");
        encodingMap.put("CSIBM273", "Cp273");
        encodingMap.put("EBCDIC-CP-DK", "Cp277");
        encodingMap.put("EBCDIC-CP-NO", "Cp277");
        encodingMap.put("IBM277", "Cp277");
        encodingMap.put("CSIBM277", "Cp277");
        encodingMap.put("EBCDIC-CP-FI", "Cp278");
        encodingMap.put("EBCDIC-CP-SE", "Cp278");
        encodingMap.put("IBM278", "Cp278");
        encodingMap.put("CP278", "Cp278");
        encodingMap.put("CSIBM278", "Cp278");
        encodingMap.put("EBCDIC-CP-IT", "Cp280");
        encodingMap.put("IBM280", "Cp280");
        encodingMap.put("CP280", "Cp280");
        encodingMap.put("CSIBM280", "Cp280");
        encodingMap.put("EBCDIC-CP-ES", "Cp284");
        encodingMap.put("IBM284", "Cp284");
        encodingMap.put("CP284", "Cp284");
        encodingMap.put("CSIBM284", "Cp284");
        encodingMap.put("EBCDIC-CP-GB", "Cp285");
        encodingMap.put("IBM285", "Cp285");
        encodingMap.put("CP285", "Cp285");
        encodingMap.put("CSIBM285", "Cp285");
        encodingMap.put("EBCDIC-CP-FR", "Cp297");
        encodingMap.put("IBM297", "Cp297");
        encodingMap.put("CP297", "Cp297");
        encodingMap.put("CSIBM297", "Cp297");
        encodingMap.put("EBCDIC-CP-AR1", "Cp420");
        encodingMap.put("IBM420", "Cp420");
        encodingMap.put("CP420", "Cp420");
        encodingMap.put("CSIBM420", "Cp420");
        encodingMap.put("EBCDIC-CP-HE", "Cp424");
        encodingMap.put("IBM424", "Cp424");
        encodingMap.put("CP424", "Cp424");
        encodingMap.put("CSIBM424", "Cp424");
        encodingMap.put("IBM437", "Cp437");
        encodingMap.put("CP437", "Cp437");
        encodingMap.put("437", "Cp437");
        encodingMap.put("CSPC8CODEPAGE437", "Cp437");
        encodingMap.put("EBCDIC-CP-BE", "Cp500");
        encodingMap.put("EBCDIC-CP-CH", "Cp500");
        encodingMap.put("IBM500", "Cp500");
        encodingMap.put("CP500", "Cp500");
        encodingMap.put("CSIBM500", "Cp500");
        encodingMap.put("IBM775", "Cp775");
        encodingMap.put("CP775", "Cp775");
        encodingMap.put("CSPC775BALTIC", "Cp775");
        encodingMap.put("IBM850", "Cp850");
        encodingMap.put("CP850", "Cp850");
        encodingMap.put("850", "Cp850");
        encodingMap.put("CSPC850MULTILINGUAL", "Cp850");
        encodingMap.put("IBM852", "Cp852");
        encodingMap.put("852", "Cp852");
        encodingMap.put("CP852", "Cp852");
        encodingMap.put("CSPCP852", "Cp852");
        encodingMap.put("IBM855", "Cp855");
        encodingMap.put("CP855", "Cp855");
        encodingMap.put("855", "Cp855");
        encodingMap.put("CSIBM855", "Cp855");
        encodingMap.put("IBM857", "Cp857");
        encodingMap.put("CP857", "Cp857");
        encodingMap.put("857", "Cp857");
        encodingMap.put("CSIBM857", "Cp857");
        encodingMap.put("IBM860", "Cp860");
        encodingMap.put("CP860", "Cp860");
        encodingMap.put("860", "Cp860");
        encodingMap.put("CSIBM860", "Cp860");
        encodingMap.put("IBM861", "Cp861");
        encodingMap.put("CP861", "Cp861");
        encodingMap.put("861", "Cp861");
        encodingMap.put("CSIBM861", "Cp861");
        encodingMap.put("CP-IS", "Cp861");
        encodingMap.put("IBM862", "Cp862");
        encodingMap.put("CP862", "Cp862");
        encodingMap.put("862", "Cp862");
        encodingMap.put("CSPC862LATINHEBREW", "Cp862");
        encodingMap.put("IBM863", "Cp863");
        encodingMap.put("CP863", "Cp863");
        encodingMap.put("863", "Cp863");
        encodingMap.put("CSIBM863", "Cp863");
        encodingMap.put("IBM864", "Cp864");
        encodingMap.put("CP864", "Cp864");
        encodingMap.put("CSIBM864", "Cp864");
        encodingMap.put("IBM865", "Cp865");
        encodingMap.put("CP865", "Cp865");
        encodingMap.put("865", "Cp865");
        encodingMap.put("CSIBM865", "Cp865");
        encodingMap.put("IBM866", "Cp866");
        encodingMap.put("866", "Cp866");
        encodingMap.put("CP866", "Cp866");
        encodingMap.put("CSIBM866", "Cp866");
        encodingMap.put("IBM868", "Cp868");
        encodingMap.put("CP868", "Cp868");
        encodingMap.put("CP-AR", "Cp868");
        encodingMap.put("CSIBM868", "Cp868");
        encodingMap.put("IBM869", "Cp869");
        encodingMap.put("CP869", "Cp869");
        encodingMap.put("869", "Cp869");
        encodingMap.put("CP-GR", "Cp869");
        encodingMap.put("CSIBM869", "Cp869");
        encodingMap.put("EBCDIC-CP-ROECE", "Cp870");
        encodingMap.put("EBCDIC-CP-YU", "Cp870");
        encodingMap.put("IBM870", "Cp870");
        encodingMap.put("CP870", "Cp870");
        encodingMap.put("CSIBM870", "Cp870");
        encodingMap.put("EBCDIC-CP-IS", "Cp871");
        encodingMap.put("IBM871", "Cp871");
        encodingMap.put("CP871", "Cp871");
        encodingMap.put("CSIBM871", "Cp871");
        encodingMap.put("EBCDIC-CP-AR2", "Cp918");
        encodingMap.put("IBM918", "Cp918");
        encodingMap.put("CP918", "Cp918");
        encodingMap.put("CSIBM918", "Cp918");
        encodingMap.put("IBM1026", "Cp1026");
        encodingMap.put("CP1026", "Cp1026");
        encodingMap.put("CSIBM1026", "Cp1026");
        encodingMap.put("WINDOWS-1250", "Cp1250");
        encodingMap.put("X-CP1250", "Cp1250");
        encodingMap.put("WINDOWS-1251", "Cp1251");
        encodingMap.put("X-CP1251", "Cp1251");
        encodingMap.put("CP1047", "Cp1047");
        encodingMap.put("IBM1047", "Cp1047");
        encodingMap.put("CP1047", "Cp1047");
        encodingMap.put("IBM1047", "Cp1047");
        encodingMap.put("WINDOWS-1252", "Cp1252");
        encodingMap.put("WINDOWS-1253", "Cp1253");
        encodingMap.put("WINDOWS-1254", "Cp1254");
        encodingMap.put("WINDOWS-1255", "Cp1255");
        encodingMap.put("LOGICAL", "Cp1255");
        encodingMap.put("WINDOWS-1256", "Cp1256");
        encodingMap.put("WINDOWS-1257", "Cp1257");
        encodingMap.put("WINDOWS-1258", "Cp1258");
        encodingMap.put("GB2312", "EUC_CN");
        encodingMap.put("CHINESE", "EUC_CN");
        encodingMap.put("CSGB2312", "EUC_CN");
        encodingMap.put("CSISO58GB231280", "EUC_CN");
        encodingMap.put("GB_2312-80", "EUC_CN");
        encodingMap.put("ISO-IR-58", "EUC_CN");
        encodingMap.put("EUC-CN", "EUC_CN");
        encodingMap.put("EUC-JP", "EUC_JP");
        encodingMap.put("CSEUCPKDFMTJAPANESE", "EUC_JP");
        encodingMap.put("EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", "EUC_JP");
        encodingMap.put("X-EUC", "EUC_JP");
        encodingMap.put("X-EUC-JP", "EUC_JP");
        encodingMap.put("KS_C_5601-1987", "EUC_KR");
        encodingMap.put("EUC-KR", "EUC_KR");
        encodingMap.put("KOREAN", "EUC_KR");
        encodingMap.put("KS_C_5601", "EUC_KR");
        encodingMap.put("CSKSC56011987", "EUC_KR");
        encodingMap.put("CSEUC-KR", "EUC_KR");
        encodingMap.put("EUC-TW", "EUC_TW");
        encodingMap.put("GBK", "GBK");
        encodingMap.put("ISO-2022-CN", "ISO2022CN");
        encodingMap.put("CSISO2022CN", "ISO2022CN");
        encodingMap.put("ISO-2022-KR", "ISO2022KR");
        encodingMap.put("CSISO2022KR", "ISO2022KR");
        encodingMap.put("ISO-2022-JP", "ISO2022JP");
        encodingMap.put("CSISO2022JP", "ISO2022JP");
        encodingMap.put("KOI8-R", "KOI8_R");
        encodingMap.put("CSKOI8-R", "KOI8_R");
        encodingMap.put("KOI", "KOI8_R");
        encodingMap.put("WINDOWS-874", "MS874");
        encodingMap.put("TIS-620", "TIS620");
        encodingMap.put("SHIFT_JIS", "MS932");
        encodingMap.put("MS_KANJI", "MS932");
        encodingMap.put("X-MS-CP932", "MS932");
        encodingMap.put("X-SJIS", "MS932");
        encodingMap.put("CSSHIFTJIS", "MS932");
        encodingMap.put("CSWINDOWS31J", "MS932");
        encodingMap.put("WINDOWS-949", "MS949");
        encodingMap.put("WINDOWS-950", "MS950");
        encodingMap.put("UTF-8", "UTF8");
        encodingMap.put("UNICODE-1-1-UTF-8", "UTF8");
        encodingMap.put("UNICODE-2-0-UTF-8", "UTF8");
        encodingMap.put("X-UNICODE-2-0-UTF-8", "UTF8");
        encodingMap.put("JUTF8", "UTF8");
        encodingMap.put("IBM00858", "Cp858");
        encodingMap.put("CCSID00858", "Cp858");
        encodingMap.put("CP00858", "Cp858");
        encodingMap.put("PC-MULTILINGUAL-850+EURO", "Cp858");
        encodingMap.put("IBM00924", "Cp924");
        encodingMap.put("CCSID00924", "Cp924");
        encodingMap.put("CP00924", "Cp924");
        encodingMap.put("EBCDIC-LATIN9--EURO", "Cp924");
        encodingMap.put("IBM01140", "Cp1140");
        encodingMap.put("CCSID01140", "Cp1140");
        encodingMap.put("CP01140", "Cp1140");
        encodingMap.put("EBCDIC-US-37+EURO", "Cp1140");
        encodingMap.put("IBM01141", "Cp1141");
        encodingMap.put("CCSID01141", "Cp1141");
        encodingMap.put("CP01141", "Cp1141");
        encodingMap.put("EBCDIC-DE-273+EURO", "Cp1141");
        encodingMap.put("IBM01142", "Cp1142");
        encodingMap.put("CCSID01142", "Cp1142");
        encodingMap.put("CP01142", "Cp1142");
        encodingMap.put("EBCDIC-DK-277+EURO", "Cp1142");
        encodingMap.put("EBCDIC-NO-277+EURO", "Cp1142");
        encodingMap.put("IBM01143", "Cp1143");
        encodingMap.put("CCSID01143", "Cp1143");
        encodingMap.put("CP01143", "Cp1143");
        encodingMap.put("EBCDIC-FI-278+EURO", "Cp1143");
        encodingMap.put("EBCDIC-SE-278+EURO", "Cp1143");
        encodingMap.put("IBM01144", "Cp1144");
        encodingMap.put("CCSID01144", "Cp1144");
        encodingMap.put("CP01144", "Cp1144");
        encodingMap.put("EBCDIC-IT-280+EURO", "Cp1144");
        encodingMap.put("IBM01145", "Cp1145");
        encodingMap.put("CCSID01145", "Cp1145");
        encodingMap.put("CP01145", "Cp1145");
        encodingMap.put("EBCDIC-ES-284+EURO", "Cp1145");
        encodingMap.put("IBM01146", "Cp1146");
        encodingMap.put("CCSID01146", "Cp1146");
        encodingMap.put("CP01146", "Cp1146");
        encodingMap.put("EBCDIC-GB-285+EURO", "Cp1146");
        encodingMap.put("IBM01147", "Cp1147");
        encodingMap.put("CCSID01147", "Cp1147");
        encodingMap.put("CP01147", "Cp1147");
        encodingMap.put("EBCDIC-FR-297+EURO", "Cp1147");
        encodingMap.put("IBM01148", "Cp1148");
        encodingMap.put("CP01148", "Cp1148");
        encodingMap.put("CCSID01148", "Cp1148");
        encodingMap.put("EBCDIC-INTERNATIONAL-500+EURO", "Cp1148");
        encodingMap.put("IBM01149", "Cp1149");
        encodingMap.put("CCSID01149", "Cp1149");
        encodingMap.put("CP01149", "Cp1149");
        encodingMap.put("EBCDIC-IS-871+EURO", "Cp1149");
        encodingMap116.put("ISO-8859-1", "8859_1");
        encodingMap116.put("ISO_8859-1", "8859_1");
        encodingMap116.put("ISO_8859-1:1987", "8859_1");
        encodingMap116.put("ISO-ir-100", "8859_1");
        encodingMap116.put("LATIN1", "8859_1");
        encodingMap116.put("L1", "8859_1");
        encodingMap116.put("IBM819", "8859_1");
        encodingMap116.put("CP819", "8859_1");
        encodingMap116.put("CSISOLATIN1", "8859_1");
        encodingMap116.put("ISO-8859-2", "8859_2");
        encodingMap116.put("ISO_8859-2", "8859_2");
        encodingMap116.put("ISO_8859-2:1987", "8859_2");
        encodingMap116.put("8859-2", "8859_2");
        encodingMap116.put("ISO-IR-101", "8859_2");
        encodingMap116.put("LATIN2", "8859_2");
        encodingMap116.put("L2", "8859_2");
        encodingMap116.put("CSISOLATIN2", "8859_2");
        encodingMap116.put("ISO-8859-3", "8859_3");
        encodingMap116.put("ISO_8859-3", "8859_3");
        encodingMap116.put("ISO_8859-3:1988", "8859_3");
        encodingMap116.put("ISO-IR-109", "8859_3");
        encodingMap116.put("LATIN3", "8859_3");
        encodingMap116.put("L3", "8859_3");
        encodingMap116.put("CSISOLATIN3", "8859_3");
        encodingMap116.put("ISO-8859-4", "8859_4");
        encodingMap116.put("ISO_8859-4", "8859_4");
        encodingMap116.put("ISO_8859-4:1988", "8859_4");
        encodingMap116.put("ISO-IR-110", "8859_4");
        encodingMap116.put("LATIN4", "8859_4");
        encodingMap116.put("L4", "8859_4");
        encodingMap116.put("CSISOLATIN4", "8859_4");
        encodingMap116.put("ISO-8859-5", "8859_5");
        encodingMap116.put("ISO_8859-5", "8859_5");
        encodingMap116.put("ISO_8859-5:1988", "8859_5");
        encodingMap116.put("ISO-IR-144", "8859_5");
        encodingMap116.put("CYRILLIC", "8859_5");
        encodingMap116.put("CSISOLATINCYRILLIC", "8859_5");
        encodingMap116.put("ISO-8859-6", "8859_6");
        encodingMap116.put("ISO_8859-6", "8859_6");
        encodingMap116.put("ISO_8859-6:1987", "8859_6");
        encodingMap116.put("ISO-IR-127", "8859_6");
        encodingMap116.put("ECMA-114", "8859_6");
        encodingMap116.put("ARABIC", "8859_6");
        encodingMap116.put("ASMO-708", "8859_6");
        encodingMap116.put("CSISOLATINARABIC", "8859_6");
        encodingMap116.put("ISO-8859-7", "8859_7");
        encodingMap116.put("ISO_8859-7", "8859_7");
        encodingMap116.put("ISO_8859-7:1987", "8859_7");
        encodingMap116.put("ISO-IR-126", "8859_7");
        encodingMap116.put("ECMA-118", "8859_7");
        encodingMap116.put("ELOT_928", "8859_7");
        encodingMap116.put("GREEK", "8859_7");
        encodingMap116.put("GREEK8", "8859_7");
        encodingMap116.put("CSISOLATINGREEK", "8859_7");
        encodingMap116.put("ISO-8859-8", "8859_8");
        encodingMap116.put("ISO_8859-8", "8859_8");
        encodingMap116.put("ISO_8859-8:1988", "8859_8");
        encodingMap116.put("ISO-IR-138", "8859_8");
        encodingMap116.put("HEBREW", "8859_8");
        encodingMap116.put("VISUAL", "8859_8");
        encodingMap116.put("ISO-8859-8 VISUAL", "8859_8");
        encodingMap116.put("CSISOLATINHEBREW", "8859_8");
        encodingMap116.put("ISO-8859-9", "8859_9");
        encodingMap116.put("ISO_8859-9", "8859_9");
        encodingMap116.put("ISO_8859-9:1989", "8859_9");
        encodingMap116.put("ISO-IR-148", "8859_9");
        encodingMap116.put("LATIN5", "8859_9");
        encodingMap116.put("L5", "8859_9");
        encodingMap116.put("CSISOLATIN5", "8859_9");
        encodingMap116.put("SHIFT_JIS", "SJIS");
        encodingMap116.put("MS_KANJI", "SJIS");
        encodingMap116.put("X-MS-CP932", "SJIS");
        encodingMap116.put("X-SJIS", "SJIS");
        encodingMap116.put("CSSHIFTJIS", "SJIS");
        encodingMap116.put("CSWINDOWS31J", "SJIS");
        encodingMap116.put("ISO-2022-JP", "JIS");
        encodingMap116.put("EUC-JP", "EUCJIS");
        encodingMap116.put("EUC-KR", "KSC5601");
    }

    public static String encodeURL(String string) {
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        int n2 = 0;
        while (n2 < string.length()) {
            block8: {
                char c = string.charAt(n2);
                if (c > '\u001f' && c < '~') {
                    stringBuffer.append(c);
                } else {
                    try {
                        outputStreamWriter.write(c);
                        outputStreamWriter.flush();
                    }
                    catch (IOException iOException) {
                        byteArrayOutputStream.reset();
                        break block8;
                    }
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    int n3 = 0;
                    while (n3 < byArray.length) {
                        stringBuffer.append('%');
                        char c2 = Character.forDigit(byArray[n3] >> 4 & 0xF, 16);
                        if (Character.isLowerCase(c2)) {
                            c2 = (char)(c2 - 32);
                        }
                        stringBuffer.append(c2);
                        c2 = Character.forDigit(byArray[n3] & 0xF, 16);
                        if (Character.isLowerCase(c2)) {
                            c2 = (char)(c2 - 32);
                        }
                        stringBuffer.append(c2);
                        ++n3;
                    }
                    byteArrayOutputStream.reset();
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getJavaEncoding(String string) {
        String string2;
        String string3 = System.getProperty("java.version", "1.1");
        if (string3.startsWith("1.1") && (string2 = (String)encodingMap116.get(string)) != null) {
            return string2;
        }
        return (String)encodingMap.get(string);
    }

    public static String getLocalName(String string) {
        int n = string.length();
        String string2 = string.substring(string.indexOf(58) + 1, n);
        return string2.intern();
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        String string2 = "";
        if (n != -1) {
            string2 = string.substring(0, n).intern();
        }
        return string2;
    }

    public static boolean isFirstNameChar(char c) {
        if (c < '\u0100') {
            return (chartype[c] & 0x14) != 0;
        }
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isNameChar(char c) {
        if (c < '\u0100') {
            return (chartype[c] & 0xE) != 0;
        }
        return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.';
    }

    public static boolean isNmtokenChar(char c) {
        if (c == ':') {
            return true;
        }
        return XMLUtil.isNameChar(c);
    }

    public static boolean isWhiteSpace(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            if (!XMLUtil.isWhiteSpaceChar(cArray[n4])) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static boolean isWhiteSpaceChar(char c) {
        if (c < '\u0100') {
            return (chartype[c] & 1) != 0;
        }
        return Character.isWhitespace(c);
    }

    public static void validateName(String string) throws DOMException {
        char c = string.charAt(0);
        if (Character.isLetter(c) || c == '_' || c == ':') {
            int n = string.length();
            int n2 = 1;
            while (n2 < n) {
                c = string.charAt(n2);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != ':' && c != '-' && c != '.') {
                    throw new XMLDOMException(5);
                }
                ++n2;
            }
        } else {
            throw new XMLDOMException(5);
        }
    }

    public static void validatePrefix(String string) throws DOMException {
        char c = string.charAt(0);
        if (Character.isLetter(c) || c == '_') {
            int n = string.length();
            int n2 = 1;
            while (n2 < n) {
                c = string.charAt(n2);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.') {
                    throw new XMLDOMException(5);
                }
                ++n2;
            }
        } else {
            throw new XMLDOMException(5);
        }
    }

    public static void validateQualifiedName(String string) throws DOMException {
        int n = string.length();
        int n2 = 0;
        boolean bl = false;
        char c = string.charAt(n2);
        if (!Character.isLetter(c) && c != '_') {
            throw new XMLDOMException(14);
        }
        n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == ':' && !bl) {
                bl = true;
                String string2 = string.substring(0, n2 - 1);
            } else if (c == ':') {
                throw new XMLDOMException(14);
            }
            ++n2;
        }
        if (c == ':') {
            throw new XMLDOMException(14);
        }
    }

    public static void validateQualifiedName(String string, String string2) throws DOMException {
        int n = string2.length();
        int n2 = 0;
        boolean bl = false;
        String string3 = "";
        if (string2.equalsIgnoreCase("xmlns") && string.equals("http://www.w3.org/2000/xmlns/")) {
            throw new XMLDOMException(14);
        }
        char c = string2.charAt(n2);
        if (!Character.isLetter(c) && c != '_') {
            throw new XMLDOMException(14);
        }
        n2 = 1;
        while (n2 < n) {
            c = string2.charAt(n2);
            if (c == ':' && !bl) {
                bl = true;
                string3 = string2.substring(0, n2 - 1);
            } else if (c == ':') {
                throw new XMLDOMException(14);
            }
            ++n2;
        }
        if (c == ':') {
            throw new XMLDOMException(14);
        }
        if (bl) {
            if (string == null || string.equals("")) {
                throw new XMLDOMException(14);
            }
            if (string3.equalsIgnoreCase("xml") && !string.equals("http://www.w3.org/XML/1998/namespace")) {
                throw new XMLDOMException(14);
            }
        }
        if (string2.equalsIgnoreCase("xmlns") && string.equals("http://www.w3.org/2000/xmlns/")) {
            throw new XMLDOMException(14);
        }
    }
}

