/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;

public abstract class TransformerFactory {
    private static final String defaultPropName = "javax.xml.transform.sax.SAXTransformerFactory";
    private static String foundFactory = null;
    private static boolean debug;

    protected TransformerFactory() {
    }

    public static TransformerFactory newInstance() throws TransformerFactoryConfigurationError {
        TransformerFactory factoryImpl;
        String classname = TransformerFactory.findFactory(defaultPropName, "oracle.xml.jaxp.JXSAXTransformerFactory");
        if (classname == null) {
            throw new TransformerFactoryConfigurationError("No default implementation found");
        }
        try {
            Class<?> clazz = Class.forName(classname);
            factoryImpl = (TransformerFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new TransformerFactoryConfigurationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            throw new TransformerFactoryConfigurationError(iae);
        }
        catch (InstantiationException ie) {
            throw new TransformerFactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    public abstract Transformer newTransformer(Source var1) throws TransformerConfigurationException;

    public abstract Transformer newTransformer() throws TransformerConfigurationException;

    public abstract Templates newTemplates(Source var1) throws TransformerConfigurationException;

    public abstract Source getAssociatedStylesheet(Source var1, String var2, String var3, String var4) throws TransformerConfigurationException;

    public abstract void setURIResolver(URIResolver var1);

    public abstract URIResolver getURIResolver();

    public abstract boolean getFeature(String var1);

    public abstract void setAttribute(String var1, Object var2) throws IllegalArgumentException;

    public abstract Object getAttribute(String var1) throws IllegalArgumentException;

    public abstract void setErrorListener(ErrorListener var1) throws IllegalArgumentException;

    public abstract ErrorListener getErrorListener();

    private static String findFactory(String factoryId, String defaultFactory) {
        block19: {
            block18: {
                try {
                    String systemProp = null;
                    try {
                        systemProp = System.getProperty(factoryId);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println(String.valueOf("JAXP: found system property").concat(String.valueOf(systemProp)));
                        }
                        String string = systemProp;
                        return string;
                    }
                }
                catch (SecurityException systemProp) {
                    // empty catch block
                }
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = String.valueOf(String.valueOf(String.valueOf(String.valueOf(javah).concat(String.valueOf(File.separator))).concat(String.valueOf("lib"))).concat(String.valueOf(File.separator))).concat(String.valueOf("jaxp.properties"));
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        foundFactory = props.getProperty(factoryId);
                        if (debug) {
                            System.err.println(String.valueOf("JAXP: found java.home property ").concat(String.valueOf(foundFactory)));
                        }
                        if (foundFactory != null) {
                            String string = foundFactory;
                            return string;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block18;
                    ex.printStackTrace();
                }
            }
            String serviceId = String.valueOf("META-INF/services/").concat(String.valueOf(factoryId));
            try {
                ClassLoader cl = Class.forName("javax.xml.transform.TransformerFactory").getClassLoader();
                InputStream is = null;
                is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
                if (is != null) {
                    if (debug) {
                        System.err.println(String.valueOf("JAXP: found  ").concat(String.valueOf(serviceId)));
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    foundFactory = rd.readLine();
                    rd.close();
                    if (debug) {
                        System.err.println(String.valueOf("JAXP: loaded from services: ").concat(String.valueOf(foundFactory)));
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        String string = foundFactory;
                        return string;
                    }
                }
            }
            catch (Exception ex) {
                if (!debug) break block19;
                ex.printStackTrace();
            }
        }
        return defaultFactory;
    }

    static {
        try {
            debug = System.getProperty("jaxp.debug") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

