/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDParticleNode;
import oracle.xml.util.FastVector;

class XSDAny
extends XSDNode
implements XSDParticleNode {
    int minOccurs;
    int maxOccurs;
    String processContents;
    String namespace;
    Hashtable nsList;

    XSDAny() {
        this(0);
    }

    XSDAny(int n) {
        this.name = ":any";
        this.nodeType = n;
        this.processContents = "strict";
        this.namespace = "##any";
        if (n == 0) {
            this.minOccurs = 1;
            this.maxOccurs = 1;
        } else {
            this.minOccurs = 0;
            this.maxOccurs = 0x7FFFFFF8;
        }
    }

    boolean buildPathTable(FastVector fastVector, byte[] byArray, int n) {
        byArray[fastVector.size()] = (byte)(n + 1);
        fastVector.addElement(this);
        return true;
    }

    void buildPaths(Hashtable hashtable, int n) {
        XSDElement.addPath(hashtable, this, n);
    }

    XSDNode getMatchingAttr(XMLSchema xMLSchema, String string, String string2) {
        if (this.isMatched(string)) {
            return this.getMatchingNode(xMLSchema, string, string2);
        }
        return null;
    }

    XSDNode getMatchingNode(XMLSchema xMLSchema, String string, String string2) {
        XSDNode xSDNode = null;
        if (this.processContents == "skip") {
            return XSDConstantValues.FAKE_NODE;
        }
        xSDNode = this.nodeType == 0 ? xMLSchema.getElement(string, string2) : xMLSchema.getAttribute(string, string2);
        if (this.processContents == "lax" && xSDNode == null) {
            return XSDConstantValues.FAKE_NODE;
        }
        return xSDNode;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public String getName() {
        return null;
    }

    XSDAny intersectWith(XSDAny xSDAny) {
        Hashtable hashtable = xSDAny.resolveTargetNS();
        if (xSDAny.namespace == "##any") {
            return this;
        }
        if (this.namespace == "##any") {
            this.namespace = xSDAny.namespace;
            if (hashtable != null) {
                this.nsList = (Hashtable)hashtable.clone();
            }
            return this;
        }
        if (this.namespace != "##list" && hashtable != null) {
            this.nsList = (Hashtable)hashtable.clone();
            this.nsList.remove(this.namespace);
            this.namespace = "##list";
            return this;
        }
        if (xSDAny.namespace != "##list" && this.nsList != null) {
            this.nsList.remove(xSDAny.namespace);
        } else if (hashtable != null && this.nsList != null) {
            Enumeration enumeration = this.nsList.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (hashtable.get(string) != null) continue;
                this.nsList.remove(string);
            }
        }
        return this;
    }

    boolean isMatched(String string) {
        if (this.namespace == "##any") {
            return true;
        }
        if (this.namespace != "##list" && !string.equals(this.namespace)) {
            return true;
        }
        if (this.nsList != null) {
            return this.nsList.get(string) != null;
        }
        return false;
    }

    int postProcess(FastVector fastVector, Hashtable hashtable) throws Exception {
        this.isClean = false;
        return 1;
    }

    void print(int n) {
        this.printSTag(n);
        System.out.println(String.valueOf(XSDNode.indent(n)) + "minOccurs = " + this.minOccurs);
        System.out.println(String.valueOf(XSDNode.indent(n)) + "maxOccurs = " + this.maxOccurs);
        if (this.processContents != null) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "processContents = " + this.processContents);
        }
        if (this.namespace != null) {
            System.out.print(String.valueOf(XSDNode.indent(n)) + "namespace = ");
            if (this.namespace == "##list") {
                Enumeration enumeration = this.nsList.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    System.out.print(String.valueOf(string) + " ");
                }
                System.out.println();
            } else {
                System.out.println(this.namespace);
            }
        }
        super.printEmptySTag(n);
    }

    void printSTag(int n) {
        System.out.print(XSDNode.indent(n));
        System.out.print("<");
        this.print();
        System.out.println();
        if (this.id != null) {
            System.out.println(String.valueOf(XSDNode.indent(n)) + "id = " + this.id);
        }
    }

    Hashtable resolveTargetNS() {
        String string = this.getTargetNS();
        if (this.namespace == "##targetNamespace") {
            this.namespace = string;
        }
        if (this.nsList == null) {
            return null;
        }
        if (this.nsList.get("##targetNamespace") == null) {
            return this.nsList;
        }
        this.nsList.put(string, string);
        this.nsList.remove("##targetNamespace");
        return this.nsList;
    }

    public void setMaxOccurs(int n) {
        this.maxOccurs = n;
    }

    public void setMinOccurs(int n) {
        this.minOccurs = n;
    }

    /*
     * Unable to fully structure code
     */
    void setNamespace(String var1_1) {
        block5: {
            block4: {
                var2_2 = var1_1.intern();
                if (var2_2 != "##any" && var2_2 != "##other") break block4;
                this.namespace = var2_2;
                break block5;
            }
            this.namespace = "##list";
            this.nsList = new Hashtable<K, V>(10);
            var3_3 = var1_1.length();
            var4_4 = 0;
            var5_5 = var1_1.toCharArray();
            ** GOTO lbl27
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && var5_5[var4_4] == ' ') continue block0;
                    if (var4_4 >= var3_3) break block0;
                    var6_6 = var4_4;
                    while (var4_4 < var3_3 && var5_5[var4_4] != ' ') {
                        ++var4_4;
                    }
                    var2_2 = new String(var5_5, var6_6, var4_4 - var6_6);
                    if (var2_2.equals("##local")) {
                        this.nsList.put("", "");
                        continue;
                    }
                    this.nsList.put(var2_2, var2_2);
lbl27:
                    // 3 sources

                } while (var4_4 < var3_3);
            }
        }
    }

    void setProcessContents(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 != "skip" && string2 != "lax" && string2 != "strict") {
            throw new XSDException();
        }
        this.processContents = string2;
    }

    XSDAny unionWith(XSDAny xSDAny) {
        Hashtable hashtable = xSDAny.resolveTargetNS();
        if (this.namespace == "##any") {
            return this;
        }
        if (xSDAny.namespace == "##any") {
            this.namespace = "##any";
            this.nsList = null;
            return this;
        }
        if (this.namespace != "##list") {
            if (xSDAny.namespace != "##list") {
                if (!this.namespace.equals(xSDAny.namespace)) {
                    this.namespace = "##any";
                }
                return this;
            }
            if (hashtable.get(this.namespace) != null) {
                this.namespace = "##any";
            }
            return this;
        }
        if (xSDAny.namespace != "##list") {
            this.namespace = this.nsList.get(xSDAny.namespace) != null ? "##any" : xSDAny.namespace;
            this.nsList = null;
        } else if (hashtable != null && this.nsList != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.nsList.put(string, string);
            }
        }
        return this;
    }
}

